/* Copyright 2006 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public  class MenuButtonUI
 * extends ButtonUI
 *
 * UI implementation for menu buttons.
 *
 * @version 1.0 (Apr 18, 2006)
 */

/**
 * Constructs a new <code>MenuButtonUI</code>.
 */
vpx.gui.plaf.MenuButtonUI = function() {
   if (arguments[0] == vpx.ABSTRACT_PASS) {
      // Skip object initialization
      return;
   }

   // super()
   vpx.gui.plaf.ButtonUI.call(this);
};

// MenuButtonUI extends vpx.gui.plaf.ButtonUI
vpx.gui.plaf.MenuButtonUI.prototype = new vpx.gui.plaf.ButtonUI(vpx.ABSTRACT_PASS);
vpx.gui.plaf.MenuButtonUI.prototype.constructor = vpx.gui.plaf.MenuButtonUI;

// Shorthand for brevity's sake
var _c = vpx.gui.plaf.MenuButtonUI;       // Class
var _i = _c.prototype;                    // Instance
_i._concrete = true;                      // vpx system flag for concrete classes

// Instance variables
_i.frame = null;                          // protected vpx.gui.Frame
_i.frameHandler = null;                   // protected vpx.gui.plaf.MenuButtonUI.FrameHandler

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.plaf.ComponentUI#installUI(vpx.gui.Component)
 */
_i.installUI = function(c) {
   this.frame = new vpx.gui.Frame(vpx.getTle());

   // super.installUI(c)
   var spr = vpx.gui.plaf.ButtonUI.prototype;
   spr.installUI.call(this, c);

   var film = vpx.gui.MenuSelectionManager.defaultManager().getFilm();
   film.addChangeListener(this.getFrameHandler());

   var p = this.peer;
   var dim = new vpx.gui.Dimension(p.offsetWidth, p.offsetHeight);
   this.frame.setPreferredSize(dim);
   var doc = vpx.getTle().document;
   doc.body.appendChild(this.frame.getPeer());
   this.frame.addMouseListener(this.getHandler());
};

_i.installDefaults = function() {
};

_i.installListeners = function() {
   var l = this._createButtonListener();
   if (l != null) {
      this.button.addChangeListener(l);
      this.button.addGlobalPropertyChangeListener(l);
   }

   this.button.addMouseListener(this.getHandler());
};

_i.getHandler = function() {
   if (this.handler == null) {
      this.handler = new vpx.gui.plaf.MenuButtonUI.Handler(this);
   }
   return this.handler;
};

_i.getFrameHandler = function() {
   if (this.frameHandler == null) {
      this.frameHandler = new vpx.gui.plaf.MenuButtonUI.FrameHandler(this);
   }
   return this.frameHandler;
};

/**
 *
 *
 * @param path vpx.gui.MenuElement[]
 *    ?
 * @param elem vpx.gui.MenuElement
 *    ?
 */
_i._appendPath = function(path, elem) {
   var newPath = [];
   for (var i = 0; i < path.length; i++) {
      newPath.push(path[i]);
   }
   newPath.push(elem);
   vpx.gui.MenuSelectionManager.defaultManager().setSelectedPath(newPath);
};

/**
 * class Handler
 * extends vpx.gui.plaf.MenuItemUI.Handler
 * implements vpx.gui.event.MouseListener
 *
 * Listener that automatically gets registered with this ui's button.
 *
 * @version 1.0 (Apr 18, 2006)
 */

/**
 * Constructs a new Handler.
 */
_c.Handler = function(ui) {
   this.ui = ui;
};

/**
 * Invoked when the mouse has been clicked (pressed and released) on the menu.
 * This method does nothing.
 *
 * @param e [DOM Level 2 Events]MouseEvent
 *    The mouse event; not used
 */
_c.Handler.prototype.mouseClicked = function(e) {
   // Do nothing
};

/**
 * Invoked when the mouse has been clicked on the menu. This method clears or
 * sets the selection path of the <code>MenuSelectionManager</code>.
 *
 * @param e [DOM Level 2 Events]MouseEvent
 *    The mouse event
 */
_c.Handler.prototype.mousePressed = function(e) {
   var btn = this.ui.button;
   if (!btn.isEnabled()) {
      return;
   }

   var manager = vpx.gui.MenuSelectionManager.defaultManager();
   if (btn.isSelected()) {
      manager.clearSelectedPath();
   } else {
      manager.setSelectedPath([btn, btn.getPopupMenu()]);
   }
};

/**
 * Invoked when the mouse has been released on the menu. Delegates the mouse
 * event to the MenuSelectionManager.
 *
 * @param e [DOM Level 2 Events]MouseEvent
 *    The mouse event
 */
_c.Handler.prototype.mouseReleased = function(e) {
   // Do nothing
};

/**
 * Invoked when the cursor enters the menu. As well as managing the rollover
 * and armed state of the menu, this method sets the selected path
 * for the MenuSelectionManager and handles the case in which a menu item is
 * used to pop up an additional menu, as in a hierarchical menu system.
 *
 * @param e [DOM Level 2 Events]MouseEvent
 *    The mouse event; not used
 */
_c.Handler.prototype.mouseEntered = function(e) {
   var btn = this.ui.button;
   if (!btn.isEnabled()) {
      return;
   }

   var model = btn.getModel();
   if (btn.isRolloverEnabled()) {
      model.setRollover(true);
   }
   if (model.isPressed()) {
      model.setArmed(true);
   }
};

/**
 * Invoked when the cursor exits the menu. This method manages the rollover
 * and armed state of the menu.
 *
 * @param e [DOM Level 2 Events]MouseEvent
 *    The mouse event; not used
 */
_c.Handler.prototype.mouseExited = function(e) {
   var btn = this.ui.button;
   var model = btn.getModel();
   if (btn.isRolloverEnabled()) {
      model.setRollover(false);
   }
   model.setArmed(false);
};


/**
 * class FrameHandler
 * extends Object
 * implements vpx.core.event.ChangeListener
 *
 * Listener that automatically gets registered with this ui's menu button.
 *
 * @version 1.0 (May 03, 2006)
 */

/**
 * Constructs a new Handler.
 */
_c.FrameHandler = function(ui) {
   this.ui = ui;
};

_c.FrameHandler.prototype.stateChanged = function(e) {
   var isVisible = e.getSource().isVisible();
   var fp = this.ui.frame.getPeer();

   if (isVisible) {
      var p = this.ui.peer;
      var dim = new vpx.gui.Dimension(p.offsetWidth, p.offsetHeight);
      this.ui.frame.setPreferredSize(dim);
      var pos = this.ui.button.getLocation(vpx.getTle());
      fp.style.left = pos.x + "px";
      fp.style.top = pos.y + "px";
      delete p;
      delete dim;
      delete pos;
   }

   fp.style.visibility = (isVisible ? "visible" : "hidden");

   delete isVisible;
   delete fp;
};
