/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public  class MenuItemUI
 * extends ComponentUI
 *
 * UI implementation for menu items.
 *
 * @version 1.0 (Oct 6, 2005)
 */

/**
 *
 */
vpx.gui.plaf.MenuItemUI = function() {
   if (arguments[0] == vpx.ABSTRACT_PASS) {
      // Skip object initialization
      return;
   }

   // super()
   vpx.gui.plaf.ButtonUI.call(this);
};

// MenuItemUI extends vpx.gui.plaf.ButtonUI
vpx.gui.plaf.MenuItemUI.prototype = new vpx.gui.plaf.ButtonUI(vpx.ABSTRACT_PASS);
vpx.gui.plaf.MenuItemUI.prototype.constructor = vpx.gui.plaf.MenuItemUI;

// Shorthand for brevity's sake
var _c = vpx.gui.plaf.MenuItemUI;      // Class
var _i = _c.prototype;                 // Instance
_i._concrete = true;                   // vpx system flag for concrete classes

// Instance variables
_i.menuItem = null;                    // protected vpx.gui.MenuItem
_i.background = "white";               // protected String
_i.bgImg = "";                         // protected String
_i.foreground = "#06F";                // protected String
_i.selectionBackground = "white";      // protected String
_i.selectionBgImg = "";                // protected String
_i.selectionForeground = "#F90";       // protected String
_i.rolloverBackground = "white";       // protected String
_i.rolloverBgImg = "";                 // protected String
_i.rolloverForeground = "blue";        // protected String
_i.disabledForeground = "#999";        // protected String
_i.handler  = null;                    // protected vpx.gui.plaf.MenuItemUI.Handler

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.plaf.ComponentUI#initPeer(vpx.gui.Component)
 */
_i.initPeer = function(c) {
   var p = c.getView().document.createElement("div");
   this.peer = p;
   return p;
};

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.plaf.ComponentUI#installUI(vpx.gui.Component)
 */
_i.installUI = function(c) {
   this.initPeer(c);
   this.menuItem = c;

   this.installDefaults();
   this.installListeners();
};

/**
 * Installs the default look of this UI.
 */
_i.installDefaults = function() {
   var c = vpx.gui.plaf.MenuItemUI;
   var p = this.peer;
   p.style.backgroundColor = this.background;
   p.style.color = this.foreground;
   p.style.whiteSpace = "nowrap";
   p.style.cursor = "pointer";
   if (vpx.xua.ie) {
      // This should work everywhere, but Mozilla's padding breaks it
      p.style.width = "100%";
   }
   p.style.fontStyle = "normal";
   p.style.padding = "4px 20px 4px 14px";
};

_i.installListeners = function() {
   var l = this._createButtonListener();
   if (l != null) {
      this.menuItem.addChangeListener(l);
      this.menuItem.addGlobalPropertyChangeListener(l);
   }

   this.menuItem.addChangeListener(this.getHandler());
   this.menuItem.addMouseListener(this.getHandler());
};

/**
 * Creates a new basic button listener.
 *
 * @return vpx.gui.plaf.ButtonListener
 *    A basic button listener
 */
_i._createButtonListener = function() {
   return new vpx.gui.plaf.ButtonListener();
};

_i.getHandler = function() {
   if (this.handler == null) {
      this.handler = new vpx.gui.plaf.MenuItemUI.Handler(this);
   }
   return this.handler;
};

/**
 * ??
 *
 * @return vpx.gui.MenuElement[]
 *    ??
 */
_i.getPath = function() {
   var m = vpx.gui.MenuSelectionManager.defaultManager();
   var path = m.getSelectedPath();
   var i = path.length;

   if (i == 0) {
      return [];
   }

   var parent = this.menuItem.getParent();
   if (path[i - 1].getComponent() == parent) {
      // The parent popup menu is the last so far
      path.push(this.menuItem);
   } else {
      /* A sibling menuitem is the current selection
       *
       * This probably needs to handle 'exit submenu into
       * a menu item.  Search backwards along the current
       * selection until you find the parent popup menu,
       * then copy up to that and add yourself...
       */
      for (var j = path.length - 1; j >= 0; j--) {
         if (path[j].getComponent() == parent) {
            break;
         }
         path.pop();
      }
      path.push(this.menuItem);
   }
   return path;
};

/**
 * Call this method when a menu item is to be activated. This method handles
 * some of the details of menu item activation such as clearing the selected
 * path and messaging the MenuItem's doClick() method.
 *
 * @param msm vpx.gui.MenuSelectionManager
 *    The visual feedback and internal bookkeeping tasks are delegated to
 *    this MenuSelectionManager. If <code>null</code> is passed as this
 *    argument, the <code>MenuSelectionManager.defaultManager</code> is used
 */
_i._doClick = function(msm) {
   if (msm == null) {
      msm = vpx.gui.MenuSelectionManager.defaultManager();
   }
   msm.clearSelectedPath();
   this.menuItem.doClick(0);
};

/**
 * class Handler
 * extends Object
 * implements vpx.core.event.ChangeListener,
 *            vpx.gui.event.MouseListener
 *
 * Listener that automatically gets registered with this ui's menu item.
 *
 * @version 1.0 (Oct 11, 2005)
 */

/**
 * Constructs a new Handler.
 */
_c.Handler = function(ui) {
   if (arguments[0] == vpx.ABSTRACT_PASS) {
      // Skip object initialization
      return;
   }

   this.ui = ui;
};

/**
 * (non-Javadoc)
 *
 * @see vpx.core.event.ChangeListener#stateChanged(vpx.core.event.ChangeEvent)
 */
_c.Handler.prototype.stateChanged = function(e) {
   var ui = this.ui;
   var menuItem = ui.menuItem;
   var model = menuItem.getModel();
   var p = ui.peer;

   if (model.isArmed() || (menuItem instanceof vpx.gui.Menu && model.isSelected())) {
      p.style.borderLeft = p.style.borderRight = "1px solid " + ui.selectionBackground;
      p.style.backgroundColor = ui.selectionBackground;
      p.style.backgroundImage = ui.selectionBgImg;
      p.style.color = ui.selectionForeground;
   } else if (model.isRollover()) {
      p.style.borderLeft = p.style.borderRight = "1px solid #999999";
      p.style.backgroundColor = ui.rolloverBackground;
      p.style.backgroundImage = ui.rolloverBgImg;
      p.style.color = ui.rolloverForeground;
   } else if (!model.isEnabled()) {
      p.style.borderLeft = p.style.borderRight = "1px solid " + ui.background;
      p.style.backgroundColor = ui.background;
      p.style.backgroundImage = ui.bgImg;
      p.style.color = ui.disabledForeground;
   } else {
      p.style.borderLeft = p.style.borderRight = "1px solid " + ui.background;
      p.style.backgroundColor = ui.background;
      p.style.backgroundImage = ui.bgImg;
      p.style.color = ui.foreground;
   }
};

_c.Handler.prototype.mouseClicked = function(e) {
};

_c.Handler.prototype.mousePressed = function(e) {
};

_c.Handler.prototype.mouseReleased = function(e) {
   var m = vpx.gui.MenuSelectionManager.defaultManager();
   this.ui._doClick(m);
};

_c.Handler.prototype.mouseEntered = function(e) {
   var m = vpx.gui.MenuSelectionManager.defaultManager();
   m.setSelectedPath(this.ui.getPath());
};

_c.Handler.prototype.mouseExited = function(e) {
   var m = vpx.gui.MenuSelectionManager.defaultManager();
   var path = m.getSelectedPath();

   if (path.length > 1 && path[path.length - 1] == this.ui.menuItem) {
      path.pop();
      m.setSelectedPath(path);
   }
};
