/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public  class MenuUI
 * extends MenuItemUI
 *
 * UI implementation for menus.
 *
 * @version 1.0 (Oct 11, 2005)
 */

/**
 * Constructs a new <code>MenuUI</code>.
 */
vpx.gui.plaf.MenuUI = function() {
   if (arguments[0] == vpx.ABSTRACT_PASS) {
      // Skip object initialization
      return;
   }

   // super()
   vpx.gui.plaf.MenuItemUI.call(this);
};

// MenuUI extends vpx.gui.plaf.MenuItemUI
vpx.gui.plaf.MenuUI.prototype = new vpx.gui.plaf.MenuItemUI(vpx.ABSTRACT_PASS);
vpx.gui.plaf.MenuUI.prototype.constructor = vpx.gui.plaf.MenuUI;

// Shorthand for brevity's sake
var _c = vpx.gui.plaf.MenuUI;             // Class
var _i = _c.prototype;                    // Instance
_i._concrete = true;                      // vpx system flag for concrete classes

// Instance variables
_i.frame = null;                          // protected vpx.gui.Frame
_i.frameHandler = null;                   // protected vpx.gui.plaf.MenuUI.FrameHandler
_i.background = "#cccac2";                // protected String
_i.bgImg = "url(imx/e6e3da.png)";         // protected String
_i.foreground = "";                       // protected String
_i.selectionBackground = "white";         // protected String
_i.selectionBgImg = "";                   // protected String
_i.selectionForeground = "black";         // protected String
_i.rolloverBackground = "#e6e3da";        // protected String
_i.rolloverBgImg = "url(imx/f7f5eb.png)"; // protected String
_i.rolloverForeground = "";               // protected String
_i.disabledForeground = "silver";         // protected String

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.plaf.ComponentUI#installUI(vpx.gui.Component)
 */
_i.installUI = function(c) {
   this.frame = new vpx.gui.Frame(vpx.getTle());

   // super.installUI(c)
   var spr = vpx.gui.plaf.MenuItemUI.prototype;
   spr.installUI.call(this, c);

   var film = vpx.gui.MenuSelectionManager.defaultManager().getFilm();
   film.addChangeListener(this.getFrameHandler());

   var p = this.peer;
   var dim = new vpx.gui.Dimension(p.offsetWidth, p.offsetHeight);
   this.frame.setPreferredSize(dim);
   var doc = vpx.getTle().document;
   doc.body.appendChild(this.frame.getPeer());
   this.frame.addMouseListener(this.getHandler());
};

/**
 * Installs the default look of this UI. This is called automatically upon UI
 * installation.
 *
 * @see #installUI(vpx.gui.Component)
 */
_i.installDefaults = function() {
   var c = vpx.gui.plaf.MenuUI;
   var p = this.peer;
   var fp = this.frame.getPeer();
   p.style.backgroundColor = this.background;
   p.style.backgroundImage = this.bgImg;
   p.style.backgroundRepeat = "repeat-x";
   p.style.cursor = fp.style.cursor = "pointer";
   p.style.margin = "0px";
   p.style.padding = "0px 4px 0px 4px";
   p.style.borderLeft = fp.style.borderLeft = p.style.borderRight = fp.style.borderRight = "1px solid " + this.background;
};

_i.installListeners = function() {
   // super.installListeners()
   var spr = vpx.gui.plaf.MenuItemUI.prototype;
   spr.installListeners.call(this);

   this.menuItem.addComponentListener(this.getHandler());
};

_i.getHandler = function() {
   if (this.handler == null) {
      this.handler = new vpx.gui.plaf.MenuUI.Handler(this);
   }
   return this.handler;
};

_i.getFrameHandler = function() {
   if (this.frameHandler == null) {
      this.frameHandler = new vpx.gui.plaf.MenuUI.FrameHandler(this);
   }
   return this.frameHandler;
};

/**
 *
 *
 * @param path vpx.gui.MenuElement[]
 *    ?
 * @param elem vpx.gui.MenuElement
 *    ?
 */
_i._appendPath = function(path, elem) {
   var newPath = [];
   for (var i = 0; i < path.length; i++) {
      newPath.push(path[i]);
   }
   newPath.push(elem);
   vpx.gui.MenuSelectionManager.defaultManager().setSelectedPath(newPath);
};

/**
 * class Handler
 * extends vpx.gui.plaf.MenuItemUI.Handler
 * implements vpx.gui.event.ComponentListener,
 *            vpx.gui.event.MouseListener
 *
 * Listener that automatically gets registered with this ui's menu item.
 *
 * @version 1.0 (Oct 13, 2005)
 */

/**
 * Constructs a new Handler.
 */
_c.Handler = function(ui) {
   this.ui = ui;
};

// Handler extends vpx.gui.plaf.MenuItemUI.Handler
_c.Handler.prototype = new vpx.gui.plaf.MenuItemUI.Handler(vpx.ABSTRACT_PASS);
_c.Handler.prototype.constructor = vpx.gui.plaf.MenuUI.Handler;

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.event.ComponentListener#placementChanged(vpx.gui.event.ComponentEvent)
 */
_c.Handler.prototype.placementChanged = function(e) {
   var p = this.ui.peer;
   var fp = this.ui.frame.getPeer();
   var dim = new vpx.gui.Dimension(p.offsetWidth, p.offsetHeight);
   this.ui.frame.setPreferredSize(dim);
   var pos = this.ui.menuItem.getLocation(vpx.getTle());
   fp.style.left = pos.x + "px";
   fp.style.top = pos.y + "px";
};

/**
 * Invoked when the mouse has been clicked (pressed and released) on the menu.
 * This method does nothing.
 *
 * @param e [DOM Level 2 Events]MouseEvent
 *    The mouse event; not used
 */
_c.Handler.prototype.mouseClicked = function(e) {
   // Do nothing
};

/**
 * Invoked when the mouse has been clicked on the menu. This method clears or
 * sets the selection path of the <code>MenuSelectionManager</code>.
 *
 * @param e [DOM Level 2 Events]MouseEvent
 *    The mouse event
 */
_c.Handler.prototype.mousePressed = function(e) {
   var menu = this.ui.menuItem;
   if (!menu.isEnabled()) {
      return;
   }

   var manager = vpx.gui.MenuSelectionManager.defaultManager();
   if (menu.isTopLevelMenu()) {
		if (menu.isSelected()) {
         manager.clearSelectedPath();
		} else {
         var cnt = menu.getParent();
         if(cnt != null && cnt instanceof vpx.gui.MenuBar) {
            var me = [cnt, menu];
            manager.setSelectedPath(me);
         }
		}
   }

   var path = manager.getSelectedPath();
   if (path.length > 0 && path[path.length - 1] != menu.getPopupMenu()) {
      this.ui._appendPath(path, menu.getPopupMenu());
   }
};

/**
 * Invoked when the mouse has been released on the menu. Delegates the mouse
 * event to the MenuSelectionManager.
 *
 * @param e [DOM Level 2 Events]MouseEvent
 *    The mouse event
 */
_c.Handler.prototype.mouseReleased = function(e) {
   var menu = this.ui.menuItem;
   if (!menu.isEnabled()) {
		return;
   }

   /*var manager = vpx.gui.MenuSelectionManager.defaultManager();
   manager.processMouseEvent(e);
   if (!e.isConsumed()) {
		manager.clearSelectedPath();
   }*/
};

/**
 * Invoked when the cursor enters the menu. As well as managing the rollover
 * and armed state of the menu, this method sets the selected path
 * for the MenuSelectionManager and handles the case in which a menu item is
 * used to pop up an additional menu, as in a hierarchical menu system.
 *
 * @param e [DOM Level 2 Events]MouseEvent
 *    The mouse event; not used
 */
_c.Handler.prototype.mouseEntered = function(e) {
   var menu = this.ui.menuItem;
   if (!menu.isEnabled()) {
      return;
   }

   var model = menu.getModel();
   if (menu.isRolloverEnabled()) {
      model.setRollover(true);
   }
   if (model.isPressed()) {
      model.setArmed(true);
   }

   var manager = vpx.gui.MenuSelectionManager.defaultManager();
   var path = manager.getSelectedPath();
   if (!menu.isTopLevelMenu()) {
      if (!(path.length > 0 && path[path.length - 1] == menu.getPopupMenu())) {
         this.ui._appendPath(this.ui.getPath(), menu.getPopupMenu());
      }
   } else {
      if (path.length > 0 && path[0] == menu.getParent()) {
         var newPath = new Array(3);
         // A top level menu's parent is by definition a MenuBar
         newPath[0] = menu.getParent();
         newPath[1] = menu;
         newPath[2] = menu.getPopupMenu();
         manager.setSelectedPath(newPath);
      }
   }
};

/**
 * Invoked when the cursor exits the menu. This method manages the rollover
 * and armed state of the menu.
 *
 * @param e [DOM Level 2 Events]MouseEvent
 *    The mouse event; not used
 */
_c.Handler.prototype.mouseExited = function(e) {
   var menu = this.ui.menuItem;
   var model = menu.getModel();
   if (menu.isRolloverEnabled()) {
      model.setRollover(false);
   }
   model.setArmed(false);
};


/**
 * class FrameHandler
 * extends Object
 * implements vpx.core.event.ChangeListener
 *
 * Listener that automatically gets registered with this ui's menu item.
 *
 * @version 1.0 (Oct 25, 2005)
 */

/**
 * Constructs a new Handler.
 */
_c.FrameHandler = function(ui) {
   this.ui = ui;
};

_c.FrameHandler.prototype.stateChanged = function(e) {
   var film = e.getSource();
   var p = this.ui.frame.getPeer();
   p.style.visibility = (film.isVisible() ? "visible" : "hidden");
};
