/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public  class NodeButtonUI
 * extends ButtonUI
 *
 * UI implementation for browser package "node buttons".
 *
 * @version 1.0 (Nov 7, 2005)
 */

/**
 *
 */
vpx.gui.plaf.NodeButtonUI = function() {
   if (arguments[0] == vpx.ABSTRACT_PASS) {
      // Skip object initialization
      return;
   }
};

// NodeButtonUI extends vpx.gui.plaf.ButtonUI
vpx.gui.plaf.NodeButtonUI.prototype = new vpx.gui.plaf.ButtonUI(vpx.ABSTRACT_PASS);
vpx.gui.plaf.NodeButtonUI.prototype.constructor = vpx.gui.plaf.NodeButtonUI;

// Shorthand for brevity's sake
var _c = vpx.gui.plaf.NodeButtonUI;    // Class
var _i = _c.prototype;                 // Instance
_i._concrete = true;                   // vpx system flag for concrete classes

// Instance variables
_i.button = null;                      // protected vpx.gui.AbstractButton
_i.oDivPeer = null;                    // protected HTMLDivElement
_i.iDivPeer = null;                    // protected HTMLDivElement
_i.handler  = null;                    // protected vpx.gui.plaf.NodeButtonUI.Handler

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.plaf.ComponentUI#initPeer()
 */
_i.initPeer = function(c) {
   var doc = c.getView().document;
   var href = doc.createElement("a");
   this.peer = href;

   var oDiv = doc.createElement("div");
   href.appendChild(oDiv);
   this.oDivPeer = oDiv;

   var iDiv = doc.createElement("div");
   oDiv.appendChild(iDiv);
   this.iDivPeer = iDiv;

   return href;
};

/**
 * Installs the default look of this UI.
 */
_i.installDefaults = function() {
   var href = this.peer;
   var oDiv = this.oDivPeer;
   var iDiv = this.iDivPeer;

   href.href = "#";
   if (this.button.isSelected()) {
      oDiv.className = "listKeyHilite listKeyHilited";
      iDiv.className = "listKey listKeySlctd";
   } else {
      oDiv.className = "listKeyHilite";
      iDiv.className = "listKey";
   }

   // This (as opposed to 'iDiv.innerHTML = "&nbsp;"') avoids Mozilla bug
   var view = vpx.xua.getView(href) || window;
   var doc = view.document;
   var tmp = doc.createElement("span");
   tmp.innerHTML = this.button.getText() || "&nbsp;";
   if (tmp.childNodes.length > 0) {
      iDiv.appendChild(tmp.firstChild);
   }
};

/**
 *
 * @param b vpx.gui.AbstractButton
 *    The button on which this ui is being installed
 */
_i.installListeners = function(b) {
   // super.installListeners(b)
   var spr = vpx.gui.plaf.ButtonUI.prototype;
   spr.installListeners.call(this, b);

   var listener = this.getHandler();
   if (listener != null) {
      b.addItemListener(listener);
   }
};

/**
 * Gets the peer responsible for serving up the tooltip text to the user.  This
 * returns the UI's <code>HTMLAnchorElement</code>.
 *
 * @return HTMLElement
 *    The peer that serves up tooltip text for this button
 * @see vpx.gui.plaf.ComponentUI#getTooltipPeer()
 */
_i.getTooltipPeer = function() {
   return this.peer;
};

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.plaf.ComponentUI#getPeerSection(int)
 */
_i.getPeerSection = function(sctn) {
   //?? XXX We're assuming only PEER_SECTION_CONTENT will ever be passed
   return this.iDivPeer;
};

/**
 *
 */
_i.getHandler = function() {
   if (this.handler == null) {
      this.handler = new vpx.gui.plaf.NodeButtonUI.Handler(this);
   }
   return this.handler;
};

/**
 * class Handler
 * extends Object
 * implements vpx.gui.event.ItemListener
 *
 * Listener that automatically gets registered with this ui's node button.
 *
 * @version 1.0 (Nov 8, 2005)
 */

/**
 * Constructs a new Handler.
 */
_c.Handler = function(ui) {
   if (arguments[0] == vpx.ABSTRACT_PASS) {
      // Skip object initialization
      return;
   }

   this.ui = ui;
};

/**
 * (non-Javadoc)
 *
 * @see vpx.core.event.ChangeListener#stateChanged(vpx.core.event.ChangeEvent)
 */
_c.Handler.prototype.itemStateChanged = function(e) {
   var c = vpx.gui.event.ItemEvent;
   var oDiv = this.ui.oDivPeer;
   var iDiv = this.ui.iDivPeer;

   switch (e.getStateChange()) {
   case c.SELECTED:
      oDiv.className = "listKeyHilite listKeyHilited";
      iDiv.className = "listKey listKeySlctd";
      break;
   case c.DESELECTED:
      oDiv.className = "listKeyHilite";
      iDiv.className = "listKey";
      break;
   default:
      throw new Error("Invalid state change: " + e.getStateChange());
      break;
   }
};
