/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public  class PopupMenuUI
 * extends ComponentUI
 *
 * UI implementation for popup menus.
 *
 * @version 1.0 (Oct 6, 2005)
 */

/**
 *
 */
vpx.gui.plaf.PopupMenuUI = function() {
   if (arguments[0] == vpx.ABSTRACT_PASS) {
      // Skip object initialization
      return;
   }

   // super()
   vpx.gui.plaf.ComponentUI.call(this);
};

// PopupMenuUI extends vpx.gui.plaf.ComponentUI
vpx.gui.plaf.PopupMenuUI.prototype = new vpx.gui.plaf.ComponentUI(vpx.ABSTRACT_PASS);
vpx.gui.plaf.PopupMenuUI.prototype.constructor = vpx.gui.plaf.PopupMenuUI;

// Shorthand for brevity's sake
var _c = vpx.gui.plaf.PopupMenuUI;     // Class
var _i = _c.prototype;                 // Instance
_i._concrete = true;                   // vpx system flag for concrete classes

// Class constants
_c.PEER_Z_INDEX = "102";               // private static final int

// Instance variables
_i.popup   = null;                     // protected vpx.gui.PopupMenu
_i.handler = null;                     // protected vpx.gui.plaf.PopupMenuUI.Handler

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.plaf.ComponentUI#installUI(vpx.gui.Component)
 */
_i.installUI = function(c) {
   if (this.peer == null) {
      this.initPeer(c);
   }
   this.popup = c;

   this.peer.style.visibility = c.isVisible() ? "visible" : "hidden";

   this.installDefaults();
   this.installListeners();
};

_i.installDefaults = function() {
   var c = vpx.gui.plaf.PopupMenuUI;
   var p = this.peer;

   p.style.position = "absolute";
   p.style.zIndex = c.PEER_Z_INDEX;
   p.style.backgroundColor = "white";
   p.style.visibility = "hidden";
   p.style.border = "1px groove black";
   p.style.visibility = "hidden";

   this._recalcPeerWidth();
};

_i.installListeners = function() {
   this.popup.addGlobalPropertyChangeListener(this.getHandler());
   this.popup.addContainerListener(this.getHandler());
};

_i.getHandler = function() {
   if (this.handler == null) {
      this.handler = new vpx.gui.plaf.PopupMenuUI.Handler(this);
   }
   return this.handler;
};

_i._recalcPeerWidth = function() {
   var popup = this.popup;
   var p = this.peer;
   var s = this.getPeerSection(this.PEER_SECTION_CHILDREN);
   var maxW = 0;

   p.style.width = "";
   for (var i = 0; i < s.childNodes.length; i++) {
      var child = s.childNodes[i];
      if (vpx.xua.ie) {
         // child.style.width="100%" will screw up child.clientWidth calculation
         child.style.width = "1px";
      }
      if (child.clientWidth > maxW) {
         maxW = child.clientWidth;
      }
      if (vpx.xua.ie) {
         child.style.width = "100%";
      }
   }

   if (popup.isPreferredSizeSet()) {
      var prefSize = popup.getPreferredSize();
      if (prefSize.width > maxW) {
         maxW = prefSize.width;
      }
   }

   p.style.width = maxW + "px";
};

/**
 * class Handler
 * extends Object
 * implements vpx.gui.event.PropertyChangeListener,
 *            vpx.gui.event.ContainerListener
 *
 * Listener that automatically gets registered with this ui's popup menu.
 *
 * @version 1.0 (Oct 11, 2005)
 */

/**
 * Constructs a new Handler.
 */
_c.Handler = function(ui) {
   this.ui = ui;
};

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.event.PropertyChangeListener#propertyChange(vpx.gui.event.PropertyChangeEvent)
 */
_c.Handler.prototype.propertyChange = function(e) {
   var name = e.getPropertyName();
   var peer = this.ui.peer;

   switch (name) {

   case vpx.gui.Component.VISIBILITY_PROPERTY:
      var visible = e.getNewValue();
      peer.style.visibility = visible ? "visible" : "hidden";
      break;

   case vpx.gui.PopupMenu.LOCATION_PROPERTY:
      var p = e.getNewValue();
      var invoker = this.ui.popup.getInvoker();
      if (invoker != null) {
         var d = invoker.getLocation(this.ui.popup.getView());
         p.translate(d.x, d.y);
      }
      peer.style.left = p.x + "px";
      peer.style.top = p.y + "px";
      break;

   case vpx.gui.Component.PREF_SIZE_PROPERTY:
      this.ui._recalcPeerWidth();
      break;

   default:
      // Ignore property
      break;

   }
};

/**
 * Implements <code>ContainerListener</code>. Called when a component is added
 * to this UI's popup menu.
 *
 * @param e vpx.gui.event.ContainerEvent
 *    The <code>ContainerEvent</code> object
 */
_c.Handler.prototype.componentAdded = function(e) {
   this.ui._recalcPeerWidth();
};

/**
 * Implements <code>ContainerListener</code>. Called when a component is
 * removed from this UI's popup menu.
 *
 * @param e vpx.gui.event.ContainerEvent
 *    The <code>ContainerEvent</code> object
 */
_c.Handler.prototype.componentRemoved = function(e) {
   this.ui._recalcPeerWidth();
};
