/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public  class RadioButtonMenuItemUI
 * extends vpx.gui.plaf.MenuItemUI
 *
 * UI implementation for radio button menu items.
 *
 * @version 1.0 (Oct 14, 2005)
 */

/**
 *
 */
vpx.gui.plaf.RadioButtonMenuItemUI = function() {
   if (arguments[0] == vpx.ABSTRACT_PASS) {
      // Skip object initialization
      return;
   }

   // super()
   vpx.gui.plaf.MenuItemUI.call(this);
};

// RadioButtonMenuItemUI extends vpx.gui.plaf.MenuItemUI
vpx.gui.plaf.RadioButtonMenuItemUI.prototype = new vpx.gui.plaf.MenuItemUI(vpx.ABSTRACT_PASS);
vpx.gui.plaf.RadioButtonMenuItemUI.prototype.constructor = vpx.gui.plaf.RadioButtonMenuItemUI;

// Shorthand for brevity's sake
var _c = vpx.gui.plaf.RadioButtonMenuItemUI;  // Class
var _i = _c.prototype;                        // Instance
_i._concrete = true;                          // vpx system flag for concrete classes

// Class variables
_i.PEER_SECTION_RADIO    = 0;
_i.PEER_SECTION_ICON     = 1;
_i.PEER_SECTION_CONTENT  = 2;
_i.PEER_SECTION_CHILDREN = 3;

// Instance variables
_i.radioPeer = null;                          // protected transient HTMLInputElement

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.plaf.ComponentUI#initPeer(vpx.gui.Component)
 */
_i.initPeer = function(c) {
   var doc = c.getView().document;
   var p = doc.createElement("div");
   this.peer = p;

   // Radio peer, special to radio button menu items
   var r = doc.createElement("input");
   r.type = "radio";
   this.getPeerSection(this.PEER_SECTION_RADIO).appendChild(r);
   this.radioPeer = r;

   return p;
};

_i.installDefaults = function() {
   // super.installDefaults()
   var spr = vpx.gui.plaf.MenuItemUI.prototype;
   spr.installDefaults.call(this);

   var r = this.radioPeer;
   r.checked = this.menuItem.isSelected();
   r.style.width = r.style.height = "9px";
   r.style.marginRight = "5px";
};

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.plaf.ComponentUI#_initSections()
 */
_i._initSections = function() {
   this.sections = [];
   this.sections[this.PEER_SECTION_RADIO] = null;
   this.sections[this.PEER_SECTION_ICON] = null;
   this.sections[this.PEER_SECTION_CONTENT] = null;
   this.sections[this.PEER_SECTION_CHILDREN] = null;
};

_i.getHandler = function() {
   if (this.handler == null) {
      this.handler = new vpx.gui.plaf.RadioButtonMenuItemUI.Handler(this);
   }
   return this.handler;
};

/**
 * class Handler
 * extends vpx.gui.plaf.MenuItemUI.Handler
 * implements vpx.core.event.ChangeListener
 *
 * Listener that automatically gets registered with this ui's menu item.
 *
 * @version 1.0 (Oct 14, 2005)
 */

/**
 * Constructs a new Handler.
 */
_c.Handler = function(ui) {
   this.ui = ui;
};

// Handler extends vpx.gui.plaf.MenuItemUI.Handler
_c.Handler.prototype = new vpx.gui.plaf.MenuItemUI.Handler(vpx.ABSTRACT_PASS);
_c.Handler.prototype.constructor = _c.Handler;

/**
 * (non-Javadoc)
 *
 * @see vpx.core.event.ChangeListener#stateChanged(vpx.core.event.ChangeEvent)
 */
_c.Handler.prototype.stateChanged = function(e) {
   // super.stateChanged(e)
   var spr = vpx.gui.plaf.MenuItemUI.Handler.prototype;
   spr.stateChanged.call(this, e);

   var selected = this.ui.menuItem.isSelected();
   this.ui.radioPeer.checked = selected;

   var p = this.ui.peer;
   if (selected) {
      p.style.color = "#000";
      p.style.cursor = "default";
   } else {
      p.style.cursor = "pointer";
   }
};
