/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public class SeparatorUI
 * extends ComponentUI
 *
 * UI implementation for separators.
 *
 * @version 1.0 (Oct 6, 2005)
 */

/**
 *
 */
vpx.gui.plaf.SeparatorUI = function() {
   if (arguments[0] == vpx.ABSTRACT_PASS) {
      // Skip object initialization
      return;
   }

   // super()
   vpx.gui.plaf.ComponentUI.call(this);
};

// SeparatorUI extends vpx.gui.plaf.ComponentUI
vpx.gui.plaf.SeparatorUI.prototype = new vpx.gui.plaf.ComponentUI(vpx.ABSTRACT_PASS);
vpx.gui.plaf.SeparatorUI.prototype.constructor = vpx.gui.plaf.SeparatorUI;

// Shorthand for brevity's sake
var _c = vpx.gui.plaf.SeparatorUI;     // Class
var _i = _c.prototype;                 // Instance
_i._concrete = true;                   // vpx system flag for concrete classes

// Instance variables
_i.separator = null;                   // protected vpx.gui.Separator

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.plaf.ComponentUI#installUI(vpx.gui.Component)
 */
_i.installUI = function(c) {
   this.initPeer(c);
   this.separator = c;

   this.installDefaults();
};

_i.installDefaults = function() {
   var p = this.peer;
   p.style.width = "95%";
};

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.plaf.ComponentUI#initPeer(vpx.gui.Component)
 */
_i.initPeer = function(c) {
   var p = c.getView().document.createElement("hr");
   this.peer = p;
   return p;
};
