/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public class HttpResponse
 * extends Object
 *
 * TODO
 *
 * @version 1.0 (Dec 12, 2005)
 */

/**
 * Constructs a new <code>HttpResponse</code> initialized with the given text,
 * xml, status, and status message.
 *
 * @param contentType String
 *
 * @param text String
 *
 * @param xml [DOM Level 1 Core]Document
 *
 * @param status int
 *
 * @param statusMsg String
 */
vpx.net.HttpResponse = function HttpResponse(contentType, text, xml, status, statusMsg) {
   this.contentType = contentType;
   this.text = text;
   this.xml = xml;
   this.status = status;
   this.statusMsg = statusMsg;
};

// Shorthand for brevity's sake
var _c = vpx.net.HttpResponse;        // Class
var _i = _c.prototype;                // Instance
_i._concrete = true;                  // vpx system flag for concrete classes

// Instance variables
_i.contentType = null;                // protected String
_i.text = null;                       // protected String
_i.xml = null;                        // protected [DOM Level 1 Core]Document
_i.status = null;                     // protected int
_i.statusMsg = null;                  // protected String

/**
 * Gets the content type of the data returned from the server process.
 *
 * @return String
 *    The <code>contentType</code> property of this response
 */
_i.getContentType = function() {
   return this.contentType;
};

/**
 * Gets the string version of data returned from server process.
 *
 * @return String
 *    The <code>text</code> property of this response
 */
_i.getText = function() {
   return this.text;
};

/**
 * Gets the DOM-compatible document object of data returned from the server
 * process.
 *
 * @return [DOM Level 1 Core]Document
 *    The <code>xml</code> property of this response
 */
_i.getXml = function() {
   return this.xml;
};

/**
 * Gets the status (e.g. <code>200</code> for "OK" or <code>404</code> for "Not
 * Found") of this response.
 *
 * @return int
 *    The <code>status</code> property of this response
 */
_i.getStatus = function() {
   return this.status;
};

/**
 * Gets the status message (e.g. <code>OK</code> or <code>Not Found</code>) of
 * this response.
 *
 * @return String
 *    The <code>statusMsg</code> property of this response
 */
_i.getStatusMsg = function() {
   return this.statusMsg;
};

/**
 * (non-Javadoc)
 *
 * @see Object#toString()
 */
_i.toString = function() {
   return "[Object vpx.net.HttpResponse]";
};
