/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public class ResponseEvent
 * extends vpx.core.Event
 *
 * ResponseEvent is used to notify interested parties that the server has
 * completed its response to a client-side request.
 */

/**
 * Constructs a <code>ResponseEvent</code> object.
 *
 * @param source vpx.net.HttpResponse
 *    The response object that is the source of the event
 * @param request vpx.net.HttpRequest
 *    The request that triggered the response
 * @throws Error
 *    If <code>source</code> is null
 */
vpx.net.event.ResponseEvent = function ResponseEvent(source, request) {
   var id = vpx.net.event.ResponseEvent.RESPONSE_RECEIVED;
   vpx.core.Event.call(this, source, id);
   this.request = request;
};

// ResponseEvent extends vpx.core.Event
vpx.net.event.ResponseEvent.prototype = new vpx.core.Event(vpx.ABSTRACT_PASS);
vpx.net.event.ResponseEvent.prototype.constructor = vpx.net.event.ResponseEvent;

// Shorthand for brevity's sake
var _c = vpx.net.event.ResponseEvent; // Class
var _i = _c.prototype;                // Instance
_i._concrete = true;                  // vpx system flag for concrete classes

// Instance variables
_i.request = null;                    // private vpx.net.HttpRequest

/**
 * This event id indicates a response received.
 */
_c.RESPONSE_RECEIVED = 3101;          // public static final int

/**
 * Gets the request that triggered the response that triggered this event.
 *
 * @return vpx.net.HttpRequest
 *    The request that triggered the response
 */
_i.getRequest = function() {
   return this.request;
};

/**
 * (non-Javadoc)
 *
 * @see Object#toString()
 */
_i.toString = function() {
   var typeStr;
   switch (this.id) {
   case vpx.net.event.ResponseEvent.RESPONSE_RECEIVED:
      typeStr = "RESPONSE_RECEIVED";
      break;
   default:
      typeStr = "unknown type";
      break;
   }

   return typeStr;
};
