/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

// Create the package namespace
vpx.updates = {};

/**
 * Events that can be listened for using vpx.EventSource#registerListener().
 * When events are fired, each listener will be invoked in the order in which
 * they subscribed to the event.  They will automatically be passed certain
 * arguments, which are documented inline for each event.
 */
vpx.updates.EVENT = {
   "UPDATE"  : 0   /**
                    * Updates are needed
                    *
                    * @param agent vpx.updates.Agent
                    *    The agent that fired the event
                    * @param refresh boolean
                    *    true if a full refresh is required; false otherwise
                    * @param changeSets (optional) Object[]
                    *    An array of changeSet objects, each having the
                    *    following attributes:
                    *       id      : String
                    *       type    : String
                    *       changes : Object[] {property:String, value:String}
                    */
};
