/* Copyright 2006 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public class PropertyEvent
 * extends vpx.core.Event
 *
 * PropertyEvent is used to notify interested parties that a set of view
 * properties has been updated from the server.
 */

/**
 * Constructs a <code>PropertyEvent</code> object.
 *
 * @param source vpx.util.view.PropertyCollector
 *    The object that is the source of the event
 * @throws Error
 *    If <code>source</code> is null
 */
vpx.util.view.PropertyEvent = function(source) {
   var id = vpx.util.view.PropertyEvent.PROPERTIES_UPDATED;
   vpx.core.Event.call(this, source, id);
};

// PropertyEvent extends vpx.core.Event
vpx.util.view.PropertyEvent.prototype = new vpx.core.Event(vpx.ABSTRACT_PASS);
vpx.util.view.PropertyEvent.prototype.constructor = vpx.util.view.PropertyEvent;

// Shorthand for brevity's sake
var _c = vpx.util.view.PropertyEvent;    // Class
var _i = _c.prototype;                   // Instance
_i._concrete = true;                     // vpx system flag for concrete classes

/**
 * This event id indicates an update to a set of properties
 */
_c.PROPERTIES_UPDATED = 4101;            // public static final int

/**
 * (non-Javadoc)
 *
 * @see Object#toString()
 */
_i.toString = function() {
   var typeStr;
   switch (this.id) {
   case vpx.util.view.PropertyEvent.PROPERTIES_UPDATED:
      typeStr = "PROPERTIES_UPDATED";
      break;
   default:
      typeStr = "unknown type";
      break;
   }

   return typeStr;
};
