/* Copyright 2006 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public interface PropertyListener
 *
 * The listener interface for receiving property events. The class that is
 * interested in processing a property event implements this interface (and
 * all the methods it contains). The listener object created from that class is
 * then registered with a property collector using the collector's
 * <code>addPropertyListener</code> method. When the collector receives an
 * update to view properties from the server, the relevant method in
 * the listener object is invoked, and the <code>PropertyEvent</code> is
 * passed to it.
 *
 * @version 1.0 (Feb 13, 2006)
 */

// This file simply defines an interface. It should not be loaded into HTML
throw new Error("Interface vpx.util.view.PropertyListener cannot be instantiated");

/**
 * Invoked when the property collector has received an update from the server.
 *
 * @param e vpx.util.view.PropertyEvent
 *    The event object describing the event source
 */
vpx.util.view.PropertyListener.prototype.propertiesUpdated = function(e) {};
