/* Copyright 2005 VMware, Inc.  All rights reserved. -- VMware Confidential */

vpx.win.FrameSpec = function (size, placementPolicy, resizePolicy, minSize, maxSize, modal, alwaysOnTop) {

   this.size = size;

   this.placementPolicy =
   placementPolicy || vpx.win.PLACEMENT_POLICY_DEFAULT;

   this.resizePolicy =
   resizePolicy || vpx.win.RESIZE_POLICY_DEFAULT;

   this.minSize = minSize;

   this.maxSize = maxSize;

   this.modal = (isDefined(modal) ? modal : vpx.win.MODAL_DEFAULT);

   if (this.modal) {
      this.alwaysOnTop = true;
   } else if (isDefined(alwaysOnTop)) {
      this.alwaysOnTop = alwaysOnTop;
   } else {
      this.alwaysOnTop = vpx.win.ALWAYS_ON_TOP_DEFAULT;
   }

   this.element = null;
};

vpx.win.DEFAULT_FRAME_SPEC = new vpx.win.FrameSpec();

vpx.win.FrameSpec.prototype.getPlacementPolicy = function () {
   return this.placementPolicy;
};

vpx.win.FrameSpec.prototype.setPlacementPolicy = function (policy) {
   return this.placementPolicy = policy;
};

vpx.win.FrameSpec.prototype.getResizePolicy = function () {
   return this.resizePolicy;
};

vpx.win.FrameSpec.prototype.setResizePolicy = function (policy) {
   return this.resizePolicy = policy;
};

vpx.win.FrameSpec.prototype.getMinSize = function () {
   return this.minSize;
};

vpx.win.FrameSpec.prototype.setMinSize = function (size) {
   return this.minSize = size;
};

vpx.win.FrameSpec.prototype.getMaxSize = function () {
   return this.maxSize;
};

vpx.win.FrameSpec.prototype.setMaxSize = function (size) {
   return this.maxSize = size;
};

vpx.win.FrameSpec.prototype.getModal = function () {
   return this.modal;
};

vpx.win.FrameSpec.prototype.setModal = function (modal) {
   return this.modal = modal;
};

vpx.win.FrameSpec.prototype.getAlwaysOnTop = function () {
   return this.alwaysOnTop;
};

vpx.win.FrameSpec.prototype.setAlwaysOnTop = function (alwaysOnTop) {
   return this.alwaysOnTop = alwaysOnTop;
};
