/* Copyright 2005 VMware, Inc.  All rights reserved. -- VMware Confidential */

var VPX_WIN_SOURCE_TYPES = {
   "SOURCE_TYPE_URL"             : 1,
   "SOURCE_TYPE_STRING"          : 2,
   "SOURCE_TYPE_STRING_ELEMENT"  : 4,
   "SOURCE_TYPE_STRING_DOCUMENT" : 8,
   "SOURCE_TYPE_DOM_ELEMENT"     : 16,
   "SOURCE_TYPE_DOM_DOCUMENT"    : 32,
   "SOURCE_TYPE_CSS_CLASS"       : 64,
   "SOURCE_TYPE_CSS_STYLE"       : 128
};


var VPX_WIN_PLACEMENT_POLICIES = {
   "PLACEMENT_POLICY_INLINE"     : 0,
   "PLACEMENT_POLICY_CASCADE"    : 1,
   "PLACEMENT_POLICY_CENTER"     : 2
};


var VPX_WIN_RESIZE_POLICIES = {
   "RESIZE_POLICY_RESIZABLE"     : 1,
   "RESIZE_POLICY_SHRINKWRAP"    : 2
};


vpx.win = {
   "RESIZE_POLICY_DEFAULT"       : 2,
   "PLACEMENT_POLICY_DEFAULT"    : 1,
   "MODAL_DEFAULT"               : false,
   "ALWAYS_ON_TOP_DEFAULT"       : false
};

extendObject(vpx.win, VPX_WIN_SOURCE_TYPES);
extendObject(vpx.win, VPX_WIN_PLACEMENT_POLICIES);
extendObject(vpx.win, VPX_WIN_RESIZE_POLICIES);

vpx.win.manage = function (o) {
   var cs = clone(vpx.win.DEFAULT_CONTENT_SPEC, true);
   var fs = clone(vpx.win.DEFAULT_FRAME_SPEC, true);
   fs.setPlacementPolicy(vpx.win.PLACEMENT_POLICY_INLINE);
   var rs = clone(vpx.win.DEFAULT_ROOT_SPEC, true);
   var win = new vpx.win.Frame(cs, fs, rs, self);
   win.element = $(o);
   return win;
};


vpx.win.alert = function (message, callback, context) {
   var cs = new vpx.win.SourceSpec(vpx.win.SOURCE_TYPE_URL, "html/messageBoxContent.html");

   var rs = new vpx.win.RootSpec(
                                 new vpx.win.SourceSpec(vpx.win.SOURCE_TYPE_URL, "html/alertRoot.html")
                                 );

   if (!context) {
      context = (isView(this) ? this : self);
   }

   var msgBox = new vpx.win.Frame(cs, null /* frameSpec */, rs, context);

   msgBox.listen("ready", function (o) {
      // XXX: i18n?
      o.setTitle(new vpx.win.SourceSpec(
                                        o.SOURCE_TYPE_STRING, jsAlert
                                        ));

      o.setIcon(new vpx.win.SourceSpec(
                                       vpx.win.SOURCE_TYPE_CSS_CLASS, "warning-32x32"
                                       ));

      o.setMessage(new vpx.win.SourceSpec(vpx.win.SOURCE_TYPE_STRING, message));

      o.setPlacementPolicy(o.PLACEMENT_POLICY_CENTER);

      o.setModal(true);

      o.open();
   });

   if (isDefined(callback)) {
      msgBox.listen("cancel", callback.bind(msgBox));
   }

   msgBox.init();
};


/**
 * vpx.win.confirm() shows a modal dialog with OK and Cancel buttons and calls a provided
 * callback. The callback function receives a boolean parameter which can be queried
 * whether the user cas clicked OK (true) or Cancel (false);
 *
 * @param errorMsg to *localized* error string
 * @param context the window object where to cover with the error dialog
 * @param callback with signature function(okayBool) {}
 */

/**
 * vpx.win.confirm() shows a modal dialog with OK and Cancel buttons and calls a provided
 * callback. The callback function receives a boolean parameter which can be queried
 * whether the user cas clicked OK (true) or Cancel (false);
 *
 * @param errorMsg to *localized* error string
 * @param context the window object where to cover with the error dialog
 * @param callbackOkay with signature function(okayBool) {}
 * @param callbackCancel with signature function(okayBool) {}
 */

vpx.win.confirm = function (message, context, callbackOkay, callbackCancel) {
   var cs = new vpx.win.SourceSpec(vpx.win.SOURCE_TYPE_URL, "html/messageBoxContent.html");

   var rs = new vpx.win.RootSpec(
                                 new vpx.win.SourceSpec(vpx.win.SOURCE_TYPE_URL, "html/confirmRoot.html")
                                 );

   if (!context) {
      context = (isView(this) ? this : self);
   }

   var msgBox = new vpx.win.Frame(cs, null /* frameSpec */, rs, context);

   msgBox.listen("ready", function (o) {
      // XXX: i18n?
      o.setTitle(new vpx.win.SourceSpec(
                                        o.SOURCE_TYPE_STRING, jsConfirm
                                        ));

      o.setIcon(new vpx.win.SourceSpec(
                                       vpx.win.SOURCE_TYPE_CSS_CLASS, "information-32x32"
                                       ));

      o.setMessage(new vpx.win.SourceSpec(vpx.win.SOURCE_TYPE_STRING, message));

      o.setPlacementPolicy(o.PLACEMENT_POLICY_CENTER);

      o.setModal(true);

      o.open();
   });
   

   // Backward compatible
   if (arguments.length==3) {
      if (isDefined(callbackOkay)) {
         msgBox.listen("okay", callbackOkay.bind(msgBox));
         msgBox.listen("cancel", callbackOkay.bind(msgBox));
      }
      
   }
   // encouraged style for asynchronous notification
   if (arguments.length==4) {
      if (isDefined(callbackOkay)) {
         msgBox.listen("okay", callbackOkay.bind(msgBox));
      }
      if (isDefined(callbackCancel)) {
         msgBox.listen("cancel", callbackCancel.bind(msgBox));
      }
   }
   
   msgBox.init();
};


vpx.win.prompt = function (message, value, callback) {
   var cs = new vpx.win.SourceSpec(vpx.win.SOURCE_TYPE_URL, "html/messageBoxContent.html");

   var rs = new vpx.win.RootSpec(
                                 new vpx.win.SourceSpec(vpx.win.SOURCE_TYPE_URL, "html/promptRoot.html")
                                 );

   var context = (isView(this) ? this : self);

   var msgBox = new vpx.win.Frame(cs, null /* frameSpec */, rs, context);

   msgBox.listen("ready", function (o) {
      // XXX: i18n?
      o.setTitle(new vpx.win.SourceSpec(
                                        o.SOURCE_TYPE_STRING, jsPrompt
                                        ));

      o.setIcon(new vpx.win.SourceSpec(
                                       vpx.win.SOURCE_TYPE_CSS_CLASS, "information-32x32"
                                       ));

      if (isDefined(value)) {
         o.setReturnValue(value);
      }

      o.setMessage(new vpx.win.SourceSpec(vpx.win.SOURCE_TYPE_STRING, message));

      o.setPlacementPolicy(o.PLACEMENT_POLICY_CENTER);

      o.setModal(true);

      o.open();
   });

   if (isDefined(callback)) {
      msgBox.listen("okay", callback.bind(msgBox));
      msgBox.listen("cancel", callback.bind(msgBox));
   }
   
   msgBox.init();
};


/**
 * vpx.win.error() calls the errorsDialog.jsp for showing user errors 
 * corresponding to the provided handler type
 *
 * @param errorMsg to *localized* error string
 * @param handlerType the handler type specified in Constants.java#.._EXCEPTION_HANDLER;
 * @param context [optional] the window object where to cover with the error dialog
 */

vpx.win.error = function (errorMsg, handlerType, context) {
   if (!context) {
      context = (isView(this) ? this : self);
   }
   var url = "genericErrorsSetup.do?errors=" + vpx.xua.urlEncode(errorMsg) + "&exceptionHandler=" + handlerType;
   var rs = new vpx.win.RootSpec(new vpx.win.SourceSpec(vpx.win.SOURCE_TYPE_URL, url));       
   var msgBox = new vpx.win.Frame(null, null, rs, context);       
   msgBox.listen("ready", function (o) {       
   o.setPlacementPolicy(o.PLACEMENT_POLICY_CENTER);
   o.setIcon(new vpx.win.SourceSpec(vpx.win.SOURCE_TYPE_CSS_CLASS, "error-16x16"));
   o.setModal(true);       
   o.open();       
   });      

   msgBox.init(); 
};
