/**
 * Sets the given step as "active" in the wizard's table of contents.
 *
 * @param stepName String
 *    The unique name of the step to display as active in the table of
 *    contents
 */
function syncContentsToStep(stepName) {
   try {
      var contents = tle.getWorkspacePane().workspaceDetails.wc_wizardContentsPane;
      contents.syncToStep(stepName);
   } catch (ex) {
      // Contents window is not yet fully loaded - try again in a bit
      window.setTimeout("syncContentsToStep('" + stepName + "')", 100);
   }
}
