var submitted = false;
var eula;
var MAX_PARTITIONS = 10;
var MAX_SWAP = 1;
var SPECIAL_OPT_OTHER = "specialOptOther";
var usedSwap = new Array();

function checkIPAddress(addr) {
  if (null == addr.match(/^\s*\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\s*$/))
    return false;

  var octets = addr.split('.');

  for (var ndx = 0; ndx < octets.length; ndx++) {
    var octIntVal = parseInt(octets[ndx]);
    if (octIntVal < 0 || octIntVal > 255)
      return false;
  }

  return true;
}

function checkHostName(hostName) {
   return hostName.match(/^\w[\w-]{0,62}(\.[\w-]{1,63})*\.?$/) &&
      hostName.length <= 255;
}

//validate the netmask
function checkNetmask(addr) {
  
  var ip = 0;

  //bail if the ip is not the right format
  if (null == addr.match(/^\s*\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\s*$/))
    return false;

  var octets = addr.split('.');

  //create a 32bit integer representing the netmask
  for (var ndx = 0; ndx < octets.length; ndx++) {
    ip = (ip <<= 8) | octets[ndx];
  }

  //setting this to just 0x80000000 results in a positive int
  // |ing it with itself seems to set it to the proper negative value, 
  //javascript is weird
  var oneBit = 0x80000000 & 0x80000000;

  //walk the bits till we hit a zero
  while ((oneBit & ip) == oneBit) {
    ip <<= 1;
  }

  //if the remaining bits are zero then the netmask is valid, else not
  return (0 == ip);
}

function checkMount(mount) {
   return mount.match(/^\/([^\s\\\/]+\/?)*$/);
}

function checkValidVmfs(mount) {
   return mount.match(/^[^\s\\\/]+$/);
}

function checkWholeNumber(number) {
   var verifyNumber = parseInt(number);
   return (number.match(/^\s*\d+\s*$/) && verifyNumber >= 0);
}

function checkWholeNumberRangeInclusive(number, min, max) {
   return (checkWholeNumber(number) && (number >= min) && (number <= max));
}

function check_rs() {

   if (document.forms[0].install_method.value == 'remote' ||
       document.forms[0].install_method.value == 'nfs') {
      document.forms[0].remote_server.disabled = false;
   }
   else {
      document.forms[0].remote_server.disabled = true;
   }
}

function check_upgrade() {
   var doingUpgrade = 
    (document.forms[0].install_type.value == 'upgrade' ? true : false);

   document.forms[0].tz.disabled = doingUpgrade;
   document.forms[0].passwd1.disabled = doingUpgrade;
   document.forms[0].passwd2.disabled = doingUpgrade;
   document.forms[0].network.disabled = doingUpgrade;
   document.forms[0].createDefaultNetwork.disabled = doingUpgrade;
   document.forms[0].vlanId.disabled = doingUpgrade;
}

function check_type(partIndex) {
   var type = eval("document.forms[0].type" + partIndex).value;
   var mountPoint = eval("document.forms[0].mount" + partIndex)
   
   if (type == 'ext3' || type == 'vmfs2' || type == 'vmfs3') {
      mountPoint.disabled = false;
   }
   else {
      mountPoint.disabled = true;
   }

   return true;
}

function checkValidNetwork(text) {
   return text.match(/\s*\w+\s*/);
}

function getVirtualSwitchList() {
   var list = new Array();
   var listCount = 0;
   var q = new Query(document.forms[0]);
   
   list[listCount++] = "";
   for (i = 0; i < 8; i++) {
      var netName = q.arg('switchName' + i)[0];
      if (checkValidNetwork(netName)) {
         list.push(netName);
      };
   }

   return list;
}

// --------------------------------------------------------------------------
// This function populates the Network selection page.

function populateNicSelection() {
   var numNics = document.forms[0].numNic.value;
   var tableBody = obj("nicTable");
   
   var trs = tableBody.getElementsByTagName("tr");
   while (trs.length > 0) {
      tableBody.removeChild(trs.item(0));
   }
   
   switchList = getVirtualSwitchList();
   trList = new Array();

   //Get the list of virtual switches and populate the html page with one select
   //box for each nic in the system.
   //The layout is in columns, if there are less than "NUM_PER_COLUMN" nics in
   //the system then the cards are laid out in a single column otherwise they
   //are laid out in 2 columns.
   var NUM_PER_COLUMN = 16;
   var tr;
   for (i = 0; i < numNics; i++) {
      
      //for the first NUM_PER_COLUMN nics add a tr and put it in trList so we
      //can use it later if needed.
      if (i < NUM_PER_COLUMN) {
         tr = document.createElement("tr");
         tr.setAttribute("class", "bdy");
         tableBody.appendChild(tr);
         trList[i] = tr;
      }
      //reuse one of the trs and just add a new column
      else {
         tr = trList[i % NUM_PER_COLUMN];
      }
         
      //create a new TD and add it to the current TR which is either an empty
      //TR or a TR with an existing column.
      var label = document.createElement("td");
      var input = document.createElement("td");
      label.setAttribute("align", "left");
      label.setAttribute("width", "25%");
      input.setAttribute("align", "center");
      input.setAttribute("width", "25%");
   
      var selectList = document.createElement("select");
      selectList.setAttribute("name", "nicList" + i);
      selectList.setAttribute("id", "nicList" + i);
      //selectList.setAttribute("size", 25);

      for (j = 0; j < switchList.length; j++) {
         var option = document.createElement("option");
         option.setAttribute("value", switchList[j]);
         option.appendChild(document.createTextNode(switchList[j]));
         selectList.appendChild(option);
      }

      label.appendChild(document.createTextNode("NIC " + (i + 1)))
      input.appendChild(selectList)
      tr.appendChild(label);
      tr.appendChild(input);
   }
}

// --------------------------------------------------------------------------

function populateKnownVmfs() {
   var selectList = obj("swapKnownVolumes");
   var tableBody = obj("nicTable");
   var q = new Query(document.forms[0]);

   //clear the existing list:
   var options = selectList.getElementsByTagName("option");
   while (options.length > 0) {
      selectList.removeChild(options.item(0));
   }

   for (id = 0; id < MAX_PARTITIONS; id++) {
      var mount = q.arg('mount' + id)[0];
      var type = q.arg('type' + id)[0];
      
      if (type == 'vmfs2') {

         var newOption = document.createElement("option");
         newOption.setAttribute("value", mount);
         newOption.appendChild(document.createTextNode(mount));
         selectList.appendChild(newOption);
      }
   }

   var newOption = document.createElement("option");
   newOption.setAttribute("value", SPECIAL_OPT_OTHER);
   newOption.appendChild(document.createTextNode("Other..."));
   selectList.appendChild(newOption);
}

function createSwap() {
   var q = new Query(document.forms[0]);
   var knownSwap = obj("swapKnownVolumes").value;
   var existingSwap = obj("swapExistingVol").value;
   var swapFileSize = obj("swapFileSize").value;
   var ipAddress = q.arg("ipaddress")[0];
   var network = q.arg("network")[0];
   var volume;
   var name;

   if (knownSwap == SPECIAL_OPT_OTHER) {
      volume = existingSwap;

      if (!checkValidVmfs(existingSwap)) {
         alert(existingSwap + " is not a valid VMFS name");
         return;
      }
   }
   else {
      volume = knownSwap;
   }

   var swapFileName = obj("swapFileName").value;

   if (swapFileName != "") {

      if (!swapFileName.match(/^[\w-\.]+\.vswp$/)) {
         alert("Invalid Swap File Name, must contain only alphanumeric characters, dashes, periods, and must end in '.vswp'");
         return;
      }
      name = swapFileName;
   }
   else if (network == 'dhcp') {
      alert("Invalid Swap File Name, default only available when using static IP allocation");
      return false;
   }
   else {
      name = ipAddress + "-";
   }

   if (!checkWholeNumber(swapFileSize)) {
          alert("Swap File Size must be a whole positive number");
          return;
   }
   
   var created = 0;
   for (i = 0; i < MAX_SWAP; i++) {
      if (usedSwap[i] == 0 || (typeof(usedSwap[i]) == "undefined")) {
         usedSwap[i] = 1;

         var swapDiv = obj("swapDiv" + i);
         var swapVol = eval("document.forms[0].swapVol" + i);
         var swapName = eval("document.forms[0].swapName" + i);
         var swapSize = eval("document.forms[0].swapSize" + i);
         var swapEnable = eval("document.forms[0].swapEnable" + i);
         
         if (swapFileName != "") {
            name = swapFileName;

            if (!name.match(/\.vswp$/)) {
               name = name + ".vswp";
            }
         }
         else if (network == 'dhcp') {
            name = "DHCP-" + i + ".vswp";
         }
         else {
            name = ipAddress + "-" + i + ".vswp";
         }

         swapDiv.style.display = "";
         swapVol.value = volume;
         swapName.value = name;
         swapSize.value = swapFileSize;
         swapEnable.value = q.arg("enableSwap")[0];
         created = 1;
         break;
      }
   }

   if (!created) {
      alert("Max number of Swap files (" + MAX_SWAP + ") reached");
   }
}

function delSwap(index) {
   usedSwap[index] = 0;
   var swapDiv = obj("swapDiv" + index);
   swapDiv.style.display = "none";

   var swapVol = eval("document.forms[0].swapVol" + index);
   var swapName = eval("document.forms[0].swapName" + index);
   var swapSize = eval("document.forms[0].swapSize" + index);
   var swapEnable = eval("document.forms[0].swapEnable" + index);

   swapVol.value = "";
   swapName.value = "";
   swapSize.value = "";
   swapEnable.value = "";

}

function checkDisabled() {
   var knownSwap = obj("swapKnownVolumes").value;

   if (knownSwap == SPECIAL_OPT_OTHER) {
      document.forms[0].swapExistingVol.disabled = false;
   }
   else {
      document.forms[0].swapExistingVol.disabled = true;
   }
}

// --------------------------------------------------------------------------

function exit(idx) {
  parent.close();
}

// --------------------------------------------------------------------------

function opCb(w) {

  if (w.scriptedInstallSetup != null) {
    if (false == w.scriptedInstallSetup) {
      self.location.replace("/vmware/en/esxScriptedInstallSetup.html");
      return;
    }
  }

  
  setTimeZone(w.timeZone);

  if (w.wrn.length > 0) {
    var s = "One or more warnings were generated:";
    for (var i in w.wrn) {
      s += "\n\n" + w.wrn[i];
    }
    alert(s);
  }

  if (w.err.length > 0) {
    var s = "One or more errors occurred:";
    for (var i in w.err) {
      s += "\n\n" + w.err[i];
    }
    alert(s);
  }

  if (eula == null) {
      eula = obj("eula");
      window.setTimeout("eula.doc().location.replace('/eula');", 100);
   }

  if (submitted) {
    submitted = false;

    if (w.err.length > 0) {
      prev();
      return;
    }
  }
  
  if (w.versionMismatch) {
    var msgText = obj("mismatchText");
    msgText.style.display = "";

    var msgData = obj("mismatchData");
    msgData.style.display = "";
     
    var runningVer = obj("runningVer");
    var cdVer = obj("cdVer");

    runningVer.appendChild(document.createTextNode(w.running));
    cdVer.appendChild(document.createTextNode(w.cdImage));

    parent.slctBtns("wizNoBack");
    return;
  }

  for (i = 0; i < MAX_SWAP; i++) {
    usedSwap[i] = 0;
  }

  next();
}

function setTimeZone(timeZone) {
   var tzForm = document.forms[0].tz;

   for (var i = 0; i < tzForm.length; i++) {
      if (tzForm.options[i].value == timeZone) {
         tzForm.options[i].selected = true;
         break;
      }
   }
}

function doFloppyDownload() {
   q.f.downloadType.value = "floppy";
   q.submit();
   submitted = true;

   return true;
}

function doKickstartDownload() {
   q.f.downloadType.value = "kickstart";
   q.submit();
   submitted = true;

   return true;
}

// --------------------------------------------------------------------------

function initPage() {
  var w = parent.op.win();

  var ldgMsg = new Step("ldgMsg", obj("ldgMsg"));
  var getInstallParams = new Step("getInstallParams", obj("getInstallParams"));
  var getNetworkParams = new Step("getNetworkParams", obj("getNetworkParams"));
  var getPartitionParams = new Step("getPartitionParams", 
   obj("getPartitionParams"));
  var getSerialAndConsole = new Step("getSerialAndConsole", 
   obj("getSerialAndConsole"));
  var getPCIDivvy = new Step("getPCIDivvy", obj("getPCIDivvy"));
  var getVirtualSwitches = new Step("getVirtualSwitches", obj("getVirtualSwitches"));
  var getNicAssignment = new Step("getNicAssignment", obj("getNicAssignment"));
  var getSwapFiles = new Step("getSwapFiles", obj("getSwapFiles"));
  var svgMsg = new Step("svgMsg", obj("svgMsg"));

  getInstallParams.nxt[0] = getPartitionParams;
  getInstallParams.nxt[1] = getNetworkParams;
  getInstallParams.nxt[2] = getVirtualSwitches;
  getInstallParams.nxt[3] = svgMsg;
  getInstallParams.exec = function (i) {
    var q = new Query(document.forms[0]);

    var upgrade = q.arg('install_type')[0] == 'upgrade'

    if (true != upgrade) {

      if (q.arg('passwd1')[0] != q.arg('passwd2')[0]) {
         alert("Root passwords must match.");
         return false;
      }

      if (! (q.arg('passwd1')[0]).match(/^\S{6,}$/)) {
         alert("Root passwords must be longer than six characters");
         return false;
      }
    }

    var remoteServer = q.arg('remote_server')[0].toLowerCase();
    if (q.arg('install_method')[0] == 'remote' && 
        !(remoteServer.match(/^(http|ftp):\/\/[\w\-\.]+(:\d+)?[\w\-\.\/]*\/$/))) {
      alert("Remote server URLs must be either http:// or ftp:// and end with a '/' ");
      return false;
    }
    else if (q.arg('install_method')[0] == 'nfs') {
      
      if (!q.arg('remote_server')[0].match(/^.+:\/.+$/)) {
         alert("Invalid NFS URL must be <hostname>:<mount>");
         return false;
      }

      var nfsSplit = q.arg('remote_server')[0].split(":");
      var host = nfsSplit[0];
      var mount = nfsSplit[1];

      if (!checkHostName(host) && !checkIPAddress(host)) {
         alert("Invalid NFS server specified.");
         return false;
      }

      if (! checkMount(mount)) {
         alert("Invalid NFS mount point.");
         return false;
      }
    }

    if (q.arg('network')[0] == 'dhcp' && true == upgrade) {
      parent.slctBtns("wizSIFinal");
    }
    else {
      parent.slctBtns("wiz");
    }
  };

  getNetworkParams.nxt[0] = getPartitionParams;
  getNetworkParams.nxt[1] = getVirtualSwitches;
  getNetworkParams.nxt[2] = svgMsg;
  getNetworkParams.exec = function (i) {
    var q = new Query(document.forms[0]);
   
    var upgrade = q.arg('install_type')[0] == 'upgrade'

    if (! checkHostName(q.arg('hostname')[0])) {
      alert("Invalid hostname entered.");
      return false;
    }

    if (! checkIPAddress(q.arg('ipaddress')[0])) {
      alert("Invalid IP address entered.");
      return false;
    }

    if (! checkNetmask(q.arg('netmask')[0])) {
      alert("Invalid IP Netmask entered.");
      return false;
    }

    if (! checkIPAddress(q.arg('defaultgw')[0])) {
      alert("Invalid IP gateway entered.");
      return false;
    }

    if (! checkIPAddress(q.arg('nameserver1')[0])) {
      alert("Invalid primary nameserver entered.");
      return false;
    }

    if (true == upgrade) {
      parent.slctBtns("wizSIFinal");
    }
  }

  getSerialAndConsole.nxt[0] = getPartitionParams;
  getSerialAndConsole.nxt[1] = getPCIDivvy;
  getSerialAndConsole.exec = function (i) {
    var q = new Query(document.forms[0]);
    
    // XXX: Some Mozilla based clients return null for eula.doc() if the iframe
    // or its parent css display property is "none". Wait a fraction of a
    // second to ensure that eula's parent (editor) css diplay property will
    // not be "none".
    window.setTimeout("eula.doc().location.replace('/eula');", 100);

    if (! q.f.eula.checked) {
      alert("Please read and accept the End User License Agreement before " +
        "continuing.");
      return false;
    }

    if (q.arg('sn1')[0].match(/\S+/)) {
      for (var i = 0; i < 4; i++) {
         if ( ! q.arg('sn1')[i].match(/^\w{5}$/)) {
            alert("Invalid ESX Server serial number: ESX Server serial " +
               "numbers must total 20 characters long and contain no spaces.");
            return false;
         }
      }
    }
    else {
      alert("WARNING: You did not enter an ESX Serial " +
	    "Number.  You will not be able to use VMware ESX Server " +
	    "until you enter a valid serial number.");
    }

    if (q.arg('sn2')[0].match(/\S+/)) {
      for (var i = 0; i < 4; i++) {
         if ( ! q.arg('sn2')[i].match(/^\w{5}$/)) {
            alert("Invalid Virtual SMP serial number: Virtual SMP serial " +
               "numbers must total 20 characters long and contain no spaces.");
            return false;
         }
      }
    }
  }

  var MAX_DIVVY_DEVS = 8;
  getPCIDivvy.nxt[0] = getPartitionParams;
  getPCIDivvy.exec = function (i) {
    var q = new Query(document.forms[0]);

    var seenCOS = false;

    for (id = 0; id < MAX_DIVVY_DEVS; id++) {
      var bus = q.arg('bus' + id)[0];
      var slot = q.arg('slot' + id)[0];
      var func = q.arg('func' + id)[0];
      var target = q.arg('divvyTrgt' + id)[0];

      //nothing entered, keep going
      if (bus == "" && slot == "") {
         continue;
      }

      var busNum = parseInt(bus, 16);

      if ((!bus.match(/^\s*[0-9a-fA-F]{1,2}\s*$/)) || isNaN(busNum) || 
         busNum < 0 || busNum > 255) {

         alert("PCI bus on device " + (id + 1) +
           " must be a number from 0-ff in hexidecimal");
         return false;
      }

      //at this point assume slot must be given.
      var slotNum = parseInt(slot, 16);

      if ((!slot.match(/^\s*[0-9a-fA-F]{1,2}\s*$/)) || isNaN(slotNum) || 
         slotNum < 0 || slotNum > 255) {

         alert("PCI slot on device " + (id + 1) +
           " must be a number from 0-ff in hexidecimal");
         return false;
      }

      if (func != "") {
         var funcNum = parseInt(func, 16);

         if ((!func.match(/^\s*[0-9a-fA-F]{1,2}\s*$/)) || isNaN(funcNum) || 
            funcNum < 0 || funcNum > 7) {

            alert("PCI card function on device " + (id + 1) + 
               " must be a number from 0-7");
            return false;
         }
      }

      if (target == "host") {
         seenCOS = true;
      }
    }

    if (!seenCOS) {
      alert ("At least 1 device, a network card, must be assigned to " +
      "the Service Console for ESX Server to operate properly.");
      return false;
    }
  }

  getPartitionParams.nxt[0] = svgMsg;
  getPartitionParams.nxt[1] = getSwapFiles;
  getPartitionParams.exec = function (i) {
    var q = new Query(document.forms[0]);
    var haveRoot = false;
    var haveSwap = false;
    var haveVmkCore = false;

    for (id = 0; id < MAX_PARTITIONS; id++) {
      var drive = q.arg('drive' + id)[0];
      var mount = q.arg('mount' + id)[0];
      var size = q.arg('size' + id)[0];
      var type = q.arg('type' + id)[0];
      var grow = q.arg('grow' + id)[0];

      // Only do checking if we have a valid mount name or size
      if (mount.match(/\S+/) || size.match(/\S+/)) {

        //extra warning for Window's users so they no spaces are a no-no
        if (mount.match(/\s+/)) {
          alert("Mount points cannot have spaces in their names");
          return false; 
        }

        if (type == 'ext3' && ! checkMount(mount)) {
          alert("Partition  " + (id + 1) + " mount point " + mount + " is invalid.");
          return false;
        }
        else if (type == 'vmfs2' && !checkValidVmfs(mount)) {
          alert("VMFS partition " + (id + 1) + " label \"" + 
            mount + "\" is invalid.");
          return false;
        }
         
        //parse int will take hex values so make sure its all digits first
        if (!checkWholeNumber(size)) {
          alert("Partition " + (id + 1) + " size " + size + " is invalid.\n" + 
                "Partition sizes must be whole, positive integers");
          return false;
        }
      }

      if ((type == 'vmfs2' || type == 'vmkcore') && drive.match(/^hd./)) {
         alert("Partition " + (id + 1) + " is type " + type + " and cannot " +
            "be located on an IDE drive!");
         return false;
      }
      
      //we can assume the parseInt will not return NaN since it was checked
      //above
      if (type == 'vmkcore' && parseInt(size) > 100) {
         alert("vmkcore dump partitions should not be larger than 100M");
         return false;
      }

      if (mount == '/')
        haveRoot = true;

      if (type == 'swap')
        haveSwap = true;

      if (haveVmkCore == true && type == 'vmkcore') {
         alert("Only one vmkcore dump partition should exist on a system.");
         return false;
      }
      else if (type == 'vmkcore') {
         haveVmkCore = true;
      }
    }

    if (! haveRoot) {
      alert("You must define a root partition");
      return false;
    }

    if (! haveSwap) {
      alert("You must define a swap partition");
      return false;
    }

    if (! haveVmkCore) {
      alert("Warning it is recommended that you define a vmkcore partion");
    }
  };

  getVirtualSwitches.nxt[0] = getNicAssignment;
  getVirtualSwitches.nxt[1] = getSerialAndConsole;
  getVirtualSwitches.exec = function (i) {
    var q = new Query(document.forms[0]);
    var MAX_NET_SWITCHES = 8;

    for (i = 0; i < MAX_NET_SWITCHES; i++) {

      //only invalid char should be "
      if (q.arg('switchName' + i)[0].match(/"/)) {
         alert("Virtual Switch " + (i + 1) + " Network name cannot contain quotes");
         return false;
      }
    }
    return true;
  };

  getNicAssignment.nxt[0] = getSerialAndConsole;
  getNicAssignment.exec = function (i) {
    var q = new Query(document.forms[0]);

    //I don't think this has any validation
    return true;
  };

  getSwapFiles.nxt[0] = svgMsg;
  getSwapFiles.exec = function (i) {
    var q = new Query(document.forms[0]);

    //validation done in createSwap
    return true;
  };

  ldgMsg.nxt[0] = getInstallParams;
  ldgMsg.exec = function (i) {
    q = new Query(document.forms[0]);
    parent.slctBtns("wizNoBack");
  };

  svgMsg.nxt[0] = getInstallParams;
  svgMsg.exec = function(idx) {
  }

  var curStep = ldgMsg;

  prev = function () {
    if (curStep == getInstallParams || curStep.slct(-1) == getInstallParams) {
      parent.slctBtns("wizNoBack");
    }
    else {
      parent.slctBtns("wiz");
    }

    curStep = curStep.slct(-1);
  };

  next = function (idx) {
    var q = new Query(document.forms[0]);
    var upgrade = q.arg('install_type')[0] == 'upgrade'
    var divvy = q.arg('divvyMethod')[0] == 'manual';


    if (curStep == getInstallParams) {
      //if !DHCP go to net
      if (q.arg('network')[0] != 'dhcp') {
        curStep = curStep.slct(1);
        return;
      } 
      //if upgrade goto end
      else if (true == upgrade) {
        curStep = curStep.slct(3);
        parent.slctBtns("wizSIFinal");
        return;
      }
      //else goto sc and serial
      else {
         curStep = curStep.slct(2);
         return;
      }
    }
    else if (curStep == getNetworkParams) {
      if (true == upgrade) {
        curStep = curStep.slct(2);
        parent.slctBtns("wizSIFinal");
      }
      else {
        curStep = curStep.slct(1);
      }
      return;
    }
    else if (curStep == getVirtualSwitches) {
       if (q.f.numNic.value == 0 || getVirtualSwitchList().length == 1) {
         curStep = curStep.slct(1);
         return;
       }
    }
    else if (curStep == getSerialAndConsole && true == divvy) {
      curStep = curStep.slct(1);
      return;
    }
    else if (curStep == getPartitionParams) {

      for (id = 0; id < MAX_PARTITIONS; id++) {
         var type = q.arg('type' + id)[0];

         if (type == 'vmfs2') {
            curStep = curStep.slct(1);
            populateKnownVmfs();
            return;
         }
      }
    }
    else if (curStep == getSerialAndConsole && true == divvy) {
      curStep = curStep.slct(1);
      return;
    }

    curStep = curStep.slct(idx);

    if (curStep == getInstallParams) {
      parent.slctBtns("wizNoBack");
    }
    else if (curStep == svgMsg) {
      parent.slctBtns("wizSIFinal");
    }
    else if (curStep == getNicAssignment) {
      populateNicSelection();
    }
  };

  check_rs();

  parent.loadData("/scriptedinstall");
}
