require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_I386_PGALLOC_H)) {
    eval 'sub _I386_PGALLOC_H () {1;}' unless defined(&_I386_PGALLOC_H);
    require 'linux/config.ph';
    require 'asm/processor.ph';
    require 'asm/fixmap.ph';
    require 'linux/threads.ph';
    eval 'sub pgd_quicklist () {( ($current_cpu_data->{pgd_quick}));}' unless defined(&pgd_quicklist);
    eval 'sub pmd_quicklist () {( ($current_cpu_data->{pmd_quick}));}' unless defined(&pmd_quicklist);
    eval 'sub pte_quicklist () {( ($current_cpu_data->{pte_quick}));}' unless defined(&pte_quicklist);
    eval 'sub pgtable_cache_size () {( ($current_cpu_data->{pgtable_cache_sz}));}' unless defined(&pgtable_cache_size);
    eval 'sub pmd_populate {
        my($mm, $pmd, $pte) = @_;
	    eval q( &set_pmd($pmd,  &__pmd( &_PAGE_TABLE +  &__pa($pte))));
    }' unless defined(&pmd_populate);
    if((defined(&CONFIG_X86_PAE) ? &CONFIG_X86_PAE : 0)) {
	eval 'sub pgd_t {
	    eval q(* &get_pgd_slow { \'int\'  &i;  &pgd_t * &pgd =  &kmem_cache_alloc( &pae_pgd_cachep,  &GFP_KERNEL);  &if {  &for ( &i = 0;  &i <  &USER_PTRS_PER_PGD;  &i++) { my $pmd =  &__get_free_page;  &if (! $pmd)  &goto  &out_oom;  &clear_page;  &set_pgd( &pgd +  &i,  &__pgd(1+  &__pa)); }  &memcpy( &pgd +  &USER_PTRS_PER_PGD,  &swapper_pg_dir +  &USER_PTRS_PER_PGD, ( &PTRS_PER_PGD -  &USER_PTRS_PER_PGD) *  &sizeof); }  &pgd;  &out_oom:  &for ( &i--;  &i >= 0;  &i--)  &free_page( &__va( &pgd_val( $pgd[ &i])-1));  &kmem_cache_free( &pae_pgd_cachep,  &pgd);  &NULL; });
	}' unless defined(&pgd_t);
    } else {
	eval 'sub pgd_t {
	    eval q(* &get_pgd_slow( &void) {  &pgd_t * &pgd = ( &pgd_t *) &__get_free_page( &GFP_KERNEL);  &if ( &pgd) {  &memset( &pgd, 0,  &USER_PTRS_PER_PGD * $sizeof{ &pgd_t});  &memcpy( &pgd +  &USER_PTRS_PER_PGD,  &swapper_pg_dir +  &USER_PTRS_PER_PGD, ( &PTRS_PER_PGD -  &USER_PTRS_PER_PGD) * $sizeof{ &pgd_t}); }  &pgd; });
	}' unless defined(&pgd_t);
    }
    eval 'sub pgd_t {
        eval q(* &get_pgd_fast { my $long * &ret;  &if (( &ret =  &pgd_quicklist) !=  &NULL) {  &pgd_quicklist = (* &ret);  $ret[0] = 0;  &pgtable_cache_size--; }  &else  &ret =  &get_pgd_slow(); ( &pgd_t *) &ret; });
    }' unless defined(&pgd_t);
    eval 'sub free_pgd_fast {
        my($pgd) = @_;
	    eval q({ *$pgd =  &pgd_quicklist;  &pgd_quicklist = $pgd;  &pgtable_cache_size++; });
    }' unless defined(&free_pgd_fast);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub free_pgd_slow {
        my($pgd) = @_;
	    eval q({ });
    }' unless defined(&free_pgd_slow);
    eval 'sub pte_t {
        eval q(* &pte_alloc_one(\'struct mm_struct\' * &mm, my $address) {  &pte_t * &pte= &NULL; \'int\'  &count = 0;  &do {  &pte = ( &pte_t *)  &__get_free_page( &GFP_KERNEL);  &if ( &pte)  &clear_page( &pte);  &else  &schedule_timeout( &HZ); }  &while (( &pte== &NULL) &&( &count++<10));  &pte; });
    }' unless defined(&pte_t);
    eval 'sub pte_t {
        eval q(* &pte_alloc_one_fast(\'struct mm_struct\' * &mm, my $address) { my $long * &ret;  &if (( &ret =  &pte_quicklist) !=  &NULL) {  &pte_quicklist = (* &ret);  $ret[0] =  $ret[1];  &pgtable_cache_size--; } ( &pte_t *) &ret; });
    }' unless defined(&pte_t);
    eval 'sub pte_free_fast {
        my($pte) = @_;
	    eval q({ *$pte =  &pte_quicklist;  &pte_quicklist = $pte;  &pgtable_cache_size++; });
    }' unless defined(&pte_free_fast);
    eval 'sub pte_free_slow {
        my($pte) = @_;
	    eval q({  &free_page($pte); });
    }' unless defined(&pte_free_slow);
    eval 'sub pte_free {
        my($pte) = @_;
	    eval q( &pte_free_slow($pte));
    }' unless defined(&pte_free);
    eval 'sub pgd_free {
        my($pgd) = @_;
	    eval q( &free_pgd_slow($pgd));
    }' unless defined(&pgd_free);
    eval 'sub pgd_alloc {
        my($mm) = @_;
	    eval q( &get_pgd_fast());
    }' unless defined(&pgd_alloc);
    eval 'sub pmd_alloc_one_fast {
        my($mm, $addr) = @_;
	    eval q(({  &BUG(); (( &pmd_t *)1); }));
    }' unless defined(&pmd_alloc_one_fast);
    eval 'sub pmd_alloc_one {
        my($mm, $addr) = @_;
	    eval q(({  &BUG(); (( &pmd_t *)2); }));
    }' unless defined(&pmd_alloc_one);
    eval 'sub pmd_free_slow {
        my($x) = @_;
	    eval q( &do { }  &while (0));
    }' unless defined(&pmd_free_slow);
    eval 'sub pmd_free_fast {
        my($x) = @_;
	    eval q( &do { }  &while (0));
    }' unless defined(&pmd_free_fast);
    eval 'sub pmd_free {
        my($x) = @_;
	    eval q( &do { }  &while (0));
    }' unless defined(&pmd_free);
    eval 'sub pgd_populate {
        my($mm, $pmd, $pte) = @_;
	    eval q( &BUG());
    }' unless defined(&pgd_populate);
    unless(defined(&CONFIG_SMP)) {
	eval 'sub flush_tlb () {
	    eval q( &__flush_tlb());
	}' unless defined(&flush_tlb);
	eval 'sub flush_tlb_all () {
	    eval q( &__flush_tlb_all());
	}' unless defined(&flush_tlb_all);
	eval 'sub local_flush_tlb () {
	    eval q( &__flush_tlb());
	}' unless defined(&local_flush_tlb);
	eval 'sub flush_tlb_mm {
	    my($mm) = @_;
    	    eval q({  &if ($mm ==  ($current->{active_mm}))  &__flush_tlb(); });
	}' unless defined(&flush_tlb_mm);
	eval 'sub flush_tlb_page {
	    my($vma,$addr) = @_;
    	    eval q({  &if ( ($vma->{vm_mm}) ==  ($current->{active_mm}))  &__flush_tlb_one($addr); });
	}' unless defined(&flush_tlb_page);
	eval 'sub flush_tlb_range {
	    my($mm,$start,$end) = @_;
    	    eval q({  &if ($mm ==  ($current->{active_mm}))  &__flush_tlb(); });
	}' unless defined(&flush_tlb_range);
    } else {
	require 'asm/smp.ph';
	eval 'sub local_flush_tlb () {
	    eval q( &__flush_tlb());
	}' unless defined(&local_flush_tlb);
	eval 'sub flush_tlb () {
	    eval q( &flush_tlb_current_task());
	}' unless defined(&flush_tlb);
	eval 'sub flush_tlb_range {
	    my($mm,$start,$end) = @_;
    	    eval q({  &flush_tlb_mm($mm); });
	}' unless defined(&flush_tlb_range);
	eval 'sub TLBSTATE_OK () {1;}' unless defined(&TLBSTATE_OK);
	eval 'sub TLBSTATE_LAZY () {2;}' unless defined(&TLBSTATE_LAZY);
    }
    eval 'sub flush_tlb_pgtables {
        my($mm,$start,$end) = @_;
	    eval q({ }  &endif );
    }' unless defined(&flush_tlb_pgtables);
1;
