require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_SYSTEM_H)) {
    eval 'sub __ASM_SYSTEM_H () {1;}' unless defined(&__ASM_SYSTEM_H);
    require 'linux/config.ph';
    require 'linux/kernel.ph';
    require 'asm/segment.ph';
    require 'linux/bitops.ph';
    eval 'sub wbinvd () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&wbinvd);
    eval 'sub get_limit {
        my($segment) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&get_limit);
    eval 'sub nop () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&nop);
    eval 'sub xchg {
        my($ptr,$v) = @_;
	    eval q((( &__typeof__(*)) &__xchg(($v),($ptr),$sizeof{($ptr)})));
    }' unless defined(&xchg);
    eval 'sub tas {
        my($ptr) = @_;
	    eval q(( &xchg(($ptr),1)));
    }' unless defined(&tas);
    eval 'sub __xg {
        my($x) = @_;
	    eval q((($x)));
    }' unless defined(&__xg);
    eval 'sub __set_64bit_constant {
        my($ptr,$value) = @_;
	    eval q({  &__set_64bit($ptr,, (($value)>>32)); });
    }' unless defined(&__set_64bit_constant);
    eval 'sub ll_low {
        my($x) = @_;
	    eval q(*((($x))+0));
    }' unless defined(&ll_low);
    eval 'sub ll_high {
        my($x) = @_;
	    eval q(*((($x))+1));
    }' unless defined(&ll_high);
    eval 'sub __set_64bit_var {
        my($ptr,$value) = @_;
	    eval q({  &__set_64bit($ptr, &ll_low($value),  &ll_high($value)); });
    }' unless defined(&__set_64bit_var);
    eval 'sub set_64bit {
        my($ptr,$value) = @_;
	    eval q(( &__builtin_constant_p($value) ?  &__set_64bit_constant($ptr, $value) :  &__set_64bit_var($ptr, $value) ));
    }' unless defined(&set_64bit);
    eval 'sub _set_64bit {
        my($ptr,$value) = @_;
	    eval q(( &__builtin_constant_p ?  &__set_64bit($ptr, , (($value)>>32) ) :  &__set_64bit($ptr,  &ll_low($value),  &ll_high($value)) ));
    }' unless defined(&_set_64bit);
    if(defined(&CONFIG_X86_CMPXCHG)) {
	eval 'sub __HAVE_ARCH_CMPXCHG () {1;}' unless defined(&__HAVE_ARCH_CMPXCHG);
	eval 'sub __cmpxchg {
	    my($ptr,$old,$new,$size) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&__cmpxchg);
	eval 'sub cmpxchg {
	    my($ptr,$o,$n) = @_;
    	    eval q((( &__typeof__(*)) &__cmpxchg(,, ($n),$sizeof{($ptr)})));
	}' unless defined(&cmpxchg);
    } else {
    }
    eval 'sub mb () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&mb);
    eval 'sub rmb () {
        eval q( &mb());
    }' unless defined(&rmb);
    if(defined(&CONFIG_X86_OOSTORE)) {
	eval 'sub wmb () {
	    eval q(\\"(assembly code)\\");
	}' unless defined(&wmb);
    } else {
	eval 'sub wmb () {
	    eval q(\\"(assembly code)\\");
	}' unless defined(&wmb);
    }
    if(defined(&CONFIG_SMP)) {
	eval 'sub smp_mb () {
	    eval q( &mb());
	}' unless defined(&smp_mb);
	eval 'sub smp_rmb () {
	    eval q( &rmb());
	}' unless defined(&smp_rmb);
	eval 'sub smp_wmb () {
	    eval q( &wmb());
	}' unless defined(&smp_wmb);
    } else {
	eval 'sub smp_mb () {
	    eval q( &barrier());
	}' unless defined(&smp_mb);
	eval 'sub smp_rmb () {
	    eval q( &barrier());
	}' unless defined(&smp_rmb);
	eval 'sub smp_wmb () {
	    eval q( &barrier());
	}' unless defined(&smp_wmb);
    }
    eval 'sub set_mb {
        my($var, $value) = @_;
	    eval q( &do {  &xchg($var, $value); }  &while (0));
    }' unless defined(&set_mb);
    eval 'sub set_wmb {
        my($var, $value) = @_;
	    eval q( &do { $var = $value;  &wmb(); }  &while (0));
    }' unless defined(&set_wmb);
    eval 'sub __save_flags {
        my($x) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&__save_flags);
    eval 'sub __restore_flags {
        my($x) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&__restore_flags);
    eval 'sub __cli () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&__cli);
    eval 'sub __sti () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&__sti);
    eval 'sub safe_halt () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&safe_halt);
    eval 'sub local_irq_save {
        my($x) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&local_irq_save);
    eval 'sub local_irq_restore {
        my($x) = @_;
	    eval q( &__restore_flags($x));
    }' unless defined(&local_irq_restore);
    eval 'sub local_irq_disable () {
        eval q( &__cli());
    }' unless defined(&local_irq_disable);
    eval 'sub local_irq_enable () {
        eval q( &__sti());
    }' unless defined(&local_irq_enable);
    if(defined(&CONFIG_SMP)) {
	eval 'sub cli () {
	    eval q( &__global_cli());
	}' unless defined(&cli);
	eval 'sub sti () {
	    eval q( &__global_sti());
	}' unless defined(&sti);
	eval 'sub save_flags {
	    my($x) = @_;
    	    eval q((($x)= &__global_save_flags()));
	}' unless defined(&save_flags);
	eval 'sub restore_flags {
	    my($x) = @_;
    	    eval q( &__global_restore_flags($x));
	}' unless defined(&restore_flags);
    } else {
	eval 'sub cli () {
	    eval q( &__cli());
	}' unless defined(&cli);
	eval 'sub sti () {
	    eval q( &__sti());
	}' unless defined(&sti);
	eval 'sub save_flags {
	    my($x) = @_;
    	    eval q( &__save_flags($x));
	}' unless defined(&save_flags);
	eval 'sub restore_flags {
	    my($x) = @_;
    	    eval q( &__restore_flags($x));
	}' unless defined(&restore_flags);
    }
    eval 'sub HAVE_DISABLE_HLT () {1;}' unless defined(&HAVE_DISABLE_HLT);
}
1;
