require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_BLK_H)) {
    eval 'sub _BLK_H () {1;}' unless defined(&_BLK_H);
    require 'linux/blkdev.ph';
    require 'linux/locks.ph';
    require 'linux/config.ph';
    require 'linux/spinlock.ph';
    if(defined( &CONFIG_ARCH_S390)) {
    }
    if(defined(&CONFIG_BLK_DEV_INITRD)) {
	eval 'sub INITRD_MINOR () {250;}' unless defined(&INITRD_MINOR);
    }
    if(defined( &MAJOR_NR) || defined( &IDE_DRIVER)) {
	undef(&DEVICE_ON) if defined(&DEVICE_ON);
	undef(&DEVICE_OFF) if defined(&DEVICE_OFF);
	if(defined(&IDE_DRIVER)) {
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device) >>  &PARTN_BITS));
	    }' unless defined(&DEVICE_NR);
	    eval 'sub DEVICE_NAME () {"ide";}' unless defined(&DEVICE_NAME);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&RAMDISK_MAJOR) ? &RAMDISK_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"ramdisk";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)));
	    }' unless defined(&DEVICE_NR);
	    eval 'sub DEVICE_NO_RANDOM () {1;}' unless defined(&DEVICE_NO_RANDOM);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&Z2RAM_MAJOR) ? &Z2RAM_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"Z2RAM";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &do_z2_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&FLOPPY_MAJOR) ? &FLOPPY_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"floppy";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_INTR () { &do_floppy;}' unless defined(&DEVICE_INTR);
	    eval 'sub DEVICE_REQUEST () { &do_fd_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( ( &MINOR($device) & 3) | (( &MINOR($device) & 0x80 ) >> 5)));
	    }' unless defined(&DEVICE_NR);
	    eval 'sub DEVICE_OFF {
	        my($device) = @_;
    		eval q( &floppy_off( &DEVICE_NR($device)));
	    }' unless defined(&DEVICE_OFF);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&HD_MAJOR) ? &HD_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"hard disk";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_INTR () { &do_hd;}' unless defined(&DEVICE_INTR);
	    eval 'sub TIMEOUT_VALUE () {(6* &HZ);}' unless defined(&TIMEOUT_VALUE);
	    eval 'sub DEVICE_REQUEST () { &do_hd_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)>>6));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(( &SCSI_DISK_MAJOR((defined(&MAJOR_NR) ? &MAJOR_NR : 0)))) {
	    eval 'sub DEVICE_NAME () {"scsidisk";}' unless defined(&DEVICE_NAME);
	    eval 'sub TIMEOUT_VALUE () {(2* &HZ);}' unless defined(&TIMEOUT_VALUE);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(((( &MAJOR($device) &  &SD_MAJOR_MASK) << (8- 4)) + ( &MINOR($device) >> 4)));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&MD_MAJOR) ? &MD_MAJOR : 0))  && defined( &MD_DRIVER)) {
	    eval 'sub DEVICE_NAME () {"Multiple devices driver";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &do_md_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&SCSI_TAPE_MAJOR) ? &SCSI_TAPE_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"scsitape";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_INTR () { &do_st;}' unless defined(&DEVICE_INTR);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device) & 0x7f));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&OSST_MAJOR) ? &OSST_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"onstream";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_INTR () { &do_osst;}' unless defined(&DEVICE_INTR);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device) & 0x7f));
	    }' unless defined(&DEVICE_NR);
	    eval 'sub DEVICE_ON {
	        my($device) = @_;
    		eval q();
	    }' unless defined(&DEVICE_ON);
	    eval 'sub DEVICE_OFF {
	        my($device) = @_;
    		eval q();
	    }' unless defined(&DEVICE_OFF);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&SCSI_CDROM_MAJOR) ? &SCSI_CDROM_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"CD-ROM";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&XT_DISK_MAJOR) ? &XT_DISK_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"xt disk";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &do_xd_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device) >> 6));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&PS2ESDI_MAJOR) ? &PS2ESDI_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"PS/2 ESDI";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &do_ps2esdi_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device) >> 6));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&CDU31A_CDROM_MAJOR) ? &CDU31A_CDROM_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"CDU31A";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &do_cdu31a_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&ACSI_MAJOR) ? &ACSI_MAJOR : 0))  && (defined( &CONFIG_ATARI_ACSI) || defined( &CONFIG_ATARI_ACSI_MODULE))) {
	    eval 'sub DEVICE_NAME () {"ACSI";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_INTR () { &do_acsi;}' unless defined(&DEVICE_INTR);
	    eval 'sub DEVICE_REQUEST () { &do_acsi_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device) >> 4));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&MITSUMI_CDROM_MAJOR) ? &MITSUMI_CDROM_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"Mitsumi CD-ROM";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &do_mcd_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&MITSUMI_X_CDROM_MAJOR) ? &MITSUMI_X_CDROM_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"Mitsumi CD-ROM";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &do_mcdx_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&MATSUSHITA_CDROM_MAJOR) ? &MATSUSHITA_CDROM_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"Matsushita CD-ROM controller #1";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &do_sbpcd_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&MATSUSHITA_CDROM2_MAJOR) ? &MATSUSHITA_CDROM2_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"Matsushita CD-ROM controller #2";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &do_sbpcd2_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&MATSUSHITA_CDROM3_MAJOR) ? &MATSUSHITA_CDROM3_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"Matsushita CD-ROM controller #3";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &do_sbpcd3_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&MATSUSHITA_CDROM4_MAJOR) ? &MATSUSHITA_CDROM4_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"Matsushita CD-ROM controller #4";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &do_sbpcd4_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&AZTECH_CDROM_MAJOR) ? &AZTECH_CDROM_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"Aztech CD-ROM";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &do_aztcd_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&CDU535_CDROM_MAJOR) ? &CDU535_CDROM_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"SONY-CDU535";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_INTR () { &do_cdu535;}' unless defined(&DEVICE_INTR);
	    eval 'sub DEVICE_REQUEST () { &do_cdu535_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&GOLDSTAR_CDROM_MAJOR) ? &GOLDSTAR_CDROM_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"Goldstar R420";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &do_gscd_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&CM206_CDROM_MAJOR) ? &CM206_CDROM_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"Philips/LMS CD-ROM cm206";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &do_cm206_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&OPTICS_CDROM_MAJOR) ? &OPTICS_CDROM_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"DOLPHIN 8000AT CD-ROM";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &do_optcd_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&SANYO_CDROM_MAJOR) ? &SANYO_CDROM_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"Sanyo H94A CD-ROM";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &do_sjcd_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&APBLOCK_MAJOR) ? &APBLOCK_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"apblock";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &ap_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&DDV_MAJOR) ? &DDV_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"ddv";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &ddv_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)>> &PARTN_BITS));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&MFM_ACORN_MAJOR) ? &MFM_ACORN_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"mfm disk";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_INTR () { &do_mfm;}' unless defined(&DEVICE_INTR);
	    eval 'sub DEVICE_REQUEST () { &do_mfm_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device) >> 6));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&NBD_MAJOR) ? &NBD_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"nbd";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &do_nbd_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&MDISK_MAJOR) ? &MDISK_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"mdisk";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &mdisk_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&DASD_MAJOR) ? &DASD_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"dasd";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &do_dasd_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device) >>  &PARTN_BITS));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&I2O_MAJOR) ? &I2O_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"I2O block";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_REQUEST () { &i2ob_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)>>4));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&COMPAQ_SMART2_MAJOR) ? &COMPAQ_SMART2_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"ida";}' unless defined(&DEVICE_NAME);
	    eval 'sub TIMEOUT_VALUE () {(25* &HZ);}' unless defined(&TIMEOUT_VALUE);
	    eval 'sub DEVICE_REQUEST () { &do_ida_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device) >> 4));
	    }' unless defined(&DEVICE_NR);
	}
 elsif(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) == (defined(&UBD_MAJOR) ? &UBD_MAJOR : 0))) {
	    eval 'sub DEVICE_NAME () {"User-mode block device";}' unless defined(&DEVICE_NAME);
	    eval 'sub DEVICE_INTR () { &do_ubd;}' unless defined(&DEVICE_INTR);
	    eval 'sub DEVICE_REQUEST () { &do_ubd_request;}' unless defined(&DEVICE_REQUEST);
	    eval 'sub DEVICE_NR {
	        my($device) = @_;
    		eval q(( &MINOR($device)));
	    }' unless defined(&DEVICE_NR);
	    eval 'sub DEVICE_ON {
	        my($device) = @_;
    		eval q();
	    }' unless defined(&DEVICE_ON);
	    eval 'sub DEVICE_OFF {
	        my($device) = @_;
    		eval q();
	    }' unless defined(&DEVICE_OFF);
	}
	unless(defined(&DEVICE_ON)) {
	    eval 'sub DEVICE_ON {
	        my($device) = @_;
    		eval q( &do {}  &while (0));
	    }' unless defined(&DEVICE_ON);
	}
	unless(defined(&DEVICE_OFF)) {
	    eval 'sub DEVICE_OFF {
	        my($device) = @_;
    		eval q( &do {}  &while (0));
	    }' unless defined(&DEVICE_OFF);
	}
	if(((defined(&MAJOR_NR) ? &MAJOR_NR : 0) != (defined(&SCSI_TAPE_MAJOR) ? &SCSI_TAPE_MAJOR : 0))  && ((defined(&MAJOR_NR) ? &MAJOR_NR : 0) != (defined(&OSST_MAJOR) ? &OSST_MAJOR : 0))) {
	    if(!defined( &IDE_DRIVER)) {
		unless(defined(&CURRENT)) {
		    eval 'sub CURRENT () { &blkdev_entry_next_request( ($blk_dev[&MAJOR_NR]->{request_queue}->{queue_head}));}' unless defined(&CURRENT);
		}
		unless(defined(&QUEUE_EMPTY)) {
		    eval 'sub QUEUE_EMPTY () { &list_empty( ($blk_dev[&MAJOR_NR]->{request_queue}->{queue_head}));}' unless defined(&QUEUE_EMPTY);
		}
		unless(defined(&DEVICE_NAME)) {
		    eval 'sub DEVICE_NAME () {"unknown";}' unless defined(&DEVICE_NAME);
		}
		eval 'sub CURRENT_DEV () { &DEVICE_NR( ($CURRENT->{rq_dev}));}' unless defined(&CURRENT_DEV);
		if(defined(&DEVICE_INTR)) {
		}
		eval 'sub SET_INTR {
		    my($x) = @_;
    		    eval q(( &DEVICE_INTR = ($x)));
		}' unless defined(&SET_INTR);
		if(defined(&DEVICE_REQUEST)) {
		}
		if(defined(&DEVICE_INTR)) {
		    eval 'sub CLEAR_INTR () { &SET_INTR( &NULL);}' unless defined(&CLEAR_INTR);
		} else {
		    eval 'sub CLEAR_INTR () {1;}' unless defined(&CLEAR_INTR);
		}
		eval 'sub INIT_REQUEST () { &if ( &QUEUE_EMPTY) {  &CLEAR_INTR;  &return; }  &if ( &MAJOR( ($CURRENT->{rq_dev})) !=  &MAJOR_NR)  &panic( &DEVICE_NAME ": request list destroyed");  &if ( ($CURRENT->{bh})) {  &if (! &buffer_locked( ($CURRENT->{bh})))  &panic( &DEVICE_NAME ": block not locked"); };}' unless defined(&INIT_REQUEST);
	    }
	    unless(defined(&LOCAL_END_REQUEST)) {
		if(!  &SCSI_BLK_MAJOR((defined(&MAJOR_NR) ? &MAJOR_NR : 0))  && ((defined(&MAJOR_NR) ? &MAJOR_NR : 0) != (defined(&COMPAQ_SMART2_MAJOR) ? &COMPAQ_SMART2_MAJOR : 0))) {
# some #ifdef were dropped here -- fill in the blanks
		    eval 'sub end_request {
		        my($uptodate) = @_;
    			eval q({ \'struct request\' * &req =  &CURRENT;  &if ( &end_that_request_first( &req, $uptodate,  &DEVICE_NAME)) ;  &DEVICE_OFF( ($req->{rq_dev}));  &blkdev_dequeue_request( &req);  &end_that_request_last( &req); });
		    }' unless defined(&end_request);
		}
	    }
	}
    }
}
1;
