require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_BLKDEV_H)) {
    eval 'sub _LINUX_BLKDEV_H () {1;}' unless defined(&_LINUX_BLKDEV_H);
    require 'linux/major.ph';
    require 'linux/sched.ph';
    require 'linux/genhd.ph';
    require 'linux/tqueue.ph';
    require 'linux/list.ph';
    require 'asm/io.ph';
    eval 'sub RQ_INACTIVE () {(-1);}' unless defined(&RQ_INACTIVE);
    eval 'sub RQ_ACTIVE () {1;}' unless defined(&RQ_ACTIVE);
    eval 'sub RQ_SCSI_BUSY () {0xffff;}' unless defined(&RQ_SCSI_BUSY);
    eval 'sub RQ_SCSI_DONE () {0xfffe;}' unless defined(&RQ_SCSI_DONE);
    eval 'sub RQ_SCSI_DISCONNECTING () {0xffe0;}' unless defined(&RQ_SCSI_DISCONNECTING);
    require 'linux/elevator.ph';
    eval 'sub QUEUE_NR_REQUESTS () {8192;}' unless defined(&QUEUE_NR_REQUESTS);
    eval 'sub BLK_BOUNCE_HIGH () {( &blk_max_low_pfn *  &PAGE_SIZE);}' unless defined(&BLK_BOUNCE_HIGH);
    eval 'sub BLK_BOUNCE_ANY () {(~ 0);}' unless defined(&BLK_BOUNCE_ANY);
    if(defined(&CONFIG_HIGHMEM)) {
	eval 'sub buffer_head {
	    eval q(* &blk_queue_bounce( &request_queue_t * &q, \'int\'  &rw, \'struct buffer_head\' * &bh) {  &if ( ($bh->{b_page}) <=  ($q->{bounce_limit}))  &bh;  &create_bounce( &rw,  &bh); });
	}' unless defined(&buffer_head);
    } else {
	eval 'sub blk_queue_bounce {
	    my($q, $rw, $bh) = @_;
    	    eval q(($bh));
	}' unless defined(&blk_queue_bounce);
    }
    eval 'sub bh_phys {
        my($bh) = @_;
	    eval q(( &page_to_phys(($bh)-> &b_page) +  &bh_offset(($bh))));
    }' unless defined(&bh_phys);
    eval 'sub BH_CONTIG {
        my($b1, $b2) = @_;
	    eval q(( &bh_phys(($b1)) + ($b1)-> &b_size ==  &bh_phys(($b2))));
    }' unless defined(&BH_CONTIG);
    eval 'sub BH_PHYS_4G {
        my($b1, $b2) = @_;
	    eval q((( &bh_phys(($b1)) | 0xffffffff) == (( &bh_phys(($b2)) + ($b2)-> &b_size - 1) | 0xffffffff)));
    }' unless defined(&BH_PHYS_4G);
    eval 'sub BLK_DEFAULT_QUEUE {
        my($_MAJOR) = @_;
	    eval q( ($blk_dev[$_MAJOR]->{request_queue}));
    }' unless defined(&BLK_DEFAULT_QUEUE);
    eval 'sub MAX_SEGMENTS () {128;}' unless defined(&MAX_SEGMENTS);
    eval 'sub MAX_SECTORS () {255;}' unless defined(&MAX_SECTORS);
    eval 'sub PageAlignSize {
        my($size) = @_;
	    eval q(((($size) +  &PAGE_SIZE -1) &  &PAGE_MASK));
    }' unless defined(&PageAlignSize);
    eval 'sub blkdev_entry_to_request {
        my($entry) = @_;
	    eval q( &list_entry(($entry), \'struct request\',  &queue));
    }' unless defined(&blkdev_entry_to_request);
    eval 'sub blkdev_entry_next_request {
        my($entry) = @_;
	    eval q( &blkdev_entry_to_request(($entry)-> &next));
    }' unless defined(&blkdev_entry_next_request);
    eval 'sub blkdev_entry_prev_request {
        my($entry) = @_;
	    eval q( &blkdev_entry_to_request(($entry)-> &prev));
    }' unless defined(&blkdev_entry_prev_request);
    eval 'sub blkdev_next_request {
        my($req) = @_;
	    eval q( &blkdev_entry_to_request(($req)-> ($queue->{next})));
    }' unless defined(&blkdev_next_request);
    eval 'sub blkdev_prev_request {
        my($req) = @_;
	    eval q( &blkdev_entry_to_request(($req)-> ($queue->{prev})));
    }' unless defined(&blkdev_prev_request);
    eval 'sub get_hardsect_size {
        my($dev) = @_;
	    eval q({ \'int\' * $hardsect_size[];  &if ( $hardsect_size[ &MAJOR($dev)] !=  &NULL)  $hardsect_size[ &MAJOR($dev)][ &MINOR($dev)];  &else 512; });
    }' unless defined(&get_hardsect_size);
    eval 'sub blk_finished_io {
        my($nsects) = @_;
	    eval q( &do {  &atomic_sub($nsects,  &queued_sectors);  &if ( &atomic_read( &queued_sectors) < 0) {  &printk(\\"block: queued_sectors < 0\\\\n\\");  &atomic_set( &queued_sectors, 0); }  &if ( &atomic_read( &queued_sectors) <  &low_queued_sectors)  &wake_up( &blk_buffers_wait); }  &while (0));
    }' unless defined(&blk_finished_io);
    eval 'sub blk_started_io {
        my($nsects) = @_;
	    eval q( &atomic_add($nsects,  &queued_sectors););
    }' unless defined(&blk_started_io);
}
1;
