require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_CODA_FS)) {
    eval 'sub _LINUX_CODA_FS () {1;}' unless defined(&_LINUX_CODA_FS);
    require 'linux/kernel.ph';
    require 'linux/param.ph';
    require 'linux/sched.ph';
    require 'linux/mm.ph';
    require 'linux/vmalloc.ph';
    require 'linux/slab.ph';
    require 'linux/wait.ph';
    require 'linux/types.ph';
    require 'linux/fs.ph';
    eval 'sub D_SUPER () {1;}' unless defined(&D_SUPER);
    eval 'sub D_INODE () {2;}' unless defined(&D_INODE);
    eval 'sub D_FILE () {4;}' unless defined(&D_FILE);
    eval 'sub D_CACHE () {8;}' unless defined(&D_CACHE);
    eval 'sub D_MALLOC () {16;}' unless defined(&D_MALLOC);
    eval 'sub D_CNODE () {32;}' unless defined(&D_CNODE);
    eval 'sub D_UPCALL () {64;}' unless defined(&D_UPCALL);
    eval 'sub D_PSDEV () {128;}' unless defined(&D_PSDEV);
    eval 'sub D_PIOCTL () {256;}' unless defined(&D_PIOCTL);
    eval 'sub D_SPECIAL () {512;}' unless defined(&D_SPECIAL);
    eval 'sub D_TIMING () {1024;}' unless defined(&D_TIMING);
    eval 'sub D_DOWNCALL () {2048;}' unless defined(&D_DOWNCALL);
    eval 'sub CDEBUG () {( &mask,  &format,  &a...)  &do {  &if ( &coda_debug &  &mask) {  &printk("(%s,l. %d): ",  &__FUNCTION__,  &__LINE__);  &printk( &format,   &a); } }  &while (0);}' unless defined(&CDEBUG);
    eval 'sub ENTRY () { &if( &coda_print_entry)  &printk("Process %d entered %s\\n", ($current->{pid}), &__FUNCTION__);}' unless defined(&ENTRY);
    eval 'sub EXIT () { &if( &coda_print_entry)  &printk("Process %d leaving %s\\n", ($current->{pid}), &__FUNCTION__);}' unless defined(&EXIT);
    eval 'sub CODA_ALLOC {
        my($ptr, $cast, $size) = @_;
	    eval q( &do {  &if ($size <  &PAGE_SIZE) { $ptr = ($cast) &kmalloc( $size,  &GFP_KERNEL);  &CDEBUG( &D_MALLOC, \\"kmalloced: %lx at %p.\\\\n\\", $size, $ptr); }  &else { $ptr = ($cast) &vmalloc;  &CDEBUG( &D_MALLOC, \\"vmalloced: %lx at %p .\\\\n\\", $size, $ptr);}  &if ($ptr == 0) {  &printk(\\"kernel malloc returns 0 at %s:%d\\\\n\\",  &__FILE__,  &__LINE__); }  &else  &memset( $ptr, 0, $size ); }  &while (0));
    }' unless defined(&CODA_ALLOC);
    eval 'sub CODA_FREE {
        my($ptr,$size) = @_;
	    eval q( &do { &if ($size <  &PAGE_SIZE) {  &kfree();  &CDEBUG( &D_MALLOC, \\"kfreed: %lx at %p.\\\\n\\", $size, $ptr); }  &else {  &vfree();  &CDEBUG( &D_MALLOC, \\"vfreed: %lx at %p.\\\\n\\", $size, $ptr);} }  &while (0));
    }' unless defined(&CODA_FREE);
    eval 'sub ITOC {
        my($inode) = @_;
	    eval q(((($inode)-> ($u->{coda_i}))));
    }' unless defined(&ITOC);
    eval 'sub ViceFid {
        eval q(* &coda_i2f(\'struct inode\' * &inode) { ( &ITOC( &inode)-> &c_fid); });
    }' unless defined(&ViceFid);
    eval 'sub char {
        eval q(* &coda_i2s(\'struct inode\' * &inode) {  &coda_f2s(( &ITOC( &inode)-> &c_fid)); });
    }' unless defined(&char);
}
1;
