require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_DEVFS_FS_KERNEL_H)) {
    eval 'sub _LINUX_DEVFS_FS_KERNEL_H () {1;}' unless defined(&_LINUX_DEVFS_FS_KERNEL_H);
    require 'linux/fs.ph';
    require 'linux/config.ph';
    require 'linux/locks.ph';
    require 'linux/kdev_t.ph';
    require 'linux/types.ph';
    require 'asm/semaphore.ph';
    eval 'sub DEVFS_SUPER_MAGIC () {0x1373;}' unless defined(&DEVFS_SUPER_MAGIC);
    eval 'sub IS_DEVFS_INODE {
        my($inode) = @_;
	    eval q(( &DEVFS_SUPER_MAGIC == ($inode)-> ($i_sb->{s_magic})));
    }' unless defined(&IS_DEVFS_INODE);
    eval 'sub DEVFS_MINOR {
        my($inode) = @_;
	    eval q(({\'unsigned int m\'; (($inode)-> &i_sb  && (($inode)-> ($i_sb->{s_magic})== &DEVFS_SUPER_MAGIC)  && ( &devfs_get_maj_min( &devfs_get_handle_from_inode(($inode)), &NULL, &m)==0) ) ?  &m :  &MINOR(($inode)-> &r_dev); }));
    }' unless defined(&DEVFS_MINOR);
    eval 'sub DEVFS_FL_NONE () {0x;}' unless defined(&DEVFS_FL_NONE);
    eval 'sub DEVFS_FL_AUTO_OWNER () {0x1;}' unless defined(&DEVFS_FL_AUTO_OWNER);
    eval 'sub DEVFS_FL_SHOW_UNREG () {0x2;}' unless defined(&DEVFS_FL_SHOW_UNREG);
    eval 'sub DEVFS_FL_HIDE () {0x4;}' unless defined(&DEVFS_FL_HIDE);
    eval 'sub DEVFS_FL_AUTO_DEVNUM () {0x8;}' unless defined(&DEVFS_FL_AUTO_DEVNUM);
    eval 'sub DEVFS_FL_AOPEN_NOTIFY () {0x10;}' unless defined(&DEVFS_FL_AOPEN_NOTIFY);
    eval 'sub DEVFS_FL_REMOVABLE () {0x20;}' unless defined(&DEVFS_FL_REMOVABLE);
    eval 'sub DEVFS_FL_WAIT () {0x40;}' unless defined(&DEVFS_FL_WAIT);
    eval 'sub DEVFS_FL_NO_PERSISTENCE () {0x80;}' unless defined(&DEVFS_FL_NO_PERSISTENCE);
    eval 'sub DEVFS_FL_CURRENT_OWNER () {0x100;}' unless defined(&DEVFS_FL_CURRENT_OWNER);
    eval 'sub DEVFS_FL_DEFAULT () { &DEVFS_FL_NONE;}' unless defined(&DEVFS_FL_DEFAULT);
    eval 'sub DEVFS_SPECIAL_CHR () {0;}' unless defined(&DEVFS_SPECIAL_CHR);
    eval 'sub DEVFS_SPECIAL_BLK () {1;}' unless defined(&DEVFS_SPECIAL_BLK);
    if(defined(&CONFIG_BLK_DEV_INITRD)) {
	eval 'sub ROOT_DEVICE_NAME () {(( &real_root_dev == &ROOT_DEV) ?  &root_device_name: &NULL);}' unless defined(&ROOT_DEVICE_NAME);
    } else {
	eval 'sub ROOT_DEVICE_NAME () { &root_device_name;}' unless defined(&ROOT_DEVICE_NAME);
    }
    if(defined(&CONFIG_DEVFS_FS)) {
	eval 'sub UNIQUE_NUMBERSPACE_INITIALISER () {{ &SPIN_LOCK_UNLOCKED, 0, 0, 0,  &NULL};}' unless defined(&UNIQUE_NUMBERSPACE_INITIALISER);
    } else {
	eval 'sub UNIQUE_NUMBERSPACE_INITIALISER () {{0};}' unless defined(&UNIQUE_NUMBERSPACE_INITIALISER);
	eval 'sub devfs_register {
	    my($dir,$name,$flags,$major,$minor,$mode,$ops,$info) = @_;
    	    eval q({  &NULL; });
	}' unless defined(&devfs_register);
	eval 'sub devfs_unregister {
	    my($de) = @_;
    	    eval q({ ; });
	}' unless defined(&devfs_unregister);
	eval 'sub devfs_mk_symlink {
	    my($dir,$name,$flags,$link,$handle,$info) = @_;
    	    eval q({ 0; });
	}' unless defined(&devfs_mk_symlink);
	eval 'sub devfs_mk_dir {
	    my($dir,$name,$info) = @_;
    	    eval q({  &NULL; });
	}' unless defined(&devfs_mk_dir);
	eval 'sub devfs_find_handle {
	    my($dir,$name,$major,$minor,$type,$traverse_symlinks) = @_;
    	    eval q({  &NULL; });
	}' unless defined(&devfs_find_handle);
	eval 'sub devfs_get_flags {
	    my($de,$flags) = @_;
    	    eval q({ 0; });
	}' unless defined(&devfs_get_flags);
	eval 'sub devfs_set_flags {
	    my($de,$flags) = @_;
    	    eval q({ 0; });
	}' unless defined(&devfs_set_flags);
	eval 'sub devfs_get_maj_min {
	    my($de,$major,$minor) = @_;
    	    eval q({ 0; });
	}' unless defined(&devfs_get_maj_min);
	eval 'sub devfs_get_handle_from_inode {
	    my($inode) = @_;
    	    eval q({  &NULL; });
	}' unless defined(&devfs_get_handle_from_inode);
	eval 'sub devfs_generate_path {
	    my($de,$path,$buflen) = @_;
    	    eval q({ - &ENOSYS; });
	}' unless defined(&devfs_generate_path);
	eval 'sub void {
	    eval q(* &devfs_get_ops ( &devfs_handle_t  &de) {  &NULL; });
	}' unless defined(&void);
	eval 'sub devfs_set_file_size {
	    my($de,$size) = @_;
    	    eval q({ - &ENOSYS; });
	}' unless defined(&devfs_set_file_size);
	eval 'sub void {
	    eval q(* &devfs_get_info ( &devfs_handle_t  &de) {  &NULL; });
	}' unless defined(&void);
	eval 'sub devfs_set_info {
	    my($de,$info) = @_;
    	    eval q({ 0; });
	}' unless defined(&devfs_set_info);
	eval 'sub devfs_get_parent {
	    my($de) = @_;
    	    eval q({  &NULL; });
	}' unless defined(&devfs_get_parent);
	eval 'sub devfs_get_first_child {
	    my($de) = @_;
    	    eval q({  &NULL; });
	}' unless defined(&devfs_get_first_child);
	eval 'sub devfs_get_next_sibling {
	    my($de) = @_;
    	    eval q({  &NULL; });
	}' unless defined(&devfs_get_next_sibling);
	eval 'sub devfs_auto_unregister {
	    my($master,$slave) = @_;
    	    eval q({ ; });
	}' unless defined(&devfs_auto_unregister);
	eval 'sub devfs_get_unregister_slave {
	    my($master) = @_;
    	    eval q({  &NULL; });
	}' unless defined(&devfs_get_unregister_slave);
	eval 'sub char {
	    eval q(* &devfs_get_name ( &devfs_handle_t  &de, my $int * &namelen) {  &NULL; });
	}' unless defined(&char);
	eval 'sub devfs_register_chrdev {
	    my($major,$name,$fops) = @_;
    	    eval q({  &register_chrdev ($major, $name, $fops); });
	}' unless defined(&devfs_register_chrdev);
	eval 'sub devfs_register_blkdev {
	    my($major,$name,$bdops) = @_;
    	    eval q({  &register_blkdev ($major, $name, $bdops); });
	}' unless defined(&devfs_register_blkdev);
	eval 'sub devfs_unregister_chrdev {
	    my($major,$name) = @_;
    	    eval q({  &unregister_chrdev ($major, $name); });
	}' unless defined(&devfs_unregister_chrdev);
	eval 'sub devfs_unregister_blkdev {
	    my($major,$name) = @_;
    	    eval q({  &unregister_blkdev ($major, $name); });
	}' unless defined(&devfs_unregister_blkdev);
	eval 'sub devfs_register_tape {
	    my($de) = @_;
    	    eval q({ ; });
	}' unless defined(&devfs_register_tape);
	eval 'sub devfs_register_series {
	    my($dir,$format,$num_entries,$flags,$major,$minor_start,$mode,$ops,$info) = @_;
    	    eval q({ ; });
	}' unless defined(&devfs_register_series);
	eval 'sub devfs_alloc_major {
	    my($type) = @_;
    	    eval q({ -1; });
	}' unless defined(&devfs_alloc_major);
	eval 'sub devfs_dealloc_major {
	    my($type,$major) = @_;
    	    eval q({ ; });
	}' unless defined(&devfs_dealloc_major);
	eval 'sub devfs_alloc_devnum {
	    my($type) = @_;
    	    eval q({  &NODEV; });
	}' unless defined(&devfs_alloc_devnum);
	eval 'sub devfs_dealloc_devnum {
	    my($type,$devnum) = @_;
    	    eval q({ ; });
	}' unless defined(&devfs_dealloc_devnum);
	eval 'sub devfs_alloc_unique_number {
	    my($space) = @_;
    	    eval q({ -1; });
	}' unless defined(&devfs_alloc_unique_number);
	eval 'sub devfs_dealloc_unique_number {
	    my($space,$number) = @_;
    	    eval q({ ; });
	}' unless defined(&devfs_dealloc_unique_number);
	eval 'sub mount_devfs_fs {
	    my($void) = @_;
    	    eval q({ ; });
	}' unless defined(&mount_devfs_fs);
	eval 'sub devfs_make_root {
	    my($name) = @_;
    	    eval q({ ; });
	}' unless defined(&devfs_make_root);
    }
}
1;
