require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_HIGHMEM_H)) {
    eval 'sub _LINUX_HIGHMEM_H () {1;}' unless defined(&_LINUX_HIGHMEM_H);
    require 'linux/config.ph';
    require 'asm/pgalloc.ph';
    if(defined(&CONFIG_HIGHMEM)) {
	require 'asm/highmem.ph';
	eval 'sub char {
	    eval q(* &bh_kmap(\'struct buffer_head\' * &bh) {  &kmap( ($bh->{b_page})) +  &bh_offset( &bh); });
	}' unless defined(&char);
	eval 'sub bh_kunmap {
	    my($bh) = @_;
    	    eval q({  &kunmap( ($bh->{b_page})); });
	}' unless defined(&bh_kunmap);
	eval 'sub bh_kunmap_irq {
	    my($buffer,$flags) = @_;
    	    eval q({ my $ptr = $buffer &  &PAGE_MASK;  &kunmap_atomic(( &void *)  $ptr,  &KM_BH_IRQ);  &__restore_flags(*$flags); });
	}' unless defined(&bh_kunmap_irq);
    } else {
	eval 'sub kunmap {
	    my($page) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&kunmap);
	eval 'sub kmap_atomic {
	    my($page,$idx) = @_;
    	    eval q( &kmap($page));
	}' unless defined(&kmap_atomic);
	eval 'sub kunmap_atomic {
	    my($page,$idx) = @_;
    	    eval q( &kunmap($page));
	}' unless defined(&kunmap_atomic);
	eval 'sub bh_kmap {
	    my($bh) = @_;
    	    eval q((($bh)-> &b_data));
	}' unless defined(&bh_kmap);
	eval 'sub bh_kunmap {
	    my($bh) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&bh_kunmap);
	eval 'sub bh_kmap_irq {
	    my($bh, $flags) = @_;
    	    eval q((($bh)-> &b_data));
	}' unless defined(&bh_kmap_irq);
	eval 'sub bh_kunmap_irq {
	    my($bh, $flags) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&bh_kunmap_irq);
    }
    eval 'sub clear_highpage {
        my($page) = @_;
	    eval q({  &clear_page( &kmap($page));  &kunmap($page); });
    }' unless defined(&clear_highpage);
    eval 'sub memclear_highpage {
        my($page,$offset,$size) = @_;
	    eval q({ \'char\' * &kaddr;  &if ($offset + $size >  &PAGE_SIZE)  &BUG();  &kaddr =  &kmap($page);  &memset( &kaddr + $offset, 0, $size);  &kunmap($page); });
    }' unless defined(&memclear_highpage);
    eval 'sub copy_user_highpage {
        my($to,$from,$vaddr) = @_;
	    eval q({ \'char\' * &vfrom, * &vto;  &vfrom =  &kmap_atomic($from,  &KM_USER0);  &vto =  &kmap_atomic($to,  &KM_USER1);  &copy_user_page( &vto,  &vfrom, $vaddr);  &kunmap_atomic( &vfrom,  &KM_USER0);  &kunmap_atomic( &vto,  &KM_USER1); });
    }' unless defined(&copy_user_highpage);
    eval 'sub copy_highpage {
        my($to,$from) = @_;
	    eval q({ \'char\' * &vfrom, * &vto;  &vfrom =  &kmap($from);  &vto =  &kmap($to);  &copy_page( &vto,  &vfrom);  &kunmap($from);  &kunmap($to); });
    }' unless defined(&copy_highpage);
}
1;
