require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_IDE_H)) {
    eval 'sub _IDE_H () {1;}' unless defined(&_IDE_H);
    require 'linux/config.ph';
    require 'linux/init.ph';
    require 'linux/ioport.ph';
    require 'linux/hdreg.ph';
    require 'linux/hdsmart.ph';
    require 'linux/blkdev.ph';
    require 'linux/proc_fs.ph';
    require 'linux/devfs_fs_kernel.ph';
    require 'asm/hdreg.ph';
    undef(&REALLY_FAST_IO) if defined(&REALLY_FAST_IO);
    eval 'sub INITIAL_MULT_COUNT () {0;}' unless defined(&INITIAL_MULT_COUNT);
    unless(defined(&SUPPORT_SLOW_DATA_PORTS)) {
	eval 'sub SUPPORT_SLOW_DATA_PORTS () {1;}' unless defined(&SUPPORT_SLOW_DATA_PORTS);
    }
    unless(defined(&SUPPORT_VLB_SYNC)) {
	eval 'sub SUPPORT_VLB_SYNC () {1;}' unless defined(&SUPPORT_VLB_SYNC);
    }
    unless(defined(&DISK_RECOVERY_TIME)) {
	eval 'sub DISK_RECOVERY_TIME () {0;}' unless defined(&DISK_RECOVERY_TIME);
    }
    unless(defined(&OK_TO_RESET_CONTROLLER)) {
	eval 'sub OK_TO_RESET_CONTROLLER () {1;}' unless defined(&OK_TO_RESET_CONTROLLER);
    }
    unless(defined(&FANCY_STATUS_DUMPS)) {
	eval 'sub FANCY_STATUS_DUMPS () {1;}' unless defined(&FANCY_STATUS_DUMPS);
    }
    if(defined(&CONFIG_BLK_DEV_CMD640)) {
	if(0) {
	    eval 'sub CMD640_DUMP_REGS () { &cmd640_dump_regs();}' unless defined(&CMD640_DUMP_REGS);
	}
    }
    unless(defined(&DISABLE_IRQ_NOSYNC)) {
	eval 'sub DISABLE_IRQ_NOSYNC () {0;}' unless defined(&DISABLE_IRQ_NOSYNC);
    }
    eval 'sub IDE_DRIVE_CMD () {99;}' unless defined(&IDE_DRIVE_CMD);
    eval 'sub IDE_DRIVE_TASK () {98;}' unless defined(&IDE_DRIVE_TASK);
    eval 'sub IDE_DRIVE_CMD_AEB () {98;}' unless defined(&IDE_DRIVE_CMD_AEB);
    eval 'sub ERROR_MAX () {8;}' unless defined(&ERROR_MAX);
    eval 'sub ERROR_RESET () {3;}' unless defined(&ERROR_RESET);
    eval 'sub ERROR_RECAL () {1;}' unless defined(&ERROR_RECAL);
    eval 'sub DMA_PIO_RETRY () {1;}' unless defined(&DMA_PIO_RETRY);
    if(defined(&REALLY_SLOW_IO)) {
	undef(&REALLY_FAST_IO) if defined(&REALLY_FAST_IO);
    }
    eval 'sub HWIF {
        my($drive) = @_;
	    eval q((( &ide_hwif_t *)(($drive)-> &hwif)));
    }' unless defined(&HWIF);
    eval 'sub HWGROUP {
        my($drive) = @_;
	    eval q((( &ide_hwgroup_t *)( &HWIF($drive)-> &hwgroup)));
    }' unless defined(&HWGROUP);
    eval 'sub IDE_NR_PORTS () {(10);}' unless defined(&IDE_NR_PORTS);
    eval 'sub IDE_DATA_OFFSET () {(0);}' unless defined(&IDE_DATA_OFFSET);
    eval 'sub IDE_ERROR_OFFSET () {(1);}' unless defined(&IDE_ERROR_OFFSET);
    eval 'sub IDE_NSECTOR_OFFSET () {(2);}' unless defined(&IDE_NSECTOR_OFFSET);
    eval 'sub IDE_SECTOR_OFFSET () {(3);}' unless defined(&IDE_SECTOR_OFFSET);
    eval 'sub IDE_LCYL_OFFSET () {(4);}' unless defined(&IDE_LCYL_OFFSET);
    eval 'sub IDE_HCYL_OFFSET () {(5);}' unless defined(&IDE_HCYL_OFFSET);
    eval 'sub IDE_SELECT_OFFSET () {(6);}' unless defined(&IDE_SELECT_OFFSET);
    eval 'sub IDE_STATUS_OFFSET () {(7);}' unless defined(&IDE_STATUS_OFFSET);
    eval 'sub IDE_CONTROL_OFFSET () {(8);}' unless defined(&IDE_CONTROL_OFFSET);
    eval 'sub IDE_IRQ_OFFSET () {(9);}' unless defined(&IDE_IRQ_OFFSET);
    eval 'sub IDE_FEATURE_OFFSET () { &IDE_ERROR_OFFSET;}' unless defined(&IDE_FEATURE_OFFSET);
    eval 'sub IDE_COMMAND_OFFSET () { &IDE_STATUS_OFFSET;}' unless defined(&IDE_COMMAND_OFFSET);
    eval 'sub IDE_DATA_REG () {( &HWIF( &drive)-> $io_ports[ &IDE_DATA_OFFSET]);}' unless defined(&IDE_DATA_REG);
    eval 'sub IDE_ERROR_REG () {( &HWIF( &drive)-> $io_ports[ &IDE_ERROR_OFFSET]);}' unless defined(&IDE_ERROR_REG);
    eval 'sub IDE_NSECTOR_REG () {( &HWIF( &drive)-> $io_ports[ &IDE_NSECTOR_OFFSET]);}' unless defined(&IDE_NSECTOR_REG);
    eval 'sub IDE_SECTOR_REG () {( &HWIF( &drive)-> $io_ports[ &IDE_SECTOR_OFFSET]);}' unless defined(&IDE_SECTOR_REG);
    eval 'sub IDE_LCYL_REG () {( &HWIF( &drive)-> $io_ports[ &IDE_LCYL_OFFSET]);}' unless defined(&IDE_LCYL_REG);
    eval 'sub IDE_HCYL_REG () {( &HWIF( &drive)-> $io_ports[ &IDE_HCYL_OFFSET]);}' unless defined(&IDE_HCYL_REG);
    eval 'sub IDE_SELECT_REG () {( &HWIF( &drive)-> $io_ports[ &IDE_SELECT_OFFSET]);}' unless defined(&IDE_SELECT_REG);
    eval 'sub IDE_STATUS_REG () {( &HWIF( &drive)-> $io_ports[ &IDE_STATUS_OFFSET]);}' unless defined(&IDE_STATUS_REG);
    eval 'sub IDE_CONTROL_REG () {( &HWIF( &drive)-> $io_ports[ &IDE_CONTROL_OFFSET]);}' unless defined(&IDE_CONTROL_REG);
    eval 'sub IDE_IRQ_REG () {( &HWIF( &drive)-> $io_ports[ &IDE_IRQ_OFFSET]);}' unless defined(&IDE_IRQ_REG);
    eval 'sub IDE_FEATURE_REG () { &IDE_ERROR_REG;}' unless defined(&IDE_FEATURE_REG);
    eval 'sub IDE_COMMAND_REG () { &IDE_STATUS_REG;}' unless defined(&IDE_COMMAND_REG);
    eval 'sub IDE_ALTSTATUS_REG () { &IDE_CONTROL_REG;}' unless defined(&IDE_ALTSTATUS_REG);
    eval 'sub IDE_IREASON_REG () { &IDE_NSECTOR_REG;}' unless defined(&IDE_IREASON_REG);
    eval 'sub IDE_BCOUNTL_REG () { &IDE_LCYL_REG;}' unless defined(&IDE_BCOUNTL_REG);
    eval 'sub IDE_BCOUNTH_REG () { &IDE_HCYL_REG;}' unless defined(&IDE_BCOUNTH_REG);
    eval 'sub GET_ERR () {
        eval q( &IN_BYTE( &IDE_ERROR_REG));
    }' unless defined(&GET_ERR);
    eval 'sub GET_STAT () {
        eval q( &IN_BYTE( &IDE_STATUS_REG));
    }' unless defined(&GET_STAT);
    eval 'sub GET_ALTSTAT () {
        eval q( &IN_BYTE( &IDE_CONTROL_REG));
    }' unless defined(&GET_ALTSTAT);
    eval 'sub OK_STAT {
        my($stat,$good,$bad) = @_;
	    eval q(((($stat)(($good)|($bad)))==($good)));
    }' unless defined(&OK_STAT);
    eval 'sub BAD_R_STAT () {( &BUSY_STAT |  &ERR_STAT);}' unless defined(&BAD_R_STAT);
    eval 'sub BAD_W_STAT () {( &BAD_R_STAT |  &WRERR_STAT);}' unless defined(&BAD_W_STAT);
    eval 'sub BAD_STAT () {( &BAD_R_STAT |  &DRQ_STAT);}' unless defined(&BAD_STAT);
    eval 'sub DRIVE_READY () {( &READY_STAT |  &SEEK_STAT);}' unless defined(&DRIVE_READY);
    eval 'sub DATA_READY () {( &DRQ_STAT);}' unless defined(&DATA_READY);
    eval 'sub IDE_MAJOR_NAME () {"hd";}' unless defined(&IDE_MAJOR_NAME);
    eval 'sub MAJOR_NAME () { &IDE_MAJOR_NAME;}' unless defined(&MAJOR_NAME);
    eval 'sub PARTN_BITS () {6;}' unless defined(&PARTN_BITS);
    eval 'sub PARTN_MASK () {((1<< &PARTN_BITS)-1);}' unless defined(&PARTN_MASK);
    eval 'sub MAX_DRIVES () {2;}' unless defined(&MAX_DRIVES);
    eval 'sub SECTOR_WORDS () {(512/ 4);}' unless defined(&SECTOR_WORDS);
    eval 'sub IDE_LARGE_SEEK {
        my($b1,$b2,$t) = @_;
	    eval q(((($b1) > ($b2) + ($t)) || (($b2) > ($b1) + ($t))));
    }' unless defined(&IDE_LARGE_SEEK);
    eval 'sub IDE_MIN {
        my($a,$b) = @_;
	    eval q((($a)<($b) ? ($a):($b)));
    }' unless defined(&IDE_MIN);
    eval 'sub IDE_MAX {
        my($a,$b) = @_;
	    eval q((($a)>($b) ? ($a):($b)));
    }' unless defined(&IDE_MAX);
    eval 'sub WAIT_DRQ () {(5* &HZ/100);}' unless defined(&WAIT_DRQ);
    if(defined( &CONFIG_APM) || defined( &CONFIG_APM_MODULE)) {
	eval 'sub WAIT_READY () {(5* &HZ);}' unless defined(&WAIT_READY);
    } else {
	eval 'sub WAIT_READY () {(3* &HZ/100);}' unless defined(&WAIT_READY);
    }
    eval 'sub WAIT_PIDENTIFY () {(10* &HZ);}' unless defined(&WAIT_PIDENTIFY);
    eval 'sub WAIT_WORSTCASE () {(30* &HZ);}' unless defined(&WAIT_WORSTCASE);
    eval 'sub WAIT_CMD () {(10* &HZ);}' unless defined(&WAIT_CMD);
    eval 'sub WAIT_MIN_SLEEP () {(2* &HZ/100);}' unless defined(&WAIT_MIN_SLEEP);
    eval 'sub SELECT_DRIVE {
        my($hwif,$drive) = @_;
	    eval q({  &if ( ($hwif->{selectproc}))  ($hwif->{selectproc})($drive);  &OUT_BYTE(($drive)-> ($select->{all}),  ($hwif->{io_ports[&IDE_SELECT_OFFSET]})); });
    }' unless defined(&SELECT_DRIVE);
    eval 'sub SELECT_INTERRUPT {
        my($hwif,$drive) = @_;
	    eval q({  &if ( ($hwif->{intrproc}))  ($hwif->{intrproc})($drive);  &else  &OUT_BYTE(($drive)-> &ctl|2,  ($hwif->{io_ports[&IDE_CONTROL_OFFSET]})); });
    }' unless defined(&SELECT_INTERRUPT);
    eval 'sub SELECT_MASK {
        my($hwif,$drive,$mask) = @_;
	    eval q({  &if ( ($hwif->{maskproc}))  ($hwif->{maskproc})($drive,$mask); });
    }' unless defined(&SELECT_MASK);
    eval 'sub SELECT_READ_WRITE {
        my($hwif,$drive,$func) = @_;
	    eval q({  &if ( ($hwif->{rwproc}))  ($hwif->{rwproc})($drive,$func); });
    }' unless defined(&SELECT_READ_WRITE);
    eval 'sub QUIRK_LIST {
        my($hwif,$drive) = @_;
	    eval q({  &if ( ($hwif->{quirkproc})) ($drive)-> &quirk_list =  ($hwif->{quirkproc})($drive); });
    }' unless defined(&QUIRK_LIST);
    eval 'sub IDE_DEBUG {
        my($lineno) = @_;
	    eval q( &printk(\\"%s,%s,line=%d\\\\n\\",  &__FILE__,  &__FUNCTION__, ($lineno)));
    }' unless defined(&IDE_DEBUG);
    unless(defined(&NO_DMA)) {
	eval 'sub NO_DMA () {255;}' unless defined(&NO_DMA);
    }
    require 'asm/ide.ph';
    unless(defined(&HAVE_ARCH_OUT_BYTE)) {
	if(defined(&REALLY_FAST_IO)) {
	    eval 'sub OUT_BYTE {
	        my($b,$p) = @_;
    		eval q( &outb(($b),($p)));
	    }' unless defined(&OUT_BYTE);
	} else {
	    eval 'sub OUT_BYTE {
	        my($b,$p) = @_;
    		eval q( &outb_p(($b),($p)));
	    }' unless defined(&OUT_BYTE);
	}
    }
    unless(defined(&HAVE_ARCH_IN_BYTE)) {
	if(defined(&REALLY_FAST_IO)) {
	    eval 'sub IN_BYTE {
	        my($p) = @_;
    		eval q(( &byte) &inb_p($p));
	    }' unless defined(&IN_BYTE);
	} else {
	    eval 'sub IN_BYTE {
	        my($p) = @_;
    		eval q(( &byte) &inb($p));
	    }' unless defined(&IN_BYTE);
	}
    }
    eval 'sub ide_scsi () {0x21;}' unless defined(&ide_scsi);
    eval 'sub ide_disk () {0x20;}' unless defined(&ide_disk);
    eval 'sub ide_optical () {0x7;}' unless defined(&ide_optical);
    eval 'sub ide_cdrom () {0x5;}' unless defined(&ide_cdrom);
    eval 'sub ide_tape () {0x1;}' unless defined(&ide_tape);
    eval 'sub ide_floppy () {0x;}' unless defined(&ide_floppy);
    eval("sub ide_dma_read () { 0; }") unless defined(&ide_dma_read);
    eval("sub ide_dma_write () { 1; }") unless defined(&ide_dma_write);
    eval("sub ide_dma_begin () { 2; }") unless defined(&ide_dma_begin);
    eval("sub ide_dma_end () { 3; }") unless defined(&ide_dma_end);
    eval("sub ide_dma_check () { 4; }") unless defined(&ide_dma_check);
    eval("sub ide_dma_on () { 5; }") unless defined(&ide_dma_on);
    eval("sub ide_dma_off () { 6; }") unless defined(&ide_dma_off);
    eval("sub ide_dma_off_quietly () { 7; }") unless defined(&ide_dma_off_quietly);
    eval("sub ide_dma_test_irq () { 8; }") unless defined(&ide_dma_test_irq);
    eval("sub ide_dma_bad_drive () { 9; }") unless defined(&ide_dma_bad_drive);
    eval("sub ide_dma_good_drive () { 10; }") unless defined(&ide_dma_good_drive);
    eval("sub ide_dma_verbose () { 11; }") unless defined(&ide_dma_verbose);
    eval("sub ide_dma_retune () { 12; }") unless defined(&ide_dma_retune);
    eval("sub ide_dma_lostirq () { 13; }") unless defined(&ide_dma_lostirq);
    eval("sub ide_dma_timeout () { 14; }") unless defined(&ide_dma_timeout);
    eval("sub ideproc_ide_input_data () { 0; }") unless defined(&ideproc_ide_input_data);
    eval("sub ideproc_ide_output_data () { 1; }") unless defined(&ideproc_ide_output_data);
    eval("sub ideproc_atapi_input_bytes () { 2; }") unless defined(&ideproc_atapi_input_bytes);
    eval("sub ideproc_atapi_output_bytes () { 3; }") unless defined(&ideproc_atapi_output_bytes);
    eval("sub ide_unknown () { 0; }") unless defined(&ide_unknown);
    eval("sub ide_generic () { 1; }") unless defined(&ide_generic);
    eval("sub ide_pci () { 2; }") unless defined(&ide_pci);
    eval("sub ide_cmd640 () { 3; }") unless defined(&ide_cmd640);
    eval("sub ide_dtc2278 () { 4; }") unless defined(&ide_dtc2278);
    eval("sub ide_ali14xx () { 5; }") unless defined(&ide_ali14xx);
    eval("sub ide_qd65xx () { 6; }") unless defined(&ide_qd65xx);
    eval("sub ide_umc8672 () { 7; }") unless defined(&ide_umc8672);
    eval("sub ide_ht6560b () { 8; }") unless defined(&ide_ht6560b);
    eval("sub ide_pdc4030 () { 9; }") unless defined(&ide_pdc4030);
    eval("sub ide_rz1000 () { 10; }") unless defined(&ide_rz1000);
    eval("sub ide_trm290 () { 11; }") unless defined(&ide_trm290);
    eval("sub ide_cmd646 () { 12; }") unless defined(&ide_cmd646);
    eval("sub ide_cy82c693 () { 13; }") unless defined(&ide_cy82c693);
    eval("sub ide_4drives () { 14; }") unless defined(&ide_4drives);
    eval("sub ide_pmac () { 15; }") unless defined(&ide_pmac);
    eval("sub ide_etrax100 () { 16; }") unless defined(&ide_etrax100);
    eval 'sub IDE_CHIPSET_PCI_MASK () {((1<< &ide_pci)|(1<< &ide_cmd646)|(1<< &ide_ali14xx));}' unless defined(&IDE_CHIPSET_PCI_MASK);
    eval 'sub IDE_CHIPSET_IS_PCI {
        my($c) = @_;
	    eval q((( &IDE_CHIPSET_PCI_MASK >> ($c)) & 1));
    }' unless defined(&IDE_CHIPSET_IS_PCI);
    if(defined(&CONFIG_BLK_DEV_IDEPCI)) {
	eval 'sub IDE_PCI_DEVID_NULL () {(( &ide_pci_devid_t){0,0});}' unless defined(&IDE_PCI_DEVID_NULL);
	eval 'sub IDE_PCI_DEVID_EQ {
	    my($a,$b) = @_;
    	    eval q(( ($a->{vid}) ==  ($b->{vid})  &&  ($a->{did}) ==  ($b->{did})));
	}' unless defined(&IDE_PCI_DEVID_EQ);
    }
    if(defined(&CONFIG_BLK_DEV_IDEPCI)) {
    }
    if(((defined(&DISK_RECOVERY_TIME) ? &DISK_RECOVERY_TIME : 0) > 0)) {
    }
    eval("sub ide_stopped () { 0; }") unless defined(&ide_stopped);
    eval("sub ide_started () { 1; }") unless defined(&ide_started);
    eval 'sub TYPE_INT () {0;}' unless defined(&TYPE_INT);
    eval 'sub TYPE_INTA () {1;}' unless defined(&TYPE_INTA);
    eval 'sub TYPE_BYTE () {2;}' unless defined(&TYPE_BYTE);
    eval 'sub TYPE_SHORT () {3;}' unless defined(&TYPE_SHORT);
    eval 'sub SETTING_READ () {(1<< 0);}' unless defined(&SETTING_READ);
    eval 'sub SETTING_WRITE () {(1<< 1);}' unless defined(&SETTING_WRITE);
    eval 'sub SETTING_RW () {( &SETTING_READ |  &SETTING_WRITE);}' unless defined(&SETTING_RW);
    if(defined(&CONFIG_PROC_FS)) {
	eval 'sub PROC_IDE_READ_RETURN {
	    my($page,$start,$off,$count,$eof,$len) = @_;
    	    eval q({ $len -= $off;  &if ($len < $count) { *$eof = 1;  &if ($len <= 0)  &return 0; }  &else $len = $count; *$start = $page + $off;  &return $len; });
	}' unless defined(&PROC_IDE_READ_RETURN);
    } else {
	eval 'sub PROC_IDE_READ_RETURN {
	    my($page,$start,$off,$count,$eof,$len) = @_;
    	    eval q( &return 0;);
	}' unless defined(&PROC_IDE_READ_RETURN);
    }
    eval 'sub IDE_SUBDRIVER_VERSION () {1;}' unless defined(&IDE_SUBDRIVER_VERSION);
    eval 'sub DRIVER {
        my($drive) = @_;
	    eval q((( &ide_driver_t *)(($drive)-> &driver)));
    }' unless defined(&DRIVER);
    eval 'sub IDE_CHIPSET_MODULE () {0;}' unless defined(&IDE_CHIPSET_MODULE);
    eval 'sub IDE_PROBE_MODULE () {1;}' unless defined(&IDE_PROBE_MODULE);
    eval 'sub IDE_DRIVER_MODULE () {2;}' unless defined(&IDE_DRIVER_MODULE);
    unless(defined(&_IDE_C)) {
    }
    eval 'sub IDE_DRIVER () {1;}' unless defined(&IDE_DRIVER);
    eval 'sub LOCAL_END_REQUEST () {1;}' unless defined(&LOCAL_END_REQUEST);
    require 'linux/blk.ph';
    eval("sub ide_wait () { 0; }") unless defined(&ide_wait);
    eval("sub ide_next () { 1; }") unless defined(&ide_next);
    eval("sub ide_preempt () { 2; }") unless defined(&ide_preempt);
    eval("sub ide_end () { 3; }") unless defined(&ide_end);
    eval 'sub ide_rq_offset {
        my($rq) = @_;
	    eval q(((($rq)-> &hard_cur_sectors - ($rq)-> &current_nr_sectors) << 9));
    }' unless defined(&ide_rq_offset);
    eval 'sub void {
        eval q(* &ide_map_buffer(\'struct request\' * &rq, my $long * &flags) {  &bh_kmap_irq( ($rq->{bh}),  &flags) +  &ide_rq_offset( &rq); });
    }' unless defined(&void);
    eval 'sub ide_unmap_buffer {
        my($buffer,$flags) = @_;
	    eval q({  &bh_kunmap_irq($buffer, $flags); });
    }' unless defined(&ide_unmap_buffer);
    unless(defined(&_IDE_C)) {
    }
    if(defined(&_IDE_C)) {
	if(defined(&CONFIG_BLK_DEV_IDE)) {
	}
	if(defined(&CONFIG_BLK_DEV_IDEDISK)) {
	}
	if(defined(&CONFIG_BLK_DEV_IDECD)) {
	}
	if(defined(&CONFIG_BLK_DEV_IDETAPE)) {
	}
	if(defined(&CONFIG_BLK_DEV_IDEFLOPPY)) {
	}
	if(defined(&CONFIG_BLK_DEV_IDESCSI)) {
	}
    }
    if(defined(&CONFIG_BLK_DEV_IDEPCI)) {
	eval 'sub ON_BOARD () {1;}' unless defined(&ON_BOARD);
	eval 'sub NEVER_BOARD () {0;}' unless defined(&NEVER_BOARD);
	if(defined(&CONFIG_BLK_DEV_OFFBOARD)) {
	    eval 'sub OFF_BOARD () { &ON_BOARD;}' unless defined(&OFF_BOARD);
	} else {
	    eval 'sub OFF_BOARD () { &NEVER_BOARD;}' unless defined(&OFF_BOARD);
	}
    }
    if(defined(&CONFIG_BLK_DEV_IDEDMA)) {
	eval 'sub BAD_DMA_DRIVE () {0;}' unless defined(&BAD_DMA_DRIVE);
	eval 'sub GOOD_DMA_DRIVE () {1;}' unless defined(&GOOD_DMA_DRIVE);
    }
}
1;
