require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_INTERRUPT_H)) {
    eval 'sub _LINUX_INTERRUPT_H () {1;}' unless defined(&_LINUX_INTERRUPT_H);
    require 'linux/config.ph';
    require 'linux/kernel.ph';
    require 'linux/smp.ph';
    require 'linux/cache.ph';
    require 'asm/bitops.ph';
    require 'asm/ptrace.ph';
    eval("sub TIMER_BH () { 0; }") unless defined(&TIMER_BH);
    eval("sub TQUEUE_BH () { 1; }") unless defined(&TQUEUE_BH);
    eval("sub DIGI_BH () { 2; }") unless defined(&DIGI_BH);
    eval("sub SERIAL_BH () { 3; }") unless defined(&SERIAL_BH);
    eval("sub RISCOM8_BH () { 4; }") unless defined(&RISCOM8_BH);
    eval("sub SPECIALIX_BH () { 5; }") unless defined(&SPECIALIX_BH);
    eval("sub AURORA_BH () { 6; }") unless defined(&AURORA_BH);
    eval("sub ESP_BH () { 7; }") unless defined(&ESP_BH);
    eval("sub SCSI_BH () { 8; }") unless defined(&SCSI_BH);
    eval("sub IMMEDIATE_BH () { 9; }") unless defined(&IMMEDIATE_BH);
    eval("sub CYCLADES_BH () { 10; }") unless defined(&CYCLADES_BH);
    eval("sub CM206_BH () { 11; }") unless defined(&CM206_BH);
    eval("sub JS_BH () { 12; }") unless defined(&JS_BH);
    eval("sub MACSERIAL_BH () { 13; }") unless defined(&MACSERIAL_BH);
    eval("sub ISICOM_BH () { 14; }") unless defined(&ISICOM_BH);
    require 'asm/hardirq.ph';
    require 'asm/softirq.ph';
    eval("sub HI_SOFTIRQ () { 0; }") unless defined(&HI_SOFTIRQ);
    eval("sub NET_TX_SOFTIRQ () { 1; }") unless defined(&NET_TX_SOFTIRQ);
    eval("sub NET_RX_SOFTIRQ () { 2; }") unless defined(&NET_RX_SOFTIRQ);
    eval("sub TASKLET_SOFTIRQ () { 3; }") unless defined(&TASKLET_SOFTIRQ);
    eval 'sub __cpu_raise_softirq {
        my($cpu, $nr) = @_;
	    eval q( &do {  &softirq_pending($cpu) |= 1 << ($nr); }  &while (0));
    }' unless defined(&__cpu_raise_softirq);
    eval 'sub DECLARE_TASKLET {
        my($name, $func, $data) = @_;
	    eval q(\'struct tasklet_struct\' $name = {  &NULL, 0,  &ATOMIC_INIT(0), $func, $data });
    }' unless defined(&DECLARE_TASKLET);
    eval 'sub DECLARE_TASKLET_DISABLED {
        my($name, $func, $data) = @_;
	    eval q(\'struct tasklet_struct\' $name = {  &NULL, 0,  &ATOMIC_INIT(1), $func, $data });
    }' unless defined(&DECLARE_TASKLET_DISABLED);
    eval("sub TASKLET_STATE_SCHED () { 0; }") unless defined(&TASKLET_STATE_SCHED);
    eval("sub TASKLET_STATE_RUN () { 1; }") unless defined(&TASKLET_STATE_RUN);
    if(defined(&CONFIG_SMP)) {
	eval 'sub tasklet_trylock {
	    my($t) = @_;
    	    eval q({ ! &test_and_set_bit( &TASKLET_STATE_RUN, ($t)-> &state); });
	}' unless defined(&tasklet_trylock);
	eval 'sub tasklet_unlock {
	    my($t) = @_;
    	    eval q({  &smp_mb__before_clear_bit();  &clear_bit( &TASKLET_STATE_RUN, ($t)-> &state); });
	}' unless defined(&tasklet_unlock);
	eval 'sub tasklet_unlock_wait {
	    my($t) = @_;
    	    eval q({  &while ( &test_bit( &TASKLET_STATE_RUN, ($t)-> &state)) {  &barrier(); } });
	}' unless defined(&tasklet_unlock_wait);
    } else {
	eval 'sub tasklet_trylock {
	    my($t) = @_;
    	    eval q(1);
	}' unless defined(&tasklet_trylock);
	eval 'sub tasklet_unlock_wait {
	    my($t) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&tasklet_unlock_wait);
	eval 'sub tasklet_unlock {
	    my($t) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&tasklet_unlock);
    }
    eval 'sub tasklet_schedule {
        my($t) = @_;
	    eval q({  &if (! &test_and_set_bit( &TASKLET_STATE_SCHED,  ($t->{s$tate})))  &__tasklet_schedule($t); });
    }' unless defined(&tasklet_schedule);
    eval 'sub tasklet_hi_schedule {
        my($t) = @_;
	    eval q({  &if (! &test_and_set_bit( &TASKLET_STATE_SCHED,  ($t->{s$tate})))  &__tasklet_hi_schedule($t); });
    }' unless defined(&tasklet_hi_schedule);
    eval 'sub tasklet_disable_nosync {
        my($t) = @_;
	    eval q({  &atomic_inc( ($t->{count}));  &smp_mb__after_atomic_inc(); });
    }' unless defined(&tasklet_disable_nosync);
    eval 'sub tasklet_disable {
        my($t) = @_;
	    eval q({  &tasklet_disable_nosync($t);  &tasklet_unlock_wait($t);  &smp_mb(); });
    }' unless defined(&tasklet_disable);
    eval 'sub tasklet_enable {
        my($t) = @_;
	    eval q({  &smp_mb__before_atomic_dec();  &atomic_dec( ($t->{count})); });
    }' unless defined(&tasklet_enable);
    eval 'sub tasklet_hi_enable {
        my($t) = @_;
	    eval q({  &smp_mb__before_atomic_dec();  &atomic_dec( ($t->{count})); });
    }' unless defined(&tasklet_hi_enable);
    if(defined(&CONFIG_SMP)) {
	eval 'sub SMP_TIMER_NAME {
	    my($name) = @_;
    	    eval q($name &__thr);
	}' unless defined(&SMP_TIMER_NAME);
	eval 'sub SMP_TIMER_DEFINE {
	    my($name, $task) = @_;
    	    eval q( &DECLARE_TASKLET($task, $name &__thr, 0);  &static  &void $name  {  &tasklet_schedule(($task)); });
	}' unless defined(&SMP_TIMER_DEFINE);
    } else {
	eval 'sub SMP_TIMER_NAME {
	    my($name) = @_;
    	    eval q($name);
	}' unless defined(&SMP_TIMER_NAME);
	eval 'sub SMP_TIMER_DEFINE {
	    my($name, $task) = @_;
    	    eval q();
	}' unless defined(&SMP_TIMER_DEFINE);
    }
    eval 'sub mark_bh {
        my($nr) = @_;
	    eval q({  &tasklet_hi_schedule( &bh_task_vec+$nr); });
    }' unless defined(&mark_bh);
}
1;
