require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LVM_H_INCLUDE)) {
    eval 'sub _LVM_H_INCLUDE () {1;}' unless defined(&_LVM_H_INCLUDE);
    eval 'sub LVM_RELEASE_NAME () {"LVM 0.9.1_beta7(ish)";}' unless defined(&LVM_RELEASE_NAME);
    eval 'sub LVM_RELEASE_DATE () {"20 June 2001";}' unless defined(&LVM_RELEASE_DATE);
    eval 'sub _LVM_KERNEL_H_VERSION () {"LVM " &LVM_RELEASE_NAME" (" &LVM_RELEASE_DATE")";}' unless defined(&_LVM_KERNEL_H_VERSION);
    require 'linux/config.ph';
    require 'linux/version.ph';
    eval 'sub LVM_TOTAL_RESET () {1;}' unless defined(&LVM_TOTAL_RESET);
    require 'linux/kdev_t.ph';
    require 'linux/list.ph';
    require 'asm/types.ph';
    require 'linux/major.ph';
    require 'asm/page.ph';
    if(!defined ( (defined(&LVM_BLK_MAJOR) ? &LVM_BLK_MAJOR : 0)) || !defined ( (defined(&LVM_CHAR_MAJOR) ? &LVM_CHAR_MAJOR : 0))) {
	die("Bad\ include\/linux\/major\.h\ \-\ LVM\ MAJOR\ undefined");
    }
    if(defined(&BLOCK_SIZE)) {
	undef(&BLOCK_SIZE) if defined(&BLOCK_SIZE);
    }
    if(defined(&CONFIG_ARCH_S390)) {
	eval 'sub BLOCK_SIZE () {4096;}' unless defined(&BLOCK_SIZE);
    } else {
	eval 'sub BLOCK_SIZE () {1024;}' unless defined(&BLOCK_SIZE);
    }
    unless(defined(&SECTOR_SIZE)) {
	eval 'sub SECTOR_SIZE () {512;}' unless defined(&SECTOR_SIZE);
    }
    eval 'sub LVM_STRUCT_VERSION () {1;}' unless defined(&LVM_STRUCT_VERSION);
    eval 'sub LVM_DIR_PREFIX () {"/dev/";}' unless defined(&LVM_DIR_PREFIX);
    unless(defined(&min)) {
	eval 'sub min {
	    my($a,$b) = @_;
    	    eval q(((($a)<($b))?($a):($b)));
	}' unless defined(&min);
    }
    unless(defined(&max)) {
	eval 'sub max {
	    my($a,$b) = @_;
    	    eval q(((($a)>($b))?($a):($b)));
	}' unless defined(&max);
    }
    if(( (defined(&LVM_STRUCT_VERSION) ? &LVM_STRUCT_VERSION : 0) == 1)) {
	eval 'sub pv_t () { &pv_v2_t;}' unless defined(&pv_t);
	eval 'sub lv_t () { &lv_v5_t;}' unless defined(&lv_t);
	eval 'sub vg_t () { &vg_v3_t;}' unless defined(&vg_t);
	eval 'sub pv_disk_t () { &pv_disk_v2_t;}' unless defined(&pv_disk_t);
	eval 'sub lv_disk_t () { &lv_disk_v3_t;}' unless defined(&lv_disk_t);
	eval 'sub vg_disk_t () { &vg_disk_v2_t;}' unless defined(&vg_disk_t);
	eval 'sub lv_block_exception_t () { &lv_block_exception_v1_t;}' unless defined(&lv_block_exception_t);
	eval 'sub lv_COW_table_disk_t () { &lv_COW_table_disk_v1_t;}' unless defined(&lv_COW_table_disk_t);
    }
    eval 'sub LVM_DRIVER_IOP_VERSION () {10;}' unless defined(&LVM_DRIVER_IOP_VERSION);
    eval 'sub LVM_NAME () {"lvm";}' unless defined(&LVM_NAME);
    eval 'sub LVM_GLOBAL () {"global";}' unless defined(&LVM_GLOBAL);
    eval 'sub LVM_DIR () {"lvm";}' unless defined(&LVM_DIR);
    eval 'sub LVM_VG_SUBDIR () {"VGs";}' unless defined(&LVM_VG_SUBDIR);
    eval 'sub LVM_LV_SUBDIR () {"LVs";}' unless defined(&LVM_LV_SUBDIR);
    eval 'sub LVM_PV_SUBDIR () {"PVs";}' unless defined(&LVM_PV_SUBDIR);
    eval 'sub VG_CHR {
        my($a) = @_;
	    eval q(( $a));
    }' unless defined(&VG_CHR);
    eval 'sub VG_BLK {
        my($a) = @_;
	    eval q((  ($vg_lv_map[$a]->{vg_number})));
    }' unless defined(&VG_BLK);
    eval 'sub LV_BLK {
        my($a) = @_;
	    eval q((  ($vg_lv_map[$a]->{lv_number})));
    }' unless defined(&LV_BLK);
    eval 'sub ABS_MAX_VG () {99;}' unless defined(&ABS_MAX_VG);
    eval 'sub ABS_MAX_PV () {256;}' unless defined(&ABS_MAX_PV);
    eval 'sub ABS_MAX_LV () {256;}' unless defined(&ABS_MAX_LV);
    eval 'sub MAX_VG () { &ABS_MAX_VG;}' unless defined(&MAX_VG);
    eval 'sub MAX_LV () { &ABS_MAX_LV;}' unless defined(&MAX_LV);
    eval 'sub MAX_PV () { &ABS_MAX_PV;}' unless defined(&MAX_PV);
    if(( (defined(&MAX_VG) ? &MAX_VG : 0) > (defined(&ABS_MAX_VG) ? &ABS_MAX_VG : 0))) {
	undef(&MAX_VG) if defined(&MAX_VG);
	eval 'sub MAX_VG () { &ABS_MAX_VG;}' unless defined(&MAX_VG);
    }
    if(( (defined(&MAX_LV) ? &MAX_LV : 0) > (defined(&ABS_MAX_LV) ? &ABS_MAX_LV : 0))) {
	undef(&MAX_LV) if defined(&MAX_LV);
	eval 'sub MAX_LV () { &ABS_MAX_LV;}' unless defined(&MAX_LV);
    }
    eval 'sub LVM_PV_DISK_BASE () {0;}' unless defined(&LVM_PV_DISK_BASE);
    eval 'sub LVM_PV_DISK_SIZE () {1024;}' unless defined(&LVM_PV_DISK_SIZE);
    eval 'sub LVM_VG_DISK_BASE () { &LVM_PV_DISK_SIZE;}' unless defined(&LVM_VG_DISK_BASE);
    eval 'sub LVM_VG_DISK_SIZE () {( 9* 512);}' unless defined(&LVM_VG_DISK_SIZE);
    eval 'sub LVM_TIMESTAMP_DISK_BASE () {(  &LVM_VG_DISK_BASE +  &LVM_VG_DISK_SIZE);}' unless defined(&LVM_TIMESTAMP_DISK_BASE);
    eval 'sub LVM_TIMESTAMP_DISK_SIZE () {512;}' unless defined(&LVM_TIMESTAMP_DISK_SIZE);
    eval 'sub LVM_PV_UUIDLIST_DISK_BASE () {(  &LVM_TIMESTAMP_DISK_BASE +  &LVM_TIMESTAMP_DISK_SIZE);}' unless defined(&LVM_PV_UUIDLIST_DISK_BASE);
    eval 'sub LVM_LV_DISK_OFFSET {
        my($a, $b) = @_;
	    eval q(( ($a)-> ($lv_on_disk->{b$ase}) + $sizeof{  &lv_disk_t} * $b));
    }' unless defined(&LVM_LV_DISK_OFFSET);
    eval 'sub LVM_DISK_SIZE {
        my($pv) = @_;
	    eval q(( ($pv)-> ($pe_on_disk->{base}) + ($pv)-> ($pe_on_disk->{size})));
    }' unless defined(&LVM_DISK_SIZE);
    eval 'sub LVM_PE_DISK_OFFSET {
        my($pe, $pv) = @_;
	    eval q(( $pe *  ($pv->{pe_size}) + (  &LVM_DISK_SIZE ( $pv) /  &SECTOR_SIZE)));
    }' unless defined(&LVM_PE_DISK_OFFSET);
    eval 'sub LVM_PE_ON_DISK_BASE {
        my($pv) = @_;
	    eval q({ \'int\'  &rest;  ($pv->{pe_on_disk}->{base}) =  ($pv->{lv_on_disk}->{base}) +  ($pv->{lv_on_disk}->{size});  &if ( (  &rest =  ($pv->{pe_on_disk}->{base}) %  &SECTOR_SIZE) != 0)  ($pv->{pe_on_disk}->{base}) += (  &SECTOR_SIZE -  &rest); });
    }' unless defined(&LVM_PE_ON_DISK_BASE);
    eval 'sub LVM_PE_T_MAX () {( ( 1<< ( $sizeof{  &uint16_t} * 8)) - 2);}' unless defined(&LVM_PE_T_MAX);
    eval 'sub LVM_LV_SIZE_MAX {
        my($a) = @_;
	    eval q((   &LVM_PE_T_MAX * ($a)-> &pe_size >  1024*1024/ &SECTOR_SIZE*1024*1024?  1024*1024/ &SECTOR_SIZE*1024*1024:   &LVM_PE_T_MAX * ($a)-> &pe_size));
    }' unless defined(&LVM_LV_SIZE_MAX);
    eval 'sub LVM_MIN_PE_SIZE () {( 8192 /  &SECTOR_SIZE);}' unless defined(&LVM_MIN_PE_SIZE);
    eval 'sub LVM_MAX_PE_SIZE () {( 16 * 1024 * 1024 /  &SECTOR_SIZE * 1024);}' unless defined(&LVM_MAX_PE_SIZE);
    eval 'sub LVM_DEFAULT_PE_SIZE () {( 4096 * 1024/  &SECTOR_SIZE);}' unless defined(&LVM_DEFAULT_PE_SIZE);
    eval 'sub LVM_DEFAULT_STRIPE_SIZE () {16;}' unless defined(&LVM_DEFAULT_STRIPE_SIZE);
    eval 'sub LVM_MIN_STRIPE_SIZE () {(  &PAGE_SIZE/ &SECTOR_SIZE);}' unless defined(&LVM_MIN_STRIPE_SIZE);
    eval 'sub LVM_MAX_STRIPE_SIZE () {( 512 * 1024/  &SECTOR_SIZE);}' unless defined(&LVM_MAX_STRIPE_SIZE);
    eval 'sub LVM_MAX_STRIPES () {128;}' unless defined(&LVM_MAX_STRIPES);
    eval 'sub LVM_MAX_SIZE () {( 1024 * 1024/  &SECTOR_SIZE * 1024* 1024);}' unless defined(&LVM_MAX_SIZE);
    eval 'sub LVM_MAX_MIRRORS () {2;}' unless defined(&LVM_MAX_MIRRORS);
    eval 'sub LVM_MIN_READ_AHEAD () {2;}' unless defined(&LVM_MIN_READ_AHEAD);
    eval 'sub LVM_MAX_READ_AHEAD () {120;}' unless defined(&LVM_MAX_READ_AHEAD);
    eval 'sub LVM_MAX_LV_IO_TIMEOUT () {60;}' unless defined(&LVM_MAX_LV_IO_TIMEOUT);
    eval 'sub LVM_PARTITION () {0xfe;}' unless defined(&LVM_PARTITION);
    eval 'sub LVM_NEW_PARTITION () {0x8e;}' unless defined(&LVM_NEW_PARTITION);
    eval 'sub LVM_PE_SIZE_PV_SIZE_REL () {5;}' unless defined(&LVM_PE_SIZE_PV_SIZE_REL);
    eval 'sub LVM_SNAPSHOT_MAX_CHUNK () {1024;}' unless defined(&LVM_SNAPSHOT_MAX_CHUNK);
    eval 'sub LVM_SNAPSHOT_DEF_CHUNK () {64;}' unless defined(&LVM_SNAPSHOT_DEF_CHUNK);
    eval 'sub LVM_SNAPSHOT_MIN_CHUNK () {( &PAGE_SIZE/1024);}' unless defined(&LVM_SNAPSHOT_MIN_CHUNK);
    eval 'sub UNDEF () {-1;}' unless defined(&UNDEF);
    eval 'sub FALSE () {0;}' unless defined(&FALSE);
    eval 'sub TRUE () {1;}' unless defined(&TRUE);
    eval 'sub LVM_GET_COW_TABLE_CHUNKS_PER_PE {
        my($vg, $lv) = @_;
	    eval q((  ($vg->{pe_size}) /  ($lv->{lv_chunk_size})));
    }' unless defined(&LVM_GET_COW_TABLE_CHUNKS_PER_PE);
    eval 'sub LVM_GET_COW_TABLE_ENTRIES_PER_PE {
        my($vg, $lv) = @_;
	    eval q(( { \'int\'  &COW_table_entries_per_PE; \'int\'  &COW_table_chunks_per_PE;  &COW_table_entries_per_PE =  &LVM_GET_COW_TABLE_CHUNKS_PER_PE($vg, $lv);  &COW_table_chunks_per_PE = (  &COW_table_entries_per_PE * $sizeof{ &lv_COW_table_disk_t} /  &SECTOR_SIZE +  ($lv->{lv_chunk_size}) - 1) /  ($lv->{lv_chunk_size});  &COW_table_entries_per_PE -  &COW_table_chunks_per_PE;}));
    }' unless defined(&LVM_GET_COW_TABLE_ENTRIES_PER_PE);
    eval 'sub VG_CREATE_OLD () { &_IOW ( 0xfe, 0x, 1);}' unless defined(&VG_CREATE_OLD);
    eval 'sub VG_REMOVE () { &_IOW ( 0xfe, 0x1, 1);}' unless defined(&VG_REMOVE);
    eval 'sub VG_EXTEND () { &_IOW ( 0xfe, 0x3, 1);}' unless defined(&VG_EXTEND);
    eval 'sub VG_REDUCE () { &_IOW ( 0xfe, 0x4, 1);}' unless defined(&VG_REDUCE);
    eval 'sub VG_STATUS () { &_IOWR ( 0xfe, 0x5, 1);}' unless defined(&VG_STATUS);
    eval 'sub VG_STATUS_GET_COUNT () { &_IOWR ( 0xfe, 0x6, 1);}' unless defined(&VG_STATUS_GET_COUNT);
    eval 'sub VG_STATUS_GET_NAMELIST () { &_IOWR ( 0xfe, 0x7, 1);}' unless defined(&VG_STATUS_GET_NAMELIST);
    eval 'sub VG_SET_EXTENDABLE () { &_IOW ( 0xfe, 0x8, 1);}' unless defined(&VG_SET_EXTENDABLE);
    eval 'sub VG_RENAME () { &_IOW ( 0xfe, 0x9, 1);}' unless defined(&VG_RENAME);
    eval 'sub VG_CREATE () { &_IOW ( 0xfe, 0xa, 1);}' unless defined(&VG_CREATE);
    eval 'sub LV_CREATE () { &_IOW ( 0xfe, 0x20, 1);}' unless defined(&LV_CREATE);
    eval 'sub LV_REMOVE () { &_IOW ( 0xfe, 0x21, 1);}' unless defined(&LV_REMOVE);
    eval 'sub LV_ACTIVATE () { &_IO ( 0xfe, 0x22);}' unless defined(&LV_ACTIVATE);
    eval 'sub LV_DEACTIVATE () { &_IO ( 0xfe, 0x23);}' unless defined(&LV_DEACTIVATE);
    eval 'sub LV_EXTEND () { &_IOW ( 0xfe, 0x24, 1);}' unless defined(&LV_EXTEND);
    eval 'sub LV_REDUCE () { &_IOW ( 0xfe, 0x25, 1);}' unless defined(&LV_REDUCE);
    eval 'sub LV_STATUS_BYNAME () { &_IOWR ( 0xfe, 0x26, 1);}' unless defined(&LV_STATUS_BYNAME);
    eval 'sub LV_STATUS_BYINDEX () { &_IOWR ( 0xfe, 0x27, 1);}' unless defined(&LV_STATUS_BYINDEX);
    eval 'sub LV_SET_ACCESS () { &_IOW ( 0xfe, 0x28, 1);}' unless defined(&LV_SET_ACCESS);
    eval 'sub LV_SET_ALLOCATION () { &_IOW ( 0xfe, 0x29, 1);}' unless defined(&LV_SET_ALLOCATION);
    eval 'sub LV_SET_STATUS () { &_IOW ( 0xfe, 0x2a, 1);}' unless defined(&LV_SET_STATUS);
    eval 'sub LE_REMAP () { &_IOW ( 0xfe, 0x2b, 1);}' unless defined(&LE_REMAP);
    eval 'sub LV_SNAPSHOT_USE_RATE () { &_IOWR ( 0xfe, 0x2c, 1);}' unless defined(&LV_SNAPSHOT_USE_RATE);
    eval 'sub LV_STATUS_BYDEV () { &_IOWR ( 0xfe, 0x2e, 1);}' unless defined(&LV_STATUS_BYDEV);
    eval 'sub LV_RENAME () { &_IOW ( 0xfe, 0x2f, 1);}' unless defined(&LV_RENAME);
    eval 'sub LV_BMAP () { &_IOWR ( 0xfe, 0x30, 1);}' unless defined(&LV_BMAP);
    eval 'sub PV_STATUS () { &_IOWR ( 0xfe, 0x40, 1);}' unless defined(&PV_STATUS);
    eval 'sub PV_CHANGE () { &_IOWR ( 0xfe, 0x41, 1);}' unless defined(&PV_CHANGE);
    eval 'sub PV_FLUSH () { &_IOW ( 0xfe, 0x42, 1);}' unless defined(&PV_FLUSH);
    eval 'sub PE_LOCK_UNLOCK () { &_IOW ( 0xfe, 0x50, 1);}' unless defined(&PE_LOCK_UNLOCK);
    eval 'sub LVM_GET_IOP_VERSION () { &_IOR ( 0xfe, 0x98, 1);}' unless defined(&LVM_GET_IOP_VERSION);
    if(defined(&LVM_TOTAL_RESET)) {
	eval 'sub LVM_RESET () { &_IO ( 0xfe, 0x99);}' unless defined(&LVM_RESET);
    }
    eval 'sub LVM_LOCK_LVM () { &_IO ( 0xfe, 0x100);}' unless defined(&LVM_LOCK_LVM);
    eval 'sub VG_ACTIVE () {0x1;}' unless defined(&VG_ACTIVE);
    eval 'sub VG_EXPORTED () {0x2;}' unless defined(&VG_EXPORTED);
    eval 'sub VG_EXTENDABLE () {0x4;}' unless defined(&VG_EXTENDABLE);
    eval 'sub VG_READ () {0x1;}' unless defined(&VG_READ);
    eval 'sub VG_WRITE () {0x2;}' unless defined(&VG_WRITE);
    eval 'sub VG_CLUSTERED () {0x4;}' unless defined(&VG_CLUSTERED);
    eval 'sub VG_SHARED () {0x8;}' unless defined(&VG_SHARED);
    eval 'sub LV_ACTIVE () {0x1;}' unless defined(&LV_ACTIVE);
    eval 'sub LV_SPINDOWN () {0x2;}' unless defined(&LV_SPINDOWN);
    eval 'sub LV_READ () {0x1;}' unless defined(&LV_READ);
    eval 'sub LV_WRITE () {0x2;}' unless defined(&LV_WRITE);
    eval 'sub LV_SNAPSHOT () {0x4;}' unless defined(&LV_SNAPSHOT);
    eval 'sub LV_SNAPSHOT_ORG () {0x8;}' unless defined(&LV_SNAPSHOT_ORG);
    eval 'sub LV_BADBLOCK_ON () {0x1;}' unless defined(&LV_BADBLOCK_ON);
    eval 'sub LV_STRICT () {0x1;}' unless defined(&LV_STRICT);
    eval 'sub LV_CONTIGUOUS () {0x2;}' unless defined(&LV_CONTIGUOUS);
    eval 'sub PV_ACTIVE () {0x1;}' unless defined(&PV_ACTIVE);
    eval 'sub PV_ALLOCATABLE () {0x2;}' unless defined(&PV_ALLOCATABLE);
    eval 'sub LVM_SNAPSHOT_DROPPED_SECTOR () {1;}' unless defined(&LVM_SNAPSHOT_DROPPED_SECTOR);
    eval 'sub NAME_LEN () {128;}' unless defined(&NAME_LEN);
    eval 'sub UUID_LEN () {32;}' unless defined(&UUID_LEN);
    eval("sub LOCK_PE () { 0; }") unless defined(&LOCK_PE);
    eval("sub UNLOCK_PE () { 1; }") unless defined(&UNLOCK_PE);
}
1;
