require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_MTD_COMPATMAC_H__)) {
    eval 'sub __LINUX_MTD_COMPATMAC_H__ () {1;}' unless defined(&__LINUX_MTD_COMPATMAC_H__);
    require 'linux/compatmac.ph';
    require 'linux/types.ph';
    require 'linux/module.ph';
    unless(defined(&LINUX_VERSION_CODE)) {
	require 'linux/version.ph';
    }
    if((defined(&LINUX_VERSION_CODE) ? &LINUX_VERSION_CODE : 0) >=  &KERNEL_VERSION(2,1,0)) {
	require 'linux/vmalloc.ph';
    }
    if((defined(&LINUX_VERSION_CODE) ? &LINUX_VERSION_CODE : 0) <  &KERNEL_VERSION(2,0,0)) {
	die("This kernel is too old: not supported by this file");
    }
    if((defined(&LINUX_VERSION_CODE) ? &LINUX_VERSION_CODE : 0) <  &KERNEL_VERSION(2,1,18)) {
	eval 'sub __USE_OLD_SYMTAB__ () {1;}' unless defined(&__USE_OLD_SYMTAB__);
	eval 'sub EXPORT_NO_SYMBOLS () { &register_symtab( &NULL);;}' unless defined(&EXPORT_NO_SYMBOLS);
	eval 'sub REGISTER_SYMTAB {
	    my($tab) = @_;
    	    eval q( &register_symtab($tab));
	}' unless defined(&REGISTER_SYMTAB);
    } else {
	eval 'sub REGISTER_SYMTAB {
	    my($tab) = @_;
    	    eval q();
	}' unless defined(&REGISTER_SYMTAB);
    }
    if(defined(&__USE_OLD_SYMTAB__)) {
	eval 'sub __MODULE_STRING {
	    my($s) = @_;
    	    eval q();
	}' unless defined(&__MODULE_STRING);
	eval 'sub MODULE_PARM {
	    my($v,$t) = @_;
    	    eval q();
	}' unless defined(&MODULE_PARM);
	eval 'sub MODULE_PARM_DESC {
	    my($v,$t) = @_;
    	    eval q();
	}' unless defined(&MODULE_PARM_DESC);
	eval 'sub MODULE_AUTHOR {
	    my($n) = @_;
    	    eval q();
	}' unless defined(&MODULE_AUTHOR);
	eval 'sub MODULE_DESCRIPTION {
	    my($d) = @_;
    	    eval q();
	}' unless defined(&MODULE_DESCRIPTION);
	eval 'sub MODULE_SUPPORTED_DEVICE {
	    my($n) = @_;
    	    eval q();
	}' unless defined(&MODULE_SUPPORTED_DEVICE);
    }
    if((defined(&LINUX_VERSION_CODE) ? &LINUX_VERSION_CODE : 0) >  &KERNEL_VERSION(2,1,22)) {
	require 'linux/poll.ph';
    } else {
	eval 'sub __USE_OLD_SELECT__ () {1;}' unless defined(&__USE_OLD_SELECT__);
    }
    if((defined(&LINUX_VERSION_CODE) ? &LINUX_VERSION_CODE : 0) >=  &KERNEL_VERSION(2,1,0)) {
	eval 'sub lseek_t () {\'long long\';}' unless defined(&lseek_t);
	eval 'sub lseek_off_t () {\'long long\';}' unless defined(&lseek_off_t);
    } else {
	eval 'sub lseek_t () {\'int\';}' unless defined(&lseek_t);
	eval 'sub lseek_off_t () { &off_t;}' unless defined(&lseek_off_t);
    }
    if((defined(&LINUX_VERSION_CODE) ? &LINUX_VERSION_CODE : 0) >=  &KERNEL_VERSION(2,1,0) || defined( &__alpha__)) {
	eval 'sub count_t () {\'unsigned long\';}' unless defined(&count_t);
	eval 'sub read_write_t () {\'long\';}' unless defined(&read_write_t);
    } else {
	eval 'sub count_t () {\'int\';}' unless defined(&count_t);
	eval 'sub read_write_t () {\'int\';}' unless defined(&read_write_t);
    }
    if((defined(&LINUX_VERSION_CODE) ? &LINUX_VERSION_CODE : 0) <  &KERNEL_VERSION(2,1,31)) {
	eval 'sub release_t () { &void;}' unless defined(&release_t);
	eval 'sub release_return {
	    my($x) = @_;
    	    eval q( &return);
	}' unless defined(&release_return);
    } else {
	eval 'sub release_t () {\'int\';}' unless defined(&release_t);
	eval 'sub release_return {
	    my($x) = @_;
    	    eval q( &return ($x));
	}' unless defined(&release_return);
    }
    if((defined(&LINUX_VERSION_CODE) ? &LINUX_VERSION_CODE : 0) < 0x20300) {
	eval 'sub __exit () {1;}' unless defined(&__exit);
    }
    if((defined(&LINUX_VERSION_CODE) ? &LINUX_VERSION_CODE : 0) < 0x20200) {
	eval 'sub __init () {1;}' unless defined(&__init);
    } else {
	require 'linux/init.ph';
    }
    if((defined(&LINUX_VERSION_CODE) ? &LINUX_VERSION_CODE : 0) < 0x20300) {
	eval 'sub init_MUTEX {
	    my($x) = @_;
    	    eval q( &do {*($x) =  &MUTEX;}  &while (0));
	}' unless defined(&init_MUTEX);
	eval 'sub RQFUNC_ARG () { &void;}' unless defined(&RQFUNC_ARG);
	eval 'sub blkdev_dequeue_request {
	    my($req) = @_;
    	    eval q( &do { &CURRENT =  ($req->{next});}  &while (0));
	}' unless defined(&blkdev_dequeue_request);
    } else {
	eval 'sub RQFUNC_ARG () { &request_queue_t * &q;}' unless defined(&RQFUNC_ARG);
    }
    if((defined(&LINUX_VERSION_CODE) ? &LINUX_VERSION_CODE : 0) <  &KERNEL_VERSION(2,2,0)) {
	eval 'sub __MOD_INC_USE_COUNT {
	    my($mod) = @_;
    	    eval q(( &atomic_inc(($mod)-> ($uc->{usecount})), ($mod)-> &flags |=  &MOD_VISITED| &MOD_USED_ONCE));
	}' unless defined(&__MOD_INC_USE_COUNT);
	eval 'sub __MOD_DEC_USE_COUNT {
	    my($mod) = @_;
    	    eval q(( &atomic_dec(($mod)-> ($uc->{usecount})), ($mod)-> &flags |=  &MOD_VISITED));
	}' unless defined(&__MOD_DEC_USE_COUNT);
    }
    if((defined(&LINUX_VERSION_CODE) ? &LINUX_VERSION_CODE : 0) <  &KERNEL_VERSION(2,3,0)) {
	eval 'sub DECLARE_WAIT_QUEUE_HEAD {
	    my($x) = @_;
    	    eval q(\'struct wait_queue\' *$x =  &NULL);
	}' unless defined(&DECLARE_WAIT_QUEUE_HEAD);
	eval 'sub init_waitqueue_head () { &init_waitqueue;}' unless defined(&init_waitqueue_head);
	eval 'sub try_inc_mod_count {
	    my($mod) = @_;
    	    eval q({  &if ($mod)  &__MOD_INC_USE_COUNT($mod); 1; });
	}' unless defined(&try_inc_mod_count);
    }
    require 'asm/byteorder.ph';
    unless(defined(&__constant_cpu_to_le16)) {
	if(defined(&__BIG_ENDIAN)) {
	    eval 'sub __constant_cpu_to_le64 {
	        my($x) = @_;
    		eval q( &___swab64(($x)));
	    }' unless defined(&__constant_cpu_to_le64);
	    eval 'sub __constant_le64_to_cpu {
	        my($x) = @_;
    		eval q( &___swab64(($x)));
	    }' unless defined(&__constant_le64_to_cpu);
	    eval 'sub __constant_cpu_to_le32 {
	        my($x) = @_;
    		eval q( &___swab32(($x)));
	    }' unless defined(&__constant_cpu_to_le32);
	    eval 'sub __constant_le32_to_cpu {
	        my($x) = @_;
    		eval q( &___swab32(($x)));
	    }' unless defined(&__constant_le32_to_cpu);
	    eval 'sub __constant_cpu_to_le16 {
	        my($x) = @_;
    		eval q( &___swab16(($x)));
	    }' unless defined(&__constant_cpu_to_le16);
	    eval 'sub __constant_le16_to_cpu {
	        my($x) = @_;
    		eval q( &___swab16(($x)));
	    }' unless defined(&__constant_le16_to_cpu);
	    eval 'sub __constant_cpu_to_be64 {
	        my($x) = @_;
    		eval q((( &__u64)($x)));
	    }' unless defined(&__constant_cpu_to_be64);
	    eval 'sub __constant_be64_to_cpu {
	        my($x) = @_;
    		eval q((( &__u64)($x)));
	    }' unless defined(&__constant_be64_to_cpu);
	    eval 'sub __constant_cpu_to_be32 {
	        my($x) = @_;
    		eval q((( &__u32)($x)));
	    }' unless defined(&__constant_cpu_to_be32);
	    eval 'sub __constant_be32_to_cpu {
	        my($x) = @_;
    		eval q((( &__u32)($x)));
	    }' unless defined(&__constant_be32_to_cpu);
	    eval 'sub __constant_cpu_to_be16 {
	        my($x) = @_;
    		eval q((( &__u16)($x)));
	    }' unless defined(&__constant_cpu_to_be16);
	    eval 'sub __constant_be16_to_cpu {
	        my($x) = @_;
    		eval q((( &__u16)($x)));
	    }' unless defined(&__constant_be16_to_cpu);
	} else {
	    if(defined(&__LITTLE_ENDIAN)) {
		eval 'sub __constant_cpu_to_le64 {
		    my($x) = @_;
    		    eval q((( &__u64)($x)));
		}' unless defined(&__constant_cpu_to_le64);
		eval 'sub __constant_le64_to_cpu {
		    my($x) = @_;
    		    eval q((( &__u64)($x)));
		}' unless defined(&__constant_le64_to_cpu);
		eval 'sub __constant_cpu_to_le32 {
		    my($x) = @_;
    		    eval q((( &__u32)($x)));
		}' unless defined(&__constant_cpu_to_le32);
		eval 'sub __constant_le32_to_cpu {
		    my($x) = @_;
    		    eval q((( &__u32)($x)));
		}' unless defined(&__constant_le32_to_cpu);
		eval 'sub __constant_cpu_to_le16 {
		    my($x) = @_;
    		    eval q((( &__u16)($x)));
		}' unless defined(&__constant_cpu_to_le16);
		eval 'sub __constant_le16_to_cpu {
		    my($x) = @_;
    		    eval q((( &__u16)($x)));
		}' unless defined(&__constant_le16_to_cpu);
		eval 'sub __constant_cpu_to_be64 {
		    my($x) = @_;
    		    eval q( &___swab64(($x)));
		}' unless defined(&__constant_cpu_to_be64);
		eval 'sub __constant_be64_to_cpu {
		    my($x) = @_;
    		    eval q( &___swab64(($x)));
		}' unless defined(&__constant_be64_to_cpu);
		eval 'sub __constant_cpu_to_be32 {
		    my($x) = @_;
    		    eval q( &___swab32(($x)));
		}' unless defined(&__constant_cpu_to_be32);
		eval 'sub __constant_be32_to_cpu {
		    my($x) = @_;
    		    eval q( &___swab32(($x)));
		}' unless defined(&__constant_be32_to_cpu);
		eval 'sub __constant_cpu_to_be16 {
		    my($x) = @_;
    		    eval q( &___swab16(($x)));
		}' unless defined(&__constant_cpu_to_be16);
		eval 'sub __constant_be16_to_cpu {
		    my($x) = @_;
    		    eval q( &___swab16(($x)));
		}' unless defined(&__constant_be16_to_cpu);
	    } else {
		die("No\ \(recognised\)\ endianness\ defined\ \(unless\ it\,s\ PDP\)");
	    }
	}
    }
    if((defined(&LINUX_VERSION_CODE) ? &LINUX_VERSION_CODE : 0) <  &KERNEL_VERSION(2,3,0)) {
	eval 'sub mod_init_t () {\'int\'  &__init;}' unless defined(&mod_init_t);
	eval 'sub mod_exit_t () { &void;}' unless defined(&mod_exit_t);
    } else {
	eval 'sub mod_init_t () { &static \'int\'  &__init;}' unless defined(&mod_init_t);
	eval 'sub mod_exit_t () { &static  &void  &__exit;}' unless defined(&mod_exit_t);
    }
    unless(defined(&THIS_MODULE)) {
	if(defined(&MODULE)) {
	    eval 'sub THIS_MODULE () {(& &__this_module);}' unless defined(&THIS_MODULE);
	} else {
	    eval 'sub THIS_MODULE () {( &NULL);}' unless defined(&THIS_MODULE);
	}
    }
    if((defined(&LINUX_VERSION_CODE) ? &LINUX_VERSION_CODE : 0) < 0x20300) {
	require 'linux/interrupt.ph';
	eval 'sub spin_lock_bh {
	    my($lock) = @_;
    	    eval q( &do { &start_bh_atomic(); &spin_lock($lock);} &while(0););
	}' unless defined(&spin_lock_bh);
	eval 'sub spin_unlock_bh {
	    my($lock) = @_;
    	    eval q( &do { &spin_unlock($lock); &end_bh_atomic();} &while(0););
	}' unless defined(&spin_unlock_bh);
    } else {
	require 'asm/softirq.ph';
	require 'linux/spinlock.ph';
    }
}
1;
