require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_QUOTAOPS_)) {
    eval 'sub _LINUX_QUOTAOPS_ () {1;}' unless defined(&_LINUX_QUOTAOPS_);
    require 'linux/config.ph';
    require 'linux/smp_lock.ph';
    if(defined( &CONFIG_QUOTA)) {
	require 'linux/fs.ph';
	eval 'sub sb_any_quota_enabled {
	    my($sb) = @_;
    	    eval q((($sb)-> ($s_dquot->{flags}) & ( &DQUOT_USR_ENABLED |  &DQUOT_GRP_ENABLED)));
	}' unless defined(&sb_any_quota_enabled);
	eval 'sub DQUOT_INIT {
	    my($inode) = @_;
    	    eval q({  &if (! ($inode->{i_sb}))  &BUG();  &lock_kernel();  &if ( &sb_any_quota_enabled( ($inode->{i_sb}))  && ! &IS_NOQUOTA($inode))  ($inode->{i_sb}->{dq_op}->{initialize})($inode, -1);  &unlock_kernel(); });
	}' unless defined(&DQUOT_INIT);
	eval 'sub DQUOT_DROP {
	    my($inode) = @_;
    	    eval q({  &if (! ($inode->{i_sb}))  &BUG();  &lock_kernel();  &if ( &IS_QUOTAINIT($inode))  ($inode->{i_sb}->{dq_op}->{drop})($inode);  &unlock_kernel(); });
	}' unless defined(&DQUOT_DROP);
	eval 'sub DQUOT_PREALLOC_SPACE_NODIRTY {
	    my($inode,$nr) = @_;
    	    eval q({  &lock_kernel();  &if ( &sb_any_quota_enabled( ($inode->{i_sb}))) {  &if ( ($inode->{i_sb}->{dq_op}->{alloc_space})($inode, $nr, 1) ==  &NO_QUOTA) {  &unlock_kernel(); 1; } }  &else  &inode_add_bytes($inode, $nr);  &unlock_kernel(); 0; });
	}' unless defined(&DQUOT_PREALLOC_SPACE_NODIRTY);
	eval 'sub DQUOT_PREALLOC_SPACE {
	    my($inode,$nr) = @_;
    	    eval q({ \'int\'  &ret;  &if (!( &ret =  &DQUOT_PREALLOC_SPACE_NODIRTY($inode, $nr)))  &mark_inode_dirty($inode);  &ret; });
	}' unless defined(&DQUOT_PREALLOC_SPACE);
	eval 'sub DQUOT_ALLOC_SPACE_NODIRTY {
	    my($inode,$nr) = @_;
    	    eval q({  &lock_kernel();  &if ( &sb_any_quota_enabled( ($inode->{i_sb}))) {  &if ( ($inode->{i_sb}->{dq_op}->{alloc_space})($inode, $nr, 0) ==  &NO_QUOTA) {  &unlock_kernel(); 1; } }  &else  &inode_add_bytes($inode, $nr);  &unlock_kernel(); 0; });
	}' unless defined(&DQUOT_ALLOC_SPACE_NODIRTY);
	eval 'sub DQUOT_ALLOC_SPACE {
	    my($inode,$nr) = @_;
    	    eval q({ \'int\'  &ret;  &if (!( &ret =  &DQUOT_ALLOC_SPACE_NODIRTY($inode, $nr)))  &mark_inode_dirty($inode);  &ret; });
	}' unless defined(&DQUOT_ALLOC_SPACE);
	eval 'sub DQUOT_ALLOC_INODE {
	    my($inode) = @_;
    	    eval q({  &lock_kernel();  &if ( &sb_any_quota_enabled( ($inode->{i_sb}))) {  ($inode->{i_sb}->{dq_op}->{initialize})($inode, -1);  &if ( ($inode->{i_sb}->{dq_op}->{alloc_inode})($inode, 1) ==  &NO_QUOTA) {  &unlock_kernel(); 1; } }  &unlock_kernel(); 0; });
	}' unless defined(&DQUOT_ALLOC_INODE);
	eval 'sub DQUOT_FREE_SPACE_NODIRTY {
	    my($inode,$nr) = @_;
    	    eval q({  &lock_kernel();  &if ( &sb_any_quota_enabled( ($inode->{i_sb})))  ($inode->{i_sb}->{dq_op}->{free_space})($inode, $nr);  &else  &inode_sub_bytes($inode, $nr);  &unlock_kernel(); });
	}' unless defined(&DQUOT_FREE_SPACE_NODIRTY);
	eval 'sub DQUOT_FREE_SPACE {
	    my($inode,$nr) = @_;
    	    eval q({  &DQUOT_FREE_SPACE_NODIRTY($inode, $nr);  &mark_inode_dirty($inode); });
	}' unless defined(&DQUOT_FREE_SPACE);
	eval 'sub DQUOT_TRANSFER {
	    my($inode,$iattr) = @_;
    	    eval q({  &lock_kernel();  &if ( &sb_any_quota_enabled( ($inode->{i_sb}))  && ! &IS_NOQUOTA($inode)) {  ($inode->{i_sb}->{dq_op}->{initialize})($inode, -1);  &if ( ($inode->{i_sb}->{dq_op}->{transfer})($inode, $iattr) ==  &NO_QUOTA) {  &unlock_kernel(); 1; } }  &unlock_kernel(); 0; });
	}' unless defined(&DQUOT_TRANSFER);
	eval 'sub DQUOT_SYNC {
	    my($dev) = @_;
    	    eval q( &sync_dquots($dev, -1));
	}' unless defined(&DQUOT_SYNC);
	eval 'sub DQUOT_OFF {
	    my($sb) = @_;
    	    eval q( &quota_off($sb, -1));
	}' unless defined(&DQUOT_OFF);
    } else {
	eval 'sub DQUOT_INIT {
	    my($inode) = @_;
    	    eval q( &do { }  &while(0));
	}' unless defined(&DQUOT_INIT);
	eval 'sub DQUOT_DROP {
	    my($inode) = @_;
    	    eval q( &do { }  &while(0));
	}' unless defined(&DQUOT_DROP);
	eval 'sub DQUOT_ALLOC_INODE {
	    my($inode) = @_;
    	    eval q((0));
	}' unless defined(&DQUOT_ALLOC_INODE);
	eval 'sub DQUOT_FREE_INODE {
	    my($inode) = @_;
    	    eval q( &do { }  &while(0));
	}' unless defined(&DQUOT_FREE_INODE);
	eval 'sub DQUOT_SYNC {
	    my($dev) = @_;
    	    eval q( &do { }  &while(0));
	}' unless defined(&DQUOT_SYNC);
	eval 'sub DQUOT_OFF {
	    my($sb) = @_;
    	    eval q( &do { }  &while(0));
	}' unless defined(&DQUOT_OFF);
	eval 'sub DQUOT_TRANSFER {
	    my($inode, $iattr) = @_;
    	    eval q((0));
	}' unless defined(&DQUOT_TRANSFER);
	eval 'sub DQUOT_PREALLOC_SPACE_NODIRTY {
	    my($inode,$nr) = @_;
    	    eval q({  &lock_kernel();  &inode_add_bytes($inode, $nr);  &unlock_kernel(); 0; });
	}' unless defined(&DQUOT_PREALLOC_SPACE_NODIRTY);
	eval 'sub DQUOT_PREALLOC_SPACE {
	    my($inode,$nr) = @_;
    	    eval q({  &DQUOT_PREALLOC_SPACE_NODIRTY($inode, $nr);  &mark_inode_dirty($inode); 0; });
	}' unless defined(&DQUOT_PREALLOC_SPACE);
	eval 'sub DQUOT_ALLOC_SPACE_NODIRTY {
	    my($inode,$nr) = @_;
    	    eval q({  &lock_kernel();  &inode_add_bytes($inode, $nr);  &unlock_kernel(); 0; });
	}' unless defined(&DQUOT_ALLOC_SPACE_NODIRTY);
	eval 'sub DQUOT_ALLOC_SPACE {
	    my($inode,$nr) = @_;
    	    eval q({  &DQUOT_ALLOC_SPACE_NODIRTY($inode, $nr);  &mark_inode_dirty($inode); 0; });
	}' unless defined(&DQUOT_ALLOC_SPACE);
	eval 'sub DQUOT_FREE_SPACE_NODIRTY {
	    my($inode,$nr) = @_;
    	    eval q({  &lock_kernel();  &inode_sub_bytes($inode, $nr);  &unlock_kernel(); });
	}' unless defined(&DQUOT_FREE_SPACE_NODIRTY);
	eval 'sub DQUOT_FREE_SPACE {
	    my($inode,$nr) = @_;
    	    eval q({  &DQUOT_FREE_SPACE_NODIRTY($inode, $nr);  &mark_inode_dirty($inode); });
	}' unless defined(&DQUOT_FREE_SPACE);
    }
    eval 'sub DQUOT_ALLOC_BLOCK_NODIRTY {
        my($inode, $nr) = @_;
	    eval q( &DQUOT_ALLOC_SPACE_NODIRTY(($inode), (( &qsize_t)($nr)) << ($inode)-> ($i_sb->{s_blocksize_bits})));
    }' unless defined(&DQUOT_ALLOC_BLOCK_NODIRTY);
    eval 'sub DQUOT_ALLOC_BLOCK {
        my($inode, $nr) = @_;
	    eval q( &DQUOT_ALLOC_SPACE(($inode), (( &qsize_t)($nr)) << ($inode)-> ($i_sb->{s_blocksize_bits})));
    }' unless defined(&DQUOT_ALLOC_BLOCK);
    eval 'sub DQUOT_PREALLOC_BLOCK_NODIRTY {
        my($inode, $nr) = @_;
	    eval q( &DQUOT_PREALLOC_SPACE_NODIRTY(($inode), (( &qsize_t)($nr)) << ($inode)-> ($i_sb->{s_blocksize_bits})));
    }' unless defined(&DQUOT_PREALLOC_BLOCK_NODIRTY);
    eval 'sub DQUOT_PREALLOC_BLOCK {
        my($inode, $nr) = @_;
	    eval q( &DQUOT_PREALLOC_SPACE(($inode), (( &qsize_t)($nr)) << ($inode)-> ($i_sb->{s_blocksize_bits})));
    }' unless defined(&DQUOT_PREALLOC_BLOCK);
    eval 'sub DQUOT_FREE_BLOCK_NODIRTY {
        my($inode, $nr) = @_;
	    eval q( &DQUOT_FREE_SPACE_NODIRTY(($inode), (( &qsize_t)($nr)) << ($inode)-> ($i_sb->{s_blocksize_bits})));
    }' unless defined(&DQUOT_FREE_BLOCK_NODIRTY);
    eval 'sub DQUOT_FREE_BLOCK {
        my($inode, $nr) = @_;
	    eval q( &DQUOT_FREE_SPACE(($inode), (( &qsize_t)($nr)) << ($inode)-> ($i_sb->{s_blocksize_bits})));
    }' unless defined(&DQUOT_FREE_BLOCK);
}
1;
