require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_TIMER_H)) {
    eval 'sub _LINUX_TIMER_H () {1;}' unless defined(&_LINUX_TIMER_H);
    require 'linux/config.ph';
    require 'linux/smp.ph';
    require 'linux/threads.ph';
    require 'linux/list.ph';
    require 'linux/spinlock.ph';
    eval 'sub TVN_BITS () {6;}' unless defined(&TVN_BITS);
    eval 'sub TVR_BITS () {8;}' unless defined(&TVR_BITS);
    eval 'sub TVN_SIZE () {(1<<  &TVN_BITS);}' unless defined(&TVN_SIZE);
    eval 'sub TVR_SIZE () {(1<<  &TVR_BITS);}' unless defined(&TVR_SIZE);
    eval 'sub TVN_MASK () {( &TVN_SIZE - 1);}' unless defined(&TVN_MASK);
    eval 'sub TVR_MASK () {( &TVR_SIZE - 1);}' unless defined(&TVR_MASK);
    eval 'sub NOOF_TVECS () {5;}' unless defined(&NOOF_TVECS);
    if(defined(&CONFIG_SMP)) {
	eval 'sub timer_enter {
	    my($base, $t) = @_;
    	    eval q( &do {  ($base->{running_timer}) = $t;  &mb(); }  &while (0));
	}' unless defined(&timer_enter);
	eval 'sub timer_exit {
	    my($base) = @_;
    	    eval q( &do {  ($base->{running_timer}) =  &NULL; }  &while (0));
	}' unless defined(&timer_exit);
	eval 'sub timer_is_running {
	    my($base,$t) = @_;
    	    eval q(( ($base->{running_timer}) == $t));
	}' unless defined(&timer_is_running);
	eval 'sub timer_synchronize {
	    my($base,$t) = @_;
    	    eval q( &while ( &timer_is_running($base,$t))  &barrier());
	}' unless defined(&timer_synchronize);
    } else {
	eval 'sub del_timer_sync {
	    my($t) = @_;
    	    eval q( &del_timer($t));
	}' unless defined(&del_timer_sync);
	eval 'sub sync_timers () {
	    eval q( &do { }  &while (0));
	}' unless defined(&sync_timers);
	eval 'sub timer_enter {
	    my($base,$t) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&timer_enter);
	eval 'sub timer_exit {
	    my($base) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&timer_exit);
    }
    eval 'sub init_timer {
        my($timer) = @_;
	    eval q({  ($timer->{list}->{next}) =  ($timer->{list}->{prev}) =  &NULL;  ($timer->{base}) =  &tvec_bases + 0; });
    }' unless defined(&init_timer);
    eval 'sub TIMER_DEBUG () {0;}' unless defined(&TIMER_DEBUG);
    if((defined(&TIMER_DEBUG) ? &TIMER_DEBUG : 0)) {
	eval 'sub CHECK_BASE {
	    my($base) = @_;
    	    eval q( &if ($base  && (($base <  &tvec_bases) || ($base >=  &tvec_bases +  &NR_CPUS)))  &BUG());
	}' unless defined(&CHECK_BASE);
    } else {
	eval 'sub CHECK_BASE {
	    my($base) = @_;
    	    eval q();
	}' unless defined(&CHECK_BASE);
    }
    eval 'sub timer_pending {
        my($timer) = @_;
	    eval q({  &CHECK_BASE( ($timer->{base}));  ($timer->{list}->{next}) !=  &NULL; });
    }' unless defined(&timer_pending);
    eval 'sub time_after {
        my($a,$b) = @_;
	    eval q(( - ($a) < 0));
    }' unless defined(&time_after);
    eval 'sub time_before {
        my($a,$b) = @_;
	    eval q( &time_after($b,$a));
    }' unless defined(&time_before);
    eval 'sub time_after_eq {
        my($a,$b) = @_;
	    eval q(( - ($b) >= 0));
    }' unless defined(&time_after_eq);
    eval 'sub time_before_eq {
        my($a,$b) = @_;
	    eval q( &time_after_eq($b,$a));
    }' unless defined(&time_before_eq);
}
1;
