require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_TPQIC02_H)) {
    eval 'sub _LINUX_TPQIC02_H () {1;}' unless defined(&_LINUX_TPQIC02_H);
    require 'linux/config.ph';
    if((defined(&CONFIG_QIC02_TAPE) ? &CONFIG_QIC02_TAPE : 0) || (defined(&CONFIG_QIC02_TAPE_MODULE) ? &CONFIG_QIC02_TAPE_MODULE : 0)) {
	require 'linux/mtio.ph';
	eval 'sub WANGTEK () {1;}' unless defined(&WANGTEK);
	eval 'sub EVEREX () {( &WANGTEK+1);}' unless defined(&EVEREX);
	eval 'sub EVEREX_811V () { &EVEREX;}' unless defined(&EVEREX_811V);
	eval 'sub EVEREX_831V () { &EVEREX;}' unless defined(&EVEREX_831V);
	eval 'sub ARCHIVE () {3;}' unless defined(&ARCHIVE);
	eval 'sub ARCHIVE_SC400 () { &ARCHIVE;}' unless defined(&ARCHIVE_SC400);
	eval 'sub ARCHIVE_SC402 () { &ARCHIVE;}' unless defined(&ARCHIVE_SC402);
	eval 'sub ARCHIVE_SC499 () { &ARCHIVE;}' unless defined(&ARCHIVE_SC499);
	eval 'sub MOUNTAIN () {5;}' unless defined(&MOUNTAIN);
	eval 'sub EMERALD () {6;}' unless defined(&EMERALD);
	eval 'sub QIC02_TAPE_PORT_RANGE () {8;}' unless defined(&QIC02_TAPE_PORT_RANGE);
	unless(defined(&CONFIG_QIC02_DYNCONF)) {
	    eval 'sub QIC02_TAPE_DRIVE () { &MT_ISQIC02_ALL_FEATURES;}' unless defined(&QIC02_TAPE_DRIVE);
	    eval 'sub QIC02_TAPE_IFC () { &WANGTEK;}' unless defined(&QIC02_TAPE_IFC);
	    eval 'sub QIC02_TAPE_PORT () {0x300;}' unless defined(&QIC02_TAPE_PORT);
	    eval 'sub QIC02_TAPE_IRQ () {5;}' unless defined(&QIC02_TAPE_IRQ);
	    eval 'sub QIC02_TAPE_DMA () {1;}' unless defined(&QIC02_TAPE_DMA);
	    undef(&QIC02_TAPE_DMA3_FIX) if defined(&QIC02_TAPE_DMA3_FIX);
	    if((defined(&QIC02_TAPE_DRIVE) ? &QIC02_TAPE_DRIVE : 0) == (defined(&MT_ISWT5150) ? &MT_ISWT5150 : 0)) {
		eval 'sub TP_HAVE_DENS () {1;}' unless defined(&TP_HAVE_DENS);
		eval 'sub TP_HAVE_BSF () {0;}' unless defined(&TP_HAVE_BSF);
		eval 'sub TP_HAVE_FSR () {0;}' unless defined(&TP_HAVE_FSR);
		eval 'sub TP_HAVE_BSR () {0;}' unless defined(&TP_HAVE_BSR);
		eval 'sub TP_HAVE_EOD () {0;}' unless defined(&TP_HAVE_EOD);
		eval 'sub TP_HAVE_SEEK () {0;}' unless defined(&TP_HAVE_SEEK);
		eval 'sub TP_HAVE_TELL () {0;}' unless defined(&TP_HAVE_TELL);
		eval 'sub TP_HAVE_RAS1 () {1;}' unless defined(&TP_HAVE_RAS1);
		eval 'sub TP_HAVE_RAS2 () {1;}' unless defined(&TP_HAVE_RAS2);
	    }
 elsif((defined(&QIC02_TAPE_DRIVE) ? &QIC02_TAPE_DRIVE : 0) == (defined(&MT_ISARCHIVESC499) ? &MT_ISARCHIVESC499 : 0) ) {
		eval 'sub TP_HAVE_DENS () {1;}' unless defined(&TP_HAVE_DENS);
		eval 'sub TP_HAVE_BSF () {0;}' unless defined(&TP_HAVE_BSF);
		eval 'sub TP_HAVE_FSR () {1;}' unless defined(&TP_HAVE_FSR);
		eval 'sub TP_HAVE_BSR () {1;}' unless defined(&TP_HAVE_BSR);
		eval 'sub TP_HAVE_EOD () {1;}' unless defined(&TP_HAVE_EOD);
		eval 'sub TP_HAVE_SEEK () {0;}' unless defined(&TP_HAVE_SEEK);
		eval 'sub TP_HAVE_TELL () {0;}' unless defined(&TP_HAVE_TELL);
		eval 'sub TP_HAVE_RAS1 () {1;}' unless defined(&TP_HAVE_RAS1);
		eval 'sub TP_HAVE_RAS2 () {1;}' unless defined(&TP_HAVE_RAS2);
	    }
 elsif(((defined(&QIC02_TAPE_DRIVE) ? &QIC02_TAPE_DRIVE : 0) == (defined(&MT_ISARCHIVE_2060L) ? &MT_ISARCHIVE_2060L : 0)) || ((defined(&QIC02_TAPE_DRIVE) ? &QIC02_TAPE_DRIVE : 0) == (defined(&MT_ISARCHIVE_2150L) ? &MT_ISARCHIVE_2150L : 0))) {
		eval 'sub TP_HAVE_DENS () {1;}' unless defined(&TP_HAVE_DENS);
		eval 'sub TP_HAVE_BSF () {0;}' unless defined(&TP_HAVE_BSF);
		eval 'sub TP_HAVE_FSR () {1;}' unless defined(&TP_HAVE_FSR);
		eval 'sub TP_HAVE_BSR () {1;}' unless defined(&TP_HAVE_BSR);
		eval 'sub TP_HAVE_EOD () {1;}' unless defined(&TP_HAVE_EOD);
		eval 'sub TP_HAVE_TELL () {1;}' unless defined(&TP_HAVE_TELL);
		eval 'sub TP_HAVE_SEEK () {1;}' unless defined(&TP_HAVE_SEEK);
		eval 'sub TP_HAVE_RAS1 () {1;}' unless defined(&TP_HAVE_RAS1);
		eval 'sub TP_HAVE_RAS2 () {1;}' unless defined(&TP_HAVE_RAS2);
	    }
 elsif((defined(&QIC02_TAPE_DRIVE) ? &QIC02_TAPE_DRIVE : 0) == (defined(&MT_ISARCHIVE_5945L2) ? &MT_ISARCHIVE_5945L2 : 0)) {
		eval 'sub TP_HAVE_DENS () {1;}' unless defined(&TP_HAVE_DENS);
		eval 'sub TP_HAVE_BSF () {0;}' unless defined(&TP_HAVE_BSF);
		eval 'sub TP_HAVE_FSR () {1;}' unless defined(&TP_HAVE_FSR);
		eval 'sub TP_HAVE_BSR () {1;}' unless defined(&TP_HAVE_BSR);
		eval 'sub TP_HAVE_EOD () {1;}' unless defined(&TP_HAVE_EOD);
		eval 'sub TP_HAVE_TELL () {1;}' unless defined(&TP_HAVE_TELL);
		eval 'sub TP_HAVE_SEEK () {1;}' unless defined(&TP_HAVE_SEEK);
		eval 'sub TP_HAVE_RAS1 () {1;}' unless defined(&TP_HAVE_RAS1);
		eval 'sub TP_HAVE_RAS2 () {1;}' unless defined(&TP_HAVE_RAS2);
	    }
 elsif((defined(&QIC02_TAPE_DRIVE) ? &QIC02_TAPE_DRIVE : 0) == (defined(&MT_ISTEAC_MT2ST) ? &MT_ISTEAC_MT2ST : 0)) {
		eval 'sub TP_HAVE_DENS () {0;}' unless defined(&TP_HAVE_DENS);
		eval 'sub TP_HAVE_BSF () {0;}' unless defined(&TP_HAVE_BSF);
		eval 'sub TP_HAVE_FSR () {1;}' unless defined(&TP_HAVE_FSR);
		eval 'sub TP_HAVE_BSR () {1;}' unless defined(&TP_HAVE_BSR);
		eval 'sub TP_HAVE_EOD () {1;}' unless defined(&TP_HAVE_EOD);
		eval 'sub TP_HAVE_SEEK () {1;}' unless defined(&TP_HAVE_SEEK);
		eval 'sub TP_HAVE_TELL () {1;}' unless defined(&TP_HAVE_TELL);
		eval 'sub TP_HAVE_RAS1 () {1;}' unless defined(&TP_HAVE_RAS1);
		eval 'sub TP_HAVE_RAS2 () {1;}' unless defined(&TP_HAVE_RAS2);
	    }
 elsif((defined(&QIC02_TAPE_DRIVE) ? &QIC02_TAPE_DRIVE : 0) == (defined(&MT_ISQIC02_ALL_FEATURES) ? &MT_ISQIC02_ALL_FEATURES : 0)) {
		eval 'sub TP_HAVE_DENS () {1;}' unless defined(&TP_HAVE_DENS);
		eval 'sub TP_HAVE_BSF () {1;}' unless defined(&TP_HAVE_BSF);
		eval 'sub TP_HAVE_FSR () {1;}' unless defined(&TP_HAVE_FSR);
		eval 'sub TP_HAVE_BSR () {1;}' unless defined(&TP_HAVE_BSR);
		eval 'sub TP_HAVE_EOD () {1;}' unless defined(&TP_HAVE_EOD);
		eval 'sub TP_HAVE_SEEK () {1;}' unless defined(&TP_HAVE_SEEK);
		eval 'sub TP_HAVE_TELL () {1;}' unless defined(&TP_HAVE_TELL);
		eval 'sub TP_HAVE_RAS1 () {1;}' unless defined(&TP_HAVE_RAS1);
		eval 'sub TP_HAVE_RAS2 () {1;}' unless defined(&TP_HAVE_RAS2);
	    } else {
		die("No\ QIC\-02\ tape\ drive\ type\ defined\!");
	    }
	}
	eval 'sub WT_QIC02_STAT_PORT () {( &QIC02_TAPE_PORT);}' unless defined(&WT_QIC02_STAT_PORT);
	eval 'sub WT_QIC02_CTL_PORT () {( &QIC02_TAPE_PORT);}' unless defined(&WT_QIC02_CTL_PORT);
	eval 'sub WT_QIC02_CMD_PORT () {( &QIC02_TAPE_PORT+1);}' unless defined(&WT_QIC02_CMD_PORT);
	eval 'sub WT_QIC02_DATA_PORT () {( &QIC02_TAPE_PORT+1);}' unless defined(&WT_QIC02_DATA_PORT);
	eval 'sub WT_QIC02_STAT_POLARITY () {0;}' unless defined(&WT_QIC02_STAT_POLARITY);
	eval 'sub WT_QIC02_STAT_READY () {0x1;}' unless defined(&WT_QIC02_STAT_READY);
	eval 'sub WT_QIC02_STAT_EXCEPTION () {0x2;}' unless defined(&WT_QIC02_STAT_EXCEPTION);
	eval 'sub WT_QIC02_STAT_MASK () {( &WT_QIC02_STAT_READY| &WT_QIC02_STAT_EXCEPTION);}' unless defined(&WT_QIC02_STAT_MASK);
	eval 'sub WT_QIC02_STAT_RESETMASK () {0x7;}' unless defined(&WT_QIC02_STAT_RESETMASK);
	eval 'sub WT_QIC02_STAT_RESETVAL () {( &WT_QIC02_STAT_RESETMASK & ~ &WT_QIC02_STAT_EXCEPTION);}' unless defined(&WT_QIC02_STAT_RESETVAL);
	eval 'sub WT_QIC02_CTL_RESET () {0x2;}' unless defined(&WT_QIC02_CTL_RESET);
	eval 'sub WT_QIC02_CTL_REQUEST () {0x4;}' unless defined(&WT_QIC02_CTL_REQUEST);
	eval 'sub WT_CTL_ONLINE () {0x1;}' unless defined(&WT_CTL_ONLINE);
	eval 'sub WT_CTL_CMDOFF () {0xc0;}' unless defined(&WT_CTL_CMDOFF);
	eval 'sub WT_CTL_DMA3 () {0x10;}' unless defined(&WT_CTL_DMA3);
	eval 'sub WT_CTL_DMA1 () {0x8;}' unless defined(&WT_CTL_DMA1);
	eval 'sub EMR_QIC02_STAT_PORT () {( &QIC02_TAPE_PORT);}' unless defined(&EMR_QIC02_STAT_PORT);
	eval 'sub EMR_QIC02_CTL_PORT () {( &QIC02_TAPE_PORT);}' unless defined(&EMR_QIC02_CTL_PORT);
	eval 'sub EMR_QIC02_CMD_PORT () {( &QIC02_TAPE_PORT+1);}' unless defined(&EMR_QIC02_CMD_PORT);
	eval 'sub EMR_QIC02_DATA_PORT () {( &QIC02_TAPE_PORT+1);}' unless defined(&EMR_QIC02_DATA_PORT);
	eval 'sub EMR_QIC02_STAT_POLARITY () {1;}' unless defined(&EMR_QIC02_STAT_POLARITY);
	eval 'sub EMR_QIC02_STAT_READY () {0x1;}' unless defined(&EMR_QIC02_STAT_READY);
	eval 'sub EMR_QIC02_STAT_EXCEPTION () {0x2;}' unless defined(&EMR_QIC02_STAT_EXCEPTION);
	eval 'sub EMR_QIC02_STAT_MASK () {( &EMR_QIC02_STAT_READY| &EMR_QIC02_STAT_EXCEPTION);}' unless defined(&EMR_QIC02_STAT_MASK);
	eval 'sub EMR_QIC02_STAT_RESETMASK () {0x7;}' unless defined(&EMR_QIC02_STAT_RESETMASK);
	eval 'sub EMR_QIC02_STAT_RESETVAL () {( &EMR_QIC02_STAT_RESETMASK & ~ &EMR_QIC02_STAT_EXCEPTION);}' unless defined(&EMR_QIC02_STAT_RESETVAL);
	eval 'sub EMR_QIC02_CTL_RESET () {0x2;}' unless defined(&EMR_QIC02_CTL_RESET);
	eval 'sub EMR_QIC02_CTL_REQUEST () {0x4;}' unless defined(&EMR_QIC02_CTL_REQUEST);
	eval 'sub EMR_CTL_ONLINE () {0x1;}' unless defined(&EMR_CTL_ONLINE);
	eval 'sub EMR_CTL_CMDOFF () {0xc0;}' unless defined(&EMR_CTL_CMDOFF);
	eval 'sub EMR_CTL_DMA3 () {0x10;}' unless defined(&EMR_CTL_DMA3);
	eval 'sub EMR_CTL_DMA1 () {0x8;}' unless defined(&EMR_CTL_DMA1);
	eval 'sub AR_QIC02_STAT_PORT () {( &QIC02_TAPE_PORT+1);}' unless defined(&AR_QIC02_STAT_PORT);
	eval 'sub AR_QIC02_CTL_PORT () {( &QIC02_TAPE_PORT+1);}' unless defined(&AR_QIC02_CTL_PORT);
	eval 'sub AR_QIC02_CMD_PORT () {( &QIC02_TAPE_PORT);}' unless defined(&AR_QIC02_CMD_PORT);
	eval 'sub AR_QIC02_DATA_PORT () {( &QIC02_TAPE_PORT);}' unless defined(&AR_QIC02_DATA_PORT);
	eval 'sub AR_START_DMA_PORT () {( &QIC02_TAPE_PORT+2);}' unless defined(&AR_START_DMA_PORT);
	eval 'sub AR_RESET_DMA_PORT () {( &QIC02_TAPE_PORT+3);}' unless defined(&AR_RESET_DMA_PORT);
	eval 'sub AR_QIC02_STAT_POLARITY () {0;}' unless defined(&AR_QIC02_STAT_POLARITY);
	eval 'sub AR_STAT_IRQF () {0x80;}' unless defined(&AR_STAT_IRQF);
	eval 'sub AR_QIC02_STAT_READY () {0x40;}' unless defined(&AR_QIC02_STAT_READY);
	eval 'sub AR_QIC02_STAT_EXCEPTION () {0x20;}' unless defined(&AR_QIC02_STAT_EXCEPTION);
	eval 'sub AR_QIC02_STAT_MASK () {( &AR_QIC02_STAT_READY| &AR_QIC02_STAT_EXCEPTION);}' unless defined(&AR_QIC02_STAT_MASK);
	eval 'sub AR_STAT_DMADONE () {0x10;}' unless defined(&AR_STAT_DMADONE);
	eval 'sub AR_STAT_DIRC () {0x8;}' unless defined(&AR_STAT_DIRC);
	eval 'sub AR_QIC02_STAT_RESETMASK () {0x70;}' unless defined(&AR_QIC02_STAT_RESETMASK);
	eval 'sub AR_QIC02_STAT_RESETVAL () {(( &AR_QIC02_STAT_RESETMASK & ~ &AR_STAT_IRQF & ~ &AR_QIC02_STAT_EXCEPTION) |  &AR_STAT_DMADONE);}' unless defined(&AR_QIC02_STAT_RESETVAL);
	eval 'sub AR_QIC02_CTL_RESET () {0x80;}' unless defined(&AR_QIC02_CTL_RESET);
	eval 'sub AR_QIC02_CTL_REQUEST () {0x40;}' unless defined(&AR_QIC02_CTL_REQUEST);
	eval 'sub AR_CTL_IEN () {0x20;}' unless defined(&AR_CTL_IEN);
	eval 'sub AR_CTL_DNIEN () {0x10;}' unless defined(&AR_CTL_DNIEN);
	eval 'sub MTN_QIC02_STAT_PORT () {( &QIC02_TAPE_PORT+1);}' unless defined(&MTN_QIC02_STAT_PORT);
	eval 'sub MTN_QIC02_CTL_PORT () {( &QIC02_TAPE_PORT+1);}' unless defined(&MTN_QIC02_CTL_PORT);
	eval 'sub MTN_QIC02_CMD_PORT () {( &QIC02_TAPE_PORT);}' unless defined(&MTN_QIC02_CMD_PORT);
	eval 'sub MTN_QIC02_DATA_PORT () {( &QIC02_TAPE_PORT);}' unless defined(&MTN_QIC02_DATA_PORT);
	eval 'sub MTN_W_SELECT_DMA_PORT () {( &QIC02_TAPE_PORT+2);}' unless defined(&MTN_W_SELECT_DMA_PORT);
	eval 'sub MTN_R_DESELECT_DMA_PORT () {( &QIC02_TAPE_PORT+2);}' unless defined(&MTN_R_DESELECT_DMA_PORT);
	eval 'sub MTN_W_DMA_WRITE_PORT () {( &QIC02_TAPE_PORT+3);}' unless defined(&MTN_W_DMA_WRITE_PORT);
	eval 'sub MTN_QIC02_STAT_POLARITY () {0;}' unless defined(&MTN_QIC02_STAT_POLARITY);
	eval 'sub MTN_QIC02_STAT_READY () {0x2;}' unless defined(&MTN_QIC02_STAT_READY);
	eval 'sub MTN_QIC02_STAT_EXCEPTION () {0x4;}' unless defined(&MTN_QIC02_STAT_EXCEPTION);
	eval 'sub MTN_QIC02_STAT_MASK () {( &MTN_QIC02_STAT_READY| &MTN_QIC02_STAT_EXCEPTION);}' unless defined(&MTN_QIC02_STAT_MASK);
	eval 'sub MTN_STAT_DMADONE () {0x1;}' unless defined(&MTN_STAT_DMADONE);
	eval 'sub MTN_QIC02_STAT_RESETMASK () {0x7;}' unless defined(&MTN_QIC02_STAT_RESETMASK);
	eval 'sub MTN_QIC02_STAT_RESETVAL () {(( &MTN_QIC02_STAT_RESETMASK & ~ &MTN_QIC02_STAT_EXCEPTION) |  &MTN_STAT_DMADONE);}' unless defined(&MTN_QIC02_STAT_RESETVAL);
	eval 'sub MTN_QIC02_CTL_RESET_NOT () {0x80;}' unless defined(&MTN_QIC02_CTL_RESET_NOT);
	eval 'sub MTN_QIC02_CTL_RESET () {0x80;}' unless defined(&MTN_QIC02_CTL_RESET);
	eval 'sub MTN_QIC02_CTL_ONLINE () {0x40;}' unless defined(&MTN_QIC02_CTL_ONLINE);
	eval 'sub MTN_QIC02_CTL_REQUEST () {0x20;}' unless defined(&MTN_QIC02_CTL_REQUEST);
	eval 'sub MTN_QIC02_CTL_IRQ_DRIVER () {0x10;}' unless defined(&MTN_QIC02_CTL_IRQ_DRIVER);
	eval 'sub MTN_QIC02_CTL_DMA_DRIVER () {0x8;}' unless defined(&MTN_QIC02_CTL_DMA_DRIVER);
	eval 'sub MTN_CTL_EXC_IEN () {0x4;}' unless defined(&MTN_CTL_EXC_IEN);
	eval 'sub MTN_CTL_RDY_IEN () {0x2;}' unless defined(&MTN_CTL_RDY_IEN);
	eval 'sub MTN_CTL_DNIEN () {0x1;}' unless defined(&MTN_CTL_DNIEN);
	eval 'sub MTN_CTL_ONLINE () {( &MTN_QIC02_CTL_RESET_NOT |  &MTN_QIC02_CTL_IRQ_DRIVER |  &MTN_QIC02_CTL_DMA_DRIVER);}' unless defined(&MTN_CTL_ONLINE);
	unless(defined(&CONFIG_QIC02_DYNCONF)) {
	    eval 'sub QIC02_TAPE_DEBUG () {( &qic02_tape_debug);}' unless defined(&QIC02_TAPE_DEBUG);
	    if((defined(&QIC02_TAPE_IFC) ? &QIC02_TAPE_IFC : 0) == (defined(&WANGTEK) ? &WANGTEK : 0) ) {
		eval 'sub QIC02_STAT_POLARITY () { &WT_QIC02_STAT_POLARITY;}' unless defined(&QIC02_STAT_POLARITY);
		eval 'sub QIC02_STAT_PORT () { &WT_QIC02_STAT_PORT;}' unless defined(&QIC02_STAT_PORT);
		eval 'sub QIC02_CTL_PORT () { &WT_QIC02_CTL_PORT;}' unless defined(&QIC02_CTL_PORT);
		eval 'sub QIC02_CMD_PORT () { &WT_QIC02_CMD_PORT;}' unless defined(&QIC02_CMD_PORT);
		eval 'sub QIC02_DATA_PORT () { &WT_QIC02_DATA_PORT;}' unless defined(&QIC02_DATA_PORT);
		eval 'sub QIC02_STAT_READY () { &WT_QIC02_STAT_READY;}' unless defined(&QIC02_STAT_READY);
		eval 'sub QIC02_STAT_EXCEPTION () { &WT_QIC02_STAT_EXCEPTION;}' unless defined(&QIC02_STAT_EXCEPTION);
		eval 'sub QIC02_STAT_MASK () { &WT_QIC02_STAT_MASK;}' unless defined(&QIC02_STAT_MASK);
		eval 'sub QIC02_STAT_RESETMASK () { &WT_QIC02_STAT_RESETMASK;}' unless defined(&QIC02_STAT_RESETMASK);
		eval 'sub QIC02_STAT_RESETVAL () { &WT_QIC02_STAT_RESETVAL;}' unless defined(&QIC02_STAT_RESETVAL);
		eval 'sub QIC02_CTL_RESET () { &WT_QIC02_CTL_RESET;}' unless defined(&QIC02_CTL_RESET);
		eval 'sub QIC02_CTL_REQUEST () { &WT_QIC02_CTL_REQUEST;}' unless defined(&QIC02_CTL_REQUEST);
		if((defined(&QIC02_TAPE_DMA) ? &QIC02_TAPE_DMA : 0) == 3) {
		    if(defined(&QIC02_TAPE_DMA3_FIX)) {
			eval 'sub WT_CTL_DMA () { &WT_CTL_DMA1;}' unless defined(&WT_CTL_DMA);
		    } else {
			eval 'sub WT_CTL_DMA () { &WT_CTL_DMA3;}' unless defined(&WT_CTL_DMA);
		    }
		}
 elsif((defined(&QIC02_TAPE_DMA) ? &QIC02_TAPE_DMA : 0) == 1) {
		    eval 'sub WT_CTL_DMA () { &WT_CTL_DMA1;}' unless defined(&WT_CTL_DMA);
		} else {
		    die("Unsupported\ or\ incorrect\ DMA\ configuration\.");
		}
	    }
 elsif((defined(&QIC02_TAPE_IFC) ? &QIC02_TAPE_IFC : 0) == (defined(&EMERALD) ? &EMERALD : 0)) {
		eval 'sub QIC02_STAT_POLARITY () { &EMR_QIC02_STAT_POLARITY;}' unless defined(&QIC02_STAT_POLARITY);
		eval 'sub QIC02_STAT_PORT () { &EMR_QIC02_STAT_PORT;}' unless defined(&QIC02_STAT_PORT);
		eval 'sub QIC02_CTL_PORT () { &EMR_QIC02_CTL_PORT;}' unless defined(&QIC02_CTL_PORT);
		eval 'sub QIC02_CMD_PORT () { &EMR_QIC02_CMD_PORT;}' unless defined(&QIC02_CMD_PORT);
		eval 'sub QIC02_DATA_PORT () { &EMR_QIC02_DATA_PORT;}' unless defined(&QIC02_DATA_PORT);
		eval 'sub QIC02_STAT_READY () { &EMR_QIC02_STAT_READY;}' unless defined(&QIC02_STAT_READY);
		eval 'sub QIC02_STAT_EXCEPTION () { &EMR_QIC02_STAT_EXCEPTION;}' unless defined(&QIC02_STAT_EXCEPTION);
		eval 'sub QIC02_STAT_MASK () { &EMR_QIC02_STAT_MASK;}' unless defined(&QIC02_STAT_MASK);
		eval 'sub QIC02_STAT_RESETMASK () { &EMR_QIC02_STAT_RESETMASK;}' unless defined(&QIC02_STAT_RESETMASK);
		eval 'sub QIC02_STAT_RESETVAL () { &EMR_QIC02_STAT_RESETVAL;}' unless defined(&QIC02_STAT_RESETVAL);
		eval 'sub QIC02_CTL_RESET () { &EMR_QIC02_CTL_RESET;}' unless defined(&QIC02_CTL_RESET);
		eval 'sub QIC02_CTL_REQUEST () { &EMR_QIC02_CTL_REQUEST;}' unless defined(&QIC02_CTL_REQUEST);
		if((defined(&QIC02_TAPE_DMA) ? &QIC02_TAPE_DMA : 0) == 3) {
		    if(defined(&QIC02_TAPE_DMA3_FIX)) {
			eval 'sub EMR_CTL_DMA () { &EMR_CTL_DMA1;}' unless defined(&EMR_CTL_DMA);
		    } else {
			eval 'sub EMR_CTL_DMA () { &EMR_CTL_DMA3;}' unless defined(&EMR_CTL_DMA);
		    }
		}
 elsif((defined(&QIC02_TAPE_DMA) ? &QIC02_TAPE_DMA : 0) == 1) {
		    eval 'sub EMR_CTL_DMA () { &EMR_CTL_DMA1;}' unless defined(&EMR_CTL_DMA);
		} else {
		    die("Unsupported\ or\ incorrect\ DMA\ configuration\.");
		}
	    }
 elsif((defined(&QIC02_TAPE_IFC) ? &QIC02_TAPE_IFC : 0) == (defined(&ARCHIVE) ? &ARCHIVE : 0)) {
		eval 'sub QIC02_STAT_POLARITY () { &AR_QIC02_STAT_POLARITY;}' unless defined(&QIC02_STAT_POLARITY);
		eval 'sub QIC02_STAT_PORT () { &AR_QIC02_STAT_PORT;}' unless defined(&QIC02_STAT_PORT);
		eval 'sub QIC02_CTL_PORT () { &AR_QIC02_CTL_PORT;}' unless defined(&QIC02_CTL_PORT);
		eval 'sub QIC02_CMD_PORT () { &AR_QIC02_CMD_PORT;}' unless defined(&QIC02_CMD_PORT);
		eval 'sub QIC02_DATA_PORT () { &AR_QIC02_DATA_PORT;}' unless defined(&QIC02_DATA_PORT);
		eval 'sub QIC02_STAT_READY () { &AR_QIC02_STAT_READY;}' unless defined(&QIC02_STAT_READY);
		eval 'sub QIC02_STAT_EXCEPTION () { &AR_QIC02_STAT_EXCEPTION;}' unless defined(&QIC02_STAT_EXCEPTION);
		eval 'sub QIC02_STAT_MASK () { &AR_QIC02_STAT_MASK;}' unless defined(&QIC02_STAT_MASK);
		eval 'sub QIC02_STAT_RESETMASK () { &AR_QIC02_STAT_RESETMASK;}' unless defined(&QIC02_STAT_RESETMASK);
		eval 'sub QIC02_STAT_RESETVAL () { &AR_QIC02_STAT_RESETVAL;}' unless defined(&QIC02_STAT_RESETVAL);
		eval 'sub QIC02_CTL_RESET () { &AR_QIC02_CTL_RESET;}' unless defined(&QIC02_CTL_RESET);
		eval 'sub QIC02_CTL_REQUEST () { &AR_QIC02_CTL_REQUEST;}' unless defined(&QIC02_CTL_REQUEST);
		if((defined(&QIC02_TAPE_DMA) ? &QIC02_TAPE_DMA : 0) > 3) {
		    die("DMA\ channels\ other\ than\ 1\ and\ 3\ are\ not\ supported\.");
		}
	    }
 elsif((defined(&QIC02_TAPE_IFC) ? &QIC02_TAPE_IFC : 0) == (defined(&MOUNTAIN) ? &MOUNTAIN : 0)) {
		eval 'sub QIC02_STAT_POLARITY () { &MTN_QIC02_STAT_POLARITY;}' unless defined(&QIC02_STAT_POLARITY);
		eval 'sub QIC02_STAT_PORT () { &MTN_QIC02_STAT_PORT;}' unless defined(&QIC02_STAT_PORT);
		eval 'sub QIC02_CTL_PORT () { &MTN_QIC02_CTL_PORT;}' unless defined(&QIC02_CTL_PORT);
		eval 'sub QIC02_CMD_PORT () { &MTN_QIC02_CMD_PORT;}' unless defined(&QIC02_CMD_PORT);
		eval 'sub QIC02_DATA_PORT () { &MTN_QIC02_DATA_PORT;}' unless defined(&QIC02_DATA_PORT);
		eval 'sub QIC02_STAT_READY () { &MTN_QIC02_STAT_READY;}' unless defined(&QIC02_STAT_READY);
		eval 'sub QIC02_STAT_EXCEPTION () { &MTN_QIC02_STAT_EXCEPTION;}' unless defined(&QIC02_STAT_EXCEPTION);
		eval 'sub QIC02_STAT_MASK () { &MTN_QIC02_STAT_MASK;}' unless defined(&QIC02_STAT_MASK);
		eval 'sub QIC02_STAT_RESETMASK () { &MTN_QIC02_STAT_RESETMASK;}' unless defined(&QIC02_STAT_RESETMASK);
		eval 'sub QIC02_STAT_RESETVAL () { &MTN_QIC02_STAT_RESETVAL;}' unless defined(&QIC02_STAT_RESETVAL);
		eval 'sub QIC02_CTL_RESET () { &MTN_QIC02_CTL_RESET;}' unless defined(&QIC02_CTL_RESET);
		eval 'sub QIC02_CTL_REQUEST () { &MTN_QIC02_CTL_REQUEST;}' unless defined(&QIC02_CTL_REQUEST);
		if((defined(&QIC02_TAPE_DMA) ? &QIC02_TAPE_DMA : 0) > 3) {
		    die("DMA\ channels\ other\ than\ 1\ and\ 3\ are\ not\ supported\.");
		}
	    } else {
		die("No\ valid\ interface\ card\ specified\!");
	    }
	    unless(defined(&WT_CTL_DMA)) {
		eval 'sub WT_CTL_DMA () { &WT_CTL_DMA1;}' unless defined(&WT_CTL_DMA);
	    }
	} else {
	    eval 'sub QIC02_TAPE_DRIVE () {( ($qic02_tape_dynconf->{mt_type}));}' unless defined(&QIC02_TAPE_DRIVE);
	    eval 'sub QIC02_TAPE_IFC () {( ($qic02_tape_ccb->{ifc_type}));}' unless defined(&QIC02_TAPE_IFC);
	    eval 'sub QIC02_TAPE_IRQ () {( ($qic02_tape_dynconf->{irqnr}));}' unless defined(&QIC02_TAPE_IRQ);
	    eval 'sub QIC02_TAPE_DMA () {( ($qic02_tape_dynconf->{dmanr}));}' unless defined(&QIC02_TAPE_DMA);
	    eval 'sub QIC02_TAPE_PORT () {( ($qic02_tape_dynconf->{port}));}' unless defined(&QIC02_TAPE_PORT);
	    eval 'sub WT_CTL_DMA () {( ($qic02_tape_ccb->{dma_enable_value}));}' unless defined(&WT_CTL_DMA);
	    eval 'sub QIC02_TAPE_DEBUG () {( ($qic02_tape_dynconf->{debug}));}' unless defined(&QIC02_TAPE_DEBUG);
	    eval 'sub QIC02_STAT_PORT () {( ($qic02_tape_ccb->{port_stat}));}' unless defined(&QIC02_STAT_PORT);
	    eval 'sub QIC02_CTL_PORT () {( ($qic02_tape_ccb->{port_ctl}));}' unless defined(&QIC02_CTL_PORT);
	    eval 'sub QIC02_CMD_PORT () {( ($qic02_tape_ccb->{port_cmd}));}' unless defined(&QIC02_CMD_PORT);
	    eval 'sub QIC02_DATA_PORT () {( ($qic02_tape_ccb->{port_data}));}' unless defined(&QIC02_DATA_PORT);
	    eval 'sub QIC02_STAT_POLARITY () {( ($qic02_tape_ccb->{stat_polarity}));}' unless defined(&QIC02_STAT_POLARITY);
	    eval 'sub QIC02_STAT_READY () {( ($qic02_tape_ccb->{stat_ready}));}' unless defined(&QIC02_STAT_READY);
	    eval 'sub QIC02_STAT_EXCEPTION () {( ($qic02_tape_ccb->{stat_exception}));}' unless defined(&QIC02_STAT_EXCEPTION);
	    eval 'sub QIC02_STAT_MASK () {( ($qic02_tape_ccb->{stat_mask}));}' unless defined(&QIC02_STAT_MASK);
	    eval 'sub QIC02_STAT_RESETMASK () {( ($qic02_tape_ccb->{stat_resetmask}));}' unless defined(&QIC02_STAT_RESETMASK);
	    eval 'sub QIC02_STAT_RESETVAL () {( ($qic02_tape_ccb->{stat_resetval}));}' unless defined(&QIC02_STAT_RESETVAL);
	    eval 'sub QIC02_CTL_RESET () {( ($qic02_tape_ccb->{ctl_reset}));}' unless defined(&QIC02_CTL_RESET);
	    eval 'sub QIC02_CTL_REQUEST () {( ($qic02_tape_ccb->{ctl_request}));}' unless defined(&QIC02_CTL_REQUEST);
	    eval 'sub TP_HAVE_DENS () {( ($qic02_tape_dynconf->{have_dens}));}' unless defined(&TP_HAVE_DENS);
	    eval 'sub TP_HAVE_BSF () {( ($qic02_tape_dynconf->{have_bsf}));}' unless defined(&TP_HAVE_BSF);
	    eval 'sub TP_HAVE_FSR () {( ($qic02_tape_dynconf->{have_fsr}));}' unless defined(&TP_HAVE_FSR);
	    eval 'sub TP_HAVE_BSR () {( ($qic02_tape_dynconf->{have_bsr}));}' unless defined(&TP_HAVE_BSR);
	    eval 'sub TP_HAVE_EOD () {( ($qic02_tape_dynconf->{have_eod}));}' unless defined(&TP_HAVE_EOD);
	    eval 'sub TP_HAVE_SEEK () {( ($qic02_tape_dynconf->{have_seek}));}' unless defined(&TP_HAVE_SEEK);
	    eval 'sub TP_HAVE_TELL () {( ($qic02_tape_dynconf->{have_tell}));}' unless defined(&TP_HAVE_TELL);
	    eval 'sub TP_HAVE_RAS1 () {( ($qic02_tape_dynconf->{have_ras1}));}' unless defined(&TP_HAVE_RAS1);
	    eval 'sub TP_HAVE_RAS2 () {( ($qic02_tape_dynconf->{have_ras2}));}' unless defined(&TP_HAVE_RAS2);
	}
	eval 'sub AR_QCMDV_TELL_BLK () {0xae;}' unless defined(&AR_QCMDV_TELL_BLK);
	eval 'sub AR_QCMDV_SEEK_BLK () {0xad;}' unless defined(&AR_QCMDV_SEEK_BLK);
	eval 'sub AR_SEEK_BUF_SIZE () {3;}' unless defined(&AR_SEEK_BUF_SIZE);
	eval 'sub QCMD_SEL_1 () {0x1;}' unless defined(&QCMD_SEL_1);
	eval 'sub QCMD_SEL_2 () {0x2;}' unless defined(&QCMD_SEL_2);
	eval 'sub QCMD_SEL_3 () {0x4;}' unless defined(&QCMD_SEL_3);
	eval 'sub QCMD_SEL_4 () {0x8;}' unless defined(&QCMD_SEL_4);
	eval 'sub QCMD_REWIND () {0x21;}' unless defined(&QCMD_REWIND);
	eval 'sub QCMD_ERASE () {0x22;}' unless defined(&QCMD_ERASE);
	eval 'sub QCMD_RETEN () {0x24;}' unless defined(&QCMD_RETEN);
	eval 'sub QCMD_WRT_DATA () {0x40;}' unless defined(&QCMD_WRT_DATA);
	eval 'sub QCMD_WRT_FM () {0x60;}' unless defined(&QCMD_WRT_FM);
	eval 'sub QCMD_RD_DATA () {0x80;}' unless defined(&QCMD_RD_DATA);
	eval 'sub QCMD_RD_FM () {0xa0;}' unless defined(&QCMD_RD_FM);
	eval 'sub QCMD_RD_STAT () {0xc0;}' unless defined(&QCMD_RD_STAT);
	eval 'sub QCMD_DENS_11 () {0x26;}' unless defined(&QCMD_DENS_11);
	eval 'sub QCMD_DENS_24 () {0x27;}' unless defined(&QCMD_DENS_24);
	eval 'sub QCMD_DENS_120 () {0x28;}' unless defined(&QCMD_DENS_120);
	eval 'sub QCMD_DENS_150 () {0x29;}' unless defined(&QCMD_DENS_150);
	eval 'sub QCMD_DENS_300 () {0x2a;}' unless defined(&QCMD_DENS_300);
	eval 'sub QCMD_DENS_600 () {0x2b;}' unless defined(&QCMD_DENS_600);
	eval 'sub QCMD_WRTNU_DATA () {0x40;}' unless defined(&QCMD_WRTNU_DATA);
	eval 'sub QCMD_SPACE_FWD () {0x81;}' unless defined(&QCMD_SPACE_FWD);
	eval 'sub QCMD_SPACE_BCK () {0x89;}' unless defined(&QCMD_SPACE_BCK);
	eval 'sub QCMD_RD_FM_BCK () {0xa8;}' unless defined(&QCMD_RD_FM_BCK);
	eval 'sub QCMD_SEEK_EOD () {0xa3;}' unless defined(&QCMD_SEEK_EOD);
	eval 'sub QCMD_RD_STAT_X1 () {0xc1;}' unless defined(&QCMD_RD_STAT_X1);
	eval 'sub QCMD_RD_STAT_X2 () {0xc4;}' unless defined(&QCMD_RD_STAT_X2);
	eval 'sub QCMD_RD_STAT_X3 () {0xe0;}' unless defined(&QCMD_RD_STAT_X3);
	eval 'sub QCMD_SELF_TST1 () {0xc2;}' unless defined(&QCMD_SELF_TST1);
	eval 'sub QCMD_SELF_TST2 () {0xca;}' unless defined(&QCMD_SELF_TST2);
	eval 'sub QFA_ENABLE () {0x2d;}' unless defined(&QFA_ENABLE);
	eval 'sub QFA_DATA () {0x20;}' unless defined(&QFA_DATA);
	eval 'sub QFA_DIR () {0x23;}' unless defined(&QFA_DIR);
	eval 'sub QFA_RD_POS () {0xcf;}' unless defined(&QFA_RD_POS);
	eval 'sub QFA_SEEK_EOD () {0xa1;}' unless defined(&QFA_SEEK_EOD);
	eval 'sub QFA_SEEK_BLK () {0xaf;}' unless defined(&QFA_SEEK_BLK);
	eval 'sub TPQD_SENSE_TEXT () {0x1;}' unless defined(&TPQD_SENSE_TEXT);
	eval 'sub TPQD_SENSE_CNTS () {0x2;}' unless defined(&TPQD_SENSE_CNTS);
	eval 'sub TPQD_REWIND () {0x4;}' unless defined(&TPQD_REWIND);
	eval 'sub TPQD_TERM_CYCLE () {0x8;}' unless defined(&TPQD_TERM_CYCLE);
	eval 'sub TPQD_IOCTLS () {0x10;}' unless defined(&TPQD_IOCTLS);
	eval 'sub TPQD_DMAX () {0x20;}' unless defined(&TPQD_DMAX);
	eval 'sub TPQD_BLKSZ () {0x40;}' unless defined(&TPQD_BLKSZ);
	eval 'sub TPQD_MISC () {0x80;}' unless defined(&TPQD_MISC);
	eval 'sub TPQD_DEBUG () {0x100;}' unless defined(&TPQD_DEBUG);
	eval 'sub TPQD_DIAGS () {0x1000;}' unless defined(&TPQD_DIAGS);
	eval 'sub TPQD_ALWAYS () {0x8000;}' unless defined(&TPQD_ALWAYS);
	eval 'sub TPQD_DEFAULT_FLAGS () {0xfc;}' unless defined(&TPQD_DEFAULT_FLAGS);
	eval 'sub TPQDBG {
	    my($f) = @_;
    	    eval q((( &QIC02_TAPE_DEBUG) & ( &TPQD_$f)));
	}' unless defined(&TPQDBG);
	eval 'sub TP_REWCLOSE {
	    my($d) = @_;
    	    eval q((( &MINOR($d)&0x1) == 1));
	}' unless defined(&TP_REWCLOSE);
	eval 'sub TP_DENS {
	    my($dev) = @_;
    	    eval q((( &MINOR($dev) >> 1) & 0x7));
	}' unless defined(&TP_DENS);
	eval 'sub TP_UNIT {
	    my($dev) = @_;
    	    eval q((( &MINOR($dev) >> 4) & 0x7));
	}' unless defined(&TP_UNIT);
	eval 'sub TP_DIAGS {
	    my($dev) = @_;
    	    eval q(( &QIC02_TAPE_DEBUG &  &TPQD_DIAGS));
	}' unless defined(&TP_DIAGS);
	eval 'sub TPSTATSIZE () {$sizeof{\'struct tpstatus\'};}' unless defined(&TPSTATSIZE);
	eval 'sub TP_POR () {0x100;}' unless defined(&TP_POR);
	eval 'sub TP_EOR () {0x200;}' unless defined(&TP_EOR);
	eval 'sub TP_PAR () {0x400;}' unless defined(&TP_PAR);
	eval 'sub TP_BOM () {0x800;}' unless defined(&TP_BOM);
	eval 'sub TP_MBD () {0x1000;}' unless defined(&TP_MBD);
	eval 'sub TP_NDT () {0x2000;}' unless defined(&TP_NDT);
	eval 'sub TP_ILL () {0x4000;}' unless defined(&TP_ILL);
	eval 'sub TP_ST1 () {0x8000;}' unless defined(&TP_ST1);
	eval 'sub TP_FIL () {0x1;}' unless defined(&TP_FIL);
	eval 'sub TP_BNL () {0x2;}' unless defined(&TP_BNL);
	eval 'sub TP_UDA () {0x4;}' unless defined(&TP_UDA);
	eval 'sub TP_EOM () {0x8;}' unless defined(&TP_EOM);
	eval 'sub TP_WRP () {0x10;}' unless defined(&TP_WRP);
	eval 'sub TP_USL () {0x20;}' unless defined(&TP_USL);
	eval 'sub TP_CNI () {0x40;}' unless defined(&TP_CNI);
	eval 'sub TP_ST0 () {0x80;}' unless defined(&TP_ST0);
	eval 'sub REPORT_ERR0 () {( &TP_CNI| &TP_USL| &TP_WRP| &TP_EOM| &TP_UDA| &TP_BNL| &TP_FIL);}' unless defined(&REPORT_ERR0);
	eval 'sub REPORT_ERR1 () {( &TP_ILL| &TP_NDT| &TP_MBD| &TP_PAR);}' unless defined(&REPORT_ERR1);
	eval 'sub EXC_UNKNOWN () {0;}' unless defined(&EXC_UNKNOWN);
	eval 'sub EXC_NDRV () {1;}' unless defined(&EXC_NDRV);
	eval 'sub EXC_NCART () {2;}' unless defined(&EXC_NCART);
	eval 'sub EXC_WP () {3;}' unless defined(&EXC_WP);
	eval 'sub EXC_EOM () {4;}' unless defined(&EXC_EOM);
	eval 'sub EXC_RWA () {5;}' unless defined(&EXC_RWA);
	eval 'sub EXC_XBAD () {6;}' unless defined(&EXC_XBAD);
	eval 'sub EXC_XFILLER () {7;}' unless defined(&EXC_XFILLER);
	eval 'sub EXC_NDT () {8;}' unless defined(&EXC_NDT);
	eval 'sub EXC_NDTEOM () {9;}' unless defined(&EXC_NDTEOM);
	eval 'sub EXC_NDTBOM () {10;}' unless defined(&EXC_NDTBOM);
	eval 'sub EXC_FM () {11;}' unless defined(&EXC_FM);
	eval 'sub EXC_ILL () {12;}' unless defined(&EXC_ILL);
	eval 'sub EXC_POR () {13;}' unless defined(&EXC_POR);
	eval 'sub EXC_MARGINAL () {14;}' unless defined(&EXC_MARGINAL);
	eval 'sub EXC_EOR () {15;}' unless defined(&EXC_EOR);
	eval 'sub EXC_BOM () {16;}' unless defined(&EXC_BOM);
	eval 'sub TAPE_NOTIFY_TIMEOUT () {1000000;}' unless defined(&TAPE_NOTIFY_TIMEOUT);
	eval 'sub TE_OK () {0;}' unless defined(&TE_OK);
	eval 'sub TE_EX () {1;}' unless defined(&TE_EX);
	eval 'sub TE_ERR () {2;}' unless defined(&TE_ERR);
	eval 'sub TE_NS () {3;}' unless defined(&TE_NS);
	eval 'sub TE_TIM () {4;}' unless defined(&TE_TIM);
	eval 'sub TE_DEAD () {5;}' unless defined(&TE_DEAD);
	eval 'sub TE_END () {6;}' unless defined(&TE_END);
	eval 'sub TIM_S () {(4* &HZ);}' unless defined(&TIM_S);
	eval 'sub TIM_M () {(30* &HZ);}' unless defined(&TIM_M);
	eval 'sub TIM_R () {(8*60* &HZ);}' unless defined(&TIM_R);
	eval 'sub TIM_F () {(2*3600* &HZ);}' unless defined(&TIM_F);
	eval 'sub TIMERON {
	    my($t) = @_;
    	    eval q( &mod_timer( &tp_timer,  &jiffies + ($t)));
	}' unless defined(&TIMERON);
	eval 'sub TIMEROFF () { &del_timer_sync( &tp_timer);;}' unless defined(&TIMEROFF);
	eval 'sub TIMERCONT () { &add_timer( &tp_timer);;}' unless defined(&TIMERCONT);
	eval 'sub NO () {0;}' unless defined(&NO);
	eval 'sub YES () {1;}' unless defined(&YES);
	if(defined(&TDEBUG)) {
	    eval 'sub TPQDEB {
	        my($s) = @_;
    		eval q($s);
	    }' unless defined(&TPQDEB);
	    eval 'sub TPQPUTS {
	        my($s) = @_;
    		eval q( &tpqputs($s));
	    }' unless defined(&TPQPUTS);
	} else {
	    eval 'sub TPQDEB {
	        my($s) = @_;
    		eval q();
	    }' unless defined(&TPQDEB);
	    eval 'sub TPQPUTS {
	        my($s) = @_;
    		eval q();
	    }' unless defined(&TPQPUTS);
	}
	eval 'sub NR_BLK_BUF () {20;}' unless defined(&NR_BLK_BUF);
	eval 'sub TAPE_BLKSIZE () {512;}' unless defined(&TAPE_BLKSIZE);
	eval 'sub TPQBUF_SIZE () {( &TAPE_BLKSIZE* &NR_BLK_BUF);}' unless defined(&TPQBUF_SIZE);
	eval 'sub BLOCKS_BEYOND_EW () {2;}' unless defined(&BLOCKS_BEYOND_EW);
	eval 'sub BOGUS_IRQ () {32009;}' unless defined(&BOGUS_IRQ);
	if((defined(&MODULE) ? &MODULE : 0)) {
	} else {
	}
    }
}
1;
