require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_DB_H_)) {
    eval 'sub _DB_H_ () {1;}' unless defined(&_DB_H_);
    unless(defined(&__NO_SYSTEM_INCLUDES)) {
	require 'sys/types.ph';
	require 'inttypes.ph';
	require 'stdio.ph';
    }
    if(defined( &__cplusplus)) {
    }
    undef(&__P) if defined(&__P);
    eval 'sub __P {
        my($protos) = @_;
	    eval q($protos);
    }' unless defined(&__P);
    eval 'sub DB_VERSION_MAJOR () {4;}' unless defined(&DB_VERSION_MAJOR);
    eval 'sub DB_VERSION_MINOR () {2;}' unless defined(&DB_VERSION_MINOR);
    eval 'sub DB_VERSION_PATCH () {52;}' unless defined(&DB_VERSION_PATCH);
    eval 'sub DB_VERSION_STRING () {"Sleepycat Software: Berkeley DB 4.2.52: (December  3, 2003)";}' unless defined(&DB_VERSION_STRING);
    unless(defined(&__BIT_TYPES_DEFINED__)) {
	eval 'sub __BIT_TYPES_DEFINED__ () {1;}' unless defined(&__BIT_TYPES_DEFINED__);
    }
    eval 'sub DB_MAX_PAGES () {0xffffffff;}' unless defined(&DB_MAX_PAGES);
    eval 'sub DB_MAX_RECORDS () {0xffffffff;}' unless defined(&DB_MAX_RECORDS);
    eval 'sub DB_DBT_APPMALLOC () {0x1;}' unless defined(&DB_DBT_APPMALLOC);
    eval 'sub DB_DBT_ISSET () {0x2;}' unless defined(&DB_DBT_ISSET);
    eval 'sub DB_DBT_MALLOC () {0x4;}' unless defined(&DB_DBT_MALLOC);
    eval 'sub DB_DBT_PARTIAL () {0x8;}' unless defined(&DB_DBT_PARTIAL);
    eval 'sub DB_DBT_REALLOC () {0x10;}' unless defined(&DB_DBT_REALLOC);
    eval 'sub DB_DBT_USERMEM () {0x20;}' unless defined(&DB_DBT_USERMEM);
    eval 'sub DB_DBT_DUPOK () {0x40;}' unless defined(&DB_DBT_DUPOK);
    eval 'sub DB_CREATE () {0x1;}' unless defined(&DB_CREATE);
    eval 'sub DB_CXX_NO_EXCEPTIONS () {0x2;}' unless defined(&DB_CXX_NO_EXCEPTIONS);
    eval 'sub DB_FORCE () {0x4;}' unless defined(&DB_FORCE);
    eval 'sub DB_NOMMAP () {0x8;}' unless defined(&DB_NOMMAP);
    eval 'sub DB_RDONLY () {0x10;}' unless defined(&DB_RDONLY);
    eval 'sub DB_RECOVER () {0x20;}' unless defined(&DB_RECOVER);
    eval 'sub DB_THREAD () {0x40;}' unless defined(&DB_THREAD);
    eval 'sub DB_TRUNCATE () {0x80;}' unless defined(&DB_TRUNCATE);
    eval 'sub DB_TXN_NOSYNC () {0x100;}' unless defined(&DB_TXN_NOSYNC);
    eval 'sub DB_TXN_NOT_DURABLE () {0x200;}' unless defined(&DB_TXN_NOT_DURABLE);
    eval 'sub DB_USE_ENVIRON () {0x400;}' unless defined(&DB_USE_ENVIRON);
    eval 'sub DB_USE_ENVIRON_ROOT () {0x800;}' unless defined(&DB_USE_ENVIRON_ROOT);
    eval 'sub DB_AUTO_COMMIT () {0x1000000;}' unless defined(&DB_AUTO_COMMIT);
    eval 'sub DB_DIRTY_READ () {0x2000000;}' unless defined(&DB_DIRTY_READ);
    eval 'sub DB_NO_AUTO_COMMIT () {0x4000000;}' unless defined(&DB_NO_AUTO_COMMIT);
    eval 'sub DB_RPCCLIENT () {0x1;}' unless defined(&DB_RPCCLIENT);
    eval 'sub DB_REP_CREATE () {0x1;}' unless defined(&DB_REP_CREATE);
    eval 'sub DB_XA_CREATE () {0x2;}' unless defined(&DB_XA_CREATE);
    eval 'sub DB_INIT_CDB () {0x1000;}' unless defined(&DB_INIT_CDB);
    eval 'sub DB_INIT_LOCK () {0x2000;}' unless defined(&DB_INIT_LOCK);
    eval 'sub DB_INIT_LOG () {0x4000;}' unless defined(&DB_INIT_LOG);
    eval 'sub DB_INIT_MPOOL () {0x8000;}' unless defined(&DB_INIT_MPOOL);
    eval 'sub DB_INIT_REP () {0x10000;}' unless defined(&DB_INIT_REP);
    eval 'sub DB_INIT_TXN () {0x20000;}' unless defined(&DB_INIT_TXN);
    eval 'sub DB_JOINENV () {0x40000;}' unless defined(&DB_JOINENV);
    eval 'sub DB_LOCKDOWN () {0x80000;}' unless defined(&DB_LOCKDOWN);
    eval 'sub DB_PRIVATE () {0x100000;}' unless defined(&DB_PRIVATE);
    eval 'sub DB_RECOVER_FATAL () {0x200000;}' unless defined(&DB_RECOVER_FATAL);
    eval 'sub DB_SYSTEM_MEM () {0x400000;}' unless defined(&DB_SYSTEM_MEM);
    eval 'sub DB_EXCL () {0x1000;}' unless defined(&DB_EXCL);
    eval 'sub DB_FCNTL_LOCKING () {0x2000;}' unless defined(&DB_FCNTL_LOCKING);
    eval 'sub DB_RDWRMASTER () {0x4000;}' unless defined(&DB_RDWRMASTER);
    eval 'sub DB_WRITEOPEN () {0x8000;}' unless defined(&DB_WRITEOPEN);
    eval 'sub DB_TXN_NOWAIT () {0x1000;}' unless defined(&DB_TXN_NOWAIT);
    eval 'sub DB_TXN_SYNC () {0x2000;}' unless defined(&DB_TXN_SYNC);
    eval 'sub DB_ENCRYPT_AES () {0x1;}' unless defined(&DB_ENCRYPT_AES);
    eval 'sub DB_CDB_ALLDB () {0x1000;}' unless defined(&DB_CDB_ALLDB);
    eval 'sub DB_DIRECT_DB () {0x2000;}' unless defined(&DB_DIRECT_DB);
    eval 'sub DB_DIRECT_LOG () {0x4000;}' unless defined(&DB_DIRECT_LOG);
    eval 'sub DB_LOG_AUTOREMOVE () {0x8000;}' unless defined(&DB_LOG_AUTOREMOVE);
    eval 'sub DB_NOLOCKING () {0x10000;}' unless defined(&DB_NOLOCKING);
    eval 'sub DB_NOPANIC () {0x20000;}' unless defined(&DB_NOPANIC);
    eval 'sub DB_OVERWRITE () {0x40000;}' unless defined(&DB_OVERWRITE);
    eval 'sub DB_PANIC_ENVIRONMENT () {0x80000;}' unless defined(&DB_PANIC_ENVIRONMENT);
    eval 'sub DB_REGION_INIT () {0x100000;}' unless defined(&DB_REGION_INIT);
    eval 'sub DB_TIME_NOTGRANTED () {0x200000;}' unless defined(&DB_TIME_NOTGRANTED);
    eval 'sub DB_TXN_WRITE_NOSYNC () {0x400000;}' unless defined(&DB_TXN_WRITE_NOSYNC);
    eval 'sub DB_YIELDCPU () {0x800000;}' unless defined(&DB_YIELDCPU);
    eval 'sub DB_UPGRADE () {0x1;}' unless defined(&DB_UPGRADE);
    eval 'sub DB_VERIFY () {0x2;}' unless defined(&DB_VERIFY);
    eval 'sub DB_DIRECT () {0x1000;}' unless defined(&DB_DIRECT);
    eval 'sub DB_EXTENT () {0x2000;}' unless defined(&DB_EXTENT);
    eval 'sub DB_ODDFILESIZE () {0x4000;}' unless defined(&DB_ODDFILESIZE);
    eval 'sub DB_CHKSUM () {0x1;}' unless defined(&DB_CHKSUM);
    eval 'sub DB_DUP () {0x2;}' unless defined(&DB_DUP);
    eval 'sub DB_DUPSORT () {0x4;}' unless defined(&DB_DUPSORT);
    eval 'sub DB_ENCRYPT () {0x8;}' unless defined(&DB_ENCRYPT);
    eval 'sub DB_RECNUM () {0x10;}' unless defined(&DB_RECNUM);
    eval 'sub DB_RENUMBER () {0x20;}' unless defined(&DB_RENUMBER);
    eval 'sub DB_REVSPLITOFF () {0x40;}' unless defined(&DB_REVSPLITOFF);
    eval 'sub DB_SNAPSHOT () {0x80;}' unless defined(&DB_SNAPSHOT);
    eval 'sub DB_STAT_CLEAR () {0x1;}' unless defined(&DB_STAT_CLEAR);
    eval 'sub DB_JOIN_NOSORT () {0x1;}' unless defined(&DB_JOIN_NOSORT);
    eval 'sub DB_AGGRESSIVE () {0x1;}' unless defined(&DB_AGGRESSIVE);
    eval 'sub DB_NOORDERCHK () {0x2;}' unless defined(&DB_NOORDERCHK);
    eval 'sub DB_ORDERCHKONLY () {0x4;}' unless defined(&DB_ORDERCHKONLY);
    eval 'sub DB_PR_PAGE () {0x8;}' unless defined(&DB_PR_PAGE);
    eval 'sub DB_PR_RECOVERYTEST () {0x10;}' unless defined(&DB_PR_RECOVERYTEST);
    eval 'sub DB_PRINTABLE () {0x20;}' unless defined(&DB_PRINTABLE);
    eval 'sub DB_SALVAGE () {0x40;}' unless defined(&DB_SALVAGE);
    eval 'sub DB_REP_NOBUFFER () {0x1;}' unless defined(&DB_REP_NOBUFFER);
    eval 'sub DB_REP_PERMANENT () {0x2;}' unless defined(&DB_REP_PERMANENT);
    eval 'sub DB_LOCKVERSION () {1;}' unless defined(&DB_LOCKVERSION);
    eval 'sub DB_FILE_ID_LEN () {20;}' unless defined(&DB_FILE_ID_LEN);
    eval 'sub DB_LOCK_NORUN () {0;}' unless defined(&DB_LOCK_NORUN);
    eval 'sub DB_LOCK_DEFAULT () {1;}' unless defined(&DB_LOCK_DEFAULT);
    eval 'sub DB_LOCK_EXPIRE () {2;}' unless defined(&DB_LOCK_EXPIRE);
    eval 'sub DB_LOCK_MAXLOCKS () {3;}' unless defined(&DB_LOCK_MAXLOCKS);
    eval 'sub DB_LOCK_MINLOCKS () {4;}' unless defined(&DB_LOCK_MINLOCKS);
    eval 'sub DB_LOCK_MINWRITE () {5;}' unless defined(&DB_LOCK_MINWRITE);
    eval 'sub DB_LOCK_OLDEST () {6;}' unless defined(&DB_LOCK_OLDEST);
    eval 'sub DB_LOCK_RANDOM () {7;}' unless defined(&DB_LOCK_RANDOM);
    eval 'sub DB_LOCK_YOUNGEST () {8;}' unless defined(&DB_LOCK_YOUNGEST);
    eval 'sub DB_LOCK_NOWAIT () {0x1;}' unless defined(&DB_LOCK_NOWAIT);
    eval 'sub DB_LOCK_RECORD () {0x2;}' unless defined(&DB_LOCK_RECORD);
    eval 'sub DB_LOCK_REMOVE () {0x4;}' unless defined(&DB_LOCK_REMOVE);
    eval 'sub DB_LOCK_SET_TIMEOUT () {0x8;}' unless defined(&DB_LOCK_SET_TIMEOUT);
    eval 'sub DB_LOCK_SWITCH () {0x10;}' unless defined(&DB_LOCK_SWITCH);
    eval 'sub DB_LOCK_UPGRADE () {0x20;}' unless defined(&DB_LOCK_UPGRADE);
    eval("sub DB_LOCK_NG () { 0; }") unless defined(&DB_LOCK_NG);
    eval("sub DB_LOCK_READ () { 1; }") unless defined(&DB_LOCK_READ);
    eval("sub DB_LOCK_WRITE () { 2; }") unless defined(&DB_LOCK_WRITE);
    eval("sub DB_LOCK_WAIT () { 3; }") unless defined(&DB_LOCK_WAIT);
    eval("sub DB_LOCK_IWRITE () { 4; }") unless defined(&DB_LOCK_IWRITE);
    eval("sub DB_LOCK_IREAD () { 5; }") unless defined(&DB_LOCK_IREAD);
    eval("sub DB_LOCK_IWR () { 6; }") unless defined(&DB_LOCK_IWR);
    eval("sub DB_LOCK_DIRTY () { 7; }") unless defined(&DB_LOCK_DIRTY);
    eval("sub DB_LOCK_WWRITE () { 8; }") unless defined(&DB_LOCK_WWRITE);
    eval("sub DB_LOCK_DUMP () { 0; }") unless defined(&DB_LOCK_DUMP);
    eval("sub DB_LOCK_GET () { 1; }") unless defined(&DB_LOCK_GET);
    eval("sub DB_LOCK_GET_TIMEOUT () { 2; }") unless defined(&DB_LOCK_GET_TIMEOUT);
    eval("sub DB_LOCK_INHERIT () { 3; }") unless defined(&DB_LOCK_INHERIT);
    eval("sub DB_LOCK_PUT () { 4; }") unless defined(&DB_LOCK_PUT);
    eval("sub DB_LOCK_PUT_ALL () { 5; }") unless defined(&DB_LOCK_PUT_ALL);
    eval("sub DB_LOCK_PUT_OBJ () { 6; }") unless defined(&DB_LOCK_PUT_OBJ);
    eval("sub DB_LOCK_PUT_READ () { 7; }") unless defined(&DB_LOCK_PUT_READ);
    eval("sub DB_LOCK_TIMEOUT () { 8; }") unless defined(&DB_LOCK_TIMEOUT);
    eval("sub DB_LOCK_TRADE () { 9; }") unless defined(&DB_LOCK_TRADE);
    eval("sub DB_LOCK_UPGRADE_WRITE () { 10; }") unless defined(&DB_LOCK_UPGRADE_WRITE);
    eval("sub DB_LSTAT_ABORTED () { 1; }") unless defined(&DB_LSTAT_ABORTED);
    eval("sub DB_LSTAT_ERR () { 2; }") unless defined(&DB_LSTAT_ERR);
    eval("sub DB_LSTAT_EXPIRED () { 3; }") unless defined(&DB_LSTAT_EXPIRED);
    eval("sub DB_LSTAT_FREE () { 4; }") unless defined(&DB_LSTAT_FREE);
    eval("sub DB_LSTAT_HELD () { 5; }") unless defined(&DB_LSTAT_HELD);
    eval("sub DB_LSTAT_NOTEXIST () { 6; }") unless defined(&DB_LSTAT_NOTEXIST);
    eval("sub DB_LSTAT_PENDING () { 7; }") unless defined(&DB_LSTAT_PENDING);
    eval("sub DB_LSTAT_WAITING () { 8; }") unless defined(&DB_LSTAT_WAITING);
    eval 'sub DB_HANDLE_LOCK () {1;}' unless defined(&DB_HANDLE_LOCK);
    eval 'sub DB_RECORD_LOCK () {2;}' unless defined(&DB_RECORD_LOCK);
    eval 'sub DB_PAGE_LOCK () {3;}' unless defined(&DB_PAGE_LOCK);
    eval 'sub DB_LOGVERSION () {8;}' unless defined(&DB_LOGVERSION);
    eval 'sub DB_LOGOLDVER () {8;}' unless defined(&DB_LOGOLDVER);
    eval 'sub DB_LOGMAGIC () {0x40988;}' unless defined(&DB_LOGMAGIC);
    eval 'sub DB_ARCH_ABS () {0x1;}' unless defined(&DB_ARCH_ABS);
    eval 'sub DB_ARCH_DATA () {0x2;}' unless defined(&DB_ARCH_DATA);
    eval 'sub DB_ARCH_LOG () {0x4;}' unless defined(&DB_ARCH_LOG);
    eval 'sub DB_ARCH_REMOVE () {0x8;}' unless defined(&DB_ARCH_REMOVE);
    eval 'sub DB_FLUSH () {0x1;}' unless defined(&DB_FLUSH);
    eval 'sub DB_LOG_CHKPNT () {0x2;}' unless defined(&DB_LOG_CHKPNT);
    eval 'sub DB_LOG_COMMIT () {0x4;}' unless defined(&DB_LOG_COMMIT);
    eval 'sub DB_LOG_NOCOPY () {0x8;}' unless defined(&DB_LOG_NOCOPY);
    eval 'sub DB_LOG_NOT_DURABLE () {0x10;}' unless defined(&DB_LOG_NOT_DURABLE);
    eval 'sub DB_LOG_PERM () {0x20;}' unless defined(&DB_LOG_PERM);
    eval 'sub DB_LOG_WRNOSYNC () {0x40;}' unless defined(&DB_LOG_WRNOSYNC);
    eval 'sub DB_user_BEGIN () {10000;}' unless defined(&DB_user_BEGIN);
    eval 'sub DB_debug_FLAG () {0x80000000;}' unless defined(&DB_debug_FLAG);
    eval 'sub DB_LOGC_BUF_SIZE () {(32* 1024);}' unless defined(&DB_LOGC_BUF_SIZE);
    eval 'sub DB_LOG_DISK () {0x1;}' unless defined(&DB_LOG_DISK);
    eval 'sub DB_LOG_LOCKED () {0x2;}' unless defined(&DB_LOG_LOCKED);
    eval 'sub DB_LOG_SILENT_ERR () {0x4;}' unless defined(&DB_LOG_SILENT_ERR);
    eval 'sub DB_MPOOL_CREATE () {0x1;}' unless defined(&DB_MPOOL_CREATE);
    eval 'sub DB_MPOOL_LAST () {0x2;}' unless defined(&DB_MPOOL_LAST);
    eval 'sub DB_MPOOL_NEW () {0x4;}' unless defined(&DB_MPOOL_NEW);
    eval 'sub DB_MPOOL_CLEAN () {0x1;}' unless defined(&DB_MPOOL_CLEAN);
    eval 'sub DB_MPOOL_DIRTY () {0x2;}' unless defined(&DB_MPOOL_DIRTY);
    eval 'sub DB_MPOOL_DISCARD () {0x4;}' unless defined(&DB_MPOOL_DISCARD);
    eval 'sub DB_MPOOL_NOFILE () {0x1;}' unless defined(&DB_MPOOL_NOFILE);
    eval 'sub DB_MPOOL_UNLINK () {0x2;}' unless defined(&DB_MPOOL_UNLINK);
    eval("sub DB_PRIORITY_VERY_LOW () { 1; }") unless defined(&DB_PRIORITY_VERY_LOW);
    eval("sub DB_PRIORITY_LOW () { 2; }") unless defined(&DB_PRIORITY_LOW);
    eval("sub DB_PRIORITY_DEFAULT () { 3; }") unless defined(&DB_PRIORITY_DEFAULT);
    eval("sub DB_PRIORITY_HIGH () { 4; }") unless defined(&DB_PRIORITY_HIGH);
    eval("sub DB_PRIORITY_VERY_HIGH () { 5; }") unless defined(&DB_PRIORITY_VERY_HIGH);
    eval 'sub MP_FILEID_SET () {0x1;}' unless defined(&MP_FILEID_SET);
    eval 'sub MP_FLUSH () {0x2;}' unless defined(&MP_FLUSH);
    eval 'sub MP_OPEN_CALLED () {0x4;}' unless defined(&MP_OPEN_CALLED);
    eval 'sub MP_READONLY () {0x8;}' unless defined(&MP_READONLY);
    eval 'sub DB_TXNVERSION () {1;}' unless defined(&DB_TXNVERSION);
    eval("sub DB_TXN_ABORT () { 0; }") unless defined(&DB_TXN_ABORT);
    eval("sub DB_TXN_APPLY () { 1; }") unless defined(&DB_TXN_APPLY);
    eval("sub DB_TXN_BACKWARD_ALLOC () { 2; }") unless defined(&DB_TXN_BACKWARD_ALLOC);
    eval("sub DB_TXN_BACKWARD_ROLL () { 3; }") unless defined(&DB_TXN_BACKWARD_ROLL);
    eval("sub DB_TXN_FORWARD_ROLL () { 4; }") unless defined(&DB_TXN_FORWARD_ROLL);
    eval("sub DB_TXN_GETPGNOS () { 5; }") unless defined(&DB_TXN_GETPGNOS);
    eval("sub DB_TXN_OPENFILES () { 6; }") unless defined(&DB_TXN_OPENFILES);
    eval("sub DB_TXN_POPENFILES () { 7; }") unless defined(&DB_TXN_POPENFILES);
    eval("sub DB_TXN_PRINT () { 8; }") unless defined(&DB_TXN_PRINT);
    eval 'sub DB_UNDO {
        my($op) = @_;
	    eval q((($op) ==  &DB_TXN_ABORT || ($op) ==  &DB_TXN_BACKWARD_ROLL || ($op) ==  &DB_TXN_BACKWARD_ALLOC));
    }' unless defined(&DB_UNDO);
    eval 'sub DB_REDO {
        my($op) = @_;
	    eval q((($op) ==  &DB_TXN_FORWARD_ROLL || ($op) ==  &DB_TXN_APPLY));
    }' unless defined(&DB_REDO);
    eval 'sub TXN_CHILDCOMMIT () {0x1;}' unless defined(&TXN_CHILDCOMMIT);
    eval 'sub TXN_COMPENSATE () {0x2;}' unless defined(&TXN_COMPENSATE);
    eval 'sub TXN_DIRTY_READ () {0x4;}' unless defined(&TXN_DIRTY_READ);
    eval 'sub TXN_LOCKTIMEOUT () {0x8;}' unless defined(&TXN_LOCKTIMEOUT);
    eval 'sub TXN_MALLOC () {0x10;}' unless defined(&TXN_MALLOC);
    eval 'sub TXN_NOSYNC () {0x20;}' unless defined(&TXN_NOSYNC);
    eval 'sub TXN_NOWAIT () {0x40;}' unless defined(&TXN_NOWAIT);
    eval 'sub TXN_RESTORED () {0x80;}' unless defined(&TXN_RESTORED);
    eval 'sub TXN_SYNC () {0x100;}' unless defined(&TXN_SYNC);
    eval 'sub DB_XIDDATASIZE () {128;}' unless defined(&DB_XIDDATASIZE);
    eval 'sub DB_EID_BROADCAST () {-1;}' unless defined(&DB_EID_BROADCAST);
    eval 'sub DB_EID_INVALID () {-2;}' unless defined(&DB_EID_INVALID);
    eval 'sub DB_REP_CLIENT () {0x1;}' unless defined(&DB_REP_CLIENT);
    eval 'sub DB_REP_LOGSONLY () {0x2;}' unless defined(&DB_REP_LOGSONLY);
    eval 'sub DB_REP_MASTER () {0x4;}' unless defined(&DB_REP_MASTER);
    eval("sub DB_BTREE () { 1; }") unless defined(&DB_BTREE);
    eval("sub DB_HASH () { 2; }") unless defined(&DB_HASH);
    eval("sub DB_RECNO () { 3; }") unless defined(&DB_RECNO);
    eval("sub DB_QUEUE () { 4; }") unless defined(&DB_QUEUE);
    eval("sub DB_UNKNOWN () { 5; }") unless defined(&DB_UNKNOWN);
    eval 'sub DB_RENAMEMAGIC () {0x30800;}' unless defined(&DB_RENAMEMAGIC);
    eval 'sub DB_BTREEVERSION () {9;}' unless defined(&DB_BTREEVERSION);
    eval 'sub DB_BTREEOLDVER () {8;}' unless defined(&DB_BTREEOLDVER);
    eval 'sub DB_BTREEMAGIC () {0x53162;}' unless defined(&DB_BTREEMAGIC);
    eval 'sub DB_HASHVERSION () {8;}' unless defined(&DB_HASHVERSION);
    eval 'sub DB_HASHOLDVER () {7;}' unless defined(&DB_HASHOLDVER);
    eval 'sub DB_HASHMAGIC () {0x61561;}' unless defined(&DB_HASHMAGIC);
    eval 'sub DB_QAMVERSION () {4;}' unless defined(&DB_QAMVERSION);
    eval 'sub DB_QAMOLDVER () {3;}' unless defined(&DB_QAMOLDVER);
    eval 'sub DB_QAMMAGIC () {0x42253;}' unless defined(&DB_QAMMAGIC);
    eval 'sub DB_AFTER () {1;}' unless defined(&DB_AFTER);
    eval 'sub DB_APPEND () {2;}' unless defined(&DB_APPEND);
    eval 'sub DB_BEFORE () {3;}' unless defined(&DB_BEFORE);
    eval 'sub DB_CACHED_COUNTS () {4;}' unless defined(&DB_CACHED_COUNTS);
    eval 'sub DB_CONSUME () {5;}' unless defined(&DB_CONSUME);
    eval 'sub DB_CONSUME_WAIT () {6;}' unless defined(&DB_CONSUME_WAIT);
    eval 'sub DB_CURRENT () {7;}' unless defined(&DB_CURRENT);
    eval 'sub DB_FAST_STAT () {8;}' unless defined(&DB_FAST_STAT);
    eval 'sub DB_FIRST () {9;}' unless defined(&DB_FIRST);
    eval 'sub DB_GET_BOTH () {10;}' unless defined(&DB_GET_BOTH);
    eval 'sub DB_GET_BOTHC () {11;}' unless defined(&DB_GET_BOTHC);
    eval 'sub DB_GET_BOTH_RANGE () {12;}' unless defined(&DB_GET_BOTH_RANGE);
    eval 'sub DB_GET_RECNO () {13;}' unless defined(&DB_GET_RECNO);
    eval 'sub DB_JOIN_ITEM () {14;}' unless defined(&DB_JOIN_ITEM);
    eval 'sub DB_KEYFIRST () {15;}' unless defined(&DB_KEYFIRST);
    eval 'sub DB_KEYLAST () {16;}' unless defined(&DB_KEYLAST);
    eval 'sub DB_LAST () {17;}' unless defined(&DB_LAST);
    eval 'sub DB_NEXT () {18;}' unless defined(&DB_NEXT);
    eval 'sub DB_NEXT_DUP () {19;}' unless defined(&DB_NEXT_DUP);
    eval 'sub DB_NEXT_NODUP () {20;}' unless defined(&DB_NEXT_NODUP);
    eval 'sub DB_NODUPDATA () {21;}' unless defined(&DB_NODUPDATA);
    eval 'sub DB_NOOVERWRITE () {22;}' unless defined(&DB_NOOVERWRITE);
    eval 'sub DB_NOSYNC () {23;}' unless defined(&DB_NOSYNC);
    eval 'sub DB_POSITION () {24;}' unless defined(&DB_POSITION);
    eval 'sub DB_PREV () {25;}' unless defined(&DB_PREV);
    eval 'sub DB_PREV_NODUP () {26;}' unless defined(&DB_PREV_NODUP);
    eval 'sub DB_RECORDCOUNT () {27;}' unless defined(&DB_RECORDCOUNT);
    eval 'sub DB_SET () {28;}' unless defined(&DB_SET);
    eval 'sub DB_SET_LOCK_TIMEOUT () {29;}' unless defined(&DB_SET_LOCK_TIMEOUT);
    eval 'sub DB_SET_RANGE () {30;}' unless defined(&DB_SET_RANGE);
    eval 'sub DB_SET_RECNO () {31;}' unless defined(&DB_SET_RECNO);
    eval 'sub DB_SET_TXN_NOW () {32;}' unless defined(&DB_SET_TXN_NOW);
    eval 'sub DB_SET_TXN_TIMEOUT () {33;}' unless defined(&DB_SET_TXN_TIMEOUT);
    eval 'sub DB_UPDATE_SECONDARY () {34;}' unless defined(&DB_UPDATE_SECONDARY);
    eval 'sub DB_WRITECURSOR () {35;}' unless defined(&DB_WRITECURSOR);
    eval 'sub DB_WRITELOCK () {36;}' unless defined(&DB_WRITELOCK);
    eval 'sub DB_OPFLAGS_MASK () {0xff;}' unless defined(&DB_OPFLAGS_MASK);
    eval 'sub DB_MULTIPLE () {0x4000000;}' unless defined(&DB_MULTIPLE);
    eval 'sub DB_MULTIPLE_KEY () {0x8000000;}' unless defined(&DB_MULTIPLE_KEY);
    eval 'sub DB_RMW () {0x10000000;}' unless defined(&DB_RMW);
    eval 'sub DB_DONOTINDEX () {(-30999);}' unless defined(&DB_DONOTINDEX);
    eval 'sub DB_FILEOPEN () {(-30998);}' unless defined(&DB_FILEOPEN);
    eval 'sub DB_KEYEMPTY () {(-30997);}' unless defined(&DB_KEYEMPTY);
    eval 'sub DB_KEYEXIST () {(-30996);}' unless defined(&DB_KEYEXIST);
    eval 'sub DB_LOCK_DEADLOCK () {(-30995);}' unless defined(&DB_LOCK_DEADLOCK);
    eval 'sub DB_LOCK_NOTGRANTED () {(-30994);}' unless defined(&DB_LOCK_NOTGRANTED);
    eval 'sub DB_NOSERVER () {(-30993);}' unless defined(&DB_NOSERVER);
    eval 'sub DB_NOSERVER_HOME () {(-30992);}' unless defined(&DB_NOSERVER_HOME);
    eval 'sub DB_NOSERVER_ID () {(-30991);}' unless defined(&DB_NOSERVER_ID);
    eval 'sub DB_NOTFOUND () {(-30990);}' unless defined(&DB_NOTFOUND);
    eval 'sub DB_OLD_VERSION () {(-30989);}' unless defined(&DB_OLD_VERSION);
    eval 'sub DB_PAGE_NOTFOUND () {(-30988);}' unless defined(&DB_PAGE_NOTFOUND);
    eval 'sub DB_REP_DUPMASTER () {(-30987);}' unless defined(&DB_REP_DUPMASTER);
    eval 'sub DB_REP_HANDLE_DEAD () {(-30986);}' unless defined(&DB_REP_HANDLE_DEAD);
    eval 'sub DB_REP_HOLDELECTION () {(-30985);}' unless defined(&DB_REP_HOLDELECTION);
    eval 'sub DB_REP_ISPERM () {(-30984);}' unless defined(&DB_REP_ISPERM);
    eval 'sub DB_REP_NEWMASTER () {(-30983);}' unless defined(&DB_REP_NEWMASTER);
    eval 'sub DB_REP_NEWSITE () {(-30982);}' unless defined(&DB_REP_NEWSITE);
    eval 'sub DB_REP_NOTPERM () {(-30981);}' unless defined(&DB_REP_NOTPERM);
    eval 'sub DB_REP_OUTDATED () {(-30980);}' unless defined(&DB_REP_OUTDATED);
    eval 'sub DB_REP_UNAVAIL () {(-30979);}' unless defined(&DB_REP_UNAVAIL);
    eval 'sub DB_RUNRECOVERY () {(-30978);}' unless defined(&DB_RUNRECOVERY);
    eval 'sub DB_SECONDARY_BAD () {(-30977);}' unless defined(&DB_SECONDARY_BAD);
    eval 'sub DB_VERIFY_BAD () {(-30976);}' unless defined(&DB_VERIFY_BAD);
    eval 'sub DB_ALREADY_ABORTED () {(-30899);}' unless defined(&DB_ALREADY_ABORTED);
    eval 'sub DB_DELETED () {(-30898);}' unless defined(&DB_DELETED);
    eval 'sub DB_LOCK_NOTEXIST () {(-30897);}' unless defined(&DB_LOCK_NOTEXIST);
    eval 'sub DB_NEEDSPLIT () {(-30896);}' unless defined(&DB_NEEDSPLIT);
    eval 'sub DB_SURPRISE_KID () {(-30895);}' unless defined(&DB_SURPRISE_KID);
    eval 'sub DB_SWAPBYTES () {(-30894);}' unless defined(&DB_SWAPBYTES);
    eval 'sub DB_TIMEOUT () {(-30893);}' unless defined(&DB_TIMEOUT);
    eval 'sub DB_TXN_CKP () {(-30892);}' unless defined(&DB_TXN_CKP);
    eval 'sub DB_VERIFY_FATAL () {(-30891);}' unless defined(&DB_VERIFY_FATAL);
    eval 'sub DB_LOGFILEID_INVALID () {-1;}' unless defined(&DB_LOGFILEID_INVALID);
    eval 'sub DB_OK_BTREE () {0x1;}' unless defined(&DB_OK_BTREE);
    eval 'sub DB_OK_HASH () {0x2;}' unless defined(&DB_OK_HASH);
    eval 'sub DB_OK_QUEUE () {0x4;}' unless defined(&DB_OK_QUEUE);
    eval 'sub DB_OK_RECNO () {0x8;}' unless defined(&DB_OK_RECNO);
    eval 'sub DB_AM_CHKSUM () {0x1;}' unless defined(&DB_AM_CHKSUM);
    eval 'sub DB_AM_CL_WRITER () {0x2;}' unless defined(&DB_AM_CL_WRITER);
    eval 'sub DB_AM_COMPENSATE () {0x4;}' unless defined(&DB_AM_COMPENSATE);
    eval 'sub DB_AM_CREATED () {0x8;}' unless defined(&DB_AM_CREATED);
    eval 'sub DB_AM_CREATED_MSTR () {0x10;}' unless defined(&DB_AM_CREATED_MSTR);
    eval 'sub DB_AM_DBM_ERROR () {0x20;}' unless defined(&DB_AM_DBM_ERROR);
    eval 'sub DB_AM_DELIMITER () {0x40;}' unless defined(&DB_AM_DELIMITER);
    eval 'sub DB_AM_DIRTY () {0x80;}' unless defined(&DB_AM_DIRTY);
    eval 'sub DB_AM_DISCARD () {0x100;}' unless defined(&DB_AM_DISCARD);
    eval 'sub DB_AM_DUP () {0x200;}' unless defined(&DB_AM_DUP);
    eval 'sub DB_AM_DUPSORT () {0x400;}' unless defined(&DB_AM_DUPSORT);
    eval 'sub DB_AM_ENCRYPT () {0x800;}' unless defined(&DB_AM_ENCRYPT);
    eval 'sub DB_AM_FIXEDLEN () {0x1000;}' unless defined(&DB_AM_FIXEDLEN);
    eval 'sub DB_AM_INMEM () {0x2000;}' unless defined(&DB_AM_INMEM);
    eval 'sub DB_AM_IN_RENAME () {0x4000;}' unless defined(&DB_AM_IN_RENAME);
    eval 'sub DB_AM_NOT_DURABLE () {0x8000;}' unless defined(&DB_AM_NOT_DURABLE);
    eval 'sub DB_AM_OPEN_CALLED () {0x10000;}' unless defined(&DB_AM_OPEN_CALLED);
    eval 'sub DB_AM_PAD () {0x20000;}' unless defined(&DB_AM_PAD);
    eval 'sub DB_AM_PGDEF () {0x40000;}' unless defined(&DB_AM_PGDEF);
    eval 'sub DB_AM_RDONLY () {0x80000;}' unless defined(&DB_AM_RDONLY);
    eval 'sub DB_AM_RECNUM () {0x100000;}' unless defined(&DB_AM_RECNUM);
    eval 'sub DB_AM_RECOVER () {0x200000;}' unless defined(&DB_AM_RECOVER);
    eval 'sub DB_AM_RENUMBER () {0x400000;}' unless defined(&DB_AM_RENUMBER);
    eval 'sub DB_AM_REPLICATION () {0x800000;}' unless defined(&DB_AM_REPLICATION);
    eval 'sub DB_AM_REVSPLITOFF () {0x1000000;}' unless defined(&DB_AM_REVSPLITOFF);
    eval 'sub DB_AM_SECONDARY () {0x2000000;}' unless defined(&DB_AM_SECONDARY);
    eval 'sub DB_AM_SNAPSHOT () {0x4000000;}' unless defined(&DB_AM_SNAPSHOT);
    eval 'sub DB_AM_SUBDB () {0x8000000;}' unless defined(&DB_AM_SUBDB);
    eval 'sub DB_AM_SWAP () {0x10000000;}' unless defined(&DB_AM_SWAP);
    eval 'sub DB_AM_TXN () {0x20000000;}' unless defined(&DB_AM_TXN);
    eval 'sub DB_AM_VERIFYING () {0x40000000;}' unless defined(&DB_AM_VERIFYING);
    eval 'sub DB_MULTIPLE_INIT {
        my($pointer, $dbt) = @_;
	    eval q(($pointer = ( &u_int8_t *)($dbt)-> &data + ($dbt)-> &ulen - $sizeof{ &u_int32_t}));
    }' unless defined(&DB_MULTIPLE_INIT);
    eval 'sub DB_MULTIPLE_NEXT {
        my($pointer, $dbt, $retdata, $retdlen) = @_;
	    eval q( &do {  &if (*(( &u_int32_t *)($pointer)) == ( &u_int32_t)-1) { $retdata =  &NULL; $pointer =  &NULL;  &break; } $retdata = ( &u_int8_t *) ($dbt)-> &data + *( &u_int32_t *)($pointer); ($pointer) = ( &u_int32_t *)($pointer) - 1; $retdlen = *( &u_int32_t *)($pointer); ($pointer) = ( &u_int32_t *)($pointer) - 1;  &if ($retdlen == 0 && $retdata == ( &u_int8_t *)($dbt)-> &data) $retdata =  &NULL; }  &while (0));
    }' unless defined(&DB_MULTIPLE_NEXT);
    eval 'sub DB_MULTIPLE_KEY_NEXT {
        my($pointer, $dbt, $retkey, $retklen, $retdata, $retdlen) = @_;
	    eval q( &do {  &if (*(( &u_int32_t *)($pointer)) == ( &u_int32_t)-1) { $retdata =  &NULL; $retkey =  &NULL; $pointer =  &NULL;  &break; } $retkey = ( &u_int8_t *) ($dbt)-> &data + *( &u_int32_t *)($pointer); ($pointer) = ( &u_int32_t *)($pointer) - 1; $retklen = *( &u_int32_t *)($pointer); ($pointer) = ( &u_int32_t *)($pointer) - 1; $retdata = ( &u_int8_t *) ($dbt)-> &data + *( &u_int32_t *)($pointer); ($pointer) = ( &u_int32_t *)($pointer) - 1; $retdlen = *( &u_int32_t *)($pointer); ($pointer) = ( &u_int32_t *)($pointer) - 1; }  &while (0));
    }' unless defined(&DB_MULTIPLE_KEY_NEXT);
    eval 'sub DB_MULTIPLE_RECNO_NEXT {
        my($pointer, $dbt, $recno, $retdata, $retdlen) = @_;
	    eval q( &do {  &if (*(( &u_int32_t *)($pointer)) == ( &u_int32_t)0) { $recno = 0; $retdata =  &NULL; $pointer =  &NULL;  &break; } $recno = *( &u_int32_t *)($pointer); ($pointer) = ( &u_int32_t *)($pointer) - 1; $retdata = ( &u_int8_t *) ($dbt)-> &data + *( &u_int32_t *)($pointer); ($pointer) = ( &u_int32_t *)($pointer) - 1; $retdlen = *( &u_int32_t *)($pointer); ($pointer) = ( &u_int32_t *)($pointer) - 1; }  &while (0));
    }' unless defined(&DB_MULTIPLE_RECNO_NEXT);
    eval 'sub DBC_ACTIVE () {0x1;}' unless defined(&DBC_ACTIVE);
    eval 'sub DBC_COMPENSATE () {0x2;}' unless defined(&DBC_COMPENSATE);
    eval 'sub DBC_DIRTY_READ () {0x4;}' unless defined(&DBC_DIRTY_READ);
    eval 'sub DBC_OPD () {0x8;}' unless defined(&DBC_OPD);
    eval 'sub DBC_RECOVER () {0x10;}' unless defined(&DBC_RECOVER);
    eval 'sub DBC_RMW () {0x20;}' unless defined(&DBC_RMW);
    eval 'sub DBC_TRANSIENT () {0x40;}' unless defined(&DBC_TRANSIENT);
    eval 'sub DBC_WRITECURSOR () {0x80;}' unless defined(&DBC_WRITECURSOR);
    eval 'sub DBC_WRITER () {0x100;}' unless defined(&DBC_WRITER);
    eval 'sub DBC_MULTIPLE () {0x200;}' unless defined(&DBC_MULTIPLE);
    eval 'sub DBC_MULTIPLE_KEY () {0x400;}' unless defined(&DBC_MULTIPLE_KEY);
    eval 'sub DBC_OWN_LID () {0x800;}' unless defined(&DBC_OWN_LID);
    eval 'sub DB_REGION_MAGIC () {0x120897;}' unless defined(&DB_REGION_MAGIC);
    eval 'sub DB_VERB_CHKPOINT () {0x1;}' unless defined(&DB_VERB_CHKPOINT);
    eval 'sub DB_VERB_DEADLOCK () {0x2;}' unless defined(&DB_VERB_DEADLOCK);
    eval 'sub DB_VERB_RECOVERY () {0x4;}' unless defined(&DB_VERB_RECOVERY);
    eval 'sub DB_VERB_REPLICATION () {0x8;}' unless defined(&DB_VERB_REPLICATION);
    eval 'sub DB_VERB_WAITSFOR () {0x10;}' unless defined(&DB_VERB_WAITSFOR);
    eval 'sub DB_TEST_ELECTINIT () {1;}' unless defined(&DB_TEST_ELECTINIT);
    eval 'sub DB_TEST_POSTDESTROY () {2;}' unless defined(&DB_TEST_POSTDESTROY);
    eval 'sub DB_TEST_POSTLOG () {3;}' unless defined(&DB_TEST_POSTLOG);
    eval 'sub DB_TEST_POSTLOGMETA () {4;}' unless defined(&DB_TEST_POSTLOGMETA);
    eval 'sub DB_TEST_POSTOPEN () {5;}' unless defined(&DB_TEST_POSTOPEN);
    eval 'sub DB_TEST_POSTSYNC () {6;}' unless defined(&DB_TEST_POSTSYNC);
    eval 'sub DB_TEST_PREDESTROY () {7;}' unless defined(&DB_TEST_PREDESTROY);
    eval 'sub DB_TEST_PREOPEN () {8;}' unless defined(&DB_TEST_PREOPEN);
    eval 'sub DB_TEST_SUBDB_LOCKS () {9;}' unless defined(&DB_TEST_SUBDB_LOCKS);
    eval 'sub DB_ENV_AUTO_COMMIT () {0x1;}' unless defined(&DB_ENV_AUTO_COMMIT);
    eval 'sub DB_ENV_CDB () {0x2;}' unless defined(&DB_ENV_CDB);
    eval 'sub DB_ENV_CDB_ALLDB () {0x4;}' unless defined(&DB_ENV_CDB_ALLDB);
    eval 'sub DB_ENV_CREATE () {0x8;}' unless defined(&DB_ENV_CREATE);
    eval 'sub DB_ENV_DBLOCAL () {0x10;}' unless defined(&DB_ENV_DBLOCAL);
    eval 'sub DB_ENV_DIRECT_DB () {0x20;}' unless defined(&DB_ENV_DIRECT_DB);
    eval 'sub DB_ENV_DIRECT_LOG () {0x40;}' unless defined(&DB_ENV_DIRECT_LOG);
    eval 'sub DB_ENV_FATAL () {0x80;}' unless defined(&DB_ENV_FATAL);
    eval 'sub DB_ENV_LOCKDOWN () {0x100;}' unless defined(&DB_ENV_LOCKDOWN);
    eval 'sub DB_ENV_LOG_AUTOREMOVE () {0x200;}' unless defined(&DB_ENV_LOG_AUTOREMOVE);
    eval 'sub DB_ENV_NOLOCKING () {0x400;}' unless defined(&DB_ENV_NOLOCKING);
    eval 'sub DB_ENV_NOMMAP () {0x800;}' unless defined(&DB_ENV_NOMMAP);
    eval 'sub DB_ENV_NOPANIC () {0x1000;}' unless defined(&DB_ENV_NOPANIC);
    eval 'sub DB_ENV_OPEN_CALLED () {0x2000;}' unless defined(&DB_ENV_OPEN_CALLED);
    eval 'sub DB_ENV_OVERWRITE () {0x4000;}' unless defined(&DB_ENV_OVERWRITE);
    eval 'sub DB_ENV_PRIVATE () {0x8000;}' unless defined(&DB_ENV_PRIVATE);
    eval 'sub DB_ENV_REGION_INIT () {0x10000;}' unless defined(&DB_ENV_REGION_INIT);
    eval 'sub DB_ENV_RPCCLIENT () {0x20000;}' unless defined(&DB_ENV_RPCCLIENT);
    eval 'sub DB_ENV_RPCCLIENT_GIVEN () {0x40000;}' unless defined(&DB_ENV_RPCCLIENT_GIVEN);
    eval 'sub DB_ENV_SYSTEM_MEM () {0x80000;}' unless defined(&DB_ENV_SYSTEM_MEM);
    eval 'sub DB_ENV_THREAD () {0x100000;}' unless defined(&DB_ENV_THREAD);
    eval 'sub DB_ENV_TIME_NOTGRANTED () {0x200000;}' unless defined(&DB_ENV_TIME_NOTGRANTED);
    eval 'sub DB_ENV_TXN_NOSYNC () {0x400000;}' unless defined(&DB_ENV_TXN_NOSYNC);
    eval 'sub DB_ENV_TXN_NOT_DURABLE () {0x800000;}' unless defined(&DB_ENV_TXN_NOT_DURABLE);
    eval 'sub DB_ENV_TXN_WRITE_NOSYNC () {0x1000000;}' unless defined(&DB_ENV_TXN_WRITE_NOSYNC);
    eval 'sub DB_ENV_YIELDCPU () {0x2000000;}' unless defined(&DB_ENV_YIELDCPU);
    unless(defined(&DB_DBM_HSEARCH)) {
	eval 'sub DB_DBM_HSEARCH () {0;}' unless defined(&DB_DBM_HSEARCH);
    }
    if((defined(&DB_DBM_HSEARCH) ? &DB_DBM_HSEARCH : 0) != 0) {
	eval 'sub DBM_INSERT () {0;}' unless defined(&DBM_INSERT);
	eval 'sub DBM_REPLACE () {1;}' unless defined(&DBM_REPLACE);
	eval 'sub DBM_SUFFIX () {".db";}' unless defined(&DBM_SUFFIX);
	if(defined( &_XPG4_2)) {
	} else {
	}
	eval 'sub dbm_clearerr {
	    my($a) = @_;
    	    eval q( &__db_ndbm_clearerr_rpmdb($a));
	}' unless defined(&dbm_clearerr);
	eval 'sub dbm_close {
	    my($a) = @_;
    	    eval q( &__db_ndbm_close_rpmdb($a));
	}' unless defined(&dbm_close);
	eval 'sub dbm_delete {
	    my($a, $b) = @_;
    	    eval q( &__db_ndbm_delete_rpmdb($a, $b));
	}' unless defined(&dbm_delete);
	eval 'sub dbm_dirfno {
	    my($a) = @_;
    	    eval q( &__db_ndbm_dirfno_rpmdb($a));
	}' unless defined(&dbm_dirfno);
	eval 'sub dbm_error {
	    my($a) = @_;
    	    eval q( &__db_ndbm_error_rpmdb($a));
	}' unless defined(&dbm_error);
	eval 'sub dbm_fetch {
	    my($a, $b) = @_;
    	    eval q( &__db_ndbm_fetch_rpmdb($a, $b));
	}' unless defined(&dbm_fetch);
	eval 'sub dbm_firstkey {
	    my($a) = @_;
    	    eval q( &__db_ndbm_firstkey_rpmdb($a));
	}' unless defined(&dbm_firstkey);
	eval 'sub dbm_nextkey {
	    my($a) = @_;
    	    eval q( &__db_ndbm_nextkey_rpmdb($a));
	}' unless defined(&dbm_nextkey);
	eval 'sub dbm_open {
	    my($a, $b, $c) = @_;
    	    eval q( &__db_ndbm_open_rpmdb($a, $b, $c));
	}' unless defined(&dbm_open);
	eval 'sub dbm_pagfno {
	    my($a) = @_;
    	    eval q( &__db_ndbm_pagfno_rpmdb($a));
	}' unless defined(&dbm_pagfno);
	eval 'sub dbm_rdonly {
	    my($a) = @_;
    	    eval q( &__db_ndbm_rdonly_rpmdb($a));
	}' unless defined(&dbm_rdonly);
	eval 'sub dbm_store {
	    my($a, $b, $c, $d) = @_;
    	    eval q( &__db_ndbm_store_rpmdb($a, $b, $c, $d));
	}' unless defined(&dbm_store);
	eval 'sub dbminit {
	    my($a) = @_;
    	    eval q( &__db_dbm_init_rpmdb($a));
	}' unless defined(&dbminit);
	eval 'sub dbmclose () { &__db_dbm_close_rpmdb;}' unless defined(&dbmclose);
	if(!defined( &__cplusplus)) {
	    eval 'sub delete {
	        my($a) = @_;
    		eval q( &__db_dbm_delete_rpmdb($a));
	    }' unless defined(&delete);
	}
	eval 'sub fetch {
	    my($a) = @_;
    	    eval q( &__db_dbm_fetch_rpmdb($a));
	}' unless defined(&fetch);
	eval 'sub firstkey () { &__db_dbm_firstkey_rpmdb;}' unless defined(&firstkey);
	eval 'sub nextkey {
	    my($a) = @_;
    	    eval q( &__db_dbm_nextkey_rpmdb($a));
	}' unless defined(&nextkey);
	eval 'sub store {
	    my($a, $b) = @_;
    	    eval q( &__db_dbm_store_rpmdb($a, $b));
	}' unless defined(&store);
	eval("sub FIND () { 0; }") unless defined(&FIND);
	eval("sub ENTER () { 1; }") unless defined(&ENTER);
	eval 'sub hcreate {
	    my($a) = @_;
    	    eval q( &__db_hcreate_rpmdb($a));
	}' unless defined(&hcreate);
	eval 'sub hdestroy () { &__db_hdestroy_rpmdb;}' unless defined(&hdestroy);
	eval 'sub hsearch {
	    my($a, $b) = @_;
    	    eval q( &__db_hsearch_rpmdb($a, $b));
	}' unless defined(&hsearch);
    }
    if(defined( &__cplusplus)) {
    }
}
unless(defined(&DB_RPC_SERVERPROG)) {
    sub DB_RPC_SERVERPROG () {	((351457));}
}
unless(defined(&DB_RPC_SERVERVERS)) {
    sub DB_RPC_SERVERVERS () {	((4002));}
}
unless(defined(&_DB_EXT_DEF_IN_)) {
    eval 'sub _DB_EXT_DEF_IN_ () {1;}' unless defined(&_DB_EXT_DEF_IN_);
    eval 'sub db_create () { &db_create_rpmdb;}' unless defined(&db_create);
    eval 'sub db_strerror () { &db_strerror_rpmdb;}' unless defined(&db_strerror);
    eval 'sub db_env_create () { &db_env_create_rpmdb;}' unless defined(&db_env_create);
    eval 'sub db_version () { &db_version_rpmdb;}' unless defined(&db_version);
    eval 'sub log_compare () { &log_compare_rpmdb;}' unless defined(&log_compare);
    eval 'sub db_env_set_func_close () { &db_env_set_func_close_rpmdb;}' unless defined(&db_env_set_func_close);
    eval 'sub db_env_set_func_dirfree () { &db_env_set_func_dirfree_rpmdb;}' unless defined(&db_env_set_func_dirfree);
    eval 'sub db_env_set_func_dirlist () { &db_env_set_func_dirlist_rpmdb;}' unless defined(&db_env_set_func_dirlist);
    eval 'sub db_env_set_func_exists () { &db_env_set_func_exists_rpmdb;}' unless defined(&db_env_set_func_exists);
    eval 'sub db_env_set_func_free () { &db_env_set_func_free_rpmdb;}' unless defined(&db_env_set_func_free);
    eval 'sub db_env_set_func_fsync () { &db_env_set_func_fsync_rpmdb;}' unless defined(&db_env_set_func_fsync);
    eval 'sub db_env_set_func_ioinfo () { &db_env_set_func_ioinfo_rpmdb;}' unless defined(&db_env_set_func_ioinfo);
    eval 'sub db_env_set_func_malloc () { &db_env_set_func_malloc_rpmdb;}' unless defined(&db_env_set_func_malloc);
    eval 'sub db_env_set_func_map () { &db_env_set_func_map_rpmdb;}' unless defined(&db_env_set_func_map);
    eval 'sub db_env_set_func_open () { &db_env_set_func_open_rpmdb;}' unless defined(&db_env_set_func_open);
    eval 'sub db_env_set_func_read () { &db_env_set_func_read_rpmdb;}' unless defined(&db_env_set_func_read);
    eval 'sub db_env_set_func_realloc () { &db_env_set_func_realloc_rpmdb;}' unless defined(&db_env_set_func_realloc);
    eval 'sub db_env_set_func_rename () { &db_env_set_func_rename_rpmdb;}' unless defined(&db_env_set_func_rename);
    eval 'sub db_env_set_func_seek () { &db_env_set_func_seek_rpmdb;}' unless defined(&db_env_set_func_seek);
    eval 'sub db_env_set_func_sleep () { &db_env_set_func_sleep_rpmdb;}' unless defined(&db_env_set_func_sleep);
    eval 'sub db_env_set_func_unlink () { &db_env_set_func_unlink_rpmdb;}' unless defined(&db_env_set_func_unlink);
    eval 'sub db_env_set_func_unmap () { &db_env_set_func_unmap_rpmdb;}' unless defined(&db_env_set_func_unmap);
    eval 'sub db_env_set_func_write () { &db_env_set_func_write_rpmdb;}' unless defined(&db_env_set_func_write);
    eval 'sub db_env_set_func_yield () { &db_env_set_func_yield_rpmdb;}' unless defined(&db_env_set_func_yield);
    if((defined(&DB_DBM_HSEARCH) ? &DB_DBM_HSEARCH : 0) != 0) {
	eval 'sub __db_ndbm_clearerr () { &__db_ndbm_clearerr_rpmdb;}' unless defined(&__db_ndbm_clearerr);
	eval 'sub __db_ndbm_close () { &__db_ndbm_close_rpmdb;}' unless defined(&__db_ndbm_close);
	eval 'sub __db_ndbm_delete () { &__db_ndbm_delete_rpmdb;}' unless defined(&__db_ndbm_delete);
	eval 'sub __db_ndbm_dirfno () { &__db_ndbm_dirfno_rpmdb;}' unless defined(&__db_ndbm_dirfno);
	eval 'sub __db_ndbm_error () { &__db_ndbm_error_rpmdb;}' unless defined(&__db_ndbm_error);
	eval 'sub __db_ndbm_fetch () { &__db_ndbm_fetch_rpmdb;}' unless defined(&__db_ndbm_fetch);
	eval 'sub __db_ndbm_firstkey () { &__db_ndbm_firstkey_rpmdb;}' unless defined(&__db_ndbm_firstkey);
	eval 'sub __db_ndbm_nextkey () { &__db_ndbm_nextkey_rpmdb;}' unless defined(&__db_ndbm_nextkey);
	eval 'sub __db_ndbm_open () { &__db_ndbm_open_rpmdb;}' unless defined(&__db_ndbm_open);
	eval 'sub __db_ndbm_pagfno () { &__db_ndbm_pagfno_rpmdb;}' unless defined(&__db_ndbm_pagfno);
	eval 'sub __db_ndbm_rdonly () { &__db_ndbm_rdonly_rpmdb;}' unless defined(&__db_ndbm_rdonly);
	eval 'sub __db_ndbm_store () { &__db_ndbm_store_rpmdb;}' unless defined(&__db_ndbm_store);
	eval 'sub __db_dbm_close () { &__db_dbm_close_rpmdb;}' unless defined(&__db_dbm_close);
	eval 'sub __db_dbm_dbrdonly () { &__db_dbm_dbrdonly_rpmdb;}' unless defined(&__db_dbm_dbrdonly);
	eval 'sub __db_dbm_delete () { &__db_dbm_delete_rpmdb;}' unless defined(&__db_dbm_delete);
	eval 'sub __db_dbm_dirf () { &__db_dbm_dirf_rpmdb;}' unless defined(&__db_dbm_dirf);
	eval 'sub __db_dbm_fetch () { &__db_dbm_fetch_rpmdb;}' unless defined(&__db_dbm_fetch);
	eval 'sub __db_dbm_firstkey () { &__db_dbm_firstkey_rpmdb;}' unless defined(&__db_dbm_firstkey);
	eval 'sub __db_dbm_init () { &__db_dbm_init_rpmdb;}' unless defined(&__db_dbm_init);
	eval 'sub __db_dbm_nextkey () { &__db_dbm_nextkey_rpmdb;}' unless defined(&__db_dbm_nextkey);
	eval 'sub __db_dbm_pagf () { &__db_dbm_pagf_rpmdb;}' unless defined(&__db_dbm_pagf);
	eval 'sub __db_dbm_store () { &__db_dbm_store_rpmdb;}' unless defined(&__db_dbm_store);
    }
    if((defined(&DB_DBM_HSEARCH) ? &DB_DBM_HSEARCH : 0) != 0) {
	eval 'sub __db_hcreate () { &__db_hcreate_rpmdb;}' unless defined(&__db_hcreate);
	eval 'sub __db_hsearch () { &__db_hsearch_rpmdb;}' unless defined(&__db_hsearch);
	eval 'sub __db_hdestroy () { &__db_hdestroy_rpmdb;}' unless defined(&__db_hdestroy);
    }
    eval 'sub db_xa_switch () { &db_xa_switch_rpmdb;}' unless defined(&db_xa_switch);
}
unless(defined(&_DB_EXT_PROT_IN_)) {
    eval 'sub _DB_EXT_PROT_IN_ () {1;}' unless defined(&_DB_EXT_PROT_IN_);
    if(defined( &__cplusplus)) {
    }
    if((defined(&DB_DBM_HSEARCH) ? &DB_DBM_HSEARCH : 0) != 0) {
    }
    if((defined(&DB_DBM_HSEARCH) ? &DB_DBM_HSEARCH : 0) != 0) {
    }
    if(defined( &__cplusplus)) {
    }
}
1;
