.\"Generated by db2man.xsl. Don't modify this, modify the source.
.de Sh \" Subsection
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Ip \" List item
.br
.ie \\n(.$>=3 .ne \\$3
.el .ne 3
.IP "\\$1" \\$2
..
.TH "SMB.CONF" 5 "" "" ""
.SH NAME
smb.conf \- The configuration file for the Samba suite
.SH "SYNOPSIS"

.PP
The \fIsmb\&.conf\fR file is a configuration file for the Samba suite\&. \fIsmb\&.conf\fR contains runtime configuration information for the Samba programs\&. The \fIsmb\&.conf\fR file is designed to be configured and administered by the \fBswat\fR(8) program\&. The complete description of the file format and possible parameters held within are here for reference purposes\&.

.SH "FILE FORMAT"

.PP
The file consists of sections and parameters\&. A section begins with the name of the section in square brackets and continues until the next section begins\&. Sections contain parameters of the form

.PP
\fIname\fR = \fIvalue \fR

.PP
The file is line\-based \- that is, each newline\-terminated line represents either a comment, a section name or a parameter\&.

.PP
Section and parameter names are not case sensitive\&.

.PP
Only the first equals sign in a parameter is significant\&. Whitespace before or after the first equals sign is discarded\&. Leading, trailing and internal whitespace in section and parameter names is irrelevant\&. Leading and trailing whitespace in a parameter value is discarded\&. Internal whitespace within a parameter value is retained verbatim\&.

.PP
Any line beginning with a semicolon (``\fB;\fR'') or a hash (``\fB#\fR'') character is ignored, as are lines containing only whitespace\&.

.PP
Any line ending in a ``\fB\\\fR'' is continued on the next line in the customary UNIX fashion\&.

.PP
The values following the equals sign in parameters are all either a string (no quotes needed) or a boolean, which may be given as yes/no, 0/1 or true/false\&. Case is not significant in boolean values, but is preserved in string values\&. Some items such as create modes are numeric\&.

.SH "SECTION DESCRIPTIONS"

.PP
Each section in the configuration file (except for the [global] section) describes a shared resource (known as a ``\fBshare\fR'')\&. The section name is the name of the shared resource and the parameters within the section define the shares attributes\&.

.PP
There are three special sections, [global], [homes] and [printers], which are described under \fBspecial sections\fR\&. The following notes apply to ordinary section descriptions\&.

.PP
A share consists of a directory to which access is being given plus a description of the access rights which are granted to the user of the service\&. Some housekeeping options are also specifiable\&.

.PP
Sections are either file share services (used by the client as an extension of their native file systems) or printable services (used by the client to access print services on the host running the server)\&.

.PP
Sections may be designated \fBguest\fR services, in which case no password is required to access them\&. A specified UNIX \fBguest account\fR is used to define access privileges in this case\&.

.PP
Sections other than guest services will require a password to access them\&. The client provides the username\&. As older clients only provide passwords and not usernames, you may specify a list of usernames to check against the password using the ``\fBuser =\fR'' option in the share definition\&. For modern clients such as Windows 95/98/ME/NT/2000, this should not be necessary\&.

.PP
The access rights granted by the server are masked by the access rights granted to the specified or guest UNIX user by the host system\&. The server does not grant more access than the host system grants\&.

.PP
The following sample section defines a file space share\&. The user has write access to the path \fI/home/bar\fR\&. The share is accessed via the share name ``\fBfoo\fR'':
Example1. \fI[foo]\fR\fI
					
				path = /home/bar\fR\fI
					
				read only = read only = no\fR
.PP
The following sample section defines a printable share\&. The share is read\-only, but printable\&. That is, the only write access permitted is via calls to open, write to and close a spool file\&. The \fBguest ok\fR parameter means access will be permitted as the default guest user (specified elsewhere):
Example2. \fI[aprinter]\fR\fI
					
				path = /usr/spool/public\fR\fI
					
				read only = yes\fR\fI
					
				printable = yes\fR\fI
					
				guest ok = yes\fR
.SH "SPECIAL SECTIONS"

.SS "The [global] section"

.PP
Parameters in this section apply to the server as a whole, or are defaults for sections that do not specifically define certain items\&. See the notes under PARAMETERS for more information\&.

.SS "The [homes] section"

.PP
If a section called [homes] is included in the configuration file, services connecting clients to their home directories can be created on the fly by the server\&.

.PP
When the connection request is made, the existing sections are scanned\&. If a match is found, it is used\&. If no match is found, the requested section name is treated as a username and looked up in the local password file\&. If the name exists and the correct password has been given, a share is created by cloning the [homes] section\&.

.PP
Some modifications are then made to the newly created share:

.TP 3
\(bu
The share name is changed from homes to the located username\&.
.TP
\(bu
If no path was given, the path is set to the user's home directory\&.
.LP

.PP
If you decide to use a \fBpath =\fR line in your [homes] section, you may find it useful to use the %S macro\&. For example :

.PP
\fBpath = /data/pchome/%S\fR

.PP
is useful if you have different home directories for your PCs than for UNIX access\&.

.PP
This is a fast and simple way to give a large number of clients access to their home directories with a minimum of fuss\&.

.PP
A similar process occurs if the requested section name is ``\fBhomes\fR'', except that the share name is not changed to that of the requesting user\&. This method of using the [homes] section works well if different users share a client PC\&.

.PP
The [homes] section can specify all the parameters a normal service section can specify, though some make more sense than others\&. The following is a typical and suitable [homes] section:
Example3. \fI[homes]\fR\fI
					
				read only = no\fR
.PP
An important point is that if guest access is specified in the [homes] section, all home directories will be visible to all clients \fBwithout a password\fR\&. In the very unlikely event that this is actually desirable, it is wise to also specify \fBread only access\fR\&.

.PP
The \fBbrowseable\fR flag for auto home directories will be inherited from the global browseable flag, not the [homes] browseable flag\&. This is useful as it means setting \fBbrowseable = no\fR in the [homes] section will hide the [homes] share but make any auto home directories visible\&.

.SS "The [printers] section"

.PP
This section works like [homes], but for printers\&.

.PP
If a [printers] section occurs in the configuration file, users are able to connect to any printer specified in the local host's printcap file\&.

.PP
When a connection request is made, the existing sections are scanned\&. If a match is found, it is used\&. If no match is found, but a [homes] section exists, it is used as described above\&. Otherwise, the requested section name is treated as a printer name and the appropriate printcap file is scanned to see if the requested section name is a valid printer share name\&. If a match is found, a new printer share is created by cloning the [printers] section\&.

.PP
A few modifications are then made to the newly created share:

.TP 3
\(bu
The share name is set to the located printer name
.TP
\(bu
If no printer name was given, the printer name is set to the located printer name
.TP
\(bu
If the share does not permit guest access and no username was given, the username is set to the located printer name\&.
.LP

.PP
The [printers] service MUST be printable \- if you specify otherwise, the server will refuse to load the configuration file\&.

.PP
Typically the path specified is that of a world\-writeable spool directory with the sticky bit set on it\&. A typical [printers] entry looks like this:
Example4. \fI[printers]\fR\fI
					
				path = /usr/spool/public\fR\fI
					
				guest ok = yes\fR\fI
					
				printable = yes\fR
.PP
All aliases given for a printer in the printcap file are legitimate printer names as far as the server is concerned\&. If your printing subsystem doesn't work like that, you will have to set up a pseudo\-printcap\&. This is a file consisting of one or more lines like this:
.nf

alias|alias|alias|alias\&.\&.\&.    
		.fi

.PP
Each alias should be an acceptable printer name for your printing subsystem\&. In the [global] section, specify the new file as your printcap\&. The server will only recognize names found in your pseudo\-printcap, which of course can contain whatever aliases you like\&. The same technique could be used simply to limit access to a subset of your local printers\&.

.PP
An alias, by the way, is defined as any component of the first entry of a printcap record\&. Records are separated by newlines, components (if there are more than one) are separated by vertical bar symbols (``\fB|\fR'')\&.

.RS
.Sh "Note"

.PP
On SYSV systems which use lpstat to determine what printers are defined on the system you may be able to use``\fBprintcap name = lpstat\fR'' to automatically obtain a list of printers\&. See the ``\fBprintcap name\fR'' option for more details\&.

.RE

.SH "PARAMETERS"

.PP
Parameters define the specific attributes of sections\&.

.PP
Some parameters are specific to the [global] section (e\&.g\&., \fBsecurity\fR)\&. Some parameters are usable in all sections (e\&.g\&., \fBcreate mode\fR)\&. All others are permissible only in normal sections\&. For the purposes of the following descriptions the [homes] and [printers] sections will be considered normal\&. The letter \fBG\fR in parentheses indicates that a parameter is specific to the [global] section\&. The letter \fBS\fR indicates that a parameter can be specified in a service specific section\&. All \fBS\fR parameters can also be specified in the [global] section \- in which case they will define the default behavior for all services\&.

.PP
Parameters are arranged here in alphabetical order \- this may not create best bedfellows, but at least you can find them! Where there are synonyms, the preferred synonym is described, others refer to the preferred synonym\&.

.SH "VARIABLE SUBSTITUTIONS"

.PP
Many of the strings that are settable in the config file can take substitutions\&. For example the option ``\fBpath = /tmp/%u\fR'' is interpreted as ``\fBpath = /tmp/john\fR'' if the user connected with the username john\&.

.PP
These substitutions are mostly noted in the descriptions below, but there are some general substitutions which apply whenever they might be relevant\&. These are:

.TP
%U
session username (the username that the client wanted, not necessarily the same as the one they got)\&.

.TP
%G
primary group name of %U\&.

.TP
%h
the Internet hostname that Samba is running on\&.

.TP
%m
the NetBIOS name of the client machine (very useful)\&.

.TP
%L
the NetBIOS name of the server\&. This allows you to change your config based on what the client calls you\&. Your server can have a ``\fBdual personality\fR''\&.

This parameter is not available when Samba listens on port 445, as clients no longer send this information\&.

.TP
%M
the Internet name of the client machine\&.

.TP
%R
the selected protocol level after protocol negotiation\&. It can be one of CORE, COREPLUS, LANMAN1, LANMAN2 or NT1\&.

.TP
%d
The process id of the current server process\&.

.TP
%a
the architecture of the remote machine\&. Only some are recognized, and those may not be 100% reliable\&. It currently recognizes Samba, Windows for Workgroups, Windows 95, Windows NT and Windows 2000\&. Anything else will be known as``\fBUNKNOWN\fR''\&. If it gets it wrong sending a level 3 log to samba@samba\&.org should allow it to be fixed\&.

.TP
%I
The IP address of the client machine\&.

.TP
%T
the current date and time\&.

.TP
%D
Name of the domain or workgroup of the current user\&.

.TP
%$(\fIenvvar\fR)
The value of the environment variable\fIenvar\fR\&.

.PP
The following substitutes apply only to some configuration options (only those that are used when a connection has been established):

.TP
%S
the name of the current service, if any\&.

.TP
%P
the root directory of the current service, if any\&.

.TP
%u
username of the current service, if any\&.

.TP
%g
primary group name of %u\&.

.TP
%H
the home directory of the user given by %u\&.

.TP
%N
the name of your NIS home directory server\&. This is obtained from your NIS auto\&.map entry\&. If you have not compiled Samba with the \fB\-\-with\-automount\fR option, this value will be the same as %L\&.

.TP
%p
the path of the service's home directory, obtained from your NIS auto\&.map entry\&. The NIS auto\&.map entry is split up as ``\fB%N:%p\fR''\&.

.PP
There are some quite creative things that can be done with these substitutions and other \fIsmb\&.conf\fR options\&.

.SH "NAME MANGLING"

.PP
Samba supports ``\fBname mangling\fR'' so that DOS and Windows clients can use files that don't conform to the 8\&.3 format\&. It can also be set to adjust the case of 8\&.3 format filenames\&.

.PP
There are several options that control the way mangling is performed, and they are grouped here rather than listed separately\&. For the defaults look at the output of the testparm program\&.

.PP
All of these options can be set separately for each service (or globally, of course)\&.

.PP
The options are:

.TP
mangle case = yes/no
controls whether names that have characters that aren't of the ``\fBdefault\fR'' case are mangled\&. For example, if this is yes, a name like ``\fBMail\fR'' will be mangled\&. Default \fBno\fR\&.

.TP
case sensitive = yes/no/auto
controls whether filenames are case sensitive\&. If they aren't, Samba must do a filename search and match on passed names\&. The default setting of auto allows clients that support case sensitive filenames (Linux CIFSVFS and smbclient 3\&.0\&.5 and above currently) to tell the Samba server on a per\-packet basis that they wish to access the file system in a case\-sensitive manner (to support UNIX case sensitive semantics)\&. No Windows or DOS system supports case\-sensitive filename so setting this option to auto is that same as setting it to no for them\&. Default \fBauto\fR\&.

.TP
default case = upper/lower
controls what the default case is for new filenames\&. Default \fBlower\fR\&.

.TP
preserve case = yes/no
controls whether new files are created with the case that the client passes, or if they are forced to be the``\fBdefault\fR'' case\&. Default \fByes\fR\&.

.TP
short preserve case = yes/no
controls if new files which conform to 8\&.3 syntax, that is all in upper case and of suitable length, are created upper case, or if they are forced to be the ``\fBdefault\fR'' case\&. This option can be used with ``\fBpreserve case = yes\fR'' to permit long filenames to retain their case, while short names are lowercased\&. Default \fByes\fR\&.

.PP
By default, Samba 3\&.0 has the same semantics as a Windows NT server, in that it is case insensitive but case preserving\&.

.SH "NOTE ABOUT USERNAME/PASSWORD VALIDATION"

.PP
There are a number of ways in which a user can connect to a service\&. The server uses the following steps in determining if it will allow a connection to a specified service\&. If all the steps fail, the connection request is rejected\&. However, if one of the steps succeeds, the following steps are not checked\&.

.PP
If the service is marked ``\fBguest only = yes\fR'' and the server is running with share\-level security (``\fBsecurity = share\fR'', steps 1 to 5 are skipped\&.

.TP 3
1.
If the client has passed a username/password pair and that username/password pair is validated by the UNIX system's password programs, the connection is made as that username\&. This includes the \\\\server\\service%\fIusername\fR method of passing a username\&.
.TP
2.
If the client has previously registered a username with the system and now supplies a correct password for that username, the connection is allowed\&.
.TP
3.
The client's NetBIOS name and any previously used usernames are checked against the supplied password\&. If they match, the connection is allowed as the corresponding user\&.
.TP
4.
If the client has previously validated a username/password pair with the server and the client has passed the validation token, that username is used\&.
.TP
5.
If a ``\fBuser = \fR'' field is given in the\fIsmb\&.conf\fR file for the service and the client has supplied a password, and that password matches (according to the UNIX system's password checking) with one of the usernames from the ``\fBuser =\fR'' field, the connection is made as the username in the ``\fBuser =\fR'' line\&. If one of the usernames in the ``\fBuser =\fR'' list begins with a``\fB@\fR'', that name expands to a list of names in the group of the same name\&.
.TP
6.
If the service is a guest service, a connection is made as the username given in the ``\fBguest account =\fR'' for the service, irrespective of the supplied password\&.
.LP

.SH "EXPLANATION OF EACH PARAMETER"

.TP
abort shutdown script (G)
\fBThis parameter only exists in the HEAD cvs branch\fR This a full path name to a script called by \fBsmbd\fR(8) that should stop a shutdown procedure issued by the \fIshutdown script\fR\&.

This command will be run as user\&.

Default: \fB\fIabort shutdown script\fR = \fR 

Example: \fB\fIabort shutdown script\fR = /sbin/shutdown \-c \fR 

.TP
acl compatibility (S)
This parameter specifies what OS ACL semantics should be compatible with\&. Possible values are \fBwinnt\fR for Windows NT 4,\fBwin2k\fR for Windows 2000 and above and \fBauto\fR\&. If you specify \fBauto\fR, the value for this parameter will be based upon the version of the client\&. There should be no reason to change this parameter from the default\&.

Default: \fB\fIacl compatibility\fR = Auto \fR 

Example: \fB\fIacl compatibility\fR = win2k \fR 

.TP
add group script (G)
This is the full pathname to a script that will be run\fBAS ROOT\fR by \fBsmbd\fR(8) when a new group is requested\&. It will expand any \fI%g\fR to the group name passed\&. This script is only useful for installations using the Windows NT domain administration tools\&. The script is free to create a group with an arbitrary name to circumvent unix group name restrictions\&. In that case the script must print the numeric gid of the created group on stdout\&.

\fBNo default\fR

.TP
add machine script (G)
This is the full pathname to a script that will be run by\fBsmbd\fR(8) when a machine is added to it's domain using the administrator username and password method\&.

This option is only required when using sam back\-ends tied to the Unix uid method of RID calculation such as smbpasswd\&. This option is only available in Samba 3\&.0\&.

Default: \fB\fIadd machine script\fR = \fR 

Example: \fB\fIadd machine script\fR = /usr/sbin/adduser \-n \-g machines \-c Machine \-d /dev/null \-s /bin/false %u \fR 

.TP
addprinter command (G)
With the introduction of MS\-RPC based printing support for Windows NT/2000 clients in Samba 2\&.2, The MS Add Printer Wizard (APW) icon is now also available in the "Printers\&.\&.\&." folder displayed a share listing\&. The APW allows for printers to be add remotely to a Samba or Windows NT/2000 print server\&.

For a Samba host this means that the printer must be physically added to the underlying printing system\&. The \fIadd printer command\fR defines a script to be run which will perform the necessary operations for adding the printer to the print system and to add the appropriate service definition to the \fIsmb\&.conf\fR file in order that it can be shared by \fBsmbd\fR(8)\&.

The \fIaddprinter command\fR is automatically invoked with the following parameter (in order):


.RS
.TP 3
\(bu
\fIprinter name\fR
.TP
\(bu
\fIshare name\fR
.TP
\(bu
\fIport name\fR
.TP
\(bu
\fIdriver name\fR
.TP
\(bu
\fIlocation\fR
.TP
\(bu
\fIWindows 9x driver location\fR
.LP
.RE
All parameters are filled in from the PRINTER_INFO_2 structure sent by the Windows NT/2000 client with one exception\&. The "Windows 9x driver location" parameter is included for backwards compatibility only\&. The remaining fields in the structure are generated from answers to the APW questions\&.

Once the \fIaddprinter command\fR has been executed, \fBsmbd\fR will reparse the \fI smb\&.conf\fR to determine if the share defined by the APW exists\&. If the sharename is still invalid, then \fBsmbd \fR will return an ACCESS_DENIED error to the client\&.

The "add printer command" program can output a single line of text, which Samba will set as the port the new printer is connected to\&. If this line isn't output, Samba won't reload its printer shares\&.

Default: \fB\fIaddprinter command\fR = \fR 

Example: \fB\fIaddprinter command\fR = /usr/bin/addprinter \fR 

.TP
add share command (G)
Samba 2\&.2\&.0 introduced the ability to dynamically add and delete shares via the Windows NT 4\&.0 Server Manager\&. The\fIadd share command\fR is used to define an external program or script which will add a new service definition to \fIsmb\&.conf\fR\&. In order to successfully execute the \fIadd share command\fR, \fBsmbd\fR requires that the administrator be connected using a root account (i\&.e\&. uid == 0)\&.

When executed, \fBsmbd\fR will automatically invoke the\fIadd share command\fR with four parameters\&.


.RS
.TP 3
\(bu
\fIconfigFile\fR \- the location of the global \fIsmb\&.conf\fR file\&.
.TP
\(bu
\fIshareName\fR \- the name of the new share\&.
.TP
\(bu
\fIpathName\fR \- path to an **existing** directory on disk\&.
.TP
\(bu
\fIcomment\fR \- comment string to associate with the new share\&.
.LP
.RE
This parameter is only used for add file shares\&. To add printer shares, see the \fIaddprinter command\fR\&.

Default: \fB\fIadd share command\fR = \fR 

Example: \fB\fIadd share command\fR = /usr/local/bin/addshare \fR 

.TP
add user script (G)
This is the full pathname to a script that will be run \fBAS ROOT\fR by \fBsmbd\fR(8) under special circumstances described below\&.

Normally, a Samba server requires that UNIX users are created for all users accessing files on this server\&. For sites that use Windows NT account databases as their primary user database creating these users and keeping the user list in sync with the Windows NT PDC is an onerous task\&. This option allows smbd to create the required UNIX users\fBON DEMAND\fR when a user accesses the Samba server\&.

In order to use this option, \fBsmbd\fR(8) must \fBNOT\fR be set to \fIsecurity = share\fR and \fIadd user script\fR must be set to a full pathname for a script that will create a UNIX user given one argument of \fI%u\fR, which expands into the UNIX user name to create\&.

When the Windows user attempts to access the Samba server, at login (session setup in the SMB protocol) time, \fBsmbd\fR(8) contacts the \fIpassword server\fR and attempts to authenticate the given user with the given password\&. If the authentication succeeds then \fBsmbd\fR attempts to find a UNIX user in the UNIX password database to map the Windows user into\&. If this lookup fails, and \fIadd user script \fR is set then \fBsmbd\fR will call the specified script \fBAS ROOT\fR, expanding any \fI%u\fR argument to be the user name to create\&.

If this script successfully creates the user then \fBsmbd \fR will continue on as though the UNIX user already existed\&. In this way, UNIX users are dynamically created to match existing Windows NT accounts\&.

See also \fI security\fR, \fIpassword server\fR,\fIdelete user script\fR\&.

Default: \fB\fIadd user script\fR = \fR 

Example: \fB\fIadd user script\fR = /usr/local/samba/bin/add_user %u \fR 

.TP
add user to group script (G)
Full path to the script that will be called when a user is added to a group using the Windows NT domain administration tools\&. It will be run by \fBsmbd\fR(8)\fBAS ROOT\fR\&. Any \fI%g\fR will be replaced with the group name and any \fI%u\fR will be replaced with the user name\&.

Default: \fB\fIadd user to group script\fR = \fR 

Example: \fB\fIadd user to group script\fR = /usr/sbin/adduser %u %g \fR 

.TP
admin users (S)
This is a list of users who will be granted administrative privileges on the share\&. This means that they will do all file operations as the super\-user (root)\&.

You should use this option very carefully, as any user in this list will be able to do anything they like on the share, irrespective of file permissions\&.

Default: \fB\fIadmin users\fR = \fR 

Example: \fB\fIadmin users\fR = jason \fR 

.TP
afs share (S)
This parameter controls whether special AFS features are enabled for this share\&. If enabled, it assumes that the directory exported via the \fIpath\fR parameter is a local AFS import\&. The special AFS features include the attempt to hand\-craft an AFS token if you enabled \-\-with\-fake\-kaserver in configure\&.

Default: \fB\fIafs share\fR = no \fR 

.TP
afs username map (G)
If you are using the fake kaserver AFS feature, you might want to hand\-craft the usernames you are creating tokens for\&. For example this is necessary if you have users from several domain in your AFS Protection Database\&. One possible scheme to code users as DOMAIN+User as it is done by winbind with the + as a separator\&.

The mapped user name must contain the cell name to log into, so without setting this parameter there will be no token\&.

Default: \fB\fIafs username map\fR = \fR 

Example: \fB\fIafs username map\fR = %u@afs\&.samba\&.org \fR 

.TP
algorithmic rid base (G)
This determines how Samba will use its algorithmic mapping from uids/gid to the RIDs needed to construct NT Security Identifiers\&.

Setting this option to a larger value could be useful to sites transitioning from WinNT and Win2k, as existing user and group rids would otherwise clash with sytem users etc\&.

All UIDs and GIDs must be able to be resolved into SIDs for the correct operation of ACLs on the server\&. As such the algorithmic mapping can't be 'turned off', but pushing it 'out of the way' should resolve the issues\&. Users and groups can then be assigned 'low' RIDs in arbitary\-rid supporting backends\&.

Default: \fB\fIalgorithmic rid base\fR = 1000 \fR 

Example: \fB\fIalgorithmic rid base\fR = 100000 \fR 

.TP
allow trusted domains (G)
This option only takes effect when the \fIsecurity\fR option is set to \fBserver\fR or \fBdomain\fR\&. If it is set to no, then attempts to connect to a resource from a domain or workgroup other than the one which smbd is running in will fail, even if that domain is trusted by the remote server doing the authentication\&.

This is useful if you only want your Samba server to serve resources to users in the domain it is a member of\&. As an example, suppose that there are two domains DOMA and DOMB\&. DOMB is trusted by DOMA, which contains the Samba server\&. Under normal circumstances, a user with an account in DOMB can then access the resources of a UNIX account with the same account name on the Samba server even if they do not have an account in DOMA\&. This can make implementing a security boundary difficult\&.

Default: \fB\fIallow trusted domains\fR = yes \fR 

.TP
announce as (G)
This specifies what type of server \fBnmbd\fR(8) will announce itself as, to a network neighborhood browse list\&. By default this is set to Windows NT\&. The valid options are : "NT Server" (which can also be written as "NT"), "NT Workstation", "Win95" or "WfW" meaning Windows NT Server, Windows NT Workstation, Windows 95 and Windows for Workgroups respectively\&. Do not change this parameter unless you have a specific need to stop Samba appearing as an NT server as this may prevent Samba servers from participating as browser servers correctly\&.

Default: \fB\fIannounce as\fR = NT Server \fR 

Example: \fB\fIannounce as\fR = Win95 \fR 

.TP
announce version (G)
This specifies the major and minor version numbers that nmbd will use when announcing itself as a server\&. The default is 4\&.9\&. Do not change this parameter unless you have a specific need to set a Samba server to be a downlevel server\&.

Default: \fB\fIannounce version\fR = 4\&.9 \fR 

Example: \fB\fIannounce version\fR = 2\&.0 \fR 

.TP
auth methods (G)
This option allows the administrator to chose what authentication methods \fBsmbd\fR will use when authenticating a user\&. This option defaults to sensible values based on \fIsecurity\fR\&. This should be considered a developer option and used only in rare circumstances\&. In the majority (if not all) of production servers, the default setting should be adequate\&.

Each entry in the list attempts to authenticate the user in turn, until the user authenticates\&. In practice only one method will ever actually be able to complete the authentication\&.

Possible options include \fBguest\fR (anonymous access), \fBsam\fR (lookups in local list of accounts based on netbios name or domain name), \fBwinbind\fR (relay authentication requests for remote users through winbindd), \fBntdomain\fR (pre\-winbindd method of authentication for remote domain users; deprecated in favour of winbind method), \fBtrustdomain\fR (authenticate trusted users by contacting the remote DC directly from smbd; deprecated in favour of winbind method)\&.

Default: \fB\fIauth methods\fR = \fR 

Example: \fB\fIauth methods\fR = guest sam winbind \fR 

.TP
available (S)
This parameter lets you "turn off" a service\&. If\fIavailable = no\fR, then \fBALL\fR attempts to connect to the service will fail\&. Such failures are logged\&.

Default: \fB\fIavailable\fR = yes \fR 

.TP
bind interfaces only (G)
This global parameter allows the Samba admin to limit what interfaces on a machine will serve SMB requests\&. It affects file service \fBsmbd\fR(8) and name service \fBnmbd\fR(8) in a slightly different ways\&.

For name service it causes \fBnmbd\fR to bind to ports 137 and 138 on the interfaces listed in the interfaces parameter\&. \fBnmbd\fR also binds to the "all addresses" interface (0\&.0\&.0\&.0) on ports 137 and 138 for the purposes of reading broadcast messages\&. If this option is not set then \fBnmbd\fR will service name requests on all of these sockets\&. If \fIbind interfaces only\fR is set then \fBnmbd\fR will check the source address of any packets coming in on the broadcast sockets and discard any that don't match the broadcast addresses of the interfaces in the \fIinterfaces\fR parameter list\&. As unicast packets are received on the other sockets it allows\fBnmbd\fR to refuse to serve names to machines that send packets that arrive through any interfaces not listed in the\fIinterfaces\fR list\&. IP Source address spoofing does defeat this simple check, however, so it must not be used seriously as a security feature for \fBnmbd\fR\&.

For file service it causes \fBsmbd\fR(8) to bind only to the interface list given in the interfaces parameter\&. This restricts the networks that \fBsmbd\fR will serve to packets coming in those interfaces\&. Note that you should not use this parameter for machines that are serving PPP or other intermittent or non\-broadcast network interfaces as it will not cope with non\-permanent interfaces\&.

If \fIbind interfaces only\fR is set then unless the network address \fB127\&.0\&.0\&.1\fR is added to the \fIinterfaces\fR parameter list \fBsmbpasswd\fR(8) and \fBswat\fR(8) may not work as expected due to the reasons covered below\&.

To change a users SMB password, the \fBsmbpasswd\fR by default connects to the \fBlocalhost \- 127\&.0\&.0\&.1\fR address as an SMB client to issue the password change request\&. If\fIbind interfaces only\fR is set then unless the network address \fB127\&.0\&.0\&.1\fR is added to the\fIinterfaces\fR parameter list then \fB smbpasswd\fR will fail to connect in it's default mode\&.\fBsmbpasswd\fR can be forced to use the primary IP interface of the local host by using its \fBsmbpasswd\fR(8)\fI\-r \fIremote machine\fR\fR parameter, with \fIremote machine\fR set to the IP name of the primary interface of the local host\&.

The \fBswat\fR status page tries to connect with\fBsmbd\fR and \fBnmbd\fR at the address\fB127\&.0\&.0\&.1\fR to determine if they are running\&. Not adding \fB127\&.0\&.0\&.1\fR will cause \fB smbd\fR and \fBnmbd\fR to always show "not running" even if they really are\&. This can prevent \fB swat\fR from starting/stopping/restarting \fBsmbd\fR and \fBnmbd\fR\&.

Default: \fB\fIbind interfaces only\fR = no \fR 

.TP
blocking locks (S)
This parameter controls the behavior of \fBsmbd\fR(8) when given a request by a client to obtain a byte range lock on a region of an open file, and the request has a time limit associated with it\&.

If this parameter is set and the lock range requested cannot be immediately satisfied, samba will internally queue the lock request, and periodically attempt to obtain the lock until the timeout period expires\&.

If this parameter is set to \fBno\fR, then samba will behave as previous versions of Samba would and will fail the lock request immediately if the lock range cannot be obtained\&.

Default: \fB\fIblocking locks\fR = yes \fR 

.TP
block size (S)
This parameter controls the behavior of \fBsmbd\fR(8) when reporting disk free sizes\&. By default, this reports a disk block size of 1024 bytes\&.

Changing this parameter may have some effect on the efficiency of client writes, this is not yet confirmed\&. This parameter was added to allow advanced administrators to change it (usually to a higher value) and test the effect it has on client write performance without re\-compiling the code\&. As this is an experimental option it may be removed in a future release\&.

Changing this option does not change the disk free reporting size, just the block size unit reported to the client\&.

\fBNo default\fR

.TP
browsable
This parameter is a synonym for browseable\&.

.TP
browseable (S)
This controls whether this share is seen in the list of available shares in a net view and in the browse list\&.

Default: \fB\fIbrowseable\fR = yes \fR 

.TP
browse list (G)
This controls whether \fBsmbd\fR(8) will serve a browse list to a client doing a \fBNetServerEnum\fR call\&. Normally set to \fByes\fR\&. You should never need to change this\&.

Default: \fB\fIbrowse list\fR = yes \fR 

.TP
casesignames
This parameter is a synonym for case sensitive\&.

.TP
case sensitive (S)
See the discussion in the section NAME MANGLING\&.

Default: \fB\fIcase sensitive\fR = no \fR 

.TP
change notify timeout (G)
This SMB allows a client to tell a server to "watch" a particular directory for any changes and only reply to the SMB request when a change has occurred\&. Such constant scanning of a directory is expensive under UNIX, hence an \fBsmbd\fR(8) daemon only performs such a scan on each requested directory once every \fIchange notify timeout\fR seconds\&.

Default: \fB\fIchange notify timeout\fR = 60 \fR 

Example: \fB\fIchange notify timeout\fR = 300 # Would change the scan time to every 5 minutes\&. \fR 

.TP
change share command (G)
Samba 2\&.2\&.0 introduced the ability to dynamically add and delete shares via the Windows NT 4\&.0 Server Manager\&. The\fIchange share command\fR is used to define an external program or script which will modify an existing service definition in \fIsmb\&.conf\fR\&. In order to successfully execute the \fIchange share command\fR, \fBsmbd\fR requires that the administrator be connected using a root account (i\&.e\&. uid == 0)\&.

When executed, \fBsmbd\fR will automatically invoke the\fIchange share command\fR with four parameters\&.


.RS
.TP 3
\(bu
\fIconfigFile\fR \- the location of the global \fIsmb\&.conf\fR file\&.
.TP
\(bu
\fIshareName\fR \- the name of the new share\&.
.TP
\(bu
\fIpathName\fR \- path to an **existing** directory on disk\&.
.TP
\(bu
\fIcomment\fR \- comment string to associate with the new share\&.
.LP
.RE
This parameter is only used modify existing file shares definitions\&. To modify printer shares, use the "Printers\&.\&.\&." folder as seen when browsing the Samba host\&.

Default: \fB\fIchange share command\fR = \fR 

Example: \fB\fIchange share command\fR = /usr/local/bin/addshare \fR 

.TP
client lanman auth (G)
This parameter determines whether or not \fBsmbclient\fR(8) and other samba client tools will attempt to authenticate itself to servers using the weaker LANMAN password hash\&. If disabled, only server which support NT password hashes (e\&.g\&. Windows NT/2000, Samba, etc\&.\&.\&. but not Windows 95/98) will be able to be connected from the Samba client\&.

The LANMAN encrypted response is easily broken, due to it's case\-insensitive nature, and the choice of algorithm\&. Clients without Windows 95/98 servers are advised to disable this option\&.

Disabling this option will also disable the \fBclient plaintext auth\fR option

Likewise, if the \fBclient ntlmv2 auth\fR parameter is enabled, then only NTLMv2 logins will be attempted\&.

Default: \fB\fIclient lanman auth\fR = yes \fR 

.TP
client ntlmv2 auth (G)
This parameter determines whether or not \fBsmbclient\fR(8) will attempt to authenticate itself to servers using the NTLMv2 encrypted password response\&.

If enabled, only an NTLMv2 and LMv2 response (both much more secure than earlier versions) will be sent\&. Many servers (including NT4 < SP4, Win9x and Samba 2\&.2) are not compatible with NTLMv2\&.

Similarly, if enabled, NTLMv1, \fBclient lanman auth\fR and \fBclient plaintext auth\fR authentication will be disabled\&. This also disables share\-level authentication\&.

If disabled, an NTLM response (and possibly a LANMAN response) will be sent by the client, depending on the value of \fBclient lanman auth\fR\&.

Note that some sites (particularly those following 'best practice' security polices) only allow NTLMv2 responses, and not the weaker LM or NTLM\&.

Default: \fB\fIclient ntlmv2 auth\fR = no \fR 

.TP
client plaintext auth (G)
Specifies whether a client should send a plaintext password if the server does not support encrypted passwords\&.

Default: \fB\fIclient plaintext auth\fR = yes \fR 

.TP
client schannel (G)
This controls whether the client offers or even demands the use of the netlogon schannel\&. \fIclient schannel = no\fR does not offer the schannel, \fIserver schannel = auto\fR offers the schannel but does not enforce it, and \fIserver schannel = yes\fR denies access if the server is not able to speak netlogon schannel\&.

Default: \fB\fIclient schannel\fR = auto \fR 

Example: \fB\fIclient schannel\fR = yes \fR 

.TP
client signing (G)
This controls whether the client offers or requires the server it talks to to use SMB signing\&. Possible values are \fBauto\fR, \fBmandatory\fR and \fBdisabled\fR\&.

When set to auto, SMB signing is offered, but not enforced\&. When set to mandatory, SMB signing is required and if set to disabled, SMB signing is not offered either\&.

Default: \fB\fIclient signing\fR = auto \fR 

.TP
client use spnego (G)
This variable controls whether Samba clients will try to use Simple and Protected NEGOciation (as specified by rfc2478) with supporting servers (including WindowsXP, Windows2000 and Samba 3\&.0) to agree upon an authentication mechanism\&. This enables Kerberos authentication in particular\&.

Default: \fB\fIclient use spnego\fR = yes \fR 

.TP
comment (S)
This is a text field that is seen next to a share when a client does a queries the server, either via the network neighborhood or via \fBnet view\fR to list what shares are available\&.

If you want to set the string that is displayed next to the machine name then see the \fI server string\fR parameter\&.

Default: \fB\fIcomment\fR = # No comment \fR 

Example: \fB\fIcomment\fR = Fred's Files \fR 

.TP
config file (G)
This allows you to override the config file to use, instead of the default (usually \fIsmb\&.conf\fR)\&. There is a chicken and egg problem here as this option is set in the config file!

For this reason, if the name of the config file has changed when the parameters are loaded then it will reload them from the new config file\&.

This option takes the usual substitutions, which can be very useful\&.

If the config file doesn't exist then it won't be loaded (allowing you to special case the config files of just a few clients)\&.

\fBNo default\fR

Example: \fB\fIconfig file\fR = /usr/local/samba/lib/smb\&.conf\&.%m \fR 

.TP
copy (S)
This parameter allows you to "clone" service entries\&. The specified service is simply duplicated under the current service's name\&. Any parameters specified in the current section will override those in the section being copied\&.

This feature lets you set up a 'template' service and create similar services easily\&. Note that the service being copied must occur earlier in the configuration file than the service doing the copying\&.

Default: \fB\fIcopy\fR = \fR 

Example: \fB\fIcopy\fR = otherservice \fR 

.TP
create mode
This parameter is a synonym for create mask\&.

.TP
create mask (S)
When a file is created, the necessary permissions are calculated according to the mapping from DOS modes to UNIX permissions, and the resulting UNIX mode is then bit\-wise 'AND'ed with this parameter\&. This parameter may be thought of as a bit\-wise MASK for the UNIX modes of a file\&. Any bit \fBnot\fR set here will be removed from the modes set on a file when it is created\&.

The default value of this parameter removes the 'group' and 'other' write and execute bits from the UNIX modes\&.

Following this Samba will bit\-wise 'OR' the UNIX mode created from this parameter with the value of the \fIforce create mode\fR parameter which is set to 000 by default\&.

This parameter does not affect directory modes\&. See the parameter \fIdirectory mode \fR for details\&.

Note that this parameter does not apply to permissions set by Windows NT/2000 ACL editors\&. If the administrator wishes to enforce a mask on access control lists also, they need to set the \fIsecurity mask\fR\&.

Default: \fB\fIcreate mask\fR = 0744 \fR 

Example: \fB\fIcreate mask\fR = 0775 \fR 

.TP
csc policy (S)
This stands for \fBclient\-side caching policy\fR, and specifies how clients capable of offline caching will cache the files in the share\&. The valid values are: manual, documents, programs, disable\&.

These values correspond to those used on Windows servers\&.

For example, shares containing roaming profiles can have offline caching disabled using \fBcsc policy = disable\fR\&.

Default: \fB\fIcsc policy\fR = manual \fR 

Example: \fB\fIcsc policy\fR = programs \fR 

.TP
cups options (S)
This parameter is only applicable if \fIprinting\fR is set to \fBcups\fR\&. Its value is a free form string of options passed directly to the cups library\&.

You can pass any generic print option known to CUPS (as listed in the CUPS "Software Users' Manual")\&. You can also pass any printer specific option (as listed in "lpoptions \-d printername \-l") valid for the target queue\&.

You should set this parameter to \fBraw\fR if your CUPS server \fIerror_log\fR file contains messages such as "Unsupported format 'application/octet\-stream'" when printing from a Windows client through Samba\&. It is no longer necessary to enable system wide raw printing in \fI/etc/cups/mime\&.{convs,types}\fR\&.

Default: \fB\fIcups options\fR = "" \fR 

Example: \fB\fIcups options\fR = "raw,media=a4,job\-sheets=secret,secret" \fR 

.TP
cups server (G)
This parameter is only applicable if \fIprinting\fR is set to \fBcups\fR\&.

If set, this option overrides the ServerName option in the CUPS \fIclient\&.conf\fR\&. This is necessary if you have virtual samba servers that connect to different CUPS daemons\&.

Default: \fB\fIcups server\fR = "" \fR 

Example: \fB\fIcups server\fR = MYCUPSSERVER \fR 

.TP
deadtime (G)
The value of the parameter (a decimal integer) represents the number of minutes of inactivity before a connection is considered dead, and it is disconnected\&. The deadtime only takes effect if the number of open files is zero\&.

This is useful to stop a server's resources being exhausted by a large number of inactive connections\&.

Most clients have an auto\-reconnect feature when a connection is broken so in most cases this parameter should be transparent to users\&.

Using this parameter with a timeout of a few minutes is recommended for most systems\&.

A deadtime of zero indicates that no auto\-disconnection should be performed\&.

Default: \fB\fIdeadtime\fR = 0 \fR 

Example: \fB\fIdeadtime\fR = 15 \fR 

.TP
debug hires timestamp (G)
Sometimes the timestamps in the log messages are needed with a resolution of higher that seconds, this boolean parameter adds microsecond resolution to the timestamp message header when turned on\&.

Note that the parameter \fI debug timestamp\fR must be on for this to have an effect\&.

Default: \fB\fIdebug hires timestamp\fR = no \fR 

.TP
debug pid (G)
When using only one log file for more then one forked \fBsmbd\fR(8)\-process there may be hard to follow which process outputs which message\&. This boolean parameter is adds the process\-id to the timestamp message headers in the logfile when turned on\&.

Note that the parameter \fI debug timestamp\fR must be on for this to have an effect\&.

Default: \fB\fIdebug pid\fR = no \fR 

.TP
timestamp logs
This parameter is a synonym for debug timestamp\&.

.TP
debug timestamp (G)
Samba debug log messages are timestamped by default\&. If you are running at a high \fIdebug level\fR these timestamps can be distracting\&. This boolean parameter allows timestamping to be turned off\&.

Default: \fB\fIdebug timestamp\fR = yes \fR 

.TP
debug uid (G)
Samba is sometimes run as root and sometime run as the connected user, this boolean parameter inserts the current euid, egid, uid and gid to the timestamp message headers in the log file if turned on\&.

Note that the parameter \fI debug timestamp\fR must be on for this to have an effect\&.

Default: \fB\fIdebug uid\fR = no \fR 

.TP
default case (S)
See the section on NAME MANGLING\&. Also note the \fIshort preserve case\fR parameter\&.

Default: \fB\fIdefault case\fR = lower \fR 

.TP
default devmode (S)
This parameter is only applicable to printable services\&. When smbd is serving Printer Drivers to Windows NT/2k/XP clients, each printer on the Samba server has a Device Mode which defines things such as paper size and orientation and duplex settings\&. The device mode can only correctly be generated by the printer driver itself (which can only be executed on a Win32 platform)\&. Because smbd is unable to execute the driver code to generate the device mode, the default behavior is to set this field to NULL\&.

Most problems with serving printer drivers to Windows NT/2k/XP clients can be traced to a problem with the generated device mode\&. Certain drivers will do things such as crashing the client's Explorer\&.exe with a NULL devmode\&. However, other printer drivers can cause the client's spooler service (spoolsv\&.exe) to die if the devmode was not created by the driver itself (i\&.e\&. smbd generates a default devmode)\&.

This parameter should be used with care and tested with the printer driver in question\&. It is better to leave the device mode to NULL and let the Windows client set the correct values\&. Because drivers do not do this all the time, setting \fBdefault devmode = yes\fR will instruct smbd to generate a default one\&.

For more information on Windows NT/2k printing and Device Modes, see the MSDN documentation\&.

Default: \fB\fIdefault devmode\fR = no \fR 

.TP
default
This parameter is a synonym for default service\&.

.TP
default service (G)
This parameter specifies the name of a service which will be connected to if the service actually requested cannot be found\&. Note that the square brackets are \fBNOT\fR given in the parameter value (see example below)\&.

There is no default value for this parameter\&. If this parameter is not given, attempting to connect to a nonexistent service results in an error\&.

Typically the default service would be a \fIguest ok\fR, \fIread\-only\fR service\&.

Also note that the apparent service name will be changed to equal that of the requested service, this is very useful as it allows you to use macros like \fI%S\fR to make a wildcard service\&.

Note also that any "_" characters in the name of the service used in the default service will get mapped to a "/"\&. This allows for interesting things\&.

Default: \fB\fIdefault service\fR = \fR 

Example: \fB\fIdefault service\fR = pub \fR 

.TP
defer sharing violations (G)
Windows allows specifying how a file will be shared with other processes when it is opened\&. Sharing violations occur when a file is opened by a different process using options that violate the share settings specified by other processes\&. This parameter causes smbd to act as a Windows server does, and defer returning a "sharing violation" error message for up to one second, allowing the client to close the file causing the violation in the meantime\&.

Unix by default does not have this behaviour\&.

There should be no reason to turn off this parameter, as it is designed to enable Samba to more correctly emulate Windows\&.

Default: \fB\fIdefer sharing violations\fR = True \fR 

.TP
delete group script (G)
This is the full pathname to a script that will be run \fBAS ROOT\fR  \fBsmbd\fR(8) when a group is requested to be deleted\&. It will expand any \fI%g\fR to the group name passed\&. This script is only useful for installations using the Windows NT domain administration tools\&.

Default: \fB\fIdelete group script\fR = \fR 

.TP
deleteprinter command (G)
With the introduction of MS\-RPC based printer support for Windows NT/2000 clients in Samba 2\&.2, it is now possible to delete printer at run time by issuing the DeletePrinter() RPC call\&.

For a Samba host this means that the printer must be physically deleted from underlying printing system\&. The \fI deleteprinter command\fR defines a script to be run which will perform the necessary operations for removing the printer from the print system and from \fIsmb\&.conf\fR\&.

The \fIdeleteprinter command\fR is automatically called with only one parameter: \fI "printer name"\fR\&.

Once the \fIdeleteprinter command\fR has been executed, \fBsmbd\fR will reparse the \fI smb\&.conf\fR to associated printer no longer exists\&. If the sharename is still valid, then \fBsmbd \fR will return an ACCESS_DENIED error to the client\&.

Default: \fB\fIdeleteprinter command\fR = \fR 

Example: \fB\fIdeleteprinter command\fR = /usr/bin/removeprinter \fR 

.TP
delete readonly (S)
This parameter allows readonly files to be deleted\&. This is not normal DOS semantics, but is allowed by UNIX\&.

This option may be useful for running applications such as rcs, where UNIX file ownership prevents changing file permissions, and DOS semantics prevent deletion of a read only file\&.

Default: \fB\fIdelete readonly\fR = no \fR 

.TP
delete share command (G)
Samba 2\&.2\&.0 introduced the ability to dynamically add and delete shares via the Windows NT 4\&.0 Server Manager\&. The\fIdelete share command\fR is used to define an external program or script which will remove an existing service definition from \fIsmb\&.conf\fR\&. In order to successfully execute the \fIdelete share command\fR, \fBsmbd\fR requires that the administrator be connected using a root account (i\&.e\&. uid == 0)\&.

When executed, \fBsmbd\fR will automatically invoke the\fIdelete share command\fR with two parameters\&.


.RS
.TP 3
\(bu
\fIconfigFile\fR \- the location of the global \fIsmb\&.conf\fR file\&.
.TP
\(bu
\fIshareName\fR \- the name of the existing service\&.
.LP
.RE
This parameter is only used to remove file shares\&. To delete printer shares, see the \fIdeleteprinter command\fR\&.

Default: \fB\fIdelete share command\fR = \fR 

Example: \fB\fIdelete share command\fR = /usr/local/bin/delshare \fR 

.TP
delete user from group script (G)
Full path to the script that will be called when a user is removed from a group using the Windows NT domain administration tools\&. It will be run by \fBsmbd\fR(8)  \fBAS ROOT\fR\&. Any \fI%g\fR will be replaced with the group name and any \fI%u\fR will be replaced with the user name\&.

Default: \fB\fIdelete user from group script\fR = \fR 

Example: \fB\fIdelete user from group script\fR = /usr/sbin/deluser %u %g \fR 

.TP
delete user script (G)
This is the full pathname to a script that will be run by \fBsmbd\fR(8) when managing users with remote RPC (NT) tools\&.

This script is called when a remote client removes a user from the server, normally using 'User Manager for Domains' or\fBrpcclient\fR\&.

This script should delete the given UNIX username\&.

Default: \fB\fIdelete user script\fR = \fR 

Example: \fB\fIdelete user script\fR = /usr/local/samba/bin/del_user %u \fR 

.TP
delete veto files (S)
This option is used when Samba is attempting to delete a directory that contains one or more vetoed directories (see the \fIveto files\fR option)\&. If this option is set to \fBno\fR (the default) then if a vetoed directory contains any non\-vetoed files or directories then the directory delete will fail\&. This is usually what you want\&.

If this option is set to \fByes\fR, then Samba will attempt to recursively delete any files and directories within the vetoed directory\&. This can be useful for integration with file serving systems such as NetAtalk which create meta\-files within directories you might normally veto DOS/Windows users from seeing (e\&.g\&. \fI\&.AppleDouble\fR)

Setting \fBdelete veto files = yes\fR allows these directories to be transparently deleted when the parent directory is deleted (so long as the user has permissions to do so)\&.

Default: \fB\fIdelete veto files\fR = no \fR 

.TP
dfree command (G)
The \fIdfree command\fR setting should only be used on systems where a problem occurs with the internal disk space calculations\&. This has been known to happen with Ultrix, but may occur with other operating systems\&. The symptom that was seen was an error of "Abort Retry Ignore" at the end of each directory listing\&.

This setting allows the replacement of the internal routines to calculate the total disk space and amount available with an external routine\&. The example below gives a possible script that might fulfill this function\&.

The external program will be passed a single parameter indicating a directory in the filesystem being queried\&. This will typically consist of the string \fI\&./\fR\&. The script should return two integers in ASCII\&. The first should be the total disk space in blocks, and the second should be the number of available blocks\&. An optional third return value can give the block size in bytes\&. The default blocksize is 1024 bytes\&.

Note: Your script should \fBNOT\fR be setuid or setgid and should be owned by (and writeable only by) root!

Where the script dfree (which must be made executable) could be:


.nf
 
#!/bin/sh
df $1 | tail \-1 | awk '{print $2" "$4}'
.fi


or perhaps (on Sys V based systems):


.nf
 
#!/bin/sh
/usr/bin/df \-k $1 | tail \-1 | awk '{print $3" "$5}'
.fi


Note that you may have to replace the command names with full path names on some systems\&.

Default: \fB\fIdfree command\fR = # By default internal routines for determining the disk capacity and remaining space will be used\&. \fR 

Example: \fB\fIdfree command\fR = /usr/local/samba/bin/dfree \fR 

.TP
directory mode
This parameter is a synonym for directory mask\&.

.TP
directory mask (S)
This parameter is the octal modes which are used when converting DOS modes to UNIX modes when creating UNIX directories\&.

When a directory is created, the necessary permissions are calculated according to the mapping from DOS modes to UNIX permissions, and the resulting UNIX mode is then bit\-wise 'AND'ed with this parameter\&. This parameter may be thought of as a bit\-wise MASK for the UNIX modes of a directory\&. Any bit \fBnot\fR set here will be removed from the modes set on a directory when it is created\&.

The default value of this parameter removes the 'group' and 'other' write bits from the UNIX mode, allowing only the user who owns the directory to modify it\&.

Following this Samba will bit\-wise 'OR' the UNIX mode created from this parameter with the value of the \fIforce directory mode\fR parameter\&. This parameter is set to 000 by default (i\&.e\&. no extra mode bits are added)\&.

Note that this parameter does not apply to permissions set by Windows NT/2000 ACL editors\&. If the administrator wishes to enforce a mask on access control lists also, they need to set the \fIdirectory security mask\fR\&.

Default: \fB\fIdirectory mask\fR = 0755 \fR 

Example: \fB\fIdirectory mask\fR = 0775 \fR 

.TP
directory security mask (S)
This parameter controls what UNIX permission bits can be modified when a Windows NT client is manipulating the UNIX permission on a directory using the native NT security dialog box\&.

This parameter is applied as a mask (AND'ed with) to the changed permission bits, thus preventing any bits not in this mask from being modified\&. Essentially, zero bits in this mask may be treated as a set of bits the user is not allowed to change\&.

If not set explicitly this parameter is set to 0777 meaning a user is allowed to modify all the user/group/world permissions on a directory\&.

\fBNote\fR that users who can access the Samba server through other means can easily bypass this restriction, so it is primarily useful for standalone "appliance" systems\&. Administrators of most normal systems will probably want to leave it as the default of \fB0777\fR\&.

Default: \fB\fIdirectory security mask\fR = 0777 \fR 

Example: \fB\fIdirectory security mask\fR = 0700 \fR 

.TP
disable netbios (G)
Enabling this parameter will disable netbios support in Samba\&. Netbios is the only available form of browsing in all windows versions except for 2000 and XP\&.


.RS
.Sh "Note"
Clients that only support netbios won't be able to see your samba server when netbios support is disabled\&.

.RE
Default: \fB\fIdisable netbios\fR = no \fR 

.TP
disable spoolss (G)
Enabling this parameter will disable Samba's support for the SPOOLSS set of MS\-RPC's and will yield identical behavior as Samba 2\&.0\&.x\&. Windows NT/2000 clients will downgrade to using Lanman style printing commands\&. Windows 9x/ME will be uneffected by the parameter\&. However, this will also disable the ability to upload printer drivers to a Samba server via the Windows NT Add Printer Wizard or by using the NT printer properties dialog window\&. It will also disable the capability of Windows NT/2000 clients to download print drivers from the Samba host upon demand\&. \fBBe very careful about enabling this parameter\&.\fR 

Default: \fB\fIdisable spoolss\fR = no \fR 

.TP
display charset (G)
Specifies the charset that samba will use to print messages to stdout and stderr and SWAT will use\&. Should generally be the same as the \fBunix charset\fR\&.

Default: \fB\fIdisplay charset\fR = ASCII \fR 

Example: \fB\fIdisplay charset\fR = UTF8 \fR 

.TP
dns proxy (G)
Specifies that \fBnmbd\fR(8) when acting as a WINS server and finding that a NetBIOS name has not been registered, should treat the NetBIOS name word\-for\-word as a DNS name and do a lookup with the DNS server for that name on behalf of the name\-querying client\&.

Note that the maximum length for a NetBIOS name is 15 characters, so the DNS name (or DNS alias) can likewise only be 15 characters, maximum\&.

\fBnmbd\fR spawns a second copy of itself to do the DNS name lookup requests, as doing a name lookup is a blocking action\&.

Default: \fB\fIdns proxy\fR = yes \fR 

.TP
domain logons (G)
If set to \fByes\fR, the Samba server will serve Windows 95/98 Domain logons for the \fIworkgroup\fR it is in\&. Samba 2\&.2 has limited capability to act as a domain controller for Windows NT 4 Domains\&. For more details on setting up this feature see the PDC chapter of the Samba HOWTO Collection\&.

Default: \fB\fIdomain logons\fR = no \fR 

.TP
domain master (G)
Tell \fBsmbd\fR(8) to enable WAN\-wide browse list collation\&. Setting this option causes \fBnmbd\fR to claim a special domain specific NetBIOS name that identifies it as a domain master browser for its given \fIworkgroup\fR\&. Local master browsers in the same \fIworkgroup\fR on broadcast\-isolated subnets will give this \fBnmbd\fR their local browse lists, and then ask \fBsmbd\fR(8) for a complete copy of the browse list for the whole wide area network\&. Browser clients will then contact their local master browser, and will receive the domain\-wide browse list, instead of just the list for their broadcast\-isolated subnet\&.

Note that Windows NT Primary Domain Controllers expect to be able to claim this \fIworkgroup\fR specific special NetBIOS name that identifies them as domain master browsers for that \fIworkgroup\fR by default (i\&.e\&. there is no way to prevent a Windows NT PDC from attempting to do this)\&. This means that if this parameter is set and \fBnmbd\fR claims the special name for a \fIworkgroup\fR before a Windows NT PDC is able to do so then cross subnet browsing will behave strangely and may fail\&.

If \fBdomain logons = yes\fR, then the default behavior is to enable the \fIdomain master\fR parameter\&. If \fIdomain logons\fR is not enabled (the default setting), then neither will \fIdomain master\fR be enabled by default\&.

Default: \fB\fIdomain master\fR = auto \fR 

.TP
dont descend (S)
There are certain directories on some systems (e\&.g\&., the \fI/proc\fR tree under Linux) that are either not of interest to clients or are infinitely deep (recursive)\&. This parameter allows you to specify a comma\-delimited list of directories that the server should always show as empty\&.

Note that Samba can be very fussy about the exact format of the "dont descend" entries\&. For example you may need \fI \&./proc\fR instead of just \fI/proc\fR\&. Experimentation is the best policy :\-)

Default: \fB\fIdont descend\fR = \fR 

Example: \fB\fIdont descend\fR = /proc,/dev \fR 

.TP
dos charset (G)
DOS SMB clients assume the server has the same charset as they do\&. This option specifies which charset Samba should talk to DOS clients\&.

The default depends on which charsets you have installed\&. Samba tries to use charset 850 but falls back to ASCII in case it is not available\&. Run \fBtestparm\fR(1) to check the default on your system\&.

\fBNo default\fR

.TP
dos filemode (S)
The default behavior in Samba is to provide UNIX\-like behavior where only the owner of a file/directory is able to change the permissions on it\&. However, this behavior is often confusing to DOS/Windows users\&. Enabling this parameter allows a user who has write access to the file (by whatever means) to modify the permissions on it\&. Note that a user belonging to the group owning the file will not be allowed to change permissions if the group is only granted read access\&. Ownership of the file/directory is not changed, only the permissions are modified\&.

Default: \fB\fIdos filemode\fR = no \fR 

.TP
dos filetime resolution (S)
Under the DOS and Windows FAT filesystem, the finest granularity on time resolution is two seconds\&. Setting this parameter for a share causes Samba to round the reported time down to the nearest two second boundary when a query call that requires one second resolution is made to \fBsmbd\fR(8)\&.

This option is mainly used as a compatibility option for Visual C++ when used against Samba shares\&. If oplocks are enabled on a share, Visual C++ uses two different time reading calls to check if a file has changed since it was last read\&. One of these calls uses a one\-second granularity, the other uses a two second granularity\&. As the two second call rounds any odd second down, then if the file has a timestamp of an odd number of seconds then the two timestamps will not match and Visual C++ will keep reporting the file has changed\&. Setting this option causes the two timestamps to match, and Visual C++ is happy\&.

Default: \fB\fIdos filetime resolution\fR = no \fR 

.TP
dos filetimes (S)
Under DOS and Windows, if a user can write to a file they can change the timestamp on it\&. Under POSIX semantics, only the owner of the file or root may change the timestamp\&. By default, Samba runs with POSIX semantics and refuses to change the timestamp on a file if the user \fBsmbd\fR is acting on behalf of is not the file owner\&. Setting this option to \fB yes\fR allows DOS semantics and \fBsmbd\fR(8) will change the file timestamp as DOS requires\&.

Default: \fB\fIdos filetimes\fR = no \fR 

.TP
ea support (S)
This boolean parameter controls whether \fBsmbd\fR(8) will allow clients to attempt to store OS/2 style Extended attributes on a share\&. In order to enable this parameter the underlying filesystem exported by the share must support extended attributes (such as provided on XFS and EXT3 on Linux, with the correct kernel patches)\&. On Linux the filesystem must have been mounted with the mount option user_xattr in order for extended attributes to work, also extended attributes must be compiled into the Linux kernel\&.

Default: \fB\fIea support\fR = no \fR 

.TP
enable rid algorithm (G)
This option is used to control whether or not smbd in Samba 3\&.0 should fallback to the algorithm used by Samba 2\&.2 to generate user and group RIDs\&. The longterm development goal is to remove the algorithmic mappings of RIDs altogether, but this has proved to be difficult\&. This parameter is mainly provided so that developers can turn the algorithm on and off and see what breaks\&. This parameter should not be disabled by non\-developers because certain features in Samba will fail to work without it\&.

Default: \fB\fIenable rid algorithm\fR = yes \fR 

.TP
encrypt passwords (G)
This boolean controls whether encrypted passwords will be negotiated with the client\&. Note that Windows NT 4\&.0 SP3 and above and also Windows 98 will by default expect encrypted passwords unless a registry entry is changed\&. To use encrypted passwords in Samba see the chapter "User Database" in the Samba HOWTO Collection\&.

In order for encrypted passwords to work correctly \fBsmbd\fR(8) must either have access to a local \fBsmbpasswd\fR(5) file (see the \fBsmbpasswd\fR(8) program for information on how to set up and maintain this file), or set the security = [server|domain|ads] parameter which causes \fBsmbd\fR to authenticate against another server\&.

Default: \fB\fIencrypt passwords\fR = yes \fR 

.TP
enhanced browsing (G)
This option enables a couple of enhancements to cross\-subnet browse propagation that have been added in Samba but which are not standard in Microsoft implementations\&.

The first enhancement to browse propagation consists of a regular wildcard query to a Samba WINS server for all Domain Master Browsers, followed by a browse synchronization with each of the returned DMBs\&. The second enhancement consists of a regular randomised browse synchronization with all currently known DMBs\&.

You may wish to disable this option if you have a problem with empty workgroups not disappearing from browse lists\&. Due to the restrictions of the browse protocols these enhancements can cause a empty workgroup to stay around forever which can be annoying\&.

In general you should leave this option enabled as it makes cross\-subnet browse propagation much more reliable\&.

Default: \fB\fIenhanced browsing\fR = yes \fR 

.TP
enumports command (G)
The concept of a "port" is fairly foreign to UNIX hosts\&. Under Windows NT/2000 print servers, a port is associated with a port monitor and generally takes the form of a local port (i\&.e\&. LPT1:, COM1:, FILE:) or a remote port (i\&.e\&. LPD Port Monitor, etc\&.\&.\&.)\&. By default, Samba has only one port defined\-\-\fB"Samba Printer Port"\fR\&. Under Windows NT/2000, all printers must have a valid port name\&. If you wish to have a list of ports displayed (\fBsmbd \fR does not use a port name for anything) other than the default \fB"Samba Printer Port"\fR, you can define \fIenumports command\fR to point to a program which should generate a list of ports, one per line, to standard output\&. This listing will then be used in response to the level 1 and 2 EnumPorts() RPC\&.

Default: \fB\fIenumports command\fR = \fR 

Example: \fB\fIenumports command\fR = /usr/bin/listports \fR 

.TP
fake directory create times (S)
NTFS and Windows VFAT file systems keep a create time for all files and directories\&. This is not the same as the ctime \- status change time \- that Unix keeps, so Samba by default reports the earliest of the various times Unix does keep\&. Setting this parameter for a share causes Samba to always report midnight 1\-1\-1980 as the create time for directories\&.

This option is mainly used as a compatibility option for Visual C++ when used against Samba shares\&. Visual C++ generated makefiles have the object directory as a dependency for each object file, and a make rule to create the directory\&. Also, when NMAKE compares timestamps it uses the creation time when examining a directory\&. Thus the object directory will be created if it does not exist, but once it does exist it will always have an earlier timestamp than the object files it contains\&.

However, Unix time semantics mean that the create time reported by Samba will be updated whenever a file is created or or deleted in the directory\&. NMAKE finds all object files in the object directory\&. The timestamp of the last one built is then compared to the timestamp of the object directory\&. If the directory's timestamp if newer, then all object files will be rebuilt\&. Enabling this option ensures directories always predate their contents and an NMAKE build will proceed as expected\&.

Default: \fB\fIfake directory create times\fR = no \fR 

.TP
fake oplocks (S)
Oplocks are the way that SMB clients get permission from a server to locally cache file operations\&. If a server grants an oplock (opportunistic lock) then the client is free to assume that it is the only one accessing the file and it will aggressively cache file data\&. With some oplock types the client may even cache file open/close operations\&. This can give enormous performance benefits\&.

When you set \fBfake oplocks = yes\fR, \fBsmbd\fR(8) will always grant oplock requests no matter how many clients are using the file\&.

It is generally much better to use the real \fIoplocks\fR support rather than this parameter\&.

If you enable this option on all read\-only shares or shares that you know will only be accessed from one client at a time such as physically read\-only media like CDROMs, you will see a big performance improvement on many operations\&. If you enable this option on shares where multiple clients may be accessing the files read\-write at the same time you can get data corruption\&. Use this option carefully!

Default: \fB\fIfake oplocks\fR = no \fR 

.TP
follow symlinks (S)
This parameter allows the Samba administrator to stop \fBsmbd\fR(8)from following symbolic links in a particular share\&. Setting this parameter to \fBno\fR prevents any file or directory that is a symbolic link from being followed (the user will get an error)\&. This option is very useful to stop users from adding a symbolic link to \fI/etc/passwd\fR in their home directory for instance\&. However it will slow filename lookups down slightly\&.

This option is enabled (i\&.e\&. \fBsmbd\fR will follow symbolic links) by default\&.

Default: \fB\fIfollow symlinks\fR = yes \fR 

.TP
force create mode (S)
This parameter specifies a set of UNIX mode bit permissions that will \fBalways\fR be set on a file created by Samba\&. This is done by bitwise 'OR'ing these bits onto the mode bits of a file that is being created or having its permissions changed\&. The default for this parameter is (in octal) 000\&. The modes in this parameter are bitwise 'OR'ed onto the file mode after the mask set in the \fIcreate mask\fR parameter is applied\&.

The example below would force all created files to have read and execute permissions set for 'group' and 'other' as well as the read/write/execute bits set for the 'user'\&.

Default: \fB\fIforce create mode\fR = 000 \fR 

Example: \fB\fIforce create mode\fR = 0755 \fR 

.TP
force directory mode (S)
This parameter specifies a set of UNIX mode bit permissions that will \fBalways\fR be set on a directory created by Samba\&. This is done by bitwise 'OR'ing these bits onto the mode bits of a directory that is being created\&. The default for this parameter is (in octal) 0000 which will not add any extra permission bits to a created directory\&. This operation is done after the mode mask in the parameter \fIdirectory mask\fR is applied\&.

The example below would force all created directories to have read and execute permissions set for 'group' and 'other' as well as the read/write/execute bits set for the 'user'\&.

Default: \fB\fIforce directory mode\fR = 000 \fR 

Example: \fB\fIforce directory mode\fR = 0755 \fR 

.TP
force directory security mode (S)
This parameter controls what UNIX permission bits can be modified when a Windows NT client is manipulating the UNIX permission on a directory using the native NT security dialog box\&.

This parameter is applied as a mask (OR'ed with) to the changed permission bits, thus forcing any bits in this mask that the user may have modified to be on\&. Essentially, one bits in this mask may be treated as a set of bits that, when modifying security on a directory, the user has always set to be 'on'\&.

If not set explicitly this parameter is 000, which allows a user to modify all the user/group/world permissions on a directory without restrictions\&.


.RS
.Sh "Note"
Users who can access the Samba server through other means can easily bypass this restriction, so it is primarily useful for standalone "appliance" systems\&. Administrators of most normal systems will probably want to leave it set as 0000\&.

.RE
Default: \fB\fIforce directory security mode\fR = 0 \fR 

Example: \fB\fIforce directory security mode\fR = 700 \fR 

.TP
group
This parameter is a synonym for force group\&.

.TP
force group (S)
This specifies a UNIX group name that will be assigned as the default primary group for all users connecting to this service\&. This is useful for sharing files by ensuring that all access to files on service will use the named group for their permissions checking\&. Thus, by assigning permissions for this group to the files and directories within this service the Samba administrator can restrict or allow sharing of these files\&.

In Samba 2\&.0\&.5 and above this parameter has extended functionality in the following way\&. If the group name listed here has a '+' character prepended to it then the current user accessing the share only has the primary group default assigned to this group if they are already assigned as a member of that group\&. This allows an administrator to decide that only users who are already in a particular group will create files with group ownership set to that group\&. This gives a finer granularity of ownership assignment\&. For example, the setting \fIforce group = +sys\fR means that only users who are already in group sys will have their default primary group assigned to sys when accessing this Samba share\&. All other users will retain their ordinary primary group\&.

If the \fIforce user\fR parameter is also set the group specified in \fIforce group\fR will override the primary group set in \fIforce user\fR\&.

Default: \fB\fIforce group\fR = \fR 

Example: \fB\fIforce group\fR = agroup \fR 

.TP
force printername (S)
When printing from Windows NT (or later), each printer in \fIsmb\&.conf\fR has two associated names which can be used by the client\&. The first is the sharename (or shortname) defined in smb\&.conf\&. This is the only printername available for use by Windows 9x clients\&. The second name associated with a printer can be seen when browsing to the "Printers" (or "Printers and Faxes") folder on the Samba server\&. This is referred to simply as the printername (not to be confused with the \fIprinter name\fR option)\&.

When assigning a new driver to a printer on a remote Windows compatible print server such as Samba, the Windows client will rename the printer to match the driver name just uploaded\&. This can result in confusion for users when multiple printers are bound to the same driver\&. To prevent Samba from allowing the printer's printername to differ from the sharename defined in smb\&.conf, set \fIforce printername = yes\fR\&.

Be aware that enabling this parameter may affect migrating printers from a Windows server to Samba since Windows has no way to force the sharename and printername to match\&.

It is recommended that this parameter's value not be changed once the printer is in use by clients as this could cause a user not be able to delete printer connections from their local Printers folder\&.

Default: \fB\fIforce printername\fR = no \fR 

.TP
force security mode (S)
This parameter controls what UNIX permission bits can be modified when a Windows NT client is manipulating the UNIX permission on a file using the native NT security dialog box\&.

This parameter is applied as a mask (OR'ed with) to the changed permission bits, thus forcing any bits in this mask that the user may have modified to be on\&. Essentially, one bits in this mask may be treated as a set of bits that, when modifying security on a file, the user has always set to be 'on'\&.

If not set explicitly this parameter is set to 0, and allows a user to modify all the user/group/world permissions on a file, with no restrictions\&.

\fBNote\fR that users who can access the Samba server through other means can easily bypass this restriction, so it is primarily useful for standalone "appliance" systems\&. Administrators of most normal systems will probably want to leave this set to 0000\&.

Default: \fB\fIforce security mode\fR = 0 \fR 

Example: \fB\fIforce security mode\fR = 700 \fR 

.TP
force unknown acl user (S)
If this parameter is set, a Windows NT ACL that contains an unknown SID (security descriptor, or representation of a user or group id) as the owner or group owner of the file will be silently mapped into the current UNIX uid or gid of the currently connected user\&.

This is designed to allow Windows NT clients to copy files and folders containing ACLs that were created locally on the client machine and contain users local to that machine only (no domain users) to be copied to a Samba server (usually with XCOPY /O) and have the unknown userid and groupid of the file owner map to the current connected user\&. This can only be fixed correctly when winbindd allows arbitrary mapping from any Windows NT SID to a UNIX uid or gid\&.

Try using this parameter when XCOPY /O gives an ACCESS_DENIED error\&.

Default: \fB\fIforce unknown acl user\fR = no \fR 

.TP
force user (S)
This specifies a UNIX user name that will be assigned as the default user for all users connecting to this service\&. This is useful for sharing files\&. You should also use it carefully as using it incorrectly can cause security problems\&.

This user name only gets used once a connection is established\&. Thus clients still need to connect as a valid user and supply a valid password\&. Once connected, all file operations will be performed as the "forced user", no matter what username the client connected as\&. This can be very useful\&.

In Samba 2\&.0\&.5 and above this parameter also causes the primary group of the forced user to be used as the primary group for all file activity\&. Prior to 2\&.0\&.5 the primary group was left as the primary group of the connecting user (this was a bug)\&.

Default: \fB\fIforce user\fR = \fR 

Example: \fB\fIforce user\fR = auser \fR 

.TP
fstype (S)
This parameter allows the administrator to configure the string that specifies the type of filesystem a share is using that is reported by \fBsmbd\fR(8) when a client queries the filesystem type for a share\&. The default type is \fBNTFS\fR for compatibility with Windows NT but this can be changed to other strings such as \fBSamba\fR or \fBFAT \fR if required\&.

Default: \fB\fIfstype\fR = NTFS \fR 

Example: \fB\fIfstype\fR = Samba \fR 

.TP
get quota command (G)
The \fBget quota command\fR should only be used whenever there is no operating system API available from the OS that samba can use\&.

This option is only available with \fB\&./configure \-\-with\-sys\-quotas\fR\&. Or on linux when \fB\&./configure \-\-with\-quotas\fR was used and a working quota api was found in the system\&.

This parameter should specify the path to a script that queries the quota information for the specified user/group for the partition that the specified directory is on\&.

Such a script should take 3 arguments:


.RS
.TP 3
\(bu
directory
.TP
\(bu
type of query
.TP
\(bu
uid of user or gid of group
.LP
.RE
The type of query can be one of :


.RS
.TP 3
\(bu
1 \- user quotas
.TP
\(bu
2 \- user default quotas (uid = \-1)
.TP
\(bu
3 \- group quotas
.TP
\(bu
4 \- group default quotas (gid = \-1)
.LP
.RE
This script should print one line as output with spaces between the arguments\&. The arguments are:


.RS
.TP 3
\(bu
Arg 1 \- quota flags (0 = no quotas, 1 = quotas enabled, 2 = quotas enabled and enforced)
.TP
\(bu
Arg 2 \- number of currently used blocks
.TP
\(bu
Arg 3 \- the softlimit number of blocks
.TP
\(bu
Arg 4 \- the hardlimit number of blocks
.TP
\(bu
Arg 5 \- currently used number of inodes
.TP
\(bu
Arg 6 \- the softlimit number of inodes
.TP
\(bu
Arg 7 \- the hardlimit number of inodes
.TP
\(bu
Arg 8(optional) \- the number of bytes in a block(default is 1024)
.LP
.RE
Default: \fB\fIget quota command\fR = \fR 

Example: \fB\fIget quota command\fR = /usr/local/sbin/query_quota \fR 

.TP
getwd cache (G)
This is a tuning option\&. When this is enabled a caching algorithm will be used to reduce the time taken for getwd() calls\&. This can have a significant impact on performance, especially when the \fIwide links\fR parameter is set to \fBno\fR\&.

Default: \fB\fIgetwd cache\fR = yes \fR 

.TP
guest account (G)
This is a username which will be used for access to services which are specified as \fI guest ok\fR (see below)\&. Whatever privileges this user has will be available to any client connecting to the guest service\&. This user must exist in the password file, but does not require a valid login\&. The user account "ftp" is often a good choice for this parameter\&.

On some systems the default guest account "nobody" may not be able to print\&. Use another account in this case\&. You should test this by trying to log in as your guest user (perhaps by using the \fBsu \-\fR command) and trying to print using the system print command such as \fBlpr(1)\fR or \fB lp(1)\fR\&.

This parameter does not accept % macros, because many parts of the system require this value to be constant for correct operation\&.

Default: \fB\fIguest account\fR = nobody # default can be changed at compile\-time \fR 

Example: \fB\fIguest account\fR = ftp \fR 

.TP
public
This parameter is a synonym for guest ok\&.

.TP
guest ok (S)
If this parameter is \fByes\fR for a service, then no password is required to connect to the service\&. Privileges will be those of the \fI guest account\fR\&.

This paramater nullifies the benifits of setting \fIrestrict anonymous\fR = 2

See the section below on \fI security\fR for more information about this option\&.

Default: \fB\fIguest ok\fR = no \fR 

.TP
only guest
This parameter is a synonym for guest only\&.

.TP
guest only (S)
If this parameter is \fByes\fR for a service, then only guest connections to the service are permitted\&. This parameter will have no effect if \fIguest ok\fR is not set for the service\&.

See the section below on \fI security\fR for more information about this option\&.

Default: \fB\fIguest only\fR = no \fR 

.TP
hide dot files (S)
This is a boolean parameter that controls whether files starting with a dot appear as hidden files\&.

Default: \fB\fIhide dot files\fR = yes \fR 

.TP
hide files (S)
This is a list of files or directories that are not visible but are accessible\&. The DOS 'hidden' attribute is applied to any files or directories that match\&.

Each entry in the list must be separated by a '/', which allows spaces to be included in the entry\&. '*' and '?' can be used to specify multiple files or directories as in DOS wildcards\&.

Each entry must be a Unix path, not a DOS path and must not include the Unix directory separator '/'\&.

Note that the case sensitivity option is applicable in hiding files\&.

Setting this parameter will affect the performance of Samba, as it will be forced to check all files and directories for a match as they are scanned\&.

Default: \fB\fIhide files\fR = # no file are hidden \fR 

Example: \fB\fIhide files\fR = /\&.*/DesktopFolderDB/TrashFor%m/resource\&.frk/ # The above example is based on files that the Macintosh SMB client (DAVE) available from Thursby creates for internal use, and also still hides all files beginning with a dot\&. \fR 

.TP
hide special files (S)
This parameter prevents clients from seeing special files such as sockets, devices and fifo's in directory listings\&.

Default: \fB\fIhide special files\fR = no \fR 

.TP
hide unreadable (S)
This parameter prevents clients from seeing the existance of files that cannot be read\&. Defaults to off\&.

Default: \fB\fIhide unreadable\fR = no \fR 

.TP
hide unwriteable files (S)
This parameter prevents clients from seeing the existance of files that cannot be written to\&. Defaults to off\&. Note that unwriteable directories are shown as usual\&.

Default: \fB\fIhide unwriteable files\fR = no \fR 

.TP
homedir map (G)
If\fInis homedir \fR is \fByes\fR, and \fBsmbd\fR(8) is also acting as a Win95/98 \fIlogon server\fR then this parameter specifies the NIS (or YP) map from which the server for the user's home directory should be extracted\&. At present, only the Sun auto\&.home map format is understood\&. The form of the map is:

\fBusername server:/some/file/system\fR

and the program will extract the servername from before the first ':'\&. There should probably be a better parsing system that copes with different map formats and also Amd (another automounter) maps\&.


.RS
.Sh "Note"
A working NIS client is required on the system for this option to work\&.

.RE
Default: \fB\fIhomedir map\fR = \fR 

Example: \fB\fIhomedir map\fR = amd\&.homedir \fR 

.TP
host msdfs (G)
If set to \fByes\fR, Samba will act as a Dfs server, and allow Dfs\-aware clients to browse Dfs trees hosted on the server\&.

See also the \fI msdfs root\fR share level parameter\&. For more information on setting up a Dfs tree on Samba, refer to ???\&.

Default: \fB\fIhost msdfs\fR = no \fR 

.TP
hostname lookups (G)
Specifies whether samba should use (expensive) hostname lookups or use the ip addresses instead\&. An example place where hostname lookups are currently used is when checking the \fBhosts deny\fR and \fBhosts allow\fR\&.

Default: \fB\fIhostname lookups\fR = yes \fR 

Example: \fB\fIhostname lookups\fR = no \fR 

.TP
allow hosts
This parameter is a synonym for hosts allow\&.

.TP
hosts allow (S)
A synonym for this parameter is \fIallow hosts\fR\&.

This parameter is a comma, space, or tab delimited set of hosts which are permitted to access a service\&.

If specified in the [global] section then it will apply to all services, regardless of whether the individual service has a different setting\&.

You can specify the hosts by name or IP number\&. For example, you could restrict access to only the hosts on a Class C subnet with something like \fBallow hosts = 150\&.203\&.5\&. \fR\&. The full syntax of the list is described in the man page \fIhosts_access(5)\fR\&. Note that this man page may not be present on your system, so a brief description will be given here also\&.

Note that the localhost address 127\&.0\&.0\&.1 will always be allowed access unless specifically denied by a \fIhosts deny\fR option\&.

You can also specify hosts by network/netmask pairs and by netgroup names if your system supports netgroups\&. The \fBEXCEPT\fR keyword can also be used to limit a wildcard list\&. The following examples may provide some help:

Example 1: allow all IPs in 150\&.203\&.*\&.*; except one

\fBhosts allow = 150\&.203\&. EXCEPT 150\&.203\&.6\&.66\fR

Example 2: allow hosts that match the given network/netmask

\fBhosts allow = 150\&.203\&.15\&.0/255\&.255\&.255\&.0\fR

Example 3: allow a couple of hosts

\fBhosts allow = lapland, arvidsjaur\fR

Example 4: allow only hosts in NIS netgroup "foonet", but deny access from one particular host

\fBhosts allow = @foonet\fR

\fBhosts deny = pirate\fR


.RS
.Sh "Note"
Note that access still requires suitable user\-level passwords\&.

.RE
See \fBtestparm\fR(1) for a way of testing your host access to see if it does what you expect\&.

Default: \fB\fIhosts allow\fR = # none (i\&.e\&., all hosts permitted access) \fR 

Example: \fB\fIhosts allow\fR = 150\&.203\&.5\&. myhost\&.mynet\&.edu\&.au \fR 

.TP
deny hosts
This parameter is a synonym for hosts deny\&.

.TP
hosts deny (S)
The opposite of \fIhosts allow\fR \- hosts listed here are \fBNOT\fR permitted access to services unless the specific services have their own lists to override this one\&. Where the lists conflict, the \fIallow\fR list takes precedence\&.

Default: \fB\fIhosts deny\fR = # none (i\&.e\&., no hosts specifically excluded) \fR 

Example: \fB\fIhosts deny\fR = 150\&.203\&.4\&. badhost\&.mynet\&.edu\&.au \fR 

.TP
hosts equiv (G)
If this global parameter is a non\-null string, it specifies the name of a file to read for the names of hosts and users who will be allowed access without specifying a password\&.

This is not be confused with \fIhosts allow\fR which is about hosts access to services and is more useful for guest services\&. \fI hosts equiv\fR may be useful for NT clients which will not supply passwords to Samba\&.


.RS
.Sh "Note"
The use of \fIhosts equiv \fR can be a major security hole\&. This is because you are trusting the PC to supply the correct username\&. It is very easy to get a PC to supply a false username\&. I recommend that the \fIhosts equiv\fR option be only used if you really know what you are doing, or perhaps on a home network where you trust your spouse and kids\&. And only if you \fBreally\fR trust them :\-)\&.

.RE
Default: \fB\fIhosts equiv\fR = # no host equivalences \fR 

Example: \fB\fIhosts equiv\fR = hosts equiv = /etc/hosts\&.equiv \fR 

.TP
idmap backend (G)
The purpose of the idmap backend parameter is to allow idmap to NOT use the local idmap tdb file to obtain SID to UID / GID mappings, but instead to obtain them from a common LDAP backend\&. This way all domain members and controllers will have the same UID and GID to SID mappings\&. This avoids the risk of UID / GID inconsistencies across UNIX / Linux systems that are sharing information over protocols other than SMB/CIFS (ie: NFS)\&.

An alternate method of SID to UID / GID mapping can be achieved using the idmap_rid plug\-in\&. This plug\-in uses the account RID to derive the UID and GID by adding the RID to a base value specified\&. This utility requires that the parameter``\fBallow trusted domains = No\fR'' must be specified, as it is not compatible with multiple domain environments\&. The idmap uid and idmap gid ranges must also be specified\&.

Default: \fB\fIidmap backend\fR = \fR 

Example: \fB\fIidmap backend\fR = ldap:ldap://ldapslave\&.example\&.com \fR 

Example: \fB\fIidmap backend\fR = idmap_rid:DOMNAME=1000\-100000000 \fR 

.TP
winbind gid
This parameter is a synonym for idmap gid\&.

.TP
idmap gid (G)
The idmap gid parameter specifies the range of group ids that are allocated for the purpose of mapping UNX groups to NT group SIDs\&. This range of group ids should have no existing local or NIS groups within it as strange conflicts can occur otherwise\&.

The availability of an idmap gid range is essential for correct operation of all group mapping\&.

Default: \fB\fIidmap gid\fR = \fR 

Example: \fB\fIidmap gid\fR = 10000\-20000 \fR 

.TP
winbind uid
This parameter is a synonym for idmap uid\&.

.TP
idmap uid (G)
The idmap uid parameter specifies the range of user ids that are allocated for use in mapping UNIX users to NT user SIDs\&. This range of ids should have no existing local or NIS users within it as strange conflicts can occur otherwise\&.

Default: \fB\fIidmap uid\fR = \fR 

Example: \fB\fIidmap uid\fR = 10000\-20000 \fR 

.TP
include (G)
This allows you to include one config file inside another\&. The file is included literally, as though typed in place\&.

It takes the standard substitutions, except \fI%u \fR, \fI%P\fR and \fI%S\fR\&.

Default: \fB\fIinclude\fR = \fR 

Example: \fB\fIinclude\fR = /usr/local/samba/lib/admin_smb\&.conf \fR 

.TP
inherit acls (S)
This parameter can be used to ensure that if default acls exist on parent directories, they are always honored when creating a subdirectory\&. The default behavior is to use the mode specified when creating the directory\&. Enabling this option sets the mode to 0777, thus guaranteeing that default directory acls are propagated\&.

Default: \fB\fIinherit acls\fR = no \fR 

.TP
inherit permissions (S)
The permissions on new files and directories are normally governed by \fI create mask\fR, \fIdirectory mask\fR, \fIforce create mode\fR and \fIforce directory mode\fR but the boolean inherit permissions parameter overrides this\&.

New directories inherit the mode of the parent directory, including bits such as setgid\&.

New files inherit their read/write bits from the parent directory\&. Their execute bits continue to be determined by \fImap archive\fR, \fImap hidden\fR and \fImap system\fR as usual\&.

Note that the setuid bit is \fBnever\fR set via inheritance (the code explicitly prohibits this)\&.

This can be particularly useful on large systems with many users, perhaps several thousand, to allow a single [homes] share to be used flexibly by each user\&.

Default: \fB\fIinherit permissions\fR = no \fR 

.TP
interfaces (G)
This option allows you to override the default network interfaces list that Samba will use for browsing, name registration and other NBT traffic\&. By default Samba will query the kernel for the list of all active interfaces and use any interfaces except 127\&.0\&.0\&.1 that are broadcast capable\&.

The option takes a list of interface strings\&. Each string can be in any of the following forms:


.RS
.TP 3
\(bu
a network interface name (such as eth0)\&. This may include shell\-like wildcards so eth* will match any interface starting with the substring "eth"
.TP
\(bu
an IP address\&. In this case the netmask is determined from the list of interfaces obtained from the kernel
.TP
\(bu
an IP/mask pair\&.
.TP
\(bu
a broadcast/mask pair\&.
.LP
.RE
The "mask" parameters can either be a bit length (such as 24 for a C class network) or a full netmask in dotted decimal form\&.

The "IP" parameters above can either be a full dotted decimal IP address or a hostname which will be looked up via the OS's normal hostname resolution mechanisms\&.

Default: \fB\fIinterfaces\fR = # all active interfaces except 127\&.0\&.0\&.1 that are broadcast capable \fR 

Example: \fB\fIinterfaces\fR = # This would configure three network interfaces corresponding to the eth0 device and IP addresses 192\&.168\&.2\&.10 and 192\&.168\&.3\&.10\&. The netmasks of the latter two interfaces would be set to 255\&.255\&.255\&.0\&. eth0 192\&.168\&.2\&.10/24 192\&.168\&.3\&.10/255\&.255\&.255\&.0 \fR 

.TP
invalid users (S)
This is a list of users that should not be allowed to login to this service\&. This is really a \fBparanoid\fR check to absolutely ensure an improper setting does not breach your security\&.

A name starting with a '@' is interpreted as an NIS netgroup first (if your system supports NIS), and then as a UNIX group if the name was not found in the NIS netgroup database\&.

A name starting with '+' is interpreted only by looking in the UNIX group database\&. A name starting with '&' is interpreted only by looking in the NIS netgroup database (this requires NIS to be working on your system)\&. The characters '+' and '&' may be used at the start of the name in either order so the value \fI+&group\fR means check the UNIX group database, followed by the NIS netgroup database, and the value \fI&+group\fR means check the NIS netgroup database, followed by the UNIX group database (the same as the '@' prefix)\&.

The current servicename is substituted for \fI%S\fR\&. This is useful in the [homes] section\&.

Default: \fB\fIinvalid users\fR = # no invalid users \fR 

Example: \fB\fIinvalid users\fR = root fred admin @wheel \fR 

.TP
keepalive (G)
The value of the parameter (an integer) represents the number of seconds between \fIkeepalive\fR packets\&. If this parameter is zero, no keepalive packets will be sent\&. Keepalive packets, if sent, allow the server to tell whether a client is still present and responding\&.

Keepalives should, in general, not be needed if the socket being used has the SO_KEEPALIVE attribute set on it (see \fIsocket options\fR)\&. Basically you should only use this option if you strike difficulties\&.

Default: \fB\fIkeepalive\fR = 300 \fR 

Example: \fB\fIkeepalive\fR = 600 \fR 

.TP
kernel change notify (G)
This parameter specifies whether Samba should ask the kernel for change notifications in directories so that SMB clients can refresh whenever the data on the server changes\&.

This parameter is only used when your kernel supports change notification to user programs, using the F_NOTIFY fcntl\&.

Default: \fB\fIkernel change notify\fR = yes \fR 

.TP
kernel oplocks (G)
For UNIXes that support kernel based \fIoplocks\fR (currently only IRIX and the Linux 2\&.4 kernel), this parameter allows the use of them to be turned on or off\&.

Kernel oplocks support allows Samba \fIoplocks \fR to be broken whenever a local UNIX process or NFS operation accesses a file that \fBsmbd\fR(8) has oplocked\&. This allows complete data consistency between SMB/CIFS, NFS and local file access (and is a \fBvery\fR cool feature :\-)\&.

This parameter defaults to \fBon\fR, but is translated to a no\-op on systems that no not have the necessary kernel support\&. You should never need to touch this parameter\&.

Default: \fB\fIkernel oplocks\fR = yes \fR 

.TP
lanman auth (G)
This parameter determines whether or not \fBsmbd\fR(8) will attempt to authenticate users using the LANMAN password hash\&. If disabled, only clients which support NT password hashes (e\&.g\&. Windows NT/2000 clients, smbclient, etc\&.\&.\&. but not Windows 95/98 or the MS DOS network client) will be able to connect to the Samba host\&.

The LANMAN encrypted response is easily broken, due to it's case\-insensitive nature, and the choice of algorithm\&. Servers without Windows 95/98 or MS DOS clients are advised to disable this option\&.

Unlike the \fBencypt passwords\fR option, this parameter cannot alter client behaviour, and the LANMAN response will still be sent over the network\&. See the \fBclient lanman auth\fR to disable this for Samba's clients (such as smbclient)

If this option, and \fBntlm auth\fR are both disabled, then only NTLMv2 logins will be permited\&. Not all clients support NTLMv2, and most will require special configuration to us it\&.

Default: \fB\fIlanman auth\fR = yes \fR 

.TP
large readwrite (G)
This parameter determines whether or not \fBsmbd\fR(8) supports the new 64k streaming read and write varient SMB requests introduced with Windows 2000\&. Note that due to Windows 2000 client redirector bugs this requires Samba to be running on a 64\-bit capable operating system such as IRIX, Solaris or a Linux 2\&.4 kernel\&. Can improve performance by 10% with Windows 2000 clients\&. Defaults to on\&. Not as tested as some other Samba code paths\&.

Default: \fB\fIlarge readwrite\fR = yes \fR 

.TP
ldap admin dn (G)
The \fIldap admin dn\fR defines the Distinguished Name (DN) name used by Samba to contact the ldap server when retreiving user account information\&. The \fIldap admin dn\fR is used in conjunction with the admin dn password stored in the \fIprivate/secrets\&.tdb\fR file\&. See the \fBsmbpasswd\fR(8) man page for more information on how to accmplish this\&.

\fBNo default\fR

.TP
ldap delete dn (G)
This parameter specifies whether a delete operation in the ldapsam deletes the complete entry or only the attributes specific to Samba\&.

Default: \fB\fIldap delete dn\fR = no \fR 

.TP
ldap filter (G)
This parameter specifies the RFC 2254 compliant LDAP search filter\&. The default is to match the login name with the \fBuid\fR attribute\&. Note that this filter should only return one entry\&.

Default: \fB\fIldap filter\fR = (uid=%u) \fR 

Example: \fB\fIldap filter\fR = (&(uid=%u)(objectclass=sambaSamAccount)) \fR 

.TP
ldap group suffix (G)
This parameters specifies the suffix that is used for groups when these are added to the LDAP directory\&. If this parameter is unset, the value of \fIldap suffix\fR will be used instead\&.

Default: \fB\fIldap group suffix\fR = \fR 

Example: \fB\fIldap group suffix\fR = dc=samba,ou=Groups \fR 

.TP
ldap idmap suffix (G)
This parameters specifies the suffix that is used when storing idmap mappings\&. If this parameter is unset, the value of \fIldap suffix\fR will be used instead\&.

Default: \fB\fIldap idmap suffix\fR = \fR 

Example: \fB\fIldap idmap suffix\fR = ou=Idmap,dc=samba,dc=org \fR 

.TP
ldap machine suffix (G)
It specifies where machines should be added to the ldap tree\&.

Default: \fB\fIldap machine suffix\fR = \fR 

.TP
ldap passwd sync (G)
This option is used to define whether or not Samba should sync the LDAP password with the NT and LM hashes for normal accounts (NOT for workstation, server or domain trusts) on a password change via SAMBA\&.

The \fIldap passwd sync\fR can be set to one of three values:


.RS
.TP 3
\(bu
\fIYes\fR = Try to update the LDAP, NT and LM passwords and update the pwdLastSet time\&.
.TP
\(bu
\fINo\fR = Update NT and LM passwords and update the pwdLastSet time\&.
.TP
\(bu
\fIOnly\fR = Only update the LDAP password and let the LDAP server do the rest\&.
.LP
.RE
Default: \fB\fIldap passwd sync\fR = no \fR 

.TP
ldap port (G)
This parameter is only available if Samba has been configure to include the \fB\-\-with\-ldapsam\fR option at compile time\&.

This option is used to control the tcp port number used to contact the \fIldap server\fR\&. The default is to use the stand LDAPS port 636\&.

Default: \fB\fIldap port\fR = 636 # if ldap ssl = on \fR 

Default: \fB\fIldap port\fR = 389 # if ldap ssl = off \fR 

.TP
ldap replication sleep (G)
When Samba is asked to write to a read\-only LDAP replica, we are redirected to talk to the read\-write master server\&. This server then replicates our changes back to the 'local' server, however the replication might take some seconds, especially over slow links\&. Certain client activities, particularly domain joins, can become confused by the 'success' that does not immediately change the LDAP back\-end's data\&.

This option simply causes Samba to wait a short time, to allow the LDAP server to catch up\&. If you have a particularly high\-latency network, you may wish to time the LDAP replication with a network sniffer, and increase this value accordingly\&. Be aware that no checking is performed that the data has actually replicated\&.

The value is specified in milliseconds, the maximum value is 5000 (5 seconds)\&.

Default: \fB\fIldap replication sleep\fR = 1000 \fR 

.TP
ldap server (G)
This parameter is only available if Samba has been configure to include the \fB\-\-with\-ldapsam\fR option at compile time\&.

This parameter should contain the FQDN of the ldap directory server which should be queried to locate user account information\&.

Default: \fB\fIldap server\fR = localhost \fR 

.TP
ldap ssl (G)
This option is used to define whether or not Samba should use SSL when connecting to the ldap server This is \fBNOT\fR related to Samba's previous SSL support which was enabled by specifying the\fB\-\-with\-ssl\fR option to the \fIconfigure\fR script\&.

The \fIldap ssl\fR can be set to one of three values:


.RS
.TP 3
\(bu
\fIOff\fR = Never use SSL when querying the directory\&.
.TP
\(bu
\fIStart_tls\fR = Use the LDAPv3 StartTLS extended operation (RFC2830) for communicating with the directory server\&.
.TP
\(bu
\fIOn\fR = Use SSL on the ldaps port when contacting the \fIldap server\fR\&. Only available when the backwards\-compatiblity \fB\-\-with\-ldapsam\fR option is specified to configure\&. See \fIpassdb backend\fR
.LP
.RE
Default: \fB\fIldap ssl\fR = start_tls \fR 

.TP
ldap suffix (G)
Specifies where user and machine accounts are added to the tree\&. Can be overriden by \fBldap user suffix\fR and \fBldap machine suffix\fR\&. It also used as the base dn for all ldap searches\&.

Default: \fB\fIldap suffix\fR = \fR 

.TP
ldap timeout (G)
When Samba connects to an ldap server that server may be down or unreachable\&. To prevent Samba from hanging whilst waiting for the connection this parameter specifies in seconds how long Samba should wait before failing the connect\&. The default is to only wait fifteen seconds for the ldap server to respond to the connect request\&.

Default: \fB\fIldap timeout\fR = 15 \fR 

.TP
ldap user suffix (G)
This parameter specifies where users are added to the tree\&. If this parameter is not specified, the value from \fBldap suffix\fR\&.

Default: \fB\fIldap user suffix\fR = \fR 

.TP
level2 oplocks (S)
This parameter controls whether Samba supports level2 (read\-only) oplocks on a share\&.

Level2, or read\-only oplocks allow Windows NT clients that have an oplock on a file to downgrade from a read\-write oplock to a read\-only oplock once a second client opens the file (instead of releasing all oplocks on a second open, as in traditional, exclusive oplocks)\&. This allows all openers of the file that support level2 oplocks to cache the file for read\-ahead only (ie\&. they may not cache writes or lock requests) and increases performance for many accesses of files that are not commonly written (such as application \&.EXE files)\&.

Once one of the clients which have a read\-only oplock writes to the file all clients are notified (no reply is needed or waited for) and told to break their oplocks to "none" and delete any read\-ahead caches\&.

It is recommended that this parameter be turned on to speed access to shared executables\&.

For more discussions on level2 oplocks see the CIFS spec\&.

Currently, if \fIkernel oplocks\fR are supported then level2 oplocks are not granted (even if this parameter is set to \fByes\fR)\&. Note also, the \fIoplocks\fR parameter must be set to \fByes\fR on this share in order for this parameter to have any effect\&.

Default: \fB\fIlevel2 oplocks\fR = yes \fR 

.TP
lm announce (G)
This parameter determines if \fBnmbd\fR(8) will produce Lanman announce broadcasts that are needed by OS/2 clients in order for them to see the Samba server in their browse list\&. This parameter can have three values, \fByes\fR, \fBno\fR, or\fBauto\fR\&. The default is \fBauto\fR\&. If set to \fBno\fR Samba will never produce these broadcasts\&. If set to \fByes\fR Samba will produce Lanman announce broadcasts at a frequency set by the parameter\fIlm interval\fR\&. If set to \fBauto\fR Samba will not send Lanman announce broadcasts by default but will listen for them\&. If it hears such a broadcast on the wire it will then start sending them at a frequency set by the parameter\fIlm interval\fR\&.

Default: \fB\fIlm announce\fR = auto \fR 

Example: \fB\fIlm announce\fR = yes \fR 

.TP
lm interval (G)
If Samba is set to produce Lanman announce broadcasts needed by OS/2 clients (see the \fIlm announce\fR parameter) then this parameter defines the frequency in seconds with which they will be made\&. If this is set to zero then no Lanman announcements will be made despite the setting of the \fIlm announce\fR parameter\&.

Default: \fB\fIlm interval\fR = 60 \fR 

Example: \fB\fIlm interval\fR = 120 \fR 

.TP
load printers (G)
A boolean variable that controls whether all printers in the printcap will be loaded for browsing by default\&. See the printers section for more details\&.

Default: \fB\fIload printers\fR = yes \fR 

.TP
local master (G)
This option allows \fBnmbd\fR(8) to try and become a local master browser on a subnet\&. If set to \fBno\fR then \fB nmbd\fR will not attempt to become a local master browser on a subnet and will also lose in all browsing elections\&. By default this value is set to \fByes\fR\&. Setting this value to\fByes\fR doesn't mean that Samba will \fBbecome\fR the local master browser on a subnet, just that \fBnmbd\fR will \fBparticipate\fR in elections for local master browser\&.

Setting this value to \fBno\fR will cause \fBnmbd\fR  \fBnever\fR to become a local master browser\&.

Default: \fB\fIlocal master\fR = yes \fR 

.TP
lock dir
This parameter is a synonym for lock directory\&.

.TP
lock directory (G)
This option specifies the directory where lock files will be placed\&. The lock files are used to implement the\fImax connections\fR option\&.

Default: \fB\fIlock directory\fR = ${prefix}/var/locks \fR 

Example: \fB\fIlock directory\fR = /var/run/samba/locks \fR 

.TP
locking (S)
This controls whether or not locking will be performed by the server in response to lock requests from the client\&.

If \fBlocking = no\fR, all lock and unlock requests will appear to succeed and all lock queries will report that the file in question is available for locking\&.

If \fBlocking = yes\fR, real locking will be performed by the server\&.

This option \fBmay\fR be useful for read\-only filesystems which \fBmay\fR not need locking (such as CDROM drives), although setting this parameter of \fBno\fR is not really recommended even in this case\&.

Be careful about disabling locking either globally or in a specific service, as lack of locking may result in data corruption\&. You should never need to set this parameter\&.

\fBNo default\fR

.TP
lock spin count (G)
This parameter controls the number of times that smbd should attempt to gain a byte range lock on the behalf of a client request\&. Experiments have shown that Windows 2k servers do not reply with a failure if the lock could not be immediately granted, but try a few more times in case the lock could later be acquired\&. This behavior is used to support PC database formats such as MS Access and FoxPro\&.

Default: \fB\fIlock spin count\fR = 3 \fR 

.TP
lock spin time (G)
The time in microseconds that smbd should pause before attempting to gain a failed lock\&. See\fIlock spin count\fR for more details\&.

Default: \fB\fIlock spin time\fR = 10 \fR 

.TP
log file (G)
This option allows you to override the name of the Samba log file (also known as the debug file)\&.

This option takes the standard substitutions, allowing you to have separate log files for each user or machine\&.

\fBNo default\fR

Example: \fB\fIlog file\fR = /usr/local/samba/var/log\&.%m \fR 

.TP
debuglevel
This parameter is a synonym for log level\&.

.TP
log level (G)
The value of the parameter (a astring) allows the debug level (logging level) to be specified in the \fIsmb\&.conf\fR file\&. This parameter has been extended since the 2\&.2\&.x series, now it allow to specify the debug level for multiple debug classes\&. This is to give greater flexibility in the configuration of the system\&.

The default will be the log level specified on the command line or level zero if none was specified\&.

\fBNo default\fR

Example: \fB\fIlog level\fR = 3 passdb:5 auth:10 winbind:2 \fR 

.TP
logon drive (G)
This parameter specifies the local path to which the home directory will be connected (see \fIlogon home\fR) and is only used by NT Workstations\&.

Note that this option is only useful if Samba is set up as a logon server\&.

Default: \fB\fIlogon drive\fR = z: \fR 

Example: \fB\fIlogon drive\fR = h: \fR 

.TP
logon home (G)
This parameter specifies the home directory location when a Win95/98 or NT Workstation logs into a Samba PDC\&. It allows you to do

C:\\> \fBNET USE H: /HOME\fR 

from a command prompt, for example\&.

This option takes the standard substitutions, allowing you to have separate logon scripts for each user or machine\&.

This parameter can be used with Win9X workstations to ensure that roaming profiles are stored in a subdirectory of the user's home directory\&. This is done in the following way:

\fBlogon home = \\\\%N\\%U\\profile\fR

This tells Samba to return the above string, with substitutions made when a client requests the info, generally in a NetUserGetInfo request\&. Win9X clients truncate the info to \\\\server\\share when a user does \fBnet use /home\fR but use the whole string when dealing with profiles\&.

Note that in prior versions of Samba, the \fIlogon path\fR was returned rather than\fIlogon home\fR\&. This broke \fBnet use /home\fR but allowed profiles outside the home directory\&. The current implementation is correct, and can be used for profiles if you use the above trick\&.

This option is only useful if Samba is set up as a logon server\&.

Default: \fB\fIlogon home\fR = \\\\%N\\%U \fR 

Example: \fB\fIlogon home\fR = \\\\remote_smb_server\\%U \fR 

.TP
logon path (G)
This parameter specifies the home directory where roaming profiles (NTuser\&.dat etc files for Windows NT) are stored\&. Contrary to previous versions of these manual pages, it has nothing to do with Win 9X roaming profiles\&. To find out how to handle roaming profiles for Win 9X system, see the \fIlogon home\fR parameter\&.

This option takes the standard substitutions, allowing you to have separate logon scripts for each user or machine\&. It also specifies the directory from which the "Application Data", (\fIdesktop\fR, \fIstart menu\fR,\fInetwork neighborhood\fR, \fIprograms\fR and other folders, and their contents, are loaded and displayed on your Windows NT client\&.

The share and the path must be readable by the user for the preferences and directories to be loaded onto the Windows NT client\&. The share must be writeable when the user logs in for the first time, in order that the Windows NT client can create the NTuser\&.dat and other directories\&.

Thereafter, the directories and any of the contents can, if required, be made read\-only\&. It is not advisable that the NTuser\&.dat file be made read\-only \- rename it to NTuser\&.man to achieve the desired effect (a \fBMAN\fRdatory profile)\&.

Windows clients can sometimes maintain a connection to the [homes] share, even though there is no user logged in\&. Therefore, it is vital that the logon path does not include a reference to the homes share (i\&.e\&. setting this parameter to \\%N\\%U\\profile_path will cause problems)\&.

This option takes the standard substitutions, allowing you to have separate logon scripts for each user or machine\&.

Note that this option is only useful if Samba is set up as a logon server\&.

Default: \fB\fIlogon path\fR = \\\\%N\\%U\\profile \fR 

Example: \fB\fIlogon path\fR = >\\\\PROFILESERVER\\PROFILE\\%U \fR 

.TP
logon script (G)
This parameter specifies the batch file (\&.bat) or NT command file (\&.cmd) to be downloaded and run on a machine when a user successfully logs in\&. The file must contain the DOS style CR/LF line endings\&. Using a DOS\-style editor to create the file is recommended\&.

The script must be a relative path to the [netlogon] service\&. If the [netlogon] service specifies a \fIpath\fR of \fI/usr/local/samba/netlogon\fR, and \fBlogon script = STARTUP\&.BAT\fR, then the file that will be downloaded is:

\fI/usr/local/samba/netlogon/STARTUP\&.BAT\fR

The contents of the batch file are entirely your choice\&. A suggested command would be to add \fBNET TIME \\\\SERVER /SET /YES\fR, to force every machine to synchronize clocks with the same time server\&. Another use would be to add \fBNET USE U: \\\\SERVER\\UTILS\fR for commonly used utilities, or 
.nf

	\fBNET USE Q: \\\\SERVER\\ISO9001_QA\fR.fi
 for example\&.

Note that it is particularly important not to allow write access to the [netlogon] share, or to grant users write permission on the batch files in a secure environment, as this would allow the batch files to be arbitrarily modified and security to be breached\&.

This option takes the standard substitutions, allowing you to have separate logon scripts for each user or machine\&.

This option is only useful if Samba is set up as a logon server\&.

Default: \fB\fIlogon script\fR = \fR 

Example: \fB\fIlogon script\fR = scripts\\%U\&.bat \fR 

.TP
lppause command (S)
This parameter specifies the command to be executed on the server host in order to stop printing or spooling a specific print job\&.

This command should be a program or script which takes a printer name and job number to pause the print job\&. One way of implementing this is by using job priorities, where jobs having a too low priority won't be sent to the printer\&.

If a \fI%p\fR is given then the printer name is put in its place\&. A \fI%j\fR is replaced with the job number (an integer)\&. On HPUX (see \fIprinting=hpux \fR), if the \fI\-p%p\fR option is added to the lpq command, the job will show up with the correct status, i\&.e\&. if the job priority is lower than the set fence priority it will have the PAUSED status, whereas if the priority is equal or higher it will have the SPOOLED or PRINTING status\&.

Note that it is good practice to include the absolute path in the lppause command as the PATH may not be available to the server\&.

Default: \fB\fIlppause command\fR = # Currently no default value is given to this string, unless the value of the \fIprinting\fR parameter is \fBSYSV\fR, in which case the default is : \fBlp \-i %p\-%j \-H hold\fR or if the value of the \fIprinting\fR parameter is \fBSOFTQ\fR, then the default is: \fBqstat \-s \-j%j \-h\fR\&. \fR 

Example: \fB\fIlppause command\fR = /usr/bin/lpalt %p\-%j \-p0 \fR 

.TP
lpq cache time (G)
This controls how long lpq info will be cached for to prevent the \fBlpq\fR command being called too often\&. A separate cache is kept for each variation of the \fB lpq\fR command used by the system, so if you use different\fBlpq\fR commands for different users then they won't share cache information\&.

The cache files are stored in \fI/tmp/lpq\&.xxxx\fR where xxxx is a hash of the \fBlpq\fR command in use\&.

The default is 10 seconds, meaning that the cached results of a previous identical \fBlpq\fR command will be used if the cached data is less than 10 seconds old\&. A large value may be advisable if your \fBlpq\fR command is very slow\&.

A value of 0 will disable caching completely\&.

Default: \fB\fIlpq cache time\fR = 10 \fR 

Example: \fB\fIlpq cache time\fR = 30 \fR 

.TP
lpq command (S)
This parameter specifies the command to be executed on the server host in order to obtain \fBlpq \fR\-style printer status information\&.

This command should be a program or script which takes a printer name as its only parameter and outputs printer status information\&.

Currently nine styles of printer status information are supported; BSD, AIX, LPRNG, PLP, SYSV, HPUX, QNX, CUPS, and SOFTQ\&. This covers most UNIX systems\&. You control which type is expected using the \fIprinting =\fR option\&.

Some clients (notably Windows for Workgroups) may not correctly send the connection number for the printer they are requesting status information about\&. To get around this, the server reports on the first printer service connected to by the client\&. This only happens if the connection number sent is invalid\&.

If a \fI%p\fR is given then the printer name is put in its place\&. Otherwise it is placed at the end of the command\&.

Note that it is good practice to include the absolute path in the \fIlpq command\fR as the \fB$PATH \fR may not be available to the server\&. When compiled with the CUPS libraries, no \fIlpq command\fR is needed because smbd will make a library call to obtain the print queue listing\&.

Default: \fB\fIlpq command\fR = \fR 

Example: \fB\fIlpq command\fR = /usr/bin/lpq \-P%p \fR 

.TP
lpresume command (S)
This parameter specifies the command to be executed on the server host in order to restart or continue printing or spooling a specific print job\&.

This command should be a program or script which takes a printer name and job number to resume the print job\&. See also the \fIlppause command \fR parameter\&.

If a \fI%p\fR is given then the printer name is put in its place\&. A \fI%j\fR is replaced with the job number (an integer)\&.

Note that it is good practice to include the absolute path in the \fIlpresume command\fR as the PATH may not be available to the server\&.

See also the \fIprinting \fR parameter\&.

Default: Currently no default value is given to this string, unless the value of the \fIprinting\fR parameter is \fBSYSV\fR, in which case the default is :

\fBlp \-i %p\-%j \-H resume\fR

or if the value of the \fIprinting\fR parameter is \fBSOFTQ\fR, then the default is:

\fBqstat \-s \-j%j \-r\fR

Default: \fB\fIlpresume command\fR = lpresume command = /usr/bin/lpalt %p\-%j \-p2 \fR 

.TP
lprm command (S)
This parameter specifies the command to be executed on the server host in order to delete a print job\&.

This command should be a program or script which takes a printer name and job number, and deletes the print job\&.

If a \fI%p\fR is given then the printer name is put in its place\&. A \fI%j\fR is replaced with the job number (an integer)\&.

Note that it is good practice to include the absolute path in the \fIlprm command\fR as the PATH may not be available to the server\&.

Default: \fB\fIlprm command\fR = # depends on the setting of \fIprinting\fR \fR 

Example: \fB\fIlprm command\fR = /usr/bin/lprm \-P%p %j \fR 

Example: \fB\fIlprm command\fR = /usr/bin/cancel %p\-%j \fR 

.TP
machine password timeout (G)
If a Samba server is a member of a Windows NT Domain (see the security = domain parameter) then periodically a running smbd process will try and change the MACHINE ACCOUNT PASSWORD stored in the TDB called \fIprivate/secrets\&.tdb \fR\&. This parameter specifies how often this password will be changed, in seconds\&. The default is one week (expressed in seconds), the same as a Windows NT Domain member server\&.

See also \fBsmbpasswd\fR(8), and the security = domain parameter\&.

Default: \fB\fImachine password timeout\fR = 604800 \fR 

.TP
magic output (S)
This parameter specifies the name of a file which will contain output created by a magic script (see the\fImagic script\fR parameter below)\&.


.RS
.Sh "Warning"
If two clients use the same \fImagic script \fR in the same directory the output file content is undefined\&.

.RE
Default: \fB\fImagic output\fR = <magic script name>\&.out \fR 

Example: \fB\fImagic output\fR = myfile\&.txt \fR 

.TP
magic script (S)
This parameter specifies the name of a file which, if opened, will be executed by the server when the file is closed\&. This allows a UNIX script to be sent to the Samba host and executed on behalf of the connected user\&.

Scripts executed in this way will be deleted upon completion assuming that the user has the appropriate level of privilege and the file permissions allow the deletion\&.

If the script generates output, output will be sent to the file specified by the \fI magic output\fR parameter (see above)\&.

Note that some shells are unable to interpret scripts containing CR/LF instead of CR as the end\-of\-line marker\&. Magic scripts must be executable\fBas is\fR on the host, which for some hosts and some shells will require filtering at the DOS end\&.

Magic scripts are \fBEXPERIMENTAL\fR and should \fBNOT\fR be relied upon\&.

Default: \fB\fImagic script\fR = \fR 

Example: \fB\fImagic script\fR = user\&.csh \fR 

.TP
mangle case (S)
See the section on NAME MANGLING

Default: \fB\fImangle case\fR = no \fR 

.TP
mangled map (S)
This is for those who want to directly map UNIX file names which cannot be represented on Windows/DOS\&. The mangling of names is not always what is needed\&. In particular you may have documents with file extensions that differ between DOS and UNIX\&. For example, under UNIX it is common to use \fI\&.html\fR for HTML files, whereas under Windows/DOS \fI\&.htm\fR is more commonly used\&.

So to map \fIhtml\fR to \fIhtm\fR you would use:

\fBmangled map = (*\&.html *\&.htm)\fR

One very useful case is to remove the annoying \fI;1 \fR off the ends of filenames on some CDROMs (only visible under some UNIXes)\&. To do this use a map of (*;1 *;)\&.

Default: \fB\fImangled map\fR = # no mangled map \fR 

Example: \fB\fImangled map\fR = (*;1 *;) \fR 

.TP
mangled names (S)
This controls whether non\-DOS names under UNIX should be mapped to DOS\-compatible names ("mangled") and made visible, or whether non\-DOS names should simply be ignored\&.

See the section on NAME MANGLING for details on how to control the mangling process\&.

If mangling is used then the mangling algorithm is as follows:


.RS
.TP 3
\(bu
The first (up to) five alphanumeric characters before the rightmost dot of the filename are preserved, forced to upper case, and appear as the first (up to) five characters of the mangled name\&.
.TP
\(bu
A tilde "~" is appended to the first part of the mangled name, followed by a two\-character unique sequence, based on the original root name (i\&.e\&., the original filename minus its final extension)\&. The final extension is included in the hash calculation only if it contains any upper case characters or is longer than three characters\&.

Note that the character to use may be specified using the \fImangling char\fR option, if you don't like '~'\&.
.TP
\(bu
The first three alphanumeric characters of the final extension are preserved, forced to upper case and appear as the extension of the mangled name\&. The final extension is defined as that part of the original filename after the rightmost dot\&. If there are no dots in the filename, the mangled name will have no extension (except in the case of "hidden files" \- see below)\&.
.TP
\(bu
Files whose UNIX name begins with a dot will be presented as DOS hidden files\&. The mangled name will be created as for other filenames, but with the leading dot removed and "___" as its extension regardless of actual original extension (that's three underscores)\&.
.LP
.RE
The two\-digit hash value consists of upper case alphanumeric characters\&.

This algorithm can cause name collisions only if files in a directory share the same first five alphanumeric characters\&. The probability of such a clash is 1/1300\&.

The name mangling (if enabled) allows a file to be copied between UNIX directories from Windows/DOS while retaining the long UNIX filename\&. UNIX files can be renamed to a new extension from Windows/DOS and will retain the same basename\&. Mangled names do not change between sessions\&.

Default: \fB\fImangled names\fR = yes \fR 

.TP
mangle prefix (G)
controls the number of prefix characters from the original name used when generating the mangled names\&. A larger value will give a weaker hash and therefore more name collisions\&. The minimum value is 1 and the maximum value is 6\&.

mangle prefix is effective only when mangling method is hash2\&.

Default: \fB\fImangle prefix\fR = 1 \fR 

Example: \fB\fImangle prefix\fR = 4 \fR 

.TP
mangling char (S)
This controls what character is used as the \fBmagic\fR character in name mangling\&. The default is a '~' but this may interfere with some software\&. Use this option to set it to whatever you prefer\&. This is effective only when mangling method is hash\&.

Default: \fB\fImangling char\fR = ~ \fR 

Example: \fB\fImangling char\fR = ^ \fR 

.TP
mangling method (G)
controls the algorithm used for the generating the mangled names\&. Can take two different values, "hash" and "hash2"\&. "hash" is the algorithm that was used used in Samba for many years and was the default in Samba 2\&.2\&.x "hash2" is now the default and is newer and considered a better algorithm (generates less collisions) in the names\&. Many Win32 applications store the mangled names and so changing to algorithms must not be done lightly as these applications may break unless reinstalled\&.

Default: \fB\fImangling method\fR = hash2 \fR 

Example: \fB\fImangling method\fR = hash \fR 

.TP
map acl inherit (S)
This boolean parameter controls whether \fBsmbd\fR(8) will attempt to map the 'inherit' and 'protected' access control entry flags stored in Windows ACLs into an extended attribute called user\&.SAMBA_PAI\&. This parameter only takes effect if Samba is being run on a platform that supports extended attributes (Linux and IRIX so far) and allows the Windows 2000 ACL editor to correctly use inheritance with the Samba POSIX ACL mapping code\&.

Default: \fB\fImap acl inherit\fR = no \fR 

.TP
map archive (S)
This controls whether the DOS archive attribute should be mapped to the UNIX owner execute bit\&. The DOS archive bit is set when a file has been modified since its last backup\&. One motivation for this option it to keep Samba/your PC from making any file it touches from becoming executable under UNIX\&. This can be quite annoying for shared source code, documents, etc\&.\&.\&.

Note that this requires the \fIcreate mask\fR parameter to be set such that owner execute bit is not masked out (i\&.e\&. it must include 100)\&. See the parameter \fIcreate mask\fR for details\&.

Default: \fB\fImap archive\fR = yes \fR 

.TP
map hidden (S)
This controls whether DOS style hidden files should be mapped to the UNIX world execute bit\&.

Note that this requires the \fIcreate mask\fR to be set such that the world execute bit is not masked out (i\&.e\&. it must include 001)\&. See the parameter \fIcreate mask\fR for details\&.

\fBNo default\fR

.TP
map system (S)
This controls whether DOS style system files should be mapped to the UNIX group execute bit\&.

Note that this requires the \fIcreate mask\fR to be set such that the group execute bit is not masked out (i\&.e\&. it must include 010)\&. See the parameter \fIcreate mask\fR for details\&.

Default: \fB\fImap system\fR = no \fR 

.TP
map to guest (G)
This parameter is only useful in security modes other than \fIsecurity = share\fR \- i\&.e\&. \fBuser\fR, \fBserver\fR, and \fBdomain\fR\&.

This parameter can take three different values, which tell \fBsmbd\fR(8) what to do with user login requests that don't match a valid UNIX user in some way\&.

The three settings are :


.RS
.TP 3
\(bu
\fBNever\fR \- Means user login requests with an invalid password are rejected\&. This is the default\&.
.TP
\(bu
\fBBad User\fR \- Means user logins with an invalid password are rejected, unless the username does not exist, in which case it is treated as a guest login and mapped into the \fI guest account\fR\&.
.TP
\(bu
\fBBad Password\fR \- Means user logins with an invalid password are treated as a guest login and mapped into the guest account\&. Note that this can cause problems as it means that any user incorrectly typing their password will be silently logged on as "guest" \- and will not know the reason they cannot access files they think they should \- there will have been no message given to them that they got their password wrong\&. Helpdesk services will \fBhate\fR you if you set the \fImap to guest\fR parameter this way :\-)\&.
.LP
.RE
Note that this parameter is needed to set up "Guest" share services when using \fIsecurity\fR modes other than share\&. This is because in these modes the name of the resource being requested is \fBnot\fR sent to the server until after the server has successfully authenticated the client so the server cannot make authentication decisions at the correct time (connection to the share) for "Guest" shares\&.

For people familiar with the older Samba releases, this parameter maps to the old compile\-time setting of the \fB GUEST_SESSSETUP\fR value in local\&.h\&.

Default: \fB\fImap to guest\fR = Never \fR 

Example: \fB\fImap to guest\fR = Bad User \fR 

.TP
max connections (S)
This option allows the number of simultaneous connections to a service to be limited\&. If \fImax connections\fR is greater than 0 then connections will be refused if this number of connections to the service are already open\&. A value of zero mean an unlimited number of connections may be made\&.

Record lock files are used to implement this feature\&. The lock files will be stored in the directory specified by the \fIlock directory\fR option\&.

Default: \fB\fImax connections\fR = 0 \fR 

Default: \fB\fImax connections\fR = 10 \fR 

.TP
max disk size (G)
This option allows you to put an upper limit on the apparent size of disks\&. If you set this option to 100 then all shares will appear to be not larger than 100 MB in size\&.

Note that this option does not limit the amount of data you can put on the disk\&. In the above case you could still store much more than 100 MB on the disk, but if a client ever asks for the amount of free disk space or the total disk size then the result will be bounded by the amount specified in \fImax disk size\fR\&.

This option is primarily useful to work around bugs in some pieces of software that can't handle very large disks, particularly disks over 1GB in size\&.

A \fImax disk size\fR of 0 means no limit\&.

Default: \fB\fImax disk size\fR = 0 \fR 

Example: \fB\fImax disk size\fR = 1000 \fR 

.TP
max log size (G)
This option (an integer in kilobytes) specifies the max size the log file should grow to\&. Samba periodically checks the size and if it is exceeded it will rename the file, adding a \fI\&.old\fR extension\&.

A size of 0 means no limit\&.

Default: \fB\fImax log size\fR = 5000 \fR 

Default: \fB\fImax log size\fR = 1000 \fR 

.TP
max mux (G)
This option controls the maximum number of outstanding simultaneous SMB operations that Samba tells the client it will allow\&. You should never need to set this parameter\&.

Default: \fB\fImax mux\fR = 50 \fR 

.TP
max open files (G)
This parameter limits the maximum number of open files that one \fBsmbd\fR(8) file serving process may have open for a client at any one time\&. The default for this parameter is set very high (10,000) as Samba uses only one bit per unopened file\&.

The limit of the number of open files is usually set by the UNIX per\-process file descriptor limit rather than this parameter so you should never need to touch this parameter\&.

Default: \fB\fImax open files\fR = 10000 \fR 

.TP
max print jobs (S)
This parameter limits the maximum number of jobs allowable in a Samba printer queue at any given moment\&. If this number is exceeded, \fBsmbd\fR(8) will remote "Out of Space" to the client\&.

Default: \fB\fImax print jobs\fR = 1000 \fR 

Example: \fB\fImax print jobs\fR = 5000 \fR 

.TP
protocol
This parameter is a synonym for max protocol\&.

.TP
max protocol (G)
The value of the parameter (a string) is the highest protocol level that will be supported by the server\&.

Possible values are :


.RS
.TP 3
\(bu
\fBCORE\fR: Earliest version\&. No concept of user names\&.
.TP
\(bu
\fBCOREPLUS\fR: Slight improvements on CORE for efficiency\&.
.TP
\(bu
\fBLANMAN1\fR: First \fB modern\fR version of the protocol\&. Long filename support\&.
.TP
\(bu
\fBLANMAN2\fR: Updates to Lanman1 protocol\&.
.TP
\(bu
\fBNT1\fR: Current up to date version of the protocol\&. Used by Windows NT\&. Known as CIFS\&.
.LP
.RE
Normally this option should not be set as the automatic negotiation phase in the SMB protocol takes care of choosing the appropriate protocol\&.

Default: \fB\fImax protocol\fR = NT1 \fR 

Example: \fB\fImax protocol\fR = LANMAN1 \fR 

.TP
max reported print jobs (S)
This parameter limits the maximum number of jobs displayed in a port monitor for Samba printer queue at any given moment\&. If this number is exceeded, the excess jobs will not be shown\&. A value of zero means there is no limit on the number of print jobs reported\&.

Default: \fB\fImax reported print jobs\fR = 0 \fR 

Example: \fB\fImax reported print jobs\fR = 1000 \fR 

.TP
max smbd processes (G)
This parameter limits the maximum number of \fBsmbd\fR(8) processes concurrently running on a system and is intended as a stopgap to prevent degrading service to clients in the event that the server has insufficient resources to handle more than this number of connections\&. Remember that under normal operating conditions, each user will have an \fBsmbd\fR(8) associated with him or her to handle connections to all shares from a given host\&.

Default: \fB\fImax smbd processes\fR = 0 \fR 

Example: \fB\fImax smbd processes\fR = 1000 \fR 

.TP
max ttl (G)
This option tells \fBnmbd\fR(8) what the default 'time to live' of NetBIOS names should be (in seconds) when \fBnmbd\fR is requesting a name using either a broadcast packet or from a WINS server\&. You should never need to change this parameter\&. The default is 3 days\&.

Default: \fB\fImax ttl\fR = 259200 \fR 

.TP
max wins ttl (G)
This option tells \fBsmbd\fR(8) when acting as a WINS server (\fIwins support = yes\fR) what the maximum 'time to live' of NetBIOS names that \fBnmbd\fR will grant will be (in seconds)\&. You should never need to change this parameter\&. The default is 6 days (518400 seconds)\&.

Default: \fB\fImax wins ttl\fR = 518400 \fR 

.TP
max xmit (G)
This option controls the maximum packet size that will be negotiated by Samba\&. The default is 65535, which is the maximum\&. In some cases you may find you get better performance with a smaller value\&. A value below 2048 is likely to cause problems\&.

Default: \fB\fImax xmit\fR = 65535 \fR 

Example: \fB\fImax xmit\fR = 8192 \fR 

.TP
message command (G)
This specifies what command to run when the server receives a WinPopup style message\&.

This would normally be a command that would deliver the message somehow\&. How this is to be done is up to your imagination\&.

An example is:

\fBmessage command = csh \-c 'xedit %s;rm %s' &\fR 

This delivers the message using \fBxedit\fR, then removes it afterwards\&. \fBNOTE THAT IT IS VERY IMPORTANT THAT THIS COMMAND RETURN IMMEDIATELY\fR\&. That's why I have the '&' on the end\&. If it doesn't return immediately then your PCs may freeze when sending messages (they should recover after 30 seconds, hopefully)\&.

All messages are delivered as the global guest user\&. The command takes the standard substitutions, although \fI %u\fR won't work (\fI%U\fR may be better in this case)\&.

Apart from the standard substitutions, some additional ones apply\&. In particular:


.RS
.TP 3
\(bu
\fI%s\fR = the filename containing the message\&.
.TP
\(bu
\fI%t\fR = the destination that the message was sent to (probably the server name)\&.
.TP
\(bu
\fI%f\fR = who the message is from\&.
.LP
.RE
You could make this command send mail, or whatever else takes your fancy\&. Please let us know of any really interesting ideas you have\&.

Here's a way of sending the messages as mail to root:

\fBmessage command = /bin/mail \-s 'message from %f on %m' root < %s; rm %s\fR

If you don't have a message command then the message won't be delivered and Samba will tell the sender there was an error\&. Unfortunately WfWg totally ignores the error code and carries on regardless, saying that the message was delivered\&.

If you want to silently delete it then try:

\fBmessage command = rm %s\fR

Default: \fB\fImessage command\fR = \fR 

Example: \fB\fImessage command\fR = csh \-c 'xedit %s; rm %s' & \fR 

.TP
min passwd length
This parameter is a synonym for min password length\&.

.TP
min password length (G)
This option sets the minimum length in characters of a plaintext password that \fBsmbd\fR will accept when performing UNIX password changing\&.

Default: \fB\fImin password length\fR = 5 \fR 

.TP
min print space (S)
This sets the minimum amount of free disk space that must be available before a user will be able to spool a print job\&. It is specified in kilobytes\&. The default is 0, which means a user can always spool a print job\&.

Default: \fB\fImin print space\fR = 0 \fR 

Example: \fB\fImin print space\fR = 2000 \fR 

.TP
min protocol (G)
The value of the parameter (a string) is the lowest SMB protocol dialect than Samba will support\&. Please refer to the \fImax protocol\fR parameter for a list of valid protocol names and a brief description of each\&. You may also wish to refer to the C source code in \fIsource/smbd/negprot\&.c\fR for a listing of known protocol dialects supported by clients\&.

If you are viewing this parameter as a security measure, you should also refer to the \fIlanman auth\fR parameter\&. Otherwise, you should never need to change this parameter\&.

Default: \fB\fImin protocol\fR = CORE \fR 

Example: \fB\fImin protocol\fR = NT1 \fR 

.TP
min wins ttl (G)
This option tells \fBnmbd\fR(8) when acting as a WINS server (\fI wins support = yes\fR) what the minimum 'time to live' of NetBIOS names that \fBnmbd\fR will grant will be (in seconds)\&. You should never need to change this parameter\&. The default is 6 hours (21600 seconds)\&.

Default: \fB\fImin wins ttl\fR = 21600 \fR 

.TP
msdfs proxy (S)
This parameter indicates that the share is a stand\-in for another CIFS share whose location is specified by the value of the parameter\&. When clients attempt to connect to this share, they are redirected to the proxied share using the SMB\-Dfs protocol\&.

Only Dfs roots can act as proxy shares\&. Take a look at the\fImsdfs root\fR and \fIhost msdfs\fR options to find out how to set up a Dfs root share\&.

\fBNo default\fR

Example: \fB\fImsdfs proxy\fR = \\otherserver\\someshare \fR 

.TP
msdfs root (S)
If set to \fByes\fR, Samba treats the share as a Dfs root and allows clients to browse the distributed file system tree rooted at the share directory\&. Dfs links are specified in the share directory by symbolic links of the form \fImsdfs:serverA\\\\shareA,serverB\\\\shareB\fR and so on\&. For more information on setting up a Dfs tree on Samba, refer to ???\&.

Default: \fB\fImsdfs root\fR = no \fR 

.TP
name cache timeout (G)
Specifies the number of seconds it takes before entries in samba's hostname resolve cache time out\&. If the timeout is set to 0\&. the caching is disabled\&.

Default: \fB\fIname cache timeout\fR = 660 \fR 

Example: \fB\fIname cache timeout\fR = 0 \fR 

.TP
name resolve order (G)
This option is used by the programs in the Samba suite to determine what naming services to use and in what order to resolve host names to IP addresses\&. Its main purpose to is to control how netbios name resolution is performed\&. The option takes a space separated string of name resolution options\&.

The options are: "lmhosts", "host", "wins" and "bcast"\&. They cause names to be resolved as follows:


.RS
.TP 3
\(bu
\fBlmhosts\fR : Lookup an IP address in the Samba lmhosts file\&. If the line in lmhosts has no name type attached to the NetBIOS name (see the lmhosts(5) for details) then any name type matches for lookup\&.
.TP
\(bu
\fBhost\fR : Do a standard host name to IP address resolution, using the system \fI/etc/hosts \fR, NIS, or DNS lookups\&. This method of name resolution is operating system depended for instance on IRIX or Solaris this may be controlled by the \fI/etc/nsswitch\&.conf\fR file\&. Note that this method is used only if the NetBIOS name type being queried is the 0x20 (server) name type or 0x1c (domain controllers)\&. The latter case is only useful for active directory domains and results in a DNS query for the SRV RR entry matching _ldap\&._tcp\&.domain\&.
.TP
\(bu
\fBwins\fR : Query a name with the IP address listed in the \fI wins server\fR parameter\&. If no WINS server has been specified this method will be ignored\&.
.TP
\(bu
\fBbcast\fR : Do a broadcast on each of the known local interfaces listed in the \fIinterfaces\fR parameter\&. This is the least reliable of the name resolution methods as it depends on the target host being on a locally connected subnet\&.
.LP
.RE
The example below will cause the local lmhosts file to be examined first, followed by a broadcast attempt, followed by a normal system hostname lookup\&.

When Samba is functioning in ADS security mode (\fBsecurity = ads\fR) it is advised to use following settings for \fIname resolve order\fR:

\fBname resolve order = wins bcast\fR

DC lookups will still be done via DNS, but fallbacks to netbios names will not inundate your DNS servers with needless querys for DOMAIN<0x1c> lookups\&.

Default: \fB\fIname resolve order\fR = lmhosts host wins bcast \fR 

Example: \fB\fIname resolve order\fR = lmhosts bcast host \fR 

.TP
netbios aliases (G)
This is a list of NetBIOS names that nmbd will advertise as additional names by which the Samba server is known\&. This allows one machine to appear in browse lists under multiple names\&. If a machine is acting as a browse server or logon server none of these names will be advertised as either browse server or logon servers, only the primary name of the machine will be advertised with these capabilities\&.

Default: \fB\fInetbios aliases\fR = # empty string (no additional names) \fR 

Example: \fB\fInetbios aliases\fR = TEST TEST1 TEST2 \fR 

.TP
netbios name (G)
This sets the NetBIOS name by which a Samba server is known\&. By default it is the same as the first component of the host's DNS name\&. If a machine is a browse server or logon server this name (or the first component of the hosts DNS name) will be the name that these services are advertised under\&.

Default: \fB\fInetbios name\fR = # machine DNS name \fR 

Example: \fB\fInetbios name\fR = MYNAME \fR 

.TP
netbios scope (G)
This sets the NetBIOS scope that Samba will operate under\&. This should not be set unless every machine on your LAN also sets this value\&.

Default: \fB\fInetbios scope\fR = \fR 

.TP
nis homedir (G)
Get the home share server from a NIS map\&. For UNIX systems that use an automounter, the user's home directory will often be mounted on a workstation on demand from a remote server\&.

When the Samba logon server is not the actual home directory server, but is mounting the home directories via NFS then two network hops would be required to access the users home directory if the logon server told the client to use itself as the SMB server for home directories (one over SMB and one over NFS)\&. This can be very slow\&.

This option allows Samba to return the home share as being on a different server to the logon server and as long as a Samba daemon is running on the home directory server, it will be mounted on the Samba client directly from the directory server\&. When Samba is returning the home share to the client, it will consult the NIS map specified in \fIhomedir map\fR and return the server listed there\&.

Note that for this option to work there must be a working NIS system and the Samba server with this option must also be a logon server\&.

Default: \fB\fInis homedir\fR = no \fR 

.TP
nt acl support (S)
This boolean parameter controls whether \fBsmbd\fR(8) will attempt to map UNIX permissions into Windows NT access control lists\&. This parameter was formally a global parameter in releases prior to 2\&.2\&.2\&.

Default: \fB\fInt acl support\fR = yes \fR 

.TP
ntlm auth (G)
This parameter determines whether or not \fBsmbd\fR(8) will attempt to authenticate users using the NTLM encrypted password response\&. If disabled, either the lanman password hash or an NTLMv2 response will need to be sent by the client\&.

If this option, and \fBlanman auth\fR are both disabled, then only NTLMv2 logins will be permited\&. Not all clients support NTLMv2, and most will require special configuration to us it\&.

Default: \fB\fIntlm auth\fR = yes \fR 

.TP
nt pipe support (G)
This boolean parameter controls whether \fBsmbd\fR(8) will allow Windows NT clients to connect to the NT SMB specific \fBIPC$\fR pipes\&. This is a developer debugging option and can be left alone\&.

Default: \fB\fInt pipe support\fR = yes \fR 

.TP
nt status support (G)
This boolean parameter controls whether \fBsmbd\fR(8) will negotiate NT specific status support with Windows NT/2k/XP clients\&. This is a developer debugging option and should be left alone\&. If this option is set to \fBno\fR then Samba offers exactly the same DOS error codes that versions prior to Samba 2\&.2\&.3 reported\&.

You should not need to ever disable this parameter\&.

Default: \fB\fInt status support\fR = yes \fR 

.TP
null passwords (G)
Allow or disallow client access to accounts that have null passwords\&.

See also \fBsmbpasswd\fR(5)\&.

Default: \fB\fInull passwords\fR = no \fR 

.TP
obey pam restrictions (G)
When Samba 3\&.0 is configured to enable PAM support (i\&.e\&. \-\-with\-pam), this parameter will control whether or not Samba should obey PAM's account and session management directives\&. The default behavior is to use PAM for clear text authentication only and to ignore any account or session management\&. Note that Samba always ignores PAM for authentication in the case of \fIencrypt passwords = yes\fR\&. The reason is that PAM modules cannot support the challenge/response authentication mechanism needed in the presence of SMB password encryption\&.

Default: \fB\fIobey pam restrictions\fR = no \fR 

.TP
only user (S)
This is a boolean option that controls whether connections with usernames not in the \fIuser\fR list will be allowed\&. By default this option is disabled so that a client can supply a username to be used by the server\&. Enabling this parameter will force the server to only use the login names from the \fIuser\fR list and is only really useful in share level security\&.

Note that this also means Samba won't try to deduce usernames from the service name\&. This can be annoying for the [homes] section\&. To get around this you could use \fBuser = %S\fR which means your \fIuser\fR list will be just the service name, which for home directories is the name of the user\&.

Default: \fB\fIonly user\fR = no \fR 

.TP
oplock break wait time (G)
This is a tuning parameter added due to bugs in both Windows 9x and WinNT\&. If Samba responds to a client too quickly when that client issues an SMB that can cause an oplock break request, then the network client can fail and not respond to the break request\&. This tuning parameter (which is set in milliseconds) is the amount of time Samba will wait before sending an oplock break request to such (broken) clients\&.


.RS
.Sh "Warning"
DO NOT CHANGE THIS PARAMETER UNLESS YOU HAVE READ AND UNDERSTOOD THE SAMBA OPLOCK CODE\&.

.RE
Default: \fB\fIoplock break wait time\fR = 0 \fR 

.TP
oplock contention limit (S)
This is a \fBvery\fR advanced\fBsmbd\fR(8) tuning option to improve the efficiency of the granting of oplocks under multiple client contention for the same file\&.

In brief it specifies a number, which causes \fBsmbd\fR(8)not to grant an oplock even when requested if the approximate number of clients contending for an oplock on the same file goes over this limit\&. This causes \fBsmbd\fR to behave in a similar way to Windows NT\&.


.RS
.Sh "Warning"
DO NOT CHANGE THIS PARAMETER UNLESS YOU HAVE READ AND UNDERSTOOD THE SAMBA OPLOCK CODE\&.

.RE
Default: \fB\fIoplock contention limit\fR = 2 \fR 

.TP
oplocks (S)
This boolean option tells \fBsmbd\fR whether to issue oplocks (opportunistic locks) to file open requests on this share\&. The oplock code can dramatically (approx\&. 30% or more) improve the speed of access to files on Samba servers\&. It allows the clients to aggressively cache files locally and you may want to disable this option for unreliable network environments (it is turned on by default in Windows NT Servers)\&. For more information see the file\fISpeed\&.txt\fR in the Samba \fIdocs/\fR directory\&.

Oplocks may be selectively turned off on certain files with a share\&. See the \fI veto oplock files\fR parameter\&. On some systems oplocks are recognized by the underlying operating system\&. This allows data synchronization between all access to oplocked files, whether it be via Samba or NFS or a local UNIX process\&. See the\fIkernel oplocks\fR parameter for details\&.

Default: \fB\fIoplocks\fR = yes \fR 

.TP
os2 driver map (G)
The parameter is used to define the absolute path to a file containing a mapping of Windows NT printer driver names to OS/2 printer driver names\&. The format is:

<nt driver name> = <os2 driver name>\&.<device name>

For example, a valid entry using the HP LaserJet 5 printer driver would appear as \fBHP LaserJet 5L = LASERJET\&.HP LaserJet 5L\fR\&.

The need for the file is due to the printer driver namespace problem described in ???\&. For more details on OS/2 clients, please refer to ???\&.

Default: \fB\fIos2 driver map\fR = \fR 

.TP
os level (G)
This integer value controls what level Samba advertises itself as for browse elections\&. The value of this parameter determines whether \fBnmbd\fR(8) has a chance of becoming a local master browser for the \fI WORKGROUP\fR in the local broadcast area\&.

\fBNote :\fRBy default, Samba will win a local master browsing election over all Microsoft operating systems except a Windows NT 4\&.0/2000 Domain Controller\&. This means that a misconfigured Samba host can effectively isolate a subnet for browsing purposes\&. See \fIBROWSING\&.txt \fR in the Samba \fIdocs/\fR directory for details\&.

Default: \fB\fIos level\fR = 20 \fR 

Example: \fB\fIos level\fR = 65 \fR 

.TP
pam password change (G)
With the addition of better PAM support in Samba 2\&.2, this parameter, it is possible to use PAM's password change control flag for Samba\&. If enabled, then PAM will be used for password changes when requested by an SMB client instead of the program listed in \fIpasswd program\fR\&. It should be possible to enable this without changing your \fIpasswd chat\fR parameter for most setups\&.

Default: \fB\fIpam password change\fR = no \fR 

.TP
panic action (G)
This is a Samba developer option that allows a system command to be called when either \fBsmbd\fR(8) or \fBsmbd\fR(8)crashes\&. This is usually used to draw attention to the fact that a problem occurred\&.

Default: \fB\fIpanic action\fR = \fR 

Example: \fB\fIpanic action\fR = "/bin/sleep 90000" \fR 

.TP
paranoid server security (G)
Some version of NT 4\&.x allow non\-guest users with a bad passowrd\&. When this option is enabled, samba will not use a broken NT 4\&.x server as password server, but instead complain to the logs and exit\&.

Disabling this option prevents Samba from making this check, which involves deliberatly attempting a bad logon to the remote server\&.

Default: \fB\fIparanoid server security\fR = yes \fR 

.TP
passdb backend (G)
This option allows the administrator to chose which backends to retrieve and store passwords with\&. This allows (for example) both smbpasswd and tdbsam to be used without a recompile\&. Multiple backends can be specified, separated by spaces\&. The backends will be searched in the order they are specified\&. New users are always added to the first backend specified\&.

This parameter is in two parts, the backend's name, and a 'location' string that has meaning only to that particular backed\&. These are separated by a : character\&.

Available backends can include:

.RS
.TP 3
\(bu
\fBsmbpasswd\fR \- The default smbpasswd backend\&. Takes a path to the smbpasswd file as an optional argument\&.
.TP
\(bu
\fBtdbsam\fR \- The TDB based password storage backend\&. Takes a path to the TDB as an optional argument (defaults to passdb\&.tdb in the \fIprivate dir\fR directory\&.
.TP
\(bu
\fBldapsam\fR \- The LDAP based passdb backend\&. Takes an LDAP URL as an optional argument (defaults to \fBldap://localhost\fR)

LDAP connections should be secured where possible\&. This may be done using either Start\-TLS (see \fIldap ssl\fR) or by specifying \fIldaps://\fR in the URL argument\&.

Multiple servers may also be specified in double\-quotes, if your LDAP libraries supports the LDAP URL notation\&. (OpenLDAP does)\&.
.TP
\(bu
\fBnisplussam\fR \- The NIS+ based passdb backend\&. Takes name NIS domain as an optional argument\&. Only works with sun NIS+ servers\&.
.TP
\(bu
\fBmysql\fR \- The MySQL based passdb backend\&. Takes an identifier as argument\&. Read the Samba HOWTO Collection for configuration details\&.
.LP
.RE
 

Default: \fB\fIpassdb backend\fR = smbpasswd \fR 

Example: \fB\fIpassdb backend\fR = tdbsam:/etc/samba/private/passdb\&.tdb smbpasswd:/etc/samba/smbpasswd \fR 

Example: \fB\fIpassdb backend\fR = ldapsam:ldaps://ldap\&.example\&.com \fR 

Example: \fB\fIpassdb backend\fR = ldapsam:"ldap://ldap\-1\&.example\&.com ldap://ldap\-2\&.example\&.com" \fR 

Example: \fB\fIpassdb backend\fR = mysql:my_plugin_args tdbsam \fR 

.TP
passwd chat (G)
This string controls the \fB"chat"\fR conversation that takes places between \fBsmbd\fR(8) and the local password changing program to change the user's password\&. The string describes a sequence of response\-receive pairs that \fBsmbd\fR(8) uses to determine what to send to the \fIpasswd program\fR and what to expect back\&. If the expected output is not received then the password is not changed\&.

This chat sequence is often quite site specific, depending on what local methods are used for password control (such as NIS etc)\&.

Note that this parameter only is only used if the \fIunix password sync\fR parameter is set to \fByes\fR\&. This sequence is then called \fBAS ROOT\fR when the SMB password in the smbpasswd file is being changed, without access to the old password cleartext\&. This means that root must be able to reset the user's password without knowing the text of the previous password\&. In the presence of NIS/YP, this means that the passwd program must be executed on the NIS master\&.

The string can contain the macro \fI%n\fR which is substituted for the new password\&. The chat sequence can also contain the standard macros \fB\\\\n\fR, \fB\\\\r\fR, \fB\\\\t\fR and \fB\\\\s\fR to give line\-feed, carriage\-return, tab and space\&. The chat sequence string can also contain a '*' which matches any sequence of characters\&. Double quotes can be used to collect strings with spaces in them into a single string\&.

If the send string in any part of the chat sequence is a full stop "\&.", then no string is sent\&. Similarly, if the expect string is a full stop then no string is expected\&.

If the \fIpam password change\fR parameter is set to \fByes\fR, the chat pairs may be matched in any order, and success is determined by the PAM result, not any particular output\&. The \\n macro is ignored for PAM conversions\&.

Default: \fB\fIpasswd chat\fR = *new*password* %n\\\\n*new*password* %n\\\\n *changed* \fR 

Example: \fB\fIpasswd chat\fR = "*Enter OLD password*" %o\\\\n "*Enter NEW password*" %n\\\\n "*Reenter NEW password*" %n\\\\n "*Password changed*" \fR 

.TP
passwd chat debug (G)
This boolean specifies if the passwd chat script parameter is run in \fBdebug\fR mode\&. In this mode the strings passed to and received from the passwd chat are printed in the \fBsmbd\fR(8) log with a \fIdebug level\fR of 100\&. This is a dangerous option as it will allow plaintext passwords to be seen in the \fBsmbd\fR log\&. It is available to help Samba admins debug their \fIpasswd chat\fR scripts when calling the \fIpasswd program\fR and should be turned off after this has been done\&. This option has no effect if the \fIpam password change\fR paramter is set\&. This parameter is off by default\&.

Default: \fB\fIpasswd chat debug\fR = no \fR 

.TP
passwd chat timeout (G)
This integer specifies the number of seconds smbd will wait for an initial answer from a passwd chat script being run\&. Once the initial answer is received the subsequent answers must be received in one tenth of this time\&. The default it two seconds\&.

Default: \fB\fIpasswd chat timeout\fR = 2 \fR 

.TP
passwd program (G)
The name of a program that can be used to set UNIX user passwords\&. Any occurrences of \fI%u\fR will be replaced with the user name\&. The user name is checked for existence before calling the password changing program\&.

Also note that many passwd programs insist in \fBreasonable \fR passwords, such as a minimum length, or the inclusion of mixed case chars and digits\&. This can pose a problem as some clients (such as Windows for Workgroups) uppercase the password before sending it\&.

\fBNote\fR that if the \fIunix password sync\fR parameter is set to \fByes \fR then this program is called \fBAS ROOT\fR before the SMB password in the smbpasswd file is changed\&. If this UNIX password change fails, then \fBsmbd\fR will fail to change the SMB password also (this is by design)\&.

If the \fIunix password sync\fR parameter is set this parameter \fBMUST USE ABSOLUTE PATHS\fR for \fBALL\fR programs called, and must be examined for security implications\&. Note that by default \fIunix password sync\fR is set to \fBno\fR\&.

Default: \fB\fIpasswd program\fR = \fR 

Example: \fB\fIpasswd program\fR = /bin/passwd %u \fR 

.TP
password level (G)
Some client/server combinations have difficulty with mixed\-case passwords\&. One offending client is Windows for Workgroups, which for some reason forces passwords to upper case when using the LANMAN1 protocol, but leaves them alone when using COREPLUS! Another problem child is the Windows 95/98 family of operating systems\&. These clients upper case clear text passwords even when NT LM 0\&.12 selected by the protocol negotiation request/response\&.

This parameter defines the maximum number of characters that may be upper case in passwords\&.

For example, say the password given was "FRED"\&. If \fI password level\fR is set to 1, the following combinations would be tried if "FRED" failed:

"Fred", "fred", "fRed", "frEd","freD"

If \fIpassword level\fR was set to 2, the following combinations would also be tried:

"FRed", "FrEd", "FreD", "fREd", "fReD", "frED", \&.\&.

And so on\&.

The higher value this parameter is set to the more likely it is that a mixed case password will be matched against a single case password\&. However, you should be aware that use of this parameter reduces security and increases the time taken to process a new connection\&.

A value of zero will cause only two attempts to be made \- the password as is and the password in all\-lower case\&.

This parameter is used only when using plain\-text passwords\&. It is not at all used when encrypted passwords as in use (that is the default since samba\-3\&.0\&.0)\&. Use this only when encrypt passwords = No\&.

Default: \fB\fIpassword level\fR = 0 \fR 

Example: \fB\fIpassword level\fR = 4 \fR 

.TP
password server (G)
By specifying the name of another SMB server or Active Directory domain controller with this option, and using \fBsecurity = [ads|domain|server]\fR it is possible to get Samba to to do all its username/password validation using a specific remote server\&.

This option sets the name or IP address of the password server to use\&. New syntax has been added to support defining the port to use when connecting to the server the case of an ADS realm\&. To define a port other than the default LDAP port of 389, add the port number using a colon after the name or IP address (e\&.g\&. 192\&.168\&.1\&.100:389)\&. If you do not specify a port, Samba will use the standard LDAP port of tcp/389\&. Note that port numbers have no effect on password servers for Windows NT 4\&.0 domains or netbios connections\&.

If parameter is a name, it is looked up using the parameter \fIname resolve order\fR and so may resolved by any method and order described in that parameter\&.

The password server must be a machine capable of using the "LM1\&.2X002" or the "NT LM 0\&.12" protocol, and it must be in user level security mode\&.


.RS
.Sh "Note"
Using a password server means your UNIX box (running Samba) is only as secure as your password server\&. \fBDO NOT CHOOSE A PASSWORD SERVER THAT YOU DON'T COMPLETELY TRUST\fR\&.

.RE
Never point a Samba server at itself for password serving\&. This will cause a loop and could lock up your Samba server!

The name of the password server takes the standard substitutions, but probably the only useful one is \fI%m \fR, which means the Samba server will use the incoming client as the password server\&. If you use this then you better trust your clients, and you had better restrict them with hosts allow!

If the \fIsecurity\fR parameter is set to \fBdomain\fR or \fBads\fR, then the list of machines in this option must be a list of Primary or Backup Domain controllers for the Domain or the character '*', as the Samba server is effectively in that domain, and will use cryptographically authenticated RPC calls to authenticate the user logging on\&. The advantage of using \fB security = domain\fR is that if you list several hosts in the \fIpassword server\fR option then \fBsmbd \fR will try each in turn till it finds one that responds\&. This is useful in case your primary server goes down\&.

If the \fIpassword server\fR option is set to the character '*', then Samba will attempt to auto\-locate the Primary or Backup Domain controllers to authenticate against by doing a query for the name \fBWORKGROUP<1C>\fR and then contacting each server returned in the list of IP addresses from the name resolution source\&.

If the list of servers contains both names/IP's and the '*' character, the list is treated as a list of preferred domain controllers, but an auto lookup of all remaining DC's will be added to the list as well\&. Samba will not attempt to optimize this list by locating the closest DC\&.

If the \fIsecurity\fR parameter is set to \fBserver\fR, then there are different restrictions that \fBsecurity = domain\fR doesn't suffer from:


.RS
.TP 3
\(bu
You may list several password servers in the \fIpassword server\fR parameter, however if an \fBsmbd\fR makes a connection to a password server, and then the password server fails, no more users will be able to be authenticated from this \fBsmbd\fR\&. This is a restriction of the SMB/CIFS protocol when in \fBsecurity = server \fR mode and cannot be fixed in Samba\&.
.TP
\(bu
If you are using a Windows NT server as your password server then you will have to ensure that your users are able to login from the Samba server, as when in \fB security = server\fR mode the network logon will appear to come from there rather than from the users workstation\&.
.LP
.RE
Default: \fB\fIpassword server\fR = \fR 

Example: \fB\fIpassword server\fR = NT\-PDC, NT\-BDC1, NT\-BDC2, * \fR 

Example: \fB\fIpassword server\fR = windc\&.mydomain\&.com:389 192\&.168\&.1\&.101 * \fR 

Example: \fB\fIpassword server\fR = * \fR 

.TP
directory
This parameter is a synonym for path\&.

.TP
path (S)
This parameter specifies a directory to which the user of the service is to be given access\&. In the case of printable services, this is where print data will spool prior to being submitted to the host for printing\&.

For a printable service offering guest access, the service should be readonly and the path should be world\-writeable and have the sticky bit set\&. This is not mandatory of course, but you probably won't get the results you expect if you do otherwise\&.

Any occurrences of \fI%u\fR in the path will be replaced with the UNIX username that the client is using on this connection\&. Any occurrences of \fI%m\fR will be replaced by the NetBIOS name of the machine they are connecting from\&. These replacements are very useful for setting up pseudo home directories for users\&.

Note that this path will be based on \fIroot dir\fR if one was specified\&.

Default: \fB\fIpath\fR = \fR 

Example: \fB\fIpath\fR = /home/fred \fR 

.TP
pid directory (G)
This option specifies the directory where pid files will be placed\&.

Default: \fB\fIpid directory\fR = ${prefix}/var/locks \fR 

Example: \fB\fIpid directory\fR = pid directory = /var/run/ \fR 

.TP
posix locking (S)
The \fBsmbd\fR(8) daemon maintains an database of file locks obtained by SMB clients\&. The default behavior is to map this internal database to POSIX locks\&. This means that file locks obtained by SMB clients are consistent with those seen by POSIX compliant applications accessing the files via a non\-SMB method (e\&.g\&. NFS or local file access)\&. You should never need to disable this parameter\&.

Default: \fB\fIposix locking\fR = yes \fR 

.TP
postexec (S)
This option specifies a command to be run whenever the service is disconnected\&. It takes the usual substitutions\&. The command may be run as the root on some systems\&.

An interesting example may be to unmount server resources:

\fBpostexec = /etc/umount /cdrom\fR

Default: \fB\fIpostexec\fR = \fR 

Example: \fB\fIpostexec\fR = echo \\"%u disconnected from %S from %m (%I)\\" >> /tmp/log \fR 

.TP
exec
This parameter is a synonym for preexec\&.

.TP
preexec (S)
This option specifies a command to be run whenever the service is connected to\&. It takes the usual substitutions\&.

An interesting example is to send the users a welcome message every time they log in\&. Maybe a message of the day? Here is an example:

\fBpreexec = csh \-c 'echo \\"Welcome to %S!\\" | /usr/local/samba/bin/smbclient \-M %m \-I %I' & \fR

Of course, this could get annoying after a while :\-)

See also \fIpreexec close\fR and \fIpostexec \fR\&.

Default: \fB\fIpreexec\fR = \fR 

Example: \fB\fIpreexec\fR = echo \\"%u connected to %S from %m (%I)\\" >> /tmp/log \fR 

.TP
preexec close (S)
This boolean option controls whether a non\-zero return code from \fIpreexec \fR should close the service being connected to\&.

Default: \fB\fIpreexec close\fR = no \fR 

.TP
prefered master
This parameter is a synonym for preferred master\&.

.TP
preferred master (G)
This boolean parameter controls if\fBnmbd\fR(8) is a preferred master browser for its workgroup\&.

If this is set to \fByes\fR, on startup, \fBnmbd\fR will force an election, and it will have a slight advantage in winning the election\&. It is recommended that this parameter is used in conjunction with \fB domain master = yes\fR, so that \fBnmbd\fR can guarantee becoming a domain master\&.

Use this option with caution, because if there are several hosts (whether Samba servers, Windows 95 or NT) that are preferred master browsers on the same subnet, they will each periodically and continuously attempt to become the local master browser\&. This will result in unnecessary broadcast traffic and reduced browsing capabilities\&.

Default: \fB\fIpreferred master\fR = auto \fR 

.TP
auto services
This parameter is a synonym for preload\&.

.TP
preload (G)
This is a list of services that you want to be automatically added to the browse lists\&. This is most useful for homes and printers services that would otherwise not be visible\&.

Note that if you just want all printers in your printcap file loaded then the \fIload printers\fR option is easier\&.

Default: \fB\fIpreload\fR = \fR 

Example: \fB\fIpreload\fR = fred lp colorlp \fR 

.TP
preload modules (G)
This is a list of paths to modules that should be loaded into smbd before a client connects\&. This improves the speed of smbd when reacting to new connections somewhat\&.

Default: \fB\fIpreload modules\fR = \fR 

Example: \fB\fIpreload modules\fR = /usr/lib/samba/passdb/mysql\&.so \fR 

.TP
preserve case (S)
This controls if new filenames are created with the case that the client passes, or if they are forced to be the \fIdefault case \fR\&.

See the section on NAME MANGLING for a fuller discussion\&.

Default: \fB\fIpreserve case\fR = yes \fR 

.TP
print ok
This parameter is a synonym for printable\&.

.TP
printable (S)
If this parameter is \fByes\fR, then clients may open, write to and submit spool files on the directory specified for the service\&.

Note that a printable service will ALWAYS allow writing to the service path (user privileges permitting) via the spooling of print data\&. The \fIread only \fR parameter controls only non\-printing access to the resource\&.

Default: \fB\fIprintable\fR = no \fR 

.TP
printcap cache time (G)
This option specifies the number of seconds before the printing subsystem is again asked for the known printers\&. If the value is greater than 60 the initial waiting time is set to 60 seconds to allow an earlier first rescan of the printing subsystem\&.

Setting this parameter to 0 (the default) disables any rescanning for new or removed printers after the initial startup\&.

Default: \fB\fIprintcap cache time\fR = 0 \fR 

Example: \fB\fIprintcap cache time\fR = 600 \fR 

.TP
printcap
This parameter is a synonym for printcap name\&.

.TP
printcap name (S)
This parameter may be used to override the compiled\-in default printcap name used by the server (usually \fI /etc/printcap\fR)\&. See the discussion of the [printers] section above for reasons why you might want to do this\&.

To use the CUPS printing interface set \fBprintcap name = cups \fR\&. This should be supplemented by an addtional setting printing = cups in the [global] section\&. \fBprintcap name = cups\fR will use the "dummy" printcap created by CUPS, as specified in your CUPS configuration file\&.

On System V systems that use \fBlpstat\fR to list available printers you can use \fBprintcap name = lpstat \fR to automatically obtain lists of available printers\&. This is the default for systems that define SYSV at configure time in Samba (this includes most System V based systems)\&. If \fI printcap name\fR is set to \fBlpstat\fR on these systems then Samba will launch \fBlpstat \-v\fR and attempt to parse the output to obtain a printer list\&.

A minimal printcap file would look something like this:


.nf

print1|My Printer 1
print2|My Printer 2
print3|My Printer 3
print4|My Printer 4
print5|My Printer 5
.fi


where the '|' separates aliases of a printer\&. The fact that the second alias has a space in it gives a hint to Samba that it's a comment\&.


.RS
.Sh "Note"
Under AIX the default printcap name is \fI/etc/qconfig\fR\&. Samba will assume the file is in AIX \fIqconfig\fR format if the string\fIqconfig\fR appears in the printcap filename\&.

.RE
Default: \fB\fIprintcap name\fR = /etc/printcap \fR 

Example: \fB\fIprintcap name\fR = /etc/myprintcap \fR 

.TP
print command (S)
After a print job has finished spooling to a service, this command will be used via a \fBsystem()\fR call to process the spool file\&. Typically the command specified will submit the spool file to the host's printing subsystem, but there is no requirement that this be the case\&. The server will not remove the spool file, so whatever command you specify should remove the spool file when it has been processed, otherwise you will need to manually remove old spool files\&.

The print command is simply a text string\&. It will be used verbatim after macro substitutions have been made:

%s, %f \- the path to the spool file name

%p \- the appropriate printer name

%J \- the job name as transmitted by the client\&.

%c \- The number of printed pages of the spooled job (if known)\&.

%z \- the size of the spooled print job (in bytes)

The print command \fBMUST\fR contain at least one occurrence of \fI%s\fR or \fI%f \fR \- the \fI%p\fR is optional\&. At the time a job is submitted, if no printer name is supplied the \fI%p \fR will be silently removed from the printer command\&.

If specified in the [global] section, the print command given will be used for any printable service that does not have its own print command specified\&.

If there is neither a specified print command for a printable service nor a global print command, spool files will be created but not processed and (most importantly) not removed\&.

Note that printing may fail on some UNIXes from the \fBnobody\fR account\&. If this happens then create an alternative guest account that can print and set the \fIguest account\fR in the [global] section\&.

You can form quite complex print commands by realizing that they are just passed to a shell\&. For example the following will log a print job, print the file, then remove it\&. Note that ';' is the usual separator for command in shell scripts\&.

\fBprint command = echo Printing %s >> /tmp/print\&.log; lpr \-P %p %s; rm %s\fR

You may have to vary this command considerably depending on how you normally print files on your system\&. The default for the parameter varies depending on the setting of the \fIprinting\fR parameter\&.

Default: For \fBprinting = BSD, AIX, QNX, LPRNG or PLP :\fR

\fBprint command = lpr \-r \-P%p %s\fR

For \fBprinting = SYSV or HPUX :\fR

\fBprint command = lp \-c \-d%p %s; rm %s\fR

For \fBprinting = SOFTQ :\fR

\fBprint command = lp \-d%p \-s %s; rm %s\fR

For printing = CUPS : If SAMBA is compiled against libcups, then printcap = cups uses the CUPS API to submit jobs, etc\&. Otherwise it maps to the System V commands with the \-oraw option for printing, i\&.e\&. it uses \fBlp \-c \-d%p \-oraw; rm %s\fR\&. With \fBprinting = cups\fR, and if SAMBA is compiled against libcups, any manually set print command will be ignored\&.

\fBNo default\fR

Example: \fB\fIprint command\fR = /usr/local/samba/bin/myprintscript %p %s \fR 

.TP
printer admin (S)
This is a list of users that can do anything to printers via the remote administration interfaces offered by MS\-RPC (usually using a NT workstation)\&. Note that the root user always has admin rights\&.

Default: \fB\fIprinter admin\fR = \fR 

Example: \fB\fIprinter admin\fR = admin, @staff \fR 

.TP
printer
This parameter is a synonym for printer name\&.

.TP
printer name (S)
This parameter specifies the name of the printer to which print jobs spooled through a printable service will be sent\&.

If specified in the [global] section, the printer name given will be used for any printable service that does not have its own printer name specified\&.

Default: \fB\fIprinter name\fR = # none (but may be \fBlp\fR on many systems) \fR 

Example: \fB\fIprinter name\fR = laserwriter \fR 

.TP
printing (S)
This parameters controls how printer status information is interpreted on your system\&. It also affects the default values for the \fIprint command\fR, \fIlpq command\fR, \fIlppause command \fR, \fIlpresume command\fR, and \fIlprm command\fR if specified in the [global] section\&.

Currently nine printing styles are supported\&. They are \fBBSD\fR, \fBAIX\fR, \fBLPRNG\fR, \fBPLP\fR, \fBSYSV\fR, \fBHPUX\fR, \fBQNX\fR, \fBSOFTQ\fR, and \fBCUPS\fR\&.

To see what the defaults are for the other print commands when using the various options use the \fBtestparm\fR(1) program\&.

This option can be set on a per printer basis\&. Please be aware however, that you must place any of the various printing commands (e\&.g\&. print command, lpq command, etc\&.\&.\&.) after defining the value for the \fIprinting\fR option since it will reset the printing commands to default values\&.

See also the discussion in the [printers] section\&.

\fBNo default\fR

.TP
private dir (G)
This parameters defines the directory smbd will use for storing such files as \fIsmbpasswd\fR and \fIsecrets\&.tdb\fR\&.

Default: \fB\fIprivate dir\fR = ${prefix}/private \fR 

.TP
profile acls (S)
This boolean parameter was added to fix the problems that people have been having with storing user profiles on Samba shares from Windows 2000 or Windows XP clients\&. New versions of Windows 2000 or Windows XP service packs do security ACL checking on the owner and ability to write of the profile directory stored on a local workstation when copied from a Samba share\&.

When not in domain mode with winbindd then the security info copied onto the local workstation has no meaning to the logged in user (SID) on that workstation so the profile storing fails\&. Adding this parameter onto a share used for profile storage changes two things about the returned Windows ACL\&. Firstly it changes the owner and group owner of all reported files and directories to be BUILTIN\\\\Administrators, BUILTIN\\\\Users respectively (SIDs S\-1\-5\-32\-544, S\-1\-5\-32\-545)\&. Secondly it adds an ACE entry of "Full Control" to the SID BUILTIN\\\\Users to every returned ACL\&. This will allow any Windows 2000 or XP workstation user to access the profile\&.

Note that if you have multiple users logging on to a workstation then in order to prevent them from being able to access each others profiles you must remove the "Bypass traverse checking" advanced user right\&. This will prevent access to other users profile directories as the top level profile directory (named after the user) is created by the workstation profile code and has an ACL restricting entry to the directory tree to the owning user\&.

Default: \fB\fIprofile acls\fR = no \fR 

.TP
queuepause command (S)
This parameter specifies the command to be executed on the server host in order to pause the printer queue\&.

This command should be a program or script which takes a printer name as its only parameter and stops the printer queue, such that no longer jobs are submitted to the printer\&.

This command is not supported by Windows for Workgroups, but can be issued from the Printers window under Windows 95 and NT\&.

If a \fI%p\fR is given then the printer name is put in its place\&. Otherwise it is placed at the end of the command\&.

Note that it is good practice to include the absolute path in the command as the PATH may not be available to the server\&.

\fBNo default\fR

Example: \fB\fIqueuepause command\fR = disable %p \fR 

.TP
queueresume command (S)
This parameter specifies the command to be executed on the server host in order to resume the printer queue\&. It is the command to undo the behavior that is caused by the previous parameter (\fI queuepause command\fR)\&.

This command should be a program or script which takes a printer name as its only parameter and resumes the printer queue, such that queued jobs are resubmitted to the printer\&.

This command is not supported by Windows for Workgroups, but can be issued from the Printers window under Windows 95 and NT\&.

If a \fI%p\fR is given then the printer name is put in its place\&. Otherwise it is placed at the end of the command\&.

Note that it is good practice to include the absolute path in the command as the PATH may not be available to the server\&.

Default: \fB\fIqueueresume command\fR = \fR 

Example: \fB\fIqueueresume command\fR = enable %p \fR 

.TP
read bmpx (G)
This boolean parameter controls whether \fBsmbd\fR(8) will support the "Read Block Multiplex" SMB\&. This is now rarely used and defaults to \fBno\fR\&. You should never need to set this parameter\&.

Default: \fB\fIread bmpx\fR = no \fR 

.TP
read list (S)
This is a list of users that are given read\-only access to a service\&. If the connecting user is in this list then they will not be given write access, no matter what the \fIread only\fR option is set to\&. The list can include group names using the syntax described in the \fI invalid users\fR parameter\&.

Default: \fB\fIread list\fR = \fR 

Example: \fB\fIread list\fR = mary, @students \fR 

.TP
read only (S)
An inverted synonym is \fIwriteable\fR\&.

If this parameter is \fByes\fR, then users of a service may not create or modify files in the service's directory\&.

Note that a printable service (\fBprintable = yes\fR) will \fBALWAYS\fR allow writing to the directory (user privileges permitting), but only via spooling operations\&.

Default: \fB\fIread only\fR = yes \fR 

.TP
read raw (G)
This parameter controls whether or not the server will support the raw read SMB requests when transferring data to clients\&.

If enabled, raw reads allow reads of 65535 bytes in one packet\&. This typically provides a major performance benefit\&.

However, some clients either negotiate the allowable block size incorrectly or are incapable of supporting larger block sizes, and for these clients you may need to disable raw reads\&.

In general this parameter should be viewed as a system tuning tool and left severely alone\&.

Default: \fB\fIread raw\fR = yes \fR 

.TP
realm (G)
This option specifies the kerberos realm to use\&. The realm is used as the ADS equivalent of the NT4 \fBdomain\fR\&. It is usually set to the DNS name of the kerberos server\&.

Default: \fB\fIrealm\fR = \fR 

Example: \fB\fIrealm\fR = mysambabox\&.mycompany\&.com \fR 

.TP
remote announce (G)
This option allows you to setup \fBnmbd\fR(8)to periodically announce itself to arbitrary IP addresses with an arbitrary workgroup name\&.

This is useful if you want your Samba server to appear in a remote workgroup for which the normal browse propagation rules don't work\&. The remote workgroup can be anywhere that you can send IP packets to\&.

For example:

\fBremote announce = 192\&.168\&.2\&.255/SERVERS 192\&.168\&.4\&.255/STAFF\fR

the above line would cause \fBnmbd\fR to announce itself to the two given IP addresses using the given workgroup names\&. If you leave out the workgroup name then the one given in the \fIworkgroup\fR parameter is used instead\&.

The IP addresses you choose would normally be the broadcast addresses of the remote networks, but can also be the IP addresses of known browse masters if your network config is that stable\&.

See ???\&.

Default: \fB\fIremote announce\fR = \fR 

.TP
remote browse sync (G)
This option allows you to setup \fBnmbd\fR(8) to periodically request synchronization of browse lists with the master browser of a Samba server that is on a remote segment\&. This option will allow you to gain browse lists for multiple workgroups across routed networks\&. This is done in a manner that does not work with any non\-Samba servers\&.

This is useful if you want your Samba server and all local clients to appear in a remote workgroup for which the normal browse propagation rules don't work\&. The remote workgroup can be anywhere that you can send IP packets to\&.

For example:

\fBremote browse sync = 192\&.168\&.2\&.255 192\&.168\&.4\&.255\fR

the above line would cause \fBnmbd\fR to request the master browser on the specified subnets or addresses to synchronize their browse lists with the local server\&.

The IP addresses you choose would normally be the broadcast addresses of the remote networks, but can also be the IP addresses of known browse masters if your network config is that stable\&. If a machine IP address is given Samba makes NO attempt to validate that the remote machine is available, is listening, nor that it is in fact the browse master on its segment\&.

Default: \fB\fIremote browse sync\fR = \fR 

.TP
restrict anonymous (G)
The setting of this parameter determines whether user and group list information is returned for an anonymous connection\&. and mirrors the effects of the \fBHKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\LSA\\RestrictAnonymous\fR registry key in Windows 2000 and Windows NT\&. When set to 0, user and group list information is returned to anyone who asks\&. When set to 1, only an authenticated user can retrive user and group list information\&. For the value 2, supported by Windows 2000/XP and Samba, no anonymous connections are allowed at all\&. This can break third party and Microsoft applications which expect to be allowed to perform operations anonymously\&.

The security advantage of using restrict anonymous = 1 is dubious, as user and group list information can be obtained using other means\&.


.RS
.Sh "Note"
The security advantage of using restrict anonymous = 2 is removed by setting \fIguest ok\fR = yes on any share\&.

.RE
Default: \fB\fIrestrict anonymous\fR = 0 \fR 

.TP
root
This parameter is a synonym for root directory\&.

.TP
root dir
This parameter is a synonym for root directory\&.

.TP
root directory (G)
The server will \fBchroot()\fR (i\&.e\&. Change its root directory) to this directory on startup\&. This is not strictly necessary for secure operation\&. Even without it the server will deny access to files not in one of the service entries\&. It may also check for, and deny access to, soft links to other parts of the filesystem, or attempts to use "\&.\&." in file names to access other directories (depending on the setting of the \fIwide links\fR parameter)\&.

Adding a \fIroot directory\fR entry other than "/" adds an extra level of security, but at a price\&. It absolutely ensures that no access is given to files not in the sub\-tree specified in the \fIroot directory\fR option, \fBincluding\fR some files needed for complete operation of the server\&. To maintain full operability of the server you will need to mirror some system files into the \fIroot directory\fR tree\&. In particular you will need to mirror \fI/etc/passwd\fR (or a subset of it), and any binaries or configuration files needed for printing (if required)\&. The set of files that must be mirrored is operating system dependent\&.

Default: \fB\fIroot directory\fR = / \fR 

Example: \fB\fIroot directory\fR = /homes/smb \fR 

.TP
root postexec (S)
This is the same as the \fIpostexec\fR parameter except that the command is run as root\&. This is useful for unmounting filesystems (such as CDROMs) after a connection is closed\&.

Default: \fB\fIroot postexec\fR = \fR 

.TP
root preexec (S)
This is the same as the \fIpreexec\fR parameter except that the command is run as root\&. This is useful for mounting filesystems (such as CDROMs) when a connection is opened\&.

Default: \fB\fIroot preexec\fR = \fR 

.TP
root preexec close (S)
This is the same as the \fIpreexec close \fR parameter except that the command is run as root\&.

Default: \fB\fIroot preexec close\fR = no \fR 

.TP
security (G)
This option affects how clients respond to Samba and is one of the most important settings in the \fI smb\&.conf\fR file\&.

The option sets the "security mode bit" in replies to protocol negotiations with \fBsmbd\fR(8) to turn share level security on or off\&. Clients decide based on this bit whether (and how) to transfer user and password information to the server\&.

The default is \fBsecurity = user\fR, as this is the most common setting needed when talking to Windows 98 and Windows NT\&.

The alternatives are \fBsecurity = share\fR, \fBsecurity = server\fR or \fBsecurity = domain \fR\&.

In versions of Samba prior to 2\&.0\&.0, the default was \fBsecurity = share\fR mainly because that was the only option at one stage\&.

There is a bug in WfWg that has relevance to this setting\&. When in user or server level security a WfWg client will totally ignore the password you type in the "connect drive" dialog box\&. This makes it very difficult (if not impossible) to connect to a Samba service as anyone except the user that you are logged into WfWg as\&.

If your PCs use usernames that are the same as their usernames on the UNIX machine then you will want to use \fBsecurity = user\fR\&. If you mostly use usernames that don't exist on the UNIX box then use \fBsecurity = share\fR\&.

You should also use \fBsecurity = share\fR if you want to mainly setup shares without a password (guest shares)\&. This is commonly used for a shared printer server\&. It is more difficult to setup guest shares with \fBsecurity = user\fR, see the \fImap to guest\fRparameter for details\&.

It is possible to use \fBsmbd\fR in a \fB hybrid mode\fR where it is offers both user and share level security under different \fINetBIOS aliases\fR\&.

The different settings will now be explained\&.

\fBSECURITY = SHARE\fR

When clients connect to a share level security server they need not log onto the server with a valid username and password before attempting to connect to a shared resource (although modern clients such as Windows 95/98 and Windows NT will send a logon request with a username but no password when talking to a \fBsecurity = share \fR server)\&. Instead, the clients send authentication information (passwords) on a per\-share basis, at the time they attempt to connect to that share\&.

Note that \fBsmbd\fR  \fBALWAYS\fR uses a valid UNIX user to act on behalf of the client, even in \fBsecurity = share\fR level security\&.

As clients are not required to send a username to the server in share level security, \fBsmbd\fR uses several techniques to determine the correct UNIX user to use on behalf of the client\&.

A list of possible UNIX usernames to match with the given client password is constructed using the following methods :


.RS
.TP 3
\(bu
If the \fIguest only\fR parameter is set, then all the other stages are missed and only the \fIguest account\fR username is checked\&.
.TP
\(bu
Is a username is sent with the share connection request, then this username (after mapping \- see \fIusername map\fR), is added as a potential username\&.
.TP
\(bu
If the client did a previous \fBlogon \fR request (the SessionSetup SMB call) then the username sent in this SMB will be added as a potential username\&.
.TP
\(bu
The name of the service the client requested is added as a potential username\&.
.TP
\(bu
The NetBIOS name of the client is added to the list as a potential username\&.
.TP
\(bu
Any users on the \fI user\fR list are added as potential usernames\&.
.LP
.RE
If the \fIguest only\fR parameter is not set, then this list is then tried with the supplied password\&. The first user for whom the password matches will be used as the UNIX user\&.

If the \fIguest only\fR parameter is set, or no username can be determined then if the share is marked as available to the \fIguest account\fR, then this guest user will be used, otherwise access is denied\&.

Note that it can be \fBvery\fR confusing in share\-level security as to which UNIX username will eventually be used in granting access\&.

See also the section NOTE ABOUT USERNAME/PASSWORD VALIDATION\&.

\fBSECURITY = USER\fR

This is the default security setting in Samba 3\&.0\&. With user\-level security a client must first "log\-on" with a valid username and password (which can be mapped using the \fIusername map\fR parameter)\&. Encrypted passwords (see the \fIencrypted passwords\fR parameter) can also be used in this security mode\&. Parameters such as \fIuser\fR and \fIguest only\fR if set are then applied and may change the UNIX user to use on this connection, but only after the user has been successfully authenticated\&.

\fBNote\fR that the name of the resource being requested is \fBnot\fR sent to the server until after the server has successfully authenticated the client\&. This is why guest shares don't work in user level security without allowing the server to automatically map unknown users into the \fIguest account\fR\&. See the \fImap to guest\fR parameter for details on doing this\&.

See also the section NOTE ABOUT USERNAME/PASSWORD VALIDATION\&.

\fBSECURITY = DOMAIN\fR

This mode will only work correctly if \fBnet\fR(8) has been used to add this machine into a Windows NT Domain\&. It expects the \fIencrypted passwords\fR parameter to be set to \fByes\fR\&. In this mode Samba will try to validate the username/password by passing it to a Windows NT Primary or Backup Domain Controller, in exactly the same way that a Windows NT Server would do\&.

\fBNote\fR that a valid UNIX user must still exist as well as the account on the Domain Controller to allow Samba to have a valid UNIX account to map file access to\&.

\fBNote\fR that from the client's point of view \fBsecurity = domain\fR is the same as \fBsecurity = user\fR\&. It only affects how the server deals with the authentication, it does not in any way affect what the client sees\&.

\fBNote\fR that the name of the resource being requested is \fBnot\fR sent to the server until after the server has successfully authenticated the client\&. This is why guest shares don't work in user level security without allowing the server to automatically map unknown users into the \fIguest account\fR\&. See the \fImap to guest\fR parameter for details on doing this\&.

See also the section NOTE ABOUT USERNAME/PASSWORD VALIDATION\&.

See also the \fIpassword server\fR parameter and the \fIencrypted passwords\fR parameter\&.

\fBSECURITY = SERVER\fR

In this mode Samba will try to validate the username/password by passing it to another SMB server, such as an NT box\&. If this fails it will revert to \fBsecurity = user\fR\&. It expects the \fIencrypted passwords\fR parameter to be set to \fByes\fR, unless the remote server does not support them\&. However note that if encrypted passwords have been negotiated then Samba cannot revert back to checking the UNIX password file, it must have a valid \fIsmbpasswd\fR file to check users against\&. See the chapter about the User Database in the Samba HOWTO Collection for details on how to set this up\&.


.RS
.Sh "Note"
This mode of operation has significant pitfalls, due to the fact that is activly initiates a man\-in\-the\-middle attack on the remote SMB server\&. In particular, this mode of operation can cause significant resource consuption on the PDC, as it must maintain an active connection for the duration of the user's session\&. Furthermore, if this connection is lost, there is no way to reestablish it, and futher authenticaions to the Samba server may fail\&. (From a single client, till it disconnects)\&.

.RE

.RS
.Sh "Note"
From the client's point of view \fBsecurity = server\fR is the same as \fBsecurity = user\fR\&. It only affects how the server deals with the authentication, it does not in any way affect what the client sees\&.

.RE
\fBNote\fR that the name of the resource being requested is \fBnot\fR sent to the server until after the server has successfully authenticated the client\&. This is why guest shares don't work in user level security without allowing the server to automatically map unknown users into the \fIguest account\fR\&. See the \fImap to guest\fR parameter for details on doing this\&.

See also the section NOTE ABOUT USERNAME/PASSWORD VALIDATION\&.

See also the \fIpassword server\fR parameter and the \fIencrypted passwords\fR parameter\&.

\fBSECURITY = ADS\fR

In this mode, Samba will act as a domain member in an ADS realm\&. To operate in this mode, the machine running Samba will need to have Kerberos installed and configured and Samba will need to be joined to the ADS realm using the net utility\&.

Note that this mode does NOT make Samba operate as a Active Directory Domain Controller\&.

Read the chapter about Domain Membership in the HOWTO for details\&.

Default: \fB\fIsecurity\fR = USER \fR 

Example: \fB\fIsecurity\fR = DOMAIN \fR 

.TP
security mask (S)
This parameter controls what UNIX permission bits can be modified when a Windows NT client is manipulating the UNIX permission on a file using the native NT security dialog box\&.

This parameter is applied as a mask (AND'ed with) to the changed permission bits, thus preventing any bits not in this mask from being modified\&. Essentially, zero bits in this mask may be treated as a set of bits the user is not allowed to change\&.

If not set explicitly this parameter is 0777, allowing a user to modify all the user/group/world permissions on a file\&.

\fBNote\fR that users who can access the Samba server through other means can easily bypass this restriction, so it is primarily useful for standalone "appliance" systems\&. Administrators of most normal systems will probably want to leave it set to \fB0777\fR\&.

Default: \fB\fIsecurity mask\fR = 0777 \fR 

Example: \fB\fIsecurity mask\fR = 0770 \fR 

.TP
server schannel (G)
This controls whether the server offers or even demands the use of the netlogon schannel\&. \fIserver schannel = no\fR does not offer the schannel, \fIserver schannel = auto\fR offers the schannel but does not enforce it, and \fIserver schannel = yes\fR denies access if the client is not able to speak netlogon schannel\&. This is only the case for Windows NT4 before SP4\&.

Please note that with this set to \fIno\fR you will have to apply the WindowsXP requireSignOrSeal\-Registry patch found in the docs/Registry subdirectory\&.

Default: \fB\fIserver schannel\fR = auto \fR 

Example: \fB\fIserver schannel\fR = yes \fR 

.TP
server signing (G)
This controls whether the server offers or requires the client it talks to to use SMB signing\&. Possible values are \fBauto\fR, \fBmandatory\fR and \fBdisabled\fR\&.

When set to auto, SMB signing is offered, but not enforced\&. When set to mandatory, SMB signing is required and if set to disabled, SMB signing is not offered either\&.

Default: \fB\fIserver signing\fR = Disabled \fR 

.TP
server string (G)
This controls what string will show up in the printer comment box in print manager and next to the IPC connection in \fBnet view\fR\&. It can be any string that you wish to show to your users\&.

It also sets what will appear in browse lists next to the machine name\&.

A \fI%v\fR will be replaced with the Samba version number\&.

A \fI%h\fR will be replaced with the hostname\&.

Default: \fB\fIserver string\fR = Samba %v \fR 

Example: \fB\fIserver string\fR = University of GNUs Samba Server \fR 

.TP
set directory (S)
If \fBset directory = no\fR, then users of the service may not use the setdir command to change directory\&.

The \fBsetdir\fR command is only implemented in the Digital Pathworks client\&. See the Pathworks documentation for details\&.

Default: \fB\fIset directory\fR = no \fR 

.TP
set primary group script (G)
Thanks to the Posix subsystem in NT a Windows User has a primary group in addition to the auxiliary groups\&. This script sets the primary group in the unix userdatase when an administrator sets the primary group from the windows user manager or when fetching a SAM with \fBnet rpc vampire\fR\&. \fI%u\fR will be replaced with the user whose primary group is to be set\&.\fI%g\fR will be replaced with the group to set\&.

Default: \fB\fIset primary group script\fR = \fR 

Example: \fB\fIset primary group script\fR = /usr/sbin/usermod \-g '%g' '%u' \fR 

.TP
set quota command (G)
The \fBset quota command\fR should only be used whenever there is no operating system API available from the OS that samba can use\&.

This option is only available if Samba was configured with the argument \fB\-\-with\-sys\-quotas\fR or on linux when \fB\&./configure \-\-with\-quotas\fR was used and a working quota api was found in the system\&. Most packages are configured with these options already\&.

This parameter should specify the path to a script that can set quota for the specified arguments\&.

The specified script should take the following arguments:


.RS
.TP 3
\(bu
1 \- quota type

.RS
.TP 3
\(bu
1 \- user quotas
.TP
\(bu
2 \- user default quotas (uid = \-1)
.TP
\(bu
3 \- group quotas
.TP
\(bu
4 \- group default quotas (gid = \-1)
.LP
.RE
 
.TP
\(bu
2 \- id (uid for user, gid for group, \-1 if N/A)
.TP
\(bu
3 \- quota state (0 = disable, 1 = enable, 2 = enable and enforce)
.TP
\(bu
4 \- block softlimit
.TP
\(bu
5 \- block hardlimit
.TP
\(bu
6 \- inode softlimit
.TP
\(bu
7 \- inode hardlimit
.TP
\(bu
8(optional) \- block size, defaults to 1024
.LP
.RE
The script should output at least one line of data on success\&. And nothing on failure\&.

Default: \fB\fIset quota command\fR = \fR 

Example: \fB\fIset quota command\fR = /usr/local/sbin/set_quota \fR 

.TP
share modes (S)
This enables or disables the honoring of the \fIshare modes\fR during a file open\&. These modes are used by clients to gain exclusive read or write access to a file\&.

These open modes are not directly supported by UNIX, so they are simulated using shared memory, or lock files if your UNIX doesn't support shared memory (almost all do)\&.

The share modes that are enabled by this option are\fBDENY_DOS\fR, \fBDENY_ALL\fR,\fBDENY_READ\fR, \fBDENY_WRITE\fR,\fBDENY_NONE\fR and \fBDENY_FCB\fR\&.

This option gives full share compatibility and enabled by default\&.

You should \fBNEVER\fR turn this parameter off as many Windows applications will break if you do so\&.

Default: \fB\fIshare modes\fR = yes \fR 

.TP
short preserve case (S)
This boolean parameter controls if new files which conform to 8\&.3 syntax, that is all in upper case and of suitable length, are created upper case, or if they are forced to be the \fIdefault case \fR\&. This option can be use with \fBpreserve case = yes\fR to permit long filenames to retain their case, while short names are lowered\&.

See the section on NAME MANGLING\&.

Default: \fB\fIshort preserve case\fR = yes \fR 

.TP
show add printer wizard (G)
With the introduction of MS\-RPC based printing support for Windows NT/2000 client in Samba 2\&.2, a "Printers\&.\&.\&." folder will appear on Samba hosts in the share listing\&. Normally this folder will contain an icon for the MS Add Printer Wizard (APW)\&. However, it is possible to disable this feature regardless of the level of privilege of the connected user\&.

Under normal circumstances, the Windows NT/2000 client will open a handle on the printer server with OpenPrinterEx() asking for Administrator privileges\&. If the user does not have administrative access on the print server (i\&.e is not root or a member of the \fIprinter admin\fR group), the OpenPrinterEx() call fails and the client makes another open call with a request for a lower privilege level\&. This should succeed, however the APW icon will not be displayed\&.

Disabling the \fIshow add printer wizard\fR parameter will always cause the OpenPrinterEx() on the server to fail\&. Thus the APW icon will never be displayed\&.


.RS
.Sh "Note"
This does not prevent the same user from having administrative privilege on an individual printer\&.

.RE
Default: \fB\fIshow add printer wizard\fR = yes \fR 

.TP
shutdown script (G)
\fBThis parameter only exists in the HEAD cvs branch\fR This a full path name to a script called by \fBsmbd\fR(8) that should start a shutdown procedure\&.

This command will be run as the user connected to the server\&.

%m %t %r %f parameters are expanded:


.RS
.TP 3
\(bu
\fI%m\fR will be substituted with the shutdown message sent to the server\&.
.TP
\(bu
\fI%t\fR will be substituted with the number of seconds to wait before effectively starting the shutdown procedure\&.
.TP
\(bu
\fI%r\fR will be substituted with the switch \fB\-r\fR\&. It means reboot after shutdown for NT\&.
.TP
\(bu
\fI%f\fR will be substituted with the switch \fB\-f\fR\&. It means force the shutdown even if applications do not respond for NT\&.
.LP
.RE
Shutdown script example: 
.nf

#!/bin/bash
		
$time=0
let "time/60"
let "time++"

/sbin/shutdown $3 $4 +$time $1 &
.fi
 Shutdown does not return so we need to launch it in background\&.

Default: \fB\fIshutdown script\fR = \fR 

Example: \fB\fIshutdown script\fR = /usr/local/samba/sbin/shutdown %m %t %r %f \fR 

.TP
smb passwd file (G)
This option sets the path to the encrypted smbpasswd file\&. By default the path to the smbpasswd file is compiled into Samba\&.

Default: \fB\fIsmb passwd file\fR = ${prefix}/private/smbpasswd \fR 

Example: \fB\fIsmb passwd file\fR = /etc/samba/smbpasswd \fR 

.TP
smb ports (G)
Specifies which ports the server should listen on for SMB traffic\&.

Default: \fB\fIsmb ports\fR = 445 139 \fR 

.TP
socket address (G)
This option allows you to control what address Samba will listen for connections on\&. This is used to support multiple virtual interfaces on the one server, each with a different configuration\&.

By default Samba will accept connections on any address\&.

Default: \fB\fIsocket address\fR = \fR 

Example: \fB\fIsocket address\fR = 192\&.168\&.2\&.20 \fR 

.TP
socket options (G)
This option allows you to set socket options to be used when talking with the client\&.

Socket options are controls on the networking layer of the operating systems which allow the connection to be tuned\&.

This option will typically be used to tune your Samba server for optimal performance for your local network\&. There is no way that Samba can know what the optimal parameters are for your net, so you must experiment and choose them yourself\&. We strongly suggest you read the appropriate documentation for your operating system first (perhaps \fBman setsockopt\fR will help)\&.

You may find that on some systems Samba will say "Unknown socket option" when you supply an option\&. This means you either incorrectly typed it or you need to add an include file to includes\&.h for your OS\&. If the latter is the case please send the patch to samba\-technical@samba\&.org\&.

Any of the supported socket options may be combined in any way you like, as long as your OS allows it\&.

This is the list of socket options currently settable using this option:


.RS
.TP 3
\(bu
SO_KEEPALIVE
.TP
\(bu
SO_REUSEADDR
.TP
\(bu
SO_BROADCAST
.TP
\(bu
TCP_NODELAY
.TP
\(bu
IPTOS_LOWDELAY
.TP
\(bu
IPTOS_THROUGHPUT
.TP
\(bu
SO_SNDBUF *
.TP
\(bu
SO_RCVBUF *
.TP
\(bu
SO_SNDLOWAT *
.TP
\(bu
SO_RCVLOWAT *
.LP
.RE
Those marked with a \fB'*'\fR take an integer argument\&. The others can optionally take a 1 or 0 argument to enable or disable the option, by default they will be enabled if you don't specify 1 or 0\&.

To specify an argument use the syntax SOME_OPTION = VALUE for example \fBSO_SNDBUF = 8192\fR\&. Note that you must not have any spaces before or after the = sign\&.

If you are on a local network then a sensible option might be:

\fBsocket options = IPTOS_LOWDELAY\fR

If you have a local network then you could try:

\fBsocket options = IPTOS_LOWDELAY TCP_NODELAY\fR

If you are on a wide area network then perhaps try setting IPTOS_THROUGHPUT\&.

Note that several of the options may cause your Samba server to fail completely\&. Use these options with caution!

Default: \fB\fIsocket options\fR = TCP_NODELAY \fR 

Example: \fB\fIsocket options\fR = IPTOS_LOWDELAY \fR 

.TP
stat cache (G)
This parameter determines if \fBsmbd\fR(8) will use a cache in order to speed up case insensitive name mappings\&. You should never need to change this parameter\&.

Default: \fB\fIstat cache\fR = yes \fR 

.TP
store dos attributes (S)
If this parameter is set Samba no longer attempts to map DOS attributes like SYSTEM, HIDDEN, ARCHIVE or READ\-ONLY to UNIX permission bits (such as the \fImap hidden\fR\&. Instead, DOS attributes will be stored onto an extended attribute in the UNIX filesystem, associated with the file or directory\&. For this to operate correctly, the parameters \fImap hidden\fR, \fImap system\fR, \fImap archive\fR must be set to off\&. This parameter writes the DOS attributes as a string into the extended attribute named "user\&.DOSATTRIB"\&. This extended attribute is explicitly hidden from smbd clients requesting an EA list\&. On Linux the filesystem must have been mounted with the mount option user_xattr in order for extended attributes to work, also extended attributes must be compiled into the Linux kernel\&.

Default: \fB\fIstore dos attributes\fR = no \fR 

.TP
strict allocate (S)
This is a boolean that controls the handling of disk space allocation in the server\&. When this is set to \fByes\fR the server will change from UNIX behaviour of not committing real disk storage blocks when a file is extended to the Windows behaviour of actually forcing the disk system to allocate real storage blocks when a file is created or extended to be a given size\&. In UNIX terminology this means that Samba will stop creating sparse files\&. This can be slow on some systems\&.

When strict allocate is \fBno\fR the server does sparse disk block allocation when a file is extended\&.

Setting this to \fByes\fR can help Samba return out of quota messages on systems that are restricting the disk quota of users\&.

Default: \fB\fIstrict allocate\fR = no \fR 

.TP
strict locking (S)
This is a boolean that controls the handling of file locking in the server\&. When this is set to \fByes\fR, the server will check every read and write access for file locks, and deny access if locks exist\&. This can be slow on some systems\&.

When strict locking is disabled, the server performs file lock checks only when the client explicitly asks for them\&.

Well\-behaved clients always ask for lock checks when it is important\&. So in the vast majority of cases, \fBstrict locking = no\fR is preferable\&.

Default: \fB\fIstrict locking\fR = no \fR 

.TP
strict sync (S)
Many Windows applications (including the Windows 98 explorer shell) seem to confuse flushing buffer contents to disk with doing a sync to disk\&. Under UNIX, a sync call forces the process to be suspended until the kernel has ensured that all outstanding data in kernel disk buffers has been safely stored onto stable storage\&. This is very slow and should only be done rarely\&. Setting this parameter to \fBno\fR (the default) means that \fBsmbd\fR(8) ignores the Windows applications requests for a sync call\&. There is only a possibility of losing data if the operating system itself that Samba is running on crashes, so there is little danger in this default setting\&. In addition, this fixes many performance problems that people have reported with the new Windows98 explorer shell file copies\&.

Default: \fB\fIstrict sync\fR = no \fR 

.TP
sync always (S)
This is a boolean parameter that controls whether writes will always be written to stable storage before the write call returns\&. If this is \fBno\fR then the server will be guided by the client's request in each write call (clients can set a bit indicating that a particular write should be synchronous)\&. If this is \fByes\fR then every write will be followed by a \fBfsync() \fR call to ensure the data is written to disk\&. Note that the \fIstrict sync\fR parameter must be set to \fByes\fR in order for this parameter to have any affect\&.

Default: \fB\fIsync always\fR = no \fR 

.TP
syslog (G)
This parameter maps how Samba debug messages are logged onto the system syslog logging levels\&. Samba debug level zero maps onto syslog \fBLOG_ERR\fR, debug level one maps onto \fBLOG_WARNING\fR, debug level two maps onto \fBLOG_NOTICE\fR, debug level three maps onto LOG_INFO\&. All higher levels are mapped to \fB LOG_DEBUG\fR\&.

This parameter sets the threshold for sending messages to syslog\&. Only messages with debug level less than this value will be sent to syslog\&.

Default: \fB\fIsyslog\fR = 1 \fR 

.TP
syslog only (G)
If this parameter is set then Samba debug messages are logged into the system syslog only, and not to the debug log files\&.

Default: \fB\fIsyslog only\fR = no \fR 

.TP
template homedir (G)
When filling out the user information for a Windows NT user, the \fBwinbindd\fR(8) daemon uses this parameter to fill in the home directory for that user\&. If the string \fI%D\fR is present it is substituted with the user's Windows NT domain name\&. If the string \fI%U\fR is present it is substituted with the user's Windows NT user name\&.

Default: \fB\fItemplate homedir\fR = /home/%D/%U \fR 

.TP
template primary group (G)
This option defines the default primary group for each user created by \fBwinbindd\fR(8)'s local account management functions (similar to the 'add user script')\&.

Default: \fB\fItemplate primary group\fR = nobody \fR 

.TP
template shell (G)
When filling out the user information for a Windows NT user, the \fBwinbindd\fR(8) daemon uses this parameter to fill in the login shell for that user\&.

\fBNo default\fR

.TP
time offset (G)
This parameter is a setting in minutes to add to the normal GMT to local time conversion\&. This is useful if you are serving a lot of PCs that have incorrect daylight saving time handling\&.

Default: \fB\fItime offset\fR = 0 \fR 

Example: \fB\fItime offset\fR = 60 \fR 

.TP
time server (G)
This parameter determines if \fBnmbd\fR(8) advertises itself as a time server to Windows clients\&.

Default: \fB\fItime server\fR = no \fR 

.TP
unix charset (G)
Specifies the charset the unix machine Samba runs on uses\&. Samba needs to know this in order to be able to convert text to the charsets other SMB clients use\&.

This is also the charset Samba will use when specifying arguments to scripts that it invokes\&.

Default: \fB\fIunix charset\fR = UTF8 \fR 

Example: \fB\fIunix charset\fR = ASCII \fR 

.TP
unix extensions (G)
This boolean parameter controls whether Samba implments the CIFS UNIX extensions, as defined by HP\&. These extensions enable Samba to better serve UNIX CIFS clients by supporting features such as symbolic links, hard links, etc\&.\&.\&. These extensions require a similarly enabled client, and are of no current use to Windows clients\&.

Default: \fB\fIunix extensions\fR = yes \fR 

.TP
unix password sync (G)
This boolean parameter controls whether Samba attempts to synchronize the UNIX password with the SMB password when the encrypted SMB password in the smbpasswd file is changed\&. If this is set to \fByes\fR the program specified in the \fIpasswd program\fRparameter is called \fBAS ROOT\fR \- to allow the new UNIX password to be set without access to the old UNIX password (as the SMB password change code has no access to the old password cleartext, only the new)\&.

Default: \fB\fIunix password sync\fR = no \fR 

.TP
update encrypted (G)
This boolean parameter allows a user logging on with a plaintext password to have their encrypted (hashed) password in the smbpasswd file to be updated automatically as they log on\&. This option allows a site to migrate from plaintext password authentication (users authenticate with plaintext password over the wire, and are checked against a UNIX account database) to encrypted password authentication (the SMB challenge/response authentication mechanism) without forcing all users to re\-enter their passwords via smbpasswd at the time the change is made\&. This is a convenience option to allow the change over to encrypted passwords to be made over a longer period\&. Once all users have encrypted representations of their passwords in the smbpasswd file this parameter should be set to \fBno\fR\&.

In order for this parameter to work correctly the \fIencrypt passwords\fR parameter must be set to \fBno\fR when this parameter is set to \fByes\fR\&.

Note that even when this parameter is set a user authenticating to \fBsmbd\fR must still enter a valid password in order to connect correctly, and to update their hashed (smbpasswd) passwords\&.

Default: \fB\fIupdate encrypted\fR = no \fR 

.TP
use client driver (S)
This parameter applies only to Windows NT/2000 clients\&. It has no effect on Windows 95/98/ME clients\&. When serving a printer to Windows NT/2000 clients without first installing a valid printer driver on the Samba host, the client will be required to install a local printer driver\&. From this point on, the client will treat the print as a local printer and not a network printer connection\&. This is much the same behavior that will occur when \fBdisable spoolss = yes\fR\&.

The differentiating factor is that under normal circumstances, the NT/2000 client will attempt to open the network printer using MS\-RPC\&. The problem is that because the client considers the printer to be local, it will attempt to issue the OpenPrinterEx() call requesting access rights associated with the logged on user\&. If the user possesses local administator rights but not root privilegde on the Samba host (often the case), the OpenPrinterEx() call will fail\&. The result is that the client will now display an "Access Denied; Unable to connect" message in the printer queue window (even though jobs may successfully be printed)\&.

If this parameter is enabled for a printer, then any attempt to open the printer with the PRINTER_ACCESS_ADMINISTER right is mapped to PRINTER_ACCESS_USE instead\&. Thus allowing the OpenPrinterEx() call to succeed\&. \fBThis parameter MUST not be able enabled on a print share which has valid print driver installed on the Samba server\&.\fR

Default: \fB\fIuse client driver\fR = no \fR 

.TP
use kerberos keytab (G)
Specifies whether Samba should attempt to maintain service principals in the systems keytab file for \fBhost/FQDN\fR and \fBcifs/FQDN\fR\&.

When you are using the heimdal Kerberos libraries, you must also specify the following in \fI/etc/krb5\&.conf\fR:

.nf

[libdefaults]
  default_keytab_name = FILE:/etc/krb5\&.keytab
.fi
Default: \fB\fIuse kerberos keytab\fR = False \fR 

.TP
use mmap (G)
This global parameter determines if the tdb internals of Samba can depend on mmap working correctly on the running system\&. Samba requires a coherent mmap/read\-write system memory cache\&. Currently only HPUX does not have such a coherent cache, and so this parameter is set to \fBno\fR by default on HPUX\&. On all other systems this parameter should be left alone\&. This parameter is provided to help the Samba developers track down problems with the tdb internal code\&.

Default: \fB\fIuse mmap\fR = yes \fR 

.TP
user
This parameter is a synonym for username\&.

.TP
users
This parameter is a synonym for username\&.

.TP
username (S)
Multiple users may be specified in a comma\-delimited list, in which case the supplied password will be tested against each username in turn (left to right)\&.

The \fIusername\fR line is needed only when the PC is unable to supply its own username\&. This is the case for the COREPLUS protocol or where your users have different WfWg usernames to UNIX usernames\&. In both these cases you may also be better using the \\\\server\\share%user syntax instead\&.

The \fIusername\fR line is not a great solution in many cases as it means Samba will try to validate the supplied password against each of the usernames in the \fIusername\fR line in turn\&. This is slow and a bad idea for lots of users in case of duplicate passwords\&. You may get timeouts or security breaches using this parameter unwisely\&.

Samba relies on the underlying UNIX security\&. This parameter does not restrict who can login, it just offers hints to the Samba server as to what usernames might correspond to the supplied password\&. Users can login as whoever they please and they will be able to do no more damage than if they started a telnet session\&. The daemon runs as the user that they log in as, so they cannot do anything that user cannot do\&.

To restrict a service to a particular set of users you can use the \fIvalid users \fR parameter\&.

If any of the usernames begin with a '@' then the name will be looked up first in the NIS netgroups list (if Samba is compiled with netgroup support), followed by a lookup in the UNIX groups database and will expand to a list of all users in the group of that name\&.

If any of the usernames begin with a '+' then the name will be looked up only in the UNIX groups database and will expand to a list of all users in the group of that name\&.

If any of the usernames begin with a '&' then the name will be looked up only in the NIS netgroups database (if Samba is compiled with netgroup support) and will expand to a list of all users in the netgroup group of that name\&.

Note that searching though a groups database can take quite some time, and some clients may time out during the search\&.

See the section NOTE ABOUT USERNAME/PASSWORD VALIDATION for more information on how this parameter determines access to the services\&.

Default: \fB\fIusername\fR = # The guest account if a guest service, else <empty string>\&. \fR 

Example: \fB\fIusername\fR = fred, mary, jack, jane, @users, @pcgroup \fR 

.TP
username level (G)
This option helps Samba to try and 'guess' at the real UNIX username, as many DOS clients send an all\-uppercase username\&. By default Samba tries all lowercase, followed by the username with the first letter capitalized, and fails if the username is not found on the UNIX machine\&.

If this parameter is set to non\-zero the behavior changes\&. This parameter is a number that specifies the number of uppercase combinations to try while trying to determine the UNIX user name\&. The higher the number the more combinations will be tried, but the slower the discovery of usernames will be\&. Use this parameter when you have strange usernames on your UNIX machine, such as \fBAstrangeUser \fR\&.

This parameter is needed only on UNIX systems that have case sensitive usernames\&.

Default: \fB\fIusername level\fR = 0 \fR 

Example: \fB\fIusername level\fR = 5 \fR 

.TP
username map (G)
This option allows you to specify a file containing a mapping of usernames from the clients to the server\&. This can be used for several purposes\&. The most common is to map usernames that users use on DOS or Windows machines to those that the UNIX box uses\&. The other is to map multiple users to a single username so that they can more easily share files\&.

The map file is parsed line by line\&. Each line should contain a single UNIX username on the left then a '=' followed by a list of usernames on the right\&. The list of usernames on the right may contain names of the form @group in which case they will match any UNIX username in that group\&. The special client name '*' is a wildcard and matches any name\&. Each line of the map file may be up to 1023 characters long\&.

The file is processed on each line by taking the supplied username and comparing it with each username on the right hand side of the '=' signs\&. If the supplied name matches any of the names on the right hand side then it is replaced with the name on the left\&. Processing then continues with the next line\&.

If any line begins with a '#' or a ';' then it is ignored

If any line begins with an '!' then the processing will stop after that line if a mapping was done by the line\&. Otherwise mapping continues with every line being processed\&. Using '!' is most useful when you have a wildcard mapping line later in the file\&.

For example to map from the name \fBadmin\fR or \fBadministrator\fR to the UNIX name \fB root\fR you would use:

\fBroot = admin administrator\fR

Or to map anyone in the UNIX group \fBsystem\fR to the UNIX name \fBsys\fR you would use:

\fBsys = @system\fR

You can have as many mappings as you like in a username map file\&.

If your system supports the NIS NETGROUP option then the netgroup database is checked before the \fI/etc/group \fR database for matching groups\&.

You can map Windows usernames that have spaces in them by using double quotes around the name\&. For example:

\fBtridge = "Andrew Tridgell"\fR

would map the windows username "Andrew Tridgell" to the unix username "tridge"\&.

The following example would map mary and fred to the unix user sys, and map the rest to guest\&. Note the use of the '!' to tell Samba to stop processing if it gets a match on that line\&.


.nf

!sys = mary fred
guest = *
.fi


Note that the remapping is applied to all occurrences of usernames\&. Thus if you connect to \\\\server\\fred and \fB fred\fR is remapped to \fBmary\fR then you will actually be connecting to \\\\server\\mary and will need to supply a password suitable for \fBmary\fR not \fBfred\fR\&. The only exception to this is the username passed to the \fI password server\fR (if you have one)\&. The password server will receive whatever username the client supplies without modification\&.

Also note that no reverse mapping is done\&. The main effect this has is with printing\&. Users who have been mapped may have trouble deleting print jobs as PrintManager under WfWg will think they don't own the print job\&.

Samab versions prior to 3\&.0\&.8 would only support reading the fully qualified username (e\&.g\&.: DOMAIN\\user) from the username map when performing a kerberos login from a client\&. However, when looking up a map entry for a user authenticated by NTLM[SSP], only the login name would be used for matches\&. This resulted in inconsistent behavior sometimes even on the same server\&.

The following functionality is obeyed in version 3\&.0\&.8 and later:

When performing local authentication, the username map is applied to the login name before attempting to authenticate the connection\&.

When relying upon a external domain controller for validating authentication requests, smbd will apply the username map to the fully qualified username (i\&.e\&. DOMAIN\\user) only after the user has been successfully authenticated\&.

Default: \fB\fIusername map\fR = # no username map \fR 

Example: \fB\fIusername map\fR = /usr/local/samba/lib/users\&.map \fR 

.TP
use sendfile (S)
If this parameter is \fByes\fR, and the \fBsendfile()\fR system call is supported by the underlying operating system, then some SMB read calls (mainly ReadAndX and ReadRaw) will use the more efficient sendfile system call for files that are exclusively oplocked\&. This may make more efficient use of the system CPU's and cause Samba to be faster\&. Samba automatically turns this off for clients that use protocol levels lower than NT LM 0\&.12 and when it detects a client is Windows 9x (using sendfile from Linux will cause these clients to fail)\&.

Default: \fB\fIuse sendfile\fR = yes \fR 

.TP
use spnego (G)
This variable controls controls whether samba will try to use Simple and Protected NEGOciation (as specified by rfc2478) with WindowsXP and Windows2000 clients to agree upon an authentication mechanism\&.

Unless further issues are discovered with our SPNEGO implementation, there is no reason this should ever be disabled\&.

Default: \fB\fIuse spnego\fR = yes \fR 

.TP
utmp (G)
This boolean parameter is only available if Samba has been configured and compiled with the option \fB \-\-with\-utmp\fR\&. If set to \fByes\fR then Samba will attempt to add utmp or utmpx records (depending on the UNIX system) whenever a connection is made to a Samba server\&. Sites may use this to record the user connecting to a Samba share\&.

Due to the requirements of the utmp record, we are required to create a unique identifier for the incoming user\&. Enabling this option creates an n^2 algorithm to find this number\&. This may impede performance on large installations\&.

Default: \fB\fIutmp\fR = no \fR 

.TP
utmp directory (G)
This parameter is only available if Samba has been configured and compiled with the option \fB \-\-with\-utmp\fR\&. It specifies a directory pathname that is used to store the utmp or utmpx files (depending on the UNIX system) that record user connections to a Samba server\&. By default this is not set, meaning the system will use whatever utmp file the native system is set to use (usually\fI/var/run/utmp\fR on Linux)\&.

Default: \fB\fIutmp directory\fR = # Determined automatically \fR 

Example: \fB\fIutmp directory\fR = /var/run/utmp \fR 

.TP
\-valid (S)
This parameter indicates whether a share is valid and thus can be used\&. When this parameter is set to false, the share will be in no way visible nor accessible\&.

This option should not be used by regular users but might be of help to developers\&. Samba uses this option internally to mark shares as deleted\&.

Default: \fB\fI\-valid\fR = yes \fR 

.TP
valid users (S)
This is a list of users that should be allowed to login to this service\&. Names starting with '@', '+' and '&' are interpreted using the same rules as described in the \fIinvalid users\fR parameter\&.

If this is empty (the default) then any user can login\&. If a username is in both this list and the \fIinvalid users\fR list then access is denied for that user\&.

The current servicename is substituted for \fI%S \fR\&. This is useful in the [homes] section\&.

Default: \fB\fIvalid users\fR = # No valid users list (anyone can login) \fR 

Example: \fB\fIvalid users\fR = greg, @pcusers \fR 

.TP
veto files (S)
This is a list of files and directories that are neither visible nor accessible\&. Each entry in the list must be separated by a '/', which allows spaces to be included in the entry\&. '*' and '?' can be used to specify multiple files or directories as in DOS wildcards\&.

Each entry must be a unix path, not a DOS path and must \fBnot\fR include the unix directory separator '/'\&.

Note that the \fIcase sensitive\fR option is applicable in vetoing files\&.

One feature of the veto files parameter that it is important to be aware of is Samba's behaviour when trying to delete a directory\&. If a directory that is to be deleted contains nothing but veto files this deletion will \fBfail\fR unless you also set the \fIdelete veto files\fR parameter to\fIyes\fR\&.

Setting this parameter will affect the performance of Samba, as it will be forced to check all files and directories for a match as they are scanned\&.

Default: \fB\fIveto files\fR = # No files or directories are vetoed\&. \fR 

Example: \fB\fIveto files\fR = ; Veto any files containing the word Security, ; any ending in \&.tmp, and any directory containing the ; word root\&. veto files = /*Security*/*\&.tmp/*root*/ ; Veto the Apple specific files that a NetAtalk server ; creates\&. veto files = /\&.AppleDouble/\&.bin/\&.AppleDesktop/Network Trash Folder/ \fR 

.TP
veto oplock files (S)
This parameter is only valid when the \fIoplocks\fR parameter is turned on for a share\&. It allows the Samba administrator to selectively turn off the granting of oplocks on selected files that match a wildcarded list, similar to the wildcarded list used in the\fIveto files\fR parameter\&.

You might want to do this on files that you know will be heavily contended for by clients\&. A good example of this is in the NetBench SMB benchmark program, which causes heavy client contention for files ending in \fI\&.SEM\fR\&. To cause Samba not to grant oplocks on these files you would use the line (either in the [global] section or in the section for the particular NetBench share :

Default: \fB\fIveto oplock files\fR = # No files are vetoed for oplock grants \fR 

Example: \fB\fIveto oplock files\fR = /\&.*SEM/ \fR 

.TP
vfs object
This parameter is a synonym for vfs objects\&.

.TP
vfs objects (S)
This parameter specifies the backend names which are used for Samba VFS I/O operations\&. By default, normal disk I/O operations are used but these can be overloaded with one or more VFS objects\&.

Default: \fB\fIvfs objects\fR = \fR 

Example: \fB\fIvfs objects\fR = extd_audit recycle \fR 

.TP
volume (S)
This allows you to override the volume label returned for a share\&. Useful for CDROMs with installation programs that insist on a particular volume label\&.

Default: \fB\fIvolume\fR = # the name of the share \fR 

.TP
wide links (S)
This parameter controls whether or not links in the UNIX file system may be followed by the server\&. Links that point to areas within the directory tree exported by the server are always allowed; this parameter controls access only to areas that are outside the directory tree being exported\&.

Note that setting this parameter can have a negative effect on your server performance due to the extra system calls that Samba has to do in order to perform the link checks\&.

Default: \fB\fIwide links\fR = yes \fR 

.TP
winbind cache time (G)
This parameter specifies the number of seconds the \fBwinbindd\fR(8) daemon will cache user and group information before querying a Windows NT server again\&.


.RS
.Sh "Note"
This does not apply to authentication requests, these are always evaluated in real time\&.

.RE
Default: \fB\fIwinbind cache time\fR = 300 \fR 

.TP
winbind enable local accounts (G)
This parameter controls whether or not winbindd will act as a stand in replacement for the various account management hooks in smb\&.conf (e\&.g\&. 'add user script')\&. If enabled, winbindd will support the creation of local users and groups as another source of UNIX account information available via getpwnam() or getgrgid(), etc\&.\&.\&.

Default: \fB\fIwinbind enable local accounts\fR = no \fR 

.TP
winbind enum groups (G)
On large installations using \fBwinbindd\fR(8) it may be necessary to suppress the enumeration of groups through the \fBsetgrent()\fR,\fBgetgrent()\fR and\fBendgrent()\fR group of system calls\&. If the \fIwinbind enum groups\fR parameter is\fBno\fR, calls to the \fBgetgrent()\fR system call will not return any data\&.


.RS
.Sh "Warning"
Turning off group enumeration may cause some programs to behave oddly\&.

.RE
Default: \fB\fIwinbind enum groups\fR = yes \fR 

.TP
winbind enum users (G)
On large installations using \fBwinbindd\fR(8) it may be necessary to suppress the enumeration of users through the \fBsetpwent()\fR,\fBgetpwent()\fR and\fBendpwent()\fR group of system calls\&. If the \fIwinbind enum users\fR parameter is\fBno\fR, calls to the \fBgetpwent\fR system call will not return any data\&.


.RS
.Sh "Warning"
Turning off user enumeration may cause some programs to behave oddly\&. For example, the finger program relies on having access to the full user list when searching for matching usernames\&.

.RE
Default: \fB\fIwinbind enum users\fR = yes \fR 

.TP
winbind nested groups (G)
If set to yes, this parameter activates the support for nested groups\&. Nested groups are also called local groups or aliases\&. They work like their counterparts in Windows: Nested groups are defined locally on any machine (they are shared between DC's through their SAM) and can contain users and global groups from any trusted SAM\&. To be able to use nested groups, you need to run nss_winbind\&.

Please note that per 3\&.0\&.3 this is a new feature, so handle with care\&.

Default: \fB\fIwinbind nested groups\fR = no \fR 

.TP
winbind separator (G)
This parameter allows an admin to define the character used when listing a username of the form of \fIDOMAIN \fR\\\fIuser\fR\&. This parameter is only applicable when using the \fIpam_winbind\&.so\fR and \fInss_winbind\&.so\fR modules for UNIX services\&.

Please note that setting this parameter to + causes problems with group membership at least on glibc systems, as the character + is used as a special character for NIS in /etc/group\&.

Default: \fB\fIwinbind separator\fR = '\\' \fR 

Example: \fB\fIwinbind separator\fR = + \fR 

.TP
winbind trusted domains only (G)
This parameter is designed to allow Samba servers that are members of a Samba controlled domain to use UNIX accounts distributed via NIS, rsync, or LDAP as the uid's for winbindd users in the hosts primary domain\&. Therefore, the user DOMAIN\\user1 would be mapped to the account user1 in /etc/passwd instead of allocating a new uid for him or her\&.

Default: \fB\fIwinbind trusted domains only\fR = no \fR 

.TP
winbind use default domain (G)
This parameter specifies whether the\fBwinbindd\fR(8) daemon should operate on users without domain component in their username\&. Users without a domain component are treated as is part of the winbindd server's own domain\&. While this does not benifit Windows users, it makes SSH, FTP and e\-mail function in a way much closer to the way they would in a native unix system\&.

Default: \fB\fIwinbind use default domain\fR = no \fR 

Example: \fB\fIwinbind use default domain\fR = yes \fR 

.TP
wins hook (G)
When Samba is running as a WINS server this allows you to call an external program for all changes to the WINS database\&. The primary use for this option is to allow the dynamic update of external name resolution databases such as dynamic DNS\&.

The wins hook parameter specifies the name of a script or executable that will be called as follows:

\fBwins_hook operation name nametype ttl IP_list\fR


.RS
.TP 3
\(bu
The first argument is the operation and is one of "add", "delete", or "refresh"\&. In most cases the operation can be ignored as the rest of the parameters provide sufficient information\&. Note that "refresh" may sometimes be called when the name has not previously been added, in that case it should be treated as an add\&.
.TP
\(bu
The second argument is the NetBIOS name\&. If the name is not a legal name then the wins hook is not called\&. Legal names contain only letters, digits, hyphens, underscores and periods\&.
.TP
\(bu
The third argument is the NetBIOS name type as a 2 digit hexadecimal number\&.
.TP
\(bu
The fourth argument is the TTL (time to live) for the name in seconds\&.
.TP
\(bu
The fifth and subsequent arguments are the IP addresses currently registered for that name\&. If this list is empty then the name should be deleted\&.
.LP
.RE
An example script that calls the BIND dynamic DNS update program \fBnsupdate\fR is provided in the examples directory of the Samba source code\&.

\fBNo default\fR

.TP
wins proxy (G)
This is a boolean that controls if \fBnmbd\fR(8) will respond to broadcast name queries on behalf of other hosts\&. You may need to set this to \fByes\fR for some older clients\&.

Default: \fB\fIwins proxy\fR = no \fR 

.TP
wins server (G)
This specifies the IP address (or DNS name: IP address for preference) of the WINS server that \fBnmbd\fR(8) should register with\&. If you have a WINS server on your network then you should set this to the WINS server's IP\&.

You should point this at your WINS server if you have a multi\-subnetted network\&.

If you want to work in multiple namespaces, you can give every wins server a 'tag'\&. For each tag, only one (working) server will be queried for a name\&. The tag should be separated from the ip address by a colon\&.


.RS
.Sh "Note"
You need to set up Samba to point to a WINS server if you have multiple subnets and wish cross\-subnet browsing to work correctly\&.

.RE
See the ???\&.

Default: \fB\fIwins server\fR = \fR 

Example: \fB\fIwins server\fR = mary:192\&.9\&.200\&.1 fred:192\&.168\&.3\&.199 mary:192\&.168\&.2\&.61 # For this example when querying a certain name, 192\&.19\&.200\&.1 will be asked first and if that doesn't respond 192\&.168\&.2\&.61\&. If either of those doesn't know the name 192\&.168\&.3\&.199 will be queried\&. \fR 

Example: \fB\fIwins server\fR = 192\&.9\&.200\&.1 192\&.168\&.2\&.61 \fR 

.TP
wins support (G)
This boolean controls if the \fBnmbd\fR(8) process in Samba will act as a WINS server\&. You should not set this to \fByes\fR unless you have a multi\-subnetted network and you wish a particular \fBnmbd\fR to be your WINS server\&. Note that you should \fBNEVER\fR set this to \fByes\fR on more than one machine in your network\&.

Default: \fB\fIwins support\fR = no \fR 

.TP
workgroup (G)
This controls what workgroup your server will appear to be in when queried by clients\&. Note that this parameter also controls the Domain name used with the \fBsecurity = domain\fR setting\&.

Default: \fB\fIworkgroup\fR = WORKGROUP \fR 

Example: \fB\fIworkgroup\fR = MYGROUP \fR 

.TP
writable
This parameter is a synonym for writeable\&.

.TP
writeable (S)
Inverted synonym for \fIread only\fR\&.

\fBNo default\fR

.TP
write cache size (S)
If this integer parameter is set to non\-zero value, Samba will create an in\-memory cache for each oplocked file (it does \fBnot\fR do this for non\-oplocked files)\&. All writes that the client does not request to be flushed directly to disk will be stored in this cache if possible\&. The cache is flushed onto disk when a write comes in whose offset would not fit into the cache or when the file is closed by the client\&. Reads for the file are also served from this cache if the data is stored within it\&.

This cache allows Samba to batch client writes into a more efficient write size for RAID disks (i\&.e\&. writes may be tuned to be the RAID stripe size) and can improve performance on systems where the disk subsystem is a bottleneck but there is free memory for userspace programs\&.

The integer parameter specifies the size of this cache (per oplocked file) in bytes\&.

Default: \fB\fIwrite cache size\fR = 0 \fR 

Example: \fB\fIwrite cache size\fR = 262144 # for a 256k cache size per file \fR 

.TP
write list (S)
This is a list of users that are given read\-write access to a service\&. If the connecting user is in this list then they will be given write access, no matter what the \fIread only\fR option is set to\&. The list can include group names using the @group syntax\&.

Note that if a user is in both the read list and the write list then they will be given write access\&.

Default: \fB\fIwrite list\fR = \fR 

Example: \fB\fIwrite list\fR = admin, root, @staff \fR 

.TP
write raw (G)
This parameter controls whether or not the server will support raw write SMB's when transferring data from clients\&. You should never need to change this parameter\&.

Default: \fB\fIwrite raw\fR = yes \fR 

.TP
wtmp directory (G)
This parameter is only available if Samba has been configured and compiled with the option \fB \-\-with\-utmp\fR\&. It specifies a directory pathname that is used to store the wtmp or wtmpx files (depending on the UNIX system) that record user connections to a Samba server\&. The difference with the utmp directory is the fact that user info is kept after a user has logged out\&.

By default this is not set, meaning the system will use whatever utmp file the native system is set to use (usually\fI/var/run/wtmp\fR on Linux)\&.

Default: \fB\fIwtmp directory\fR = \fR 

Example: \fB\fIwtmp directory\fR = /var/log/wtmp \fR 

.SH "WARNINGS"

.PP
Although the configuration file permits service names to contain spaces, your client software may not\&. Spaces will be ignored in comparisons anyway, so it shouldn't be a problem \- but be aware of the possibility\&.

.PP
On a similar note, many clients \- especially DOS clients \- limit service names to eight characters\&. \fBsmbd\fR(8) has no such limitation, but attempts to connect from such clients will fail if they truncate the service names\&. For this reason you should probably keep your service names down to eight characters in length\&.

.PP
Use of the [homes] and [printers] special sections make life for an administrator easy, but the various combinations of default attributes can be tricky\&. Take extreme care when designing these sections\&. In particular, ensure that the permissions on spool directories are correct\&.

.SH "VERSION"

.PP
This man page is correct for version 3\&.0 of the Samba suite\&.

.SH "SEE ALSO"

.PP
\fBsamba\fR(7), \fBsmbpasswd\fR(8), \fBswat\fR(8), \fBsmbd\fR(8), \fBnmbd\fR(8), \fBsmbclient\fR(1), \fBnmblookup\fR(1), \fBtestparm\fR(1), \fBtestprns\fR(1)\&.

.SH "AUTHOR"

.PP
The original Samba software and related utilities were created by Andrew Tridgell\&. Samba is now developed by the Samba Team as an Open Source project similar to the way the Linux kernel is developed\&.

.PP
The original Samba man pages were written by Karl Auer\&. The man page sources were converted to YODL format (another excellent piece of Open Source software, available at ftp://ftp\&.icce\&.rug\&.nl/pub/unix/) and updated for the Samba 2\&.0 release by Jeremy Allison\&. The conversion to DocBook for Samba 2\&.2 was done by Gerald Carter\&. The conversion to DocBook XML 4\&.2 for Samba 3\&.0 was done by Alexander Bokovoy\&.

