#!/bin/sh

#Script uses absolute paths even though its always in /var/pegasus

omc_smash_dir=/var/pegasus/omc-smash

patch_identity()
{
mofs_dir=$1
pushd ${mofs_dir}/mofs/root/cimv2/ > /dev/null

#Copy all Identity schema files to PG_InterOp
cp -f identity-schema.mof VMware_Identity.mof VMware_Account.mof VMware_AssignedIdentity.mof VMware_AccountManagementService.mof IdentityInstances.mof ../PG_Interop

#fix registration to register all mofs in PG_InterOp
cd ../../../regs
sed -r 's/Namespaces.*;/ Namespaces = { \"root\/cimv2\", \"root\/PG_Interop\" };/g' identity_PegReg.mof > tmp.mof;mv -f tmp.mof identity_PegReg.mof

popd > /dev/null
}

##### Fix bug of multiple entries in identity_PegReg.mof for PG_Interop namespace. #####

#Step 1 : Check if there is a identity_PegReg.mof in the install_queue
logfiles=`find /var/pegasus/vmware/install_queue -maxdepth 3 -type f -name 'identity_PegReg.mof' -print`
logfiles_count=`echo $logfiles | wc -l`

if [ $logfiles_count -gt 0 ]
then

for logfile in $logfiles
do

#Step 2 : Correct the Namespace regardless

sed -r 's/Namespaces.*;/ Namespaces = { \"root\/cimv2\", \"root\/PG_Interop\" };/g' $logfile > /tmp/tmp.mof;mv -f /tmp/tmp.mof $logfile 

done

fi


##### Fix for the original install_queue failure in 35u1 in VMware_Identity #####

#Step 0 : Check if there is a broken install queue
logfiles=`find /var/pegasus/vmware/install_queue -maxdepth 1 -type f -name '*.log' -print`
logfiles_count=`echo $logfiles | wc -l`

if [ $logfiles_count -gt 0 ]
then

identity_patched=0

for logfile in $logfiles
do

#Step 2a : Check if the error is due to VMware_Identity
has_identity_error=`grep "VMware_Identity" $logfile | wc -c`
if [ $has_identity_error -gt 0 ]
then

#Step 1 : If pegasus has a broken install queue due to VMware_Identity, stop pegasus
#echo 'Stopping pegasus to fix install_queue...'
#/etc/init.d/pegasus stop

#Step 2b : Go to the queue directory with the error
queue_prefix=`echo $logfile | sed 's/\(.*\)\(\.log\)/\1/g'`

#Step 3a : for completeness patch x_files/mofs/root/PG_Interop, and x_files/regs/identity_PegReg.mof
patch_identity ${queue_prefix}_files

#Step 3b : sort x_files list, so identity is processed before roleauth
sed 's/\(.*schema\.mof\)\(\.*\)/\1\ \|\ sort\2/g' ${queue_prefix} > ${queue_prefix}tmp;mv -f ${queue_prefix}tmp ${queue_prefix}

identity_patched=1

else
echo 'This script only fixes the broken VMware_Identity.mof issue.'
echo 'See the error log in /var/pegasus/vmware/install_queue for other errors.'

fi

done

if [ $identity_patched -gt 0 ]
then

#Step 4 : for completeness, also patch omc-smash/mofs/root/PG_Interop and omc-smash/regs/identity_PegReg.mof
patch_identity ${omc_smash_dir}

#Step 5 : Restart pegasus
echo 'Identity patched.'
#echo 'Restarting pegasus to resume install_queue...'
#/etc/init.d/pegasus start

fi

fi

