::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::  Sample script that illustrates how to perform unattended and silent
::  VirtualCenter installations.
::
:: Copyright 2006 VMware, Inc.  All rights reserved. -- VMware Confidential
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:: Update the paths below to match your computer configuration
set VC_MEDIA=.
set VC_LICENSE=%USERPROFILE%\Desktop\vmware.lic

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

@set SETUP=start /wait %VC_MEDIA%\VMware-vcserver.exe /s /w
@set CLIENTSETUP=start /wait %VC_MEDIA%\VMware-viclient.exe /s /w
@set VMLS=start /wait %VC_MEDIA%\VMware-licenseserver.exe /s /w
@set MSDE=%VC_MEDIA%\..\redist\MSDERelA\setup.exe

:: The installation can be customized using one or more of the following
:: properties. It is helpful to first run the installer interactively to
:: get used with their scope.
::
::    INSTALLDIR=\"<InstallDir>\" - Specifies an alternate install directory
::
::    ADDLOCAL=<featureList> - Specifies what features to install.
::      It is set by default to ALL. Set it to:
::        VPX - to install only the VirtualCenter server
::        WebAccess,JRE,Tomcat - to install only webAccess
::
::    LICENSING=[Local|Custom] - Configures VirtualCenter to use an existing
::      local license server. for a silent install the server must be installed
::      before VirtualCenter. Unattended reduced/basic UI installations (/qr
::      or /qb) can install the server automatically,
::
::    DB_SERVER_TYPE=[Bundled|Custom] - Configures VirtualCenter to use an
::      existing local MSDE instance. Unattended reduced UI installations
::      (/qr or /qb) can install the server automatically,
::
::    DB_DSN="<Name>" - Customizes the DSN. the default value is 'VMware
::      VirtualCenter'.
::
::    DB_USERNAME="<Name>" - Sets the DSN account name
::    DB_PASSWORD="<Password>" - Sets the DSN account password
::
::    DIAG_PORT=<port> - Customizes the VirtualCenter diagnostics port.
::
::    MSDE_INSTANCE=<Name> - Customizes the MSDE instance name. This should match
::      the instance name passed to the MSDE setup command line.
::    MSDE_SAPWD=<Password> - Customizes the MSDE password. It makes sense
::      only when running setup.exe with with /qr or /qb.
::
::    HTTP_PROXY_PORT - VirtualCenter property that can be used to customize the
::      http web service port.
::    HTTPS_PROXY_PORT - VirtualCenter property that can be used to customize the
::      https web service port.
::    VMA_1X=1 - VirtualCenter property that enables the VMA 1.x backward
::      compatibility by setting
::      HKLM\SOFTWARE\VMware, Inc.\VMware VirtualCenter\CompatibleWith1xWebService
::      to 1
::
::    VMDB_PORT=<port> - Customizes the VirtualCenter port. The default is 902.
::
::    HEARTBEAT_PORT=<port> - Customizes the VirtualCenter heartbeat port. 
::      The default value is 902.
::
::    VMLS_LICENSEPATH=<FilePath> - During an unattended UI install, it tells the
::      VirtualCenter installer what license file to pass to the license server
::      installer it spawns. This is required only when LICENSING=Local.
::      Set it to the full path to the license file to be served.
::    VPX_LICENSEPATH=<LicensePath> - Tells VirtualCenter from where to
::      read the licenses. When LICENSING=Custom it should be set to the license
::      server address (ie. 27000@someHost). There is no need to set it
::      when LICENSING=Local because the default value is 27000@localhost.
::
::    VPX_ACCOUNT - Customizes the VirtualCenter service account name. The
::      default value is the system account.
::    VPX_PASSWORD - Specifies the password to be used with VPX_ACCOUNT
::
::    TC_PORT=<port> - Customizes the webAccess Tomcat port
::    TC_AUTO=1 - Marks the webAccess Tomcat service as 'Automatic'
::    TC_START=1 - Starts the webAccess Tomcat service at the end of the
::      installation
::
:: Note: To avoid rebooting during a silent install add REBOOT=SUPPRESS.
::       A reboot will might still be needed but you can defer it after
::       the silent install script ends.
::
::
:: Examples:
::
::    %SETUP% /v"/qn WARNING_LEVEL=0 INSTALLDIR=\"d:\vc\" DB_SERVER_TYPE=Custom \
::       DSN=VCTest"
::
::    %SETUP% /v"/qr WARNING_LEVEL=0 ADDLOCAL=WebAccess,JRE,Tomcat TC_PORT=8888"


::------------------------------------------------------------------------
::   Setup VirtualCenter server and webAccess using MSDE
::
::   Unattended (/qr or /qb) installs have an UI and can automatically install
::   MSDE and the License Server. Due to the MSI limitations silent installs
::   must script the MSDE instance installation and the VMware License Server
::   installation *before* installing VirtualCenter.
::
:: Silently install the MSDE instance
:: Note: Run only when planning to use the bundled MSDE. Once installed there
::       is no need to re-install. Use the Add/Remove panel to remove.
@set MSDE_INSTANCE=MSDE_VC
%MSDE% /qn WARNING_LEVEL=0 /L*v "%TEMP%\vmmsde.log" INSTANCENAME=%MSDE_INSTANCE% SAPWD=welcome1
::
:: Silently install the VMware License Server
%VMLS% /v"/qn /L*v "%TEMP%\vmls.log" WARNING_LEVEL=0 LICENSING=Local LICENSEPATH=\"%VC_LICENSE%\""
:: For reduced or basic UI installations substitute /qn with /qr or /qb
::    VMLS_LICENSEPATH=<FilePath> - Set it to the full path to the license file
::       to be served. The server will be set up as specified in the license file
::       (i.e. 27000@localhost).
::
:: Silently install the VirtualCenter server and webAccess
%SETUP% /v"/qn /L*v "%TEMP%\vmvc.log" WARNING_LEVEL=0 LICENSING=Custom DB_SERVER_TYPE=Bundled"


:: Note: When an unattended UI installation is acceptable, all the above commands
::       can be condensed into:
::
:: %SETUP% /v"/qr WARNING_LEVEL=0 LICENSING=Local VMLS_LICENSEPATH=\"%VC_LICENSE%\" DB_SERVER_TYPE=Bundled"


:: VirtualCenter Client silent install
%CLIENTSETUP% /s /w /v"/qn /L*v "%TEMP%\vmvcc.log" WARNING_LEVEL=0"
:: For reduced or basic UI installations substitute /qn with /qr or /qb
:: To customize the install directory add:
::    INSTALLDIR=\"<InstallDir>\" - Specifies an alternate install directory
::      Make sure it does not point to an existing folder.


:: For more details about the standard MSI flags see:
:: http://msdn.microsoft.com/library/default.asp?url=/library/en-us/msi/setup/instmsi_exe.asp

