#!/bin/sh
# Copyright 2008 VMware Inc.,

TRUE=0
FALSE=1

LOG_FILE=/var/log/vmware/upgrade.log
UPGRADE_CACHE_DIR=/var/cache/upgrade
RAMDISK_NAME=upgrade
verbose=${FALSE}

Log()
{
   if [ "${verbose}" -eq ${TRUE} ] ; then
      echo "$@" >&2
   fi

   echo "$(date "+%Y-%m-%d %H:%M:%S")" "$@" >> "${LOG_FILE}"
}

Warning()
{
   echo "Warning: $@" >&2
}

Panic()
{
   [ "${verbose}" -eq ${FALSE} ] && echo "Error: $@" >&2
   Log "CRITICAL $@"
   exit 1
}

GetESXProduct()
{
   echo $(vmware -v 2> /dev/null) | sed -n "s:\(.\+\) [0-9]\.[0-9]\.[0-9].\+:\1:p"
}

# Clean up esxupdate cache dir
if [ "$(GetESXProduct)" = "VMware ESXi" ]; then
  Log "Cleaning up esxupdate cache..."
  esxupdate --cleancache check > /dev/null 2>&1
fi

#
# Umount upgrade cache directory
#
if [ -n "${UPGRADE_CACHE_DIR}" -a -d "${UPGRADE_CACHE_DIR}" ]; then
   Log "Cleanup upgrade cache dir :${UPGRADE_CACHE_DIR}"
   rm -rf "${UPGRADE_CACHE_DIR}"/*
   if $(mount | grep -q "${UPGRADE_CACHE_DIR}"); then
      Log "Umounting upgrade cache directory..."
      umount "${UPGRADE_CACHE_DIR}" || {
         Panic "Failed to umount visorfs on ${UPGRADE_CACHE_DIR}, return :${?}"
     }
   fi
fi
