#!/bin/sh
# Copyright 2008 VMware Inc.,

GetAbsPath()
{
    local parentdir=$(dirname "${1}")
    local absparentdir=$(cd "${parentdir}"; pwd)
    echo "${absparentdir}/$(basename "${1}")"
}

for optarg in "$@"; do
    case $optarg in
        --source=*)
            src_dir=$(echo "$optarg" | cut -d"=" -f2-)
            ;;
        *)
            ;;
    esac
done

if [ -z "${src_dir}" ]; then
   src_dir=$(dirname $(GetAbsPath "${0}"))
fi

if [ -f "${src_dir}/install.sh" ]; then
   chmod +x "${src_dir}/install.sh"
   setsid ++swap=false "$src_dir/install.sh" "$@" 2> /dev/null &
else
   exit 1
fi

