#!/bin/sh
# Copyright 2008 VMware Inc.,

#set -x
TRUE=0
FALSE=1

LOG_FILE=/var/log/vmware/upgrade.log
UPGRADE_CACHE_DIR=/var/cache/upgrade
RAMDISK_NAME=upgrade
verbose=${FALSE}

Log ()
{
    if [ ${verbose} -eq ${TRUE} ]; then
       echo "$@" 1>&2
    fi

    echo "$(date "+%Y-%m-%d %H:%M:%S")" "$@" >> "${LOG_FILE}"
}

Warning()
{
   echo "Warning: $@" 1>&2
}

Panic()
{
   echo "Error: $@" 1>&2
   Log "CRITICAL installation aborted $@"
   exit 1
}

GetDefaultPermission()
{
   case "$(vmware -v)" in
      *3i*) echo "";;
      *ESXi*) echo ",01777";;
      *) Panic "Unknown platform";;
   esac
}

MountVisorfs()
{
   if [ ! -d "${2}" ]; then
      Log "INFO Creating upgrade cache directory"
      mkdir -p "${2}"
   else
      [ ! -z "${2}" ] && rm -rf "${2}"/*
   fi

   if $(mount | grep -q "${2}"); then
      Log "INFO ${RAMDISK_NAME} has been mounted..."
      return
   fi

   local permission=$(GetDefaultPermission)
   Log "INFO Mounting ${ramdisksize}MB ramdisk on ${2}"
   mount -t visorfs -o "${1},${1}${permission},${RAMDISK_NAME}" "${RAMDISK_NAME}" "${2}"  2>> ${LOG_FILE} || {
      Panic "Failed to mount visorfs with size ${ramdisksize}MB"
   }
}


if [ -z "${1}" ]; then
   Panic "Ramdisk size is not specified."
fi

# roundup requested size by 32MB, input is in byte
ramdisksize="$(((${1} + 32 * 1024 * 1024 - 1) / (32 * 1024 * 1024) * 32))"

MountVisorfs ${ramdisksize} ${UPGRADE_CACHE_DIR}
echo "${UPGRADE_CACHE_DIR}"
