/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.exception.ConnectionException;
import com.vmware.vim.vmomi.client.exception.SslException;
import com.vmware.vim.vmomi.client.exception.TransportProtocolException;
import com.vmware.vim.vmomi.client.exception.VmomiProtocolException;
import com.vmware.vim.vmomi.core.exception.CertificateValidationException;
import com.vmware.vim.vmomi.core.exception.DuplicateLinkKeyException;
import com.vmware.vim.vmomi.core.exception.InternalException;
import com.vmware.vim.vmomi.core.exception.LinkNotFoundException;
import com.vmware.vim.vmomi.core.exception.MarshallException;
import com.vmware.vim.vmomi.core.exception.MessageSignException;
import com.vmware.vim.vmomi.core.exception.UnexpectedTypeException;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.RejectedExecutionException;
import javax.net.ssl.SSLException;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.MalformedChunkCodingException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;

public class ClientExceptionTranslator {
    public static Exception translate(Exception e) {
        if (e.getClass().equals(InternalException.class)) {
            com.vmware.vim.vmomi.client.exception.InternalException clientInternalException = new com.vmware.vim.vmomi.client.exception.InternalException(e.getCause());
            clientInternalException.setStackTrace(e.getStackTrace());
            return clientInternalException;
        }
        if (e instanceof SSLException || e instanceof CertificateValidationException) {
            return ClientExceptionTranslator.fixStackTrace(new SslException(e));
        }
        if (e instanceof SocketException || e instanceof SocketTimeoutException || e instanceof ConnectionClosedException || e instanceof InterruptedIOException) {
            return ClientExceptionTranslator.fixStackTrace(new ConnectionException(e));
        }
        if (e instanceof MalformedChunkCodingException || e instanceof HttpException || e instanceof NoHttpResponseException || e instanceof ParseException || e instanceof ClientProtocolException) {
            return ClientExceptionTranslator.fixStackTrace(new TransportProtocolException(e));
        }
        if (e instanceof MarshallException || e instanceof UnmarshallException || e instanceof UnexpectedTypeException || e instanceof LinkNotFoundException || e instanceof DuplicateLinkKeyException) {
            return ClientExceptionTranslator.fixStackTrace(new VmomiProtocolException(e));
        }
        if (e instanceof RejectedExecutionException || e instanceof MessageSignException) {
            return ClientExceptionTranslator.fixStackTrace(new com.vmware.vim.vmomi.client.exception.InternalException(e));
        }
        return e;
    }

    private static Exception fixStackTrace(Exception e) {
        StackTraceElement[] stackTrace = e.getStackTrace();
        StackTraceElement[] newStackTrace = new StackTraceElement[stackTrace.length - 1];
        for (int i = 1; i < stackTrace.length; ++i) {
            newStackTrace[i - 1] = stackTrace[i];
        }
        e.setStackTrace(newStackTrace);
        return e;
    }
}

