/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.common.ProtocolBinding;
import com.vmware.vim.vmomi.client.exception.InternalException;
import com.vmware.vim.vmomi.client.http.HttpProtocolBinding;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationImpl;
import com.vmware.vim.vmomi.core.types.ManagedObjectFactory;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;

public class HttpClient
implements Client {
    private final HttpProtocolBinding _binding;
    private final ManagedObjectFactory _managedObjectFactory;
    private final VmodlVersion _version;

    HttpClient(VmodlVersion version, HttpProtocolBinding binding, ManagedObjectFactory factory) {
        this._binding = binding;
        ((HttpConfigurationImpl)this._binding.getConfiguration()).getCompiledConfiguration().reserve(this);
        this._version = version;
        this._managedObjectFactory = factory;
    }

    @Override
    public <T extends ManagedObject> T createStub(Class<T> clazz, ManagedObjectReference moRef) {
        try {
            return (T)((ManagedObject)clazz.cast(this._managedObjectFactory.createManagedObject(VmodlContext.getContext(), VmodlTypeMap.Factory.getTypeMap(), this._version, HttpClient.resolveMoRef(clazz, moRef))));
        }
        catch (InstantiationException e) {
            throw new InternalException(e);
        }
    }

    private static ManagedObjectReference resolveMoRef(Class<?> clazz, ManagedObjectReference moRef) {
        if (moRef.getType() != null) {
            return moRef;
        }
        ManagedObjectType moType = (ManagedObjectType)VmodlTypeMap.Factory.getTypeMap().getVmodlType(clazz);
        if (moType == null) {
            throw new IllegalArgumentException("No VMODL type registered for " + clazz);
        }
        ManagedObjectReference resolved = new ManagedObjectReference();
        resolved.setType(moType.getWsdlName());
        resolved.setValue(moRef.getValue());
        resolved.setServerGuid(moRef.getServerGuid());
        return resolved;
    }

    @Override
    public ProtocolBinding getBinding() {
        return this._binding;
    }

    @Override
    public void shutdown() {
        ((HttpConfigurationImpl)this._binding.getConfiguration()).getCompiledConfiguration().release(this);
    }

    public ManagedObjectFactory getManagedObjectFactory() {
        return this._managedObjectFactory;
    }
}

