/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.exception.InternalException;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.client.http.impl.CompiledHttpConfiguration;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationImpl;
import com.vmware.vim.vmomi.client.http.impl.KeyManagerWrapper;
import com.vmware.vim.vmomi.client.http.impl.ThumbprintTrustManager;
import com.vmware.vim.vmomi.core.util.FileUtil;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.apache.http.HttpHost;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class HttpConfigurationCompiler {
    private static final String AGENT = "VMware vim-java 1.0";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CompiledHttpConfiguration compile(HttpConfiguration config) {
        HttpConfiguration httpConfiguration = config;
        synchronized (httpConfiguration) {
            if (((HttpConfigurationImpl)config).getCompiledConfiguration() != null) {
                return ((HttpConfigurationImpl)config).getCompiledConfiguration();
            }
            CompiledHttpConfiguration result = null;
            BasicHttpParams params = this.createHttpParams(config);
            ClientConnectionManager connectionManager = this.createClientConnectionManager(config, params);
            result = new CompiledHttpConfiguration(connectionManager, (HttpParams)params, config.getCompressionSupport(), config.getKeepAlivePeriod());
            ((HttpConfigurationImpl)config).setCompiledConfiguration(result);
            return result;
        }
    }

    protected BasicHttpParams createHttpParams(HttpConfiguration config) {
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)false);
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)AGENT);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)config.getTimeoutMs());
        HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)config.getDisableNagle());
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)config.getCheckStaleConnection());
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)config.getMaxConnections());
        ConnPerRouteBean connPerRouteBean = new ConnPerRouteBean();
        connPerRouteBean.setDefaultMaxPerRoute(config.getDefaultMaxConnectionsPerRoute());
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)connPerRouteBean);
        if (config.getDefaultProxyHost() != null) {
            ConnRouteParams.setDefaultProxy((HttpParams)params, (HttpHost)new HttpHost(config.getDefaultProxyHost(), config.getDefaultProxyPort(), config.getDefaultProxyScheme()));
        }
        for (HttpConfiguration.RouteConfiguration route : config.getRouteConfigurations()) {
            HttpHost host = new HttpHost(route.getHostName(), route.getPort(), route.getScheme());
            HttpRoute httpRoute = new HttpRoute(host);
            connPerRouteBean.setMaxForRoute(httpRoute, route.getMaxConnections());
            ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)connPerRouteBean);
        }
        return params;
    }

    protected ClientConnectionManager createClientConnectionManager(HttpConfiguration config, BasicHttpParams params) {
        SSLSocketFactory factory = this.createSSLSocketFactory(config);
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        registry.register(new Scheme("https", (SocketFactory)factory, 443));
        return new ThreadSafeClientConnManager((HttpParams)params, registry);
    }

    protected SSLSocketFactory createSSLSocketFactory(HttpConfiguration config) {
        ThumbprintTrustManager trustManager = this.createThumbprintTrustManager(config);
        SSLContext sslContext = this.createSSLContext(config, trustManager);
        SSLSocketFactory factory = new SSLSocketFactory(sslContext);
        ThumbprintTrustManager.HostnameVerifier hostnameVerifier = new ThumbprintTrustManager.HostnameVerifier(trustManager);
        factory.setHostnameVerifier((X509HostnameVerifier)hostnameVerifier);
        return factory;
    }

    protected ThumbprintTrustManager createThumbprintTrustManager(HttpConfiguration config) {
        try {
            return new ThumbprintTrustManager(this.loadTrustStore(config), this.createThumbprintVerifier(config));
        }
        catch (KeyStoreException e) {
            throw new InternalException(e);
        }
    }

    protected ThumbprintVerifier createThumbprintVerifier(HttpConfiguration config) {
        return config.getThumbprintVerifier();
    }

    protected SSLContext createSSLContext(HttpConfiguration config, ThumbprintTrustManager trustManager) {
        SSLContext sslContext = null;
        KeyManager[] keyManagers = this.createKeyManagers(config);
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(keyManagers, new TrustManager[]{trustManager}, null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalException(e);
        }
        catch (KeyManagementException e) {
            throw new InternalException(e);
        }
        return sslContext;
    }

    protected KeyManager[] createKeyManagers(HttpConfiguration config) {
        String password = config.getKeyStoreConfig().getKeyPassword();
        String alias = config.getKeyStoreConfig().getKeyAlias();
        try {
            if (password != null && alias != null) {
                KeyStore store = this.loadKeyStore(config);
                KeyManagerFactory keyMngrFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyMngrFactory.init(store, password.toCharArray());
                KeyManager[] keyManagers = keyMngrFactory.getKeyManagers();
                for (int i = 0; i < keyManagers.length; ++i) {
                    if (!(keyManagers[i] instanceof X509KeyManager)) continue;
                    keyManagers[i] = new KeyManagerWrapper((X509KeyManager)keyManagers[i], alias);
                }
                return keyManagers;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    protected KeyStore loadTrustStore(HttpConfiguration config) {
        if (config.getTrustStore() != null) {
            return config.getTrustStore();
        }
        return this.createKeyStore(config.getKeyStoreConfig().getTrustStorePath(), config.getKeyStoreConfig().getTrustStorePassword(), "JKS");
    }

    protected KeyStore loadKeyStore(HttpConfiguration config) {
        if (config.getKeyStore() != null) {
            return config.getKeyStore();
        }
        return this.createKeyStore(config.getKeyStoreConfig().getKeyStorePath(), config.getKeyStoreConfig().getKeyStorePassword(), config.getKeyStoreConfig().getKeyStoreType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore createKeyStore(String path, String password, String type) {
        try {
            KeyStore keyStore = KeyStore.getInstance(type.toUpperCase());
            if (path != null && password != null) {
                ClassLoader loader = this.getClass().getClassLoader();
                InputStream stream = FileUtil.getInputStream((String)path, (ClassLoader)loader);
                try {
                    keyStore.load(stream, password.toCharArray());
                }
                finally {
                    stream.close();
                }
            } else {
                keyStore.load(null);
            }
            return keyStore;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create default client trust/key store", e);
        }
    }
}

