/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;

public class KeyManagerWrapper
implements X509KeyManager {
    private X509KeyManager _baseKM = null;
    private String _alias = null;

    public KeyManagerWrapper(X509KeyManager baseKM, String alias) {
        this._baseKM = baseKM;
        this._alias = alias;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        if (null == this._alias) {
            return this._baseKM.chooseClientAlias(keyType, issuers, socket);
        }
        boolean aliasFound = false;
        for (int i = 0; i < keyType.length && !aliasFound; ++i) {
            String[] validAliases = this._baseKM.getClientAliases(keyType[i], issuers);
            if (validAliases == null) continue;
            for (int j = 0; j < validAliases.length && !aliasFound; ++j) {
                if (!validAliases[j].equals(this._alias)) continue;
                aliasFound = true;
            }
        }
        if (aliasFound) {
            return this._alias;
        }
        return null;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this._baseKM.chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this._baseKM.getCertificateChain(alias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this._baseKM.getClientAliases(keyType, issuers);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this._baseKM.getPrivateKey(alias);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this._baseKM.getServerAliases(keyType, issuers);
    }
}

