/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.cfg.components.impl;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinCrypt;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.win32.W32APIOptions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemTrustStoreWin32
implements Provider<KeyStore> {
    private static final String ERROR_KEYSTORE_CREATE = "Internal error: cannot create in-memroy key store. Possibly incompatible Java platform.";
    private static final String ERROR_KEYSTORE_OP = "Internal error during operation with in-memory key store.";
    private static final String ERROR_NO_X509_FACTORY = "Internal error: X.509 certificate factory not available. Possibly incompatible Java runtime.";
    private static final String ERROR_NO_BC = "Internal error / bug: BC provider not installed.";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public KeyStore get() {
        KeyStore store = this.createInMemoryKs();
        CertificateFactory cf = this.getX509Factory();
        CertStoreApi api = (CertStoreApi)Native.loadLibrary((String)"Crypt32", CertStoreApi.class, (Map)W32APIOptions.UNICODE_OPTIONS);
        WinNT.HANDLE winStore = api.CertOpenSystemStore(null, "ROOT");
        SystemTrustStoreWin32.osCheck("CertOpenSystemStore", winStore != null);
        try {
            PCERT_CONTEXT certCtx = null;
            while ((certCtx = api.CertEnumCertificatesInStore(winStore, certCtx)) != null) {
                Collection<? extends Certificate> certs;
                byte[] certBytes = certCtx.pbCertEncoded.getByteArray(0L, certCtx.cbCertEncoded.intValue());
                try {
                    certs = cf.generateCertificates(new ByteArrayInputStream(certBytes));
                }
                catch (CertificateException e) {
                    this.log.debug("Error decoding Windows trust store entry: {}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
                    continue;
                }
                if (certs == null) continue;
                for (X509Certificate x509Certificate : certs) {
                    this.log.debug("Adding Windows ROOT certificate to trust store: {}", (Object)x509Certificate.getSubjectX500Principal());
                    store.setCertificateEntry(x509Certificate.getSubjectX500Principal().toString(), x509Certificate);
                }
            }
        }
        catch (KeyStoreException e) {
            this.log.error(ERROR_KEYSTORE_OP, (Throwable)e);
            throw new IllegalStateException(ERROR_KEYSTORE_OP, e);
        }
        finally {
            SystemTrustStoreWin32.osCheck("CertCloseStore", api.CertCloseStore(winStore, 0L));
        }
        return store;
    }

    private static void osCheck(String call, boolean successfull) {
        if (!successfull) {
            throw new IllegalStateException(String.format("%s error: %s", call, Kernel32Util.formatMessageFromLastErrorCode((int)Kernel32.INSTANCE.GetLastError())));
        }
    }

    private KeyStore createInMemoryKs() {
        try {
            KeyStore store = KeyStore.getInstance("JKS");
            store.load(null, null);
            return store;
        }
        catch (GeneralSecurityException e) {
            this.log.error(ERROR_KEYSTORE_CREATE, (Throwable)e);
            throw new IllegalStateException(ERROR_KEYSTORE_CREATE, e);
        }
        catch (IOException e) {
            this.log.error(ERROR_KEYSTORE_CREATE, (Throwable)e);
            throw new IllegalStateException(ERROR_KEYSTORE_CREATE, e);
        }
    }

    private CertificateFactory getX509Factory() {
        try {
            return CertificateFactory.getInstance("X.509", "BC");
        }
        catch (CertificateException e) {
            this.log.error(ERROR_NO_X509_FACTORY, (Throwable)e);
            throw new IllegalStateException(ERROR_NO_X509_FACTORY, e);
        }
        catch (NoSuchProviderException e) {
            this.log.error(ERROR_NO_BC, (Throwable)e);
            throw new IllegalStateException(ERROR_NO_BC, e);
        }
    }

    public static interface CertStoreApi
    extends WinNT,
    WinCrypt {
        public WinNT.HANDLE CertOpenStore(String var1, long var2, WinNT.HANDLE var4, long var5, Pointer var7);

        public WinNT.HANDLE CertOpenSystemStore(WinNT.HANDLE var1, String var2);

        public boolean CertCloseStore(WinNT.HANDLE var1, long var2);

        public PCERT_CONTEXT CertEnumCertificatesInStore(WinNT.HANDLE var1, PCERT_CONTEXT var2);
    }

    public static class PCERT_CONTEXT
    extends CERT_CONTEXT
    implements Structure.ByReference {
    }

    public static class CERT_CONTEXT
    extends Structure {
        public WinDef.DWORD dwCertEncodingType;
        public Pointer pbCertEncoded;
        public WinDef.DWORD cbCertEncoded;
        public PCERT_INFO pCertInfo;
        public WinNT.HANDLE hCertStore;

        protected List<String> getFieldOrder() {
            return Arrays.asList("dwCertEncodingType", "pbCertEncoded", "cbCertEncoded", "pCertInfo", "hCertStore");
        }
    }

    public static class PCERT_INFO
    extends CERT_INFO
    implements Structure.ByReference {
    }

    public static class CERT_INFO
    extends Structure {
        public WinDef.DWORD dwVersion;
        public WinCrypt.DATA_BLOB SerialNumber;
        public Pointer SignatureAlgorithm;
        public WinCrypt.DATA_BLOB Issuer;
        public WinBase.FILETIME NotBefore;
        public WinBase.FILETIME NotAfter;
        public WinCrypt.DATA_BLOB Subject;
        public Pointer SubjectPublicKeyInfo;
        public WinCrypt.DATA_BLOB IssuerUniqueId;
        public WinCrypt.DATA_BLOB SubjectUniqueId;
        public WinDef.DWORD cExtension;
        public Pointer rgExtension;

        protected List<String> getFieldOrder() {
            return Arrays.asList("dwVersion", "SerialNumber", "SignatureAlgorithm", "Issuer", "NotBefore", "NotAfter", "Subject", "SubjectPublicKeyInfo", "IssuerUniqueId", "SubjectUniqueId", "cExtension", "rgExtension");
        }
    }
}

