/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.serialize.impl;

import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.impl.XMLFactories;
import com.vmware.vim.vmomi.core.serialize.XmlObjectInput;
import com.vmware.vim.vmomi.core.soap.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmlObjectInputStream
extends ObjectInputStream
implements XmlObjectInput {
    private Unmarshaller _unmarshaller;
    private XMLInputFactory _inFactory;
    private XmlByteArrayInputStream _is;

    public XmlObjectInputStream(InputStream in, Unmarshaller u) throws IOException, XMLStreamException {
        super(in);
        this._unmarshaller = u;
        this._inFactory = XMLFactories.getInputFactory();
        this._is = new XmlByteArrayInputStream();
    }

    @Override
    public Object unmarshal() {
        try {
            int len = this.readInt();
            byte[] buf = this._is.getBuffer();
            if (null == buf || buf.length < len) {
                buf = new byte[len];
                this._is.setBuffer(buf);
            }
            this.read(buf, 0, len);
            XMLStreamReader reader = this._inFactory.createXMLStreamReader(this._is, "utf-8");
            reader.nextTag();
            reader.nextTag();
            Object ret = this._unmarshaller.unmarshal(null, reader);
            this._is.reset();
            return ret;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        catch (UnmarshallException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class XmlByteArrayInputStream
    extends InputStream {
        private int _pos;
        private byte[] _buf;
        private int _midLen;
        private int _totalLen;
        private static byte[] _prefix = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<soapenv:Envelope xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\"\n xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"\n xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n".getBytes();
        private static byte[] _suffix = "</soapenv:Envelope>".getBytes();

        XmlByteArrayInputStream() {
        }

        public byte[] getBuffer() {
            return this._buf;
        }

        public void setBuffer(byte[] buf) {
            this._buf = buf;
            this._midLen = _prefix.length + this._buf.length;
            this._totalLen = _prefix.length + this._buf.length + _suffix.length;
        }

        @Override
        public void reset() {
            this._pos = 0;
        }

        @Override
        public int read() throws IOException {
            if (this._pos < _prefix.length) {
                return _prefix[this._pos++] & 0xFF;
            }
            if (this._pos < this._midLen) {
                return this._buf[this._pos++ - _prefix.length] & 0xFF;
            }
            if (this._pos < this._totalLen) {
                return _suffix[this._pos++ - this._midLen] & 0xFF;
            }
            return -1;
        }
    }
}

