/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.soap.impl.unmarshaller;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.vmomi.core.exception.UnexpectedTypeException;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.soap.Constants;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.impl.VmomiServiceImpl;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class StackContext {
    private VmodlField _field;
    private VmodlType _type;
    private StackContext _parent;
    private static Log _logger = LogFactory.getLog(StackContext.class);
    protected static final QName HREF = new QName("http://www.w3.org/1999/xlink", "href");

    public StackContext(VmodlField field, VmodlType type, StackContext parent) {
        this._field = field;
        this._type = type;
        this._parent = parent;
    }

    public abstract void setValue(Object var1) throws UnmarshallException;

    public abstract void setChildValue(VmodlField var1, Object var2) throws UnmarshallException;

    public abstract Object getValue();

    public abstract void close() throws UnmarshallException;

    public abstract StackContext getNestedContext(QName var1, Map<QName, String> var2, NamespaceContext var3) throws UnmarshallException;

    public VmodlField getField() {
        return this._field;
    }

    public VmodlType getType() {
        return this._type;
    }

    public StackContext getParentContext() {
        return this._parent;
    }

    public static VmodlType getType(VmodlField field, Map<QName, String> attrs, boolean resolveMoType, boolean qsFormat, NamespaceContext namespaces) throws UnmarshallException {
        String typeName = attrs.get(Constants.XSI_TYPE_QNAME);
        VmodlTypeMap typemap = VmodlTypeMap.Factory.getTypeMap();
        VmodlType type = null;
        String namespaceURI = null;
        if (typeName != null) {
            if (typeName.contains(":")) {
                String[] split = typeName.split(":");
                namespaceURI = namespaces.getNamespaceURI(split[0]);
                if ("".equals(split[0])) {
                    throw new UnmarshallException("Empty namespace prefix used for type - \"" + typeName + "\"");
                }
                if (namespaceURI == null && _logger.isErrorEnabled()) {
                    _logger.error((Object)("Missing namespace definition detected for namespace prefix " + split[0]));
                }
                typeName = split[1];
            }
            if (namespaceURI != null) {
                if (qsFormat && "urn:vmware:queryservice".equals(namespaceURI)) {
                    if (typeName.equals("ManagedObjectLink")) {
                        type = typemap.getVmodlType("ManagedObjectReference");
                    } else if (typeName.equals("Link")) {
                        type = typemap.getVmodlType("anyURI");
                    }
                } else if (!"http://www.w3.org/2001/XMLSchema".equals(namespaceURI)) {
                    if (!namespaceURI.startsWith("urn:")) {
                        throw new IllegalArgumentException("Invalid namespace definition found in the parsed XML: " + namespaceURI);
                    }
                    String namespace = namespaceURI.substring("urn:".length());
                    VmomiServiceImpl svc = new VmomiServiceImpl("", namespace);
                    type = typemap.getVmodlType(typeName, svc);
                }
            }
            if (type == null) {
                type = typemap.getVmodlType(typeName);
            }
        } else if (field != null) {
            typeName = field.getName();
            type = field.getType();
        }
        if (type == null) {
            throw new UnexpectedTypeException(typeName);
        }
        if (resolveMoType && type.getKind() == VmodlType.Kind.MOREF) {
            type = typemap.getVmodlType(ManagedObject.class);
        }
        return type;
    }
}

