/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.types.impl;

import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.vmomi.core.soap.Marshaller;
import com.vmware.vim.vmomi.core.soap.Unmarshaller;
import com.vmware.vim.vmomi.core.soap.impl.marshaller.MarshallerImpl;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.UnmarshallerImpl;
import com.vmware.vim.vmomi.core.types.DataObjectFactory;
import com.vmware.vim.vmomi.core.types.ManagedObjectFactory;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.impl.DefaultDataObjectFactory;
import com.vmware.vim.vmomi.core.types.impl.VmodlArrayTypeImpl;
import com.vmware.vim.vmomi.core.types.impl.VmodlContextLoader;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class VmodlContextImpl
extends VmodlContext {
    private static final String CONTEXT_FILE = "/context.xml";
    private static final String CONTEXT_BEAN_NAME = "context";
    private static final String CORE_VMODL_PACKAGE = "com.vmware.vim.binding.vmodl";
    private static final String QUERY_VMODL_PACKAGE = "com.vmware.vim.binding.vmodl.query";
    private final Map<Class<?>, Boolean> _resolveMoType = new ConcurrentHashMap();
    private DataObjectFactory _requestDataObjectFactory = new DefaultDataObjectFactory();
    private DataObjectFactory _responseDataObjectFactory = new DefaultDataObjectFactory();
    private static final Log _logger = LogFactory.getLog(VmodlContextImpl.class);
    private boolean _initializing = false;

    public VmodlContextImpl() {
        this.loadVmodlPackage(CORE_VMODL_PACKAGE);
        if (Thread.currentThread().getContextClassLoader().getResource(this.getContextFileNameForPackage(QUERY_VMODL_PACKAGE)) != null) {
            this.loadVmodlPackage(QUERY_VMODL_PACKAGE);
        }
        VmodlTypeMap typeMap = VmodlTypeMap.Factory.getTypeMap();
        VmodlType methodFaultType = typeMap.getVmodlType(MethodFault.class);
        VmodlType methodFaultArrType = typeMap.getVmodlType("ArrayOfMethodFault");
        ((VmodlArrayTypeImpl)methodFaultArrType).setItemType(Exception.class);
        typeMap.registerType(Exception.class, methodFaultType);
        typeMap.registerType(Array.newInstance(Exception.class, 0).getClass(), methodFaultArrType);
        typeMap.registerType("LocalizedMethodFault", methodFaultType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadVmodlPackages(String[] vmodlPackages) {
        this._initializing = true;
        try {
            for (String pack : vmodlPackages) {
                this.loadVmodlPackage(pack);
            }
        }
        finally {
            this._initializing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadVmodlPackage(String vmodlPackage) {
        String contextPath = this.getContextFileNameForPackage(vmodlPackage);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Loading vmodl context " + vmodlPackage + " from " + this.getClass().getClassLoader().getResource(contextPath)));
        }
        NonValidatingClassPathXmlApplicationContext ctx = new NonValidatingClassPathXmlApplicationContext(contextPath);
        try {
            this.doLoadVmodlPackage((VmodlContextLoader)ctx.getBean(CONTEXT_BEAN_NAME), vmodlPackage);
        }
        finally {
            ctx.close();
        }
    }

    private void doLoadVmodlPackage(VmodlContextLoader loader, String vmodlPackage) {
        loader.load();
        boolean resolveMoType = loader.isHideMoRef();
        if (resolveMoType && _logger.isInfoEnabled()) {
            _logger.info((Object)String.format("Managed object reference hiding enabled by '%s'", vmodlPackage));
        }
        for (Class<?> version : loader.getVmodlVersionContext()) {
            this._resolveMoType.put(version, resolveMoType);
        }
    }

    public boolean isResolveMoType(Class<?> version) {
        Boolean res = this._resolveMoType.get(version);
        if (res == null) {
            throw new IllegalArgumentException("Unknown version " + version);
        }
        return res;
    }

    public boolean isResolveMoType(VmodlVersion version) {
        return this.isResolveMoType(version.getVersionClass());
    }

    @Override
    public Marshaller createMarshaller(VmodlVersion version) {
        return new MarshallerImpl(version, false);
    }

    @Override
    public Marshaller createQSMarshaller(VmodlVersion version) {
        return new MarshallerImpl(version, true);
    }

    @Override
    public Unmarshaller createRequestUnmarshaller(VmodlVersion version) {
        return new UnmarshallerImpl(this, version, this._requestDataObjectFactory, this.isResolveMoType(version), null, false);
    }

    @Override
    public Unmarshaller createResponseUnmarshaller(VmodlVersion version) {
        return this.createResponseUnmarshaller(version, null);
    }

    @Override
    public Unmarshaller createResponseUnmarshaller(VmodlVersion version, ManagedObjectFactory managedObjectFactory) {
        if (managedObjectFactory == null && this.isResolveMoType(version)) {
            throw new IllegalArgumentException("ManagedObjectFactory is required to unmarshall response for bindings emitted with hide-mo-ref=true");
        }
        return new UnmarshallerImpl(this, version, this._responseDataObjectFactory, this.isResolveMoType(version), managedObjectFactory, false);
    }

    @Override
    public Unmarshaller createQSResponseUnmarshaller(VmodlVersion version, ManagedObjectFactory managedObjectFactory) {
        if (managedObjectFactory == null && this.isResolveMoType(version)) {
            throw new IllegalArgumentException("ManagedObjectFactory is required to unmarshall response for bindings emitted with hide-mo-ref=true");
        }
        return new UnmarshallerImpl(this, version, this._responseDataObjectFactory, this.isResolveMoType(version), managedObjectFactory, true);
    }

    @Override
    public void setRequestDataObjectFactory(DataObjectFactory factory) {
        this._requestDataObjectFactory = factory;
    }

    @Override
    public DataObjectFactory getRequestDataObjectFactory() {
        return this._requestDataObjectFactory;
    }

    @Override
    public void setResponseDataObjectFactory(DataObjectFactory factory) {
        this._responseDataObjectFactory = factory;
    }

    @Override
    public DataObjectFactory getResponseDataObjectFactory() {
        return this._responseDataObjectFactory;
    }

    private String getContextFileNameForPackage(String packageName) {
        return packageName.replace('.', '/') + CONTEXT_FILE;
    }

    boolean isInitializing() {
        return this._initializing;
    }

    private class NonValidatingClassPathXmlApplicationContext
    extends ClassPathXmlApplicationContext {
        NonValidatingClassPathXmlApplicationContext(String contextPath) {
            super(contextPath);
        }

        protected void initBeanDefinitionReader(XmlBeanDefinitionReader beanDefinitionReader) {
            super.initBeanDefinitionReader(beanDefinitionReader);
            beanDefinitionReader.setValidationMode(0);
        }
    }
}

