/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.util;

import java.util.HashSet;
import java.util.Set;

public class EscapeCharactersUtil {
    private static final Set<Character> ESCAPED_CHARS;

    private EscapeCharactersUtil() {
    }

    public static String unescapeHex(String input) {
        StringBuilder unescaped = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            int ch = input.charAt(i);
            if (ch == 37 && i + 2 < input.length() && EscapeCharactersUtil.isHexDigit(input.charAt(i + 1)) && EscapeCharactersUtil.isHexDigit(input.charAt(i + 2))) {
                ch = (char)(EscapeCharactersUtil.hex2Num(input.charAt(i + 1)) << 4 | EscapeCharactersUtil.hex2Num(input.charAt(i + 2)));
                if (ESCAPED_CHARS.contains(Character.valueOf((char)ch))) {
                    i += 2;
                } else {
                    ch = 37;
                }
            }
            unescaped.append((char)ch);
        }
        return unescaped.toString();
    }

    public static String escapeHex(String input) {
        StringBuilder escaped = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ESCAPED_CHARS.contains(Character.valueOf(ch))) {
                escaped.append('%').append(Integer.toString(ch, 16));
                continue;
            }
            escaped.append(ch);
        }
        return escaped.toString();
    }

    private static boolean isHexDigit(char ch) {
        return Character.digit(ch, 16) > -1;
    }

    private static int hex2Num(char ch) {
        return Character.digit(ch, 16);
    }

    static {
        char[] charsToEscape = new char[]{'%', '/', '\\', '-', '.', '\"'};
        ESCAPED_CHARS = new HashSet<Character>();
        for (char ch : charsToEscape) {
            ESCAPED_CHARS.add(Character.valueOf(ch));
        }
    }
}

