/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.util;

import com.vmware.vim.vmomi.core.exception.InternalException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLPrettyPrinterFactory {
    private XMLPrettyPrinterFactory() {
    }

    public static XMLStreamWriter createXMLStreamWriter(XMLStreamWriter delegate, String indent, String newLine) {
        try {
            return (XMLStreamWriter)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{XMLStreamWriter.class}, (InvocationHandler)new PrettyPrintHandler(delegate, indent, newLine));
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    private static class PrettyPrintHandler
    implements InvocationHandler {
        private final XMLStreamWriter _delegate;
        private final String _indent;
        private final String _newLine;
        private final Map<Integer, Boolean> _indentOnExit = new HashMap<Integer, Boolean>();
        private int _depth;

        private PrettyPrintHandler(XMLStreamWriter delegate, String indent, String newLine) {
            this._delegate = delegate;
            this._indent = indent;
            this._newLine = newLine;
            this._depth = 0;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name2 = method.getName();
            if ("writeStartElement".equals(name2)) {
                if (this._depth > 0) {
                    this._indentOnExit.put(this._depth - 1, true);
                }
                this._indentOnExit.put(this._depth, false);
                this.printIndent();
                ++this._depth;
            } else if ("writeEmptyElement".equals(name2)) {
                if (this._depth > 0) {
                    this._indentOnExit.put(this._depth - 1, true);
                }
                this.printIndent();
            } else if ("writeEndElement".equals(name2)) {
                --this._depth;
                if (this._indentOnExit.get(this._depth).booleanValue()) {
                    this.printIndent();
                }
            }
            return method.invoke((Object)this._delegate, args);
        }

        private void printIndent() throws XMLStreamException {
            this._delegate.writeCharacters(this._newLine);
            this._delegate.writeCharacters(PrettyPrintHandler.repeat(this._depth, this._indent));
        }

        private static String repeat(int num, String str) {
            StringBuilder res = new StringBuilder();
            while (num-- > 0) {
                res.append(str);
            }
            return res.toString();
        }
    }
}

