/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.SessionManager;
import com.vmware.vim.binding.sso.fault.ServiceFault;
import com.vmware.vim.sso.AboutInfo;
import com.vmware.vim.sso.admin.client.ClientConfiguration;
import com.vmware.vim.sso.admin.client.vmomi.impl.VmomiClientCommand;
import com.vmware.vim.sso.admin.exception.SystemException;
import com.vmware.vim.sso.admin.impl.util.VmodlTypeConversions;
import com.vmware.vim.sso.admin.util.LocalAboutInfoAccess;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.security.SignInfo;
import com.vmware.vim.vmomi.core.security.impl.SignInfoImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class AbstractClient {
    private static final String WANRING_MESSAGE_HEADER = "******* WANRING ****** WANRING ****** WARNING *******";
    private static final String LOGOUT_ERROR_MSG = "Client was unable to logout from the server";
    private static final String DISPOSE_SUCCESS_MSG = "Client was disposed successfully";
    private final Log _log = LogFactory.getLog(AbstractClient.class);
    private AboutInfo _aboutInfo;
    private boolean _isAuthenticated = false;

    AbstractClient() {
    }

    public final AboutInfo getAboutInfo() {
        return this._aboutInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        try {
            this.logout();
        }
        catch (SystemException e) {
            this._log.warn((Object)LOGOUT_ERROR_MSG, (Throwable)e);
        }
        finally {
            this.shutdownClient();
        }
        this._log.info((Object)DISPOSE_SUCCESS_MSG);
    }

    protected abstract void shutdownClient();

    protected abstract SessionManager getSessionManager();

    protected final void login(ClientConfiguration.AuthenticationData authData) throws SystemException {
        assert (authData != null);
        SignInfoImpl signInfo = new SignInfoImpl(authData.getHokKey(), authData.getAuthToken());
        RequestContextImpl signedContext = new RequestContextImpl();
        signedContext.setSignInfo((SignInfo)signInfo);
        final SessionManager sessionManager = this.getSessionManager();
        ((Stub)sessionManager)._setRequestContext((RequestContext)signedContext);
        new VmomiClientCommand<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void actionCommand() throws ServiceFault, SystemException {
                try {
                    sessionManager.login();
                }
                finally {
                    ((Stub)sessionManager)._setRequestContext(null);
                }
                return null;
            }
        }.executeEnsuringNoDomainError();
        this._isAuthenticated = true;
    }

    protected final void logout() throws SystemException {
        if (this._isAuthenticated) {
            new VmomiClientCommand<Void>(){

                @Override
                public Void actionCommand() throws ServiceFault, SystemException {
                    AbstractClient.this.getSessionManager().logout();
                    return null;
                }
            }.executeEnsuringNoDomainError();
        }
    }

    protected final void populateAboutInfo(com.vmware.vim.binding.sso.AboutInfo aboutInfoDto) {
        this._aboutInfo = VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.AboutInfo)aboutInfoDto);
        this.checkApiRevision(this._aboutInfo.getApiRevision());
    }

    private void checkApiRevision(String remoteApiRevision) {
        if (!LocalAboutInfoAccess.LOCAL_ABOUT_INFO.getApiRevision().equals(remoteApiRevision)) {
            this._log.warn((Object)WANRING_MESSAGE_HEADER);
            this._log.warn((Object)"Possible remote API mismatch detected. Operation will continue, but errors are likely.");
            this._log.warn((Object)WANRING_MESSAGE_HEADER);
        }
    }
}

