/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client;

import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SamlTokenFactory;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.sso.client.impl.SamlTokenImpl;
import com.vmware.vim.sso.client.impl.X509TrustChainKeySelector;
import java.security.cert.X509Certificate;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.crypto.KeySelector;
import org.w3c.dom.Element;

public final class DefaultTokenFactory
implements SamlTokenFactory {
    private static final long DEFAULT_TOKEN_CLOCK_TOLERANCE = 0L;
    private static final String ASSERTION_JAXB_PACKAGE = "oasis.names.tc.saml._2_0.assertion";
    private final JAXBContext _jaxbContext = DefaultTokenFactory.createJaxbContext();

    @Override
    public SamlToken parseToken(Element tokenRoot, X509Certificate[] trustedRootCertificates, long clockToleranceSec) throws InvalidTokenException {
        return new SamlTokenImpl(tokenRoot, (KeySelector)new X509TrustChainKeySelector(trustedRootCertificates), clockToleranceSec, this._jaxbContext);
    }

    @Override
    public SamlToken parseToken(String tokenXml, X509Certificate[] trustedRootCertificates, long clockToleranceSec) throws InvalidTokenException {
        return new SamlTokenImpl(tokenXml, (KeySelector)new X509TrustChainKeySelector(trustedRootCertificates), clockToleranceSec, this._jaxbContext);
    }

    @Override
    public SamlToken parseToken(String tokenXml, X509Certificate ... trustedRootCertificates) throws InvalidTokenException {
        return this.parseToken(tokenXml, trustedRootCertificates, 0L);
    }

    @Override
    public SamlToken parseToken(Element tokenRoot, X509Certificate ... trustedRootCertificates) throws InvalidTokenException {
        return this.parseToken(tokenRoot, trustedRootCertificates, 0L);
    }

    public static SamlToken createToken(String tokenXml, X509Certificate[] trustedRootCertificates, long clockToleranceSec) throws InvalidTokenException {
        return new SamlTokenImpl(tokenXml, (KeySelector)new X509TrustChainKeySelector(trustedRootCertificates), clockToleranceSec, DefaultTokenFactory.createJaxbContext());
    }

    public static SamlToken createToken(String tokenXml, X509Certificate ... trustedRootCertificates) throws InvalidTokenException {
        return DefaultTokenFactory.createToken(tokenXml, trustedRootCertificates, 0L);
    }

    public static SamlToken createTokenFromDom(Element tokenRoot, X509Certificate[] trustedRootCertificates, long clockToleranceSec) throws InvalidTokenException {
        return new SamlTokenImpl(tokenRoot, (KeySelector)new X509TrustChainKeySelector(trustedRootCertificates), clockToleranceSec, DefaultTokenFactory.createJaxbContext());
    }

    public static SamlToken createTokenFromDom(Element tokenRoot, X509Certificate ... trustedRootCertificates) throws InvalidTokenException {
        return DefaultTokenFactory.createTokenFromDom(tokenRoot, trustedRootCertificates, 0L);
    }

    private static JAXBContext createJaxbContext() {
        try {
            return JAXBContext.newInstance((String)ASSERTION_JAXB_PACKAGE);
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Cannot initialize JAXBContext.", e);
        }
    }
}

