/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl;

import com.rsa.names._2009._12.std_ext.saml2.RSAAdviceType;
import com.rsa.names._2009._12.std_ext.saml2.RenewRestrictionType;
import com.rsa.names._2010._04.std_prof.saml2.AttributeNames;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.client.Advice;
import com.vmware.vim.sso.client.ConfirmationType;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.XmlParserFactory;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.sso.client.impl.PrincipalIdParser;
import com.vmware.vim.sso.client.impl.Util;
import com.vmware.vim.sso.client.impl.ValidateUtil;
import com.vmware.vim.sso.client.impl.exception.ParserException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import oasis.names.tc.saml._2_0.assertion.AdviceType;
import oasis.names.tc.saml._2_0.assertion.AssertionType;
import oasis.names.tc.saml._2_0.assertion.AttributeStatementType;
import oasis.names.tc.saml._2_0.assertion.AttributeType;
import oasis.names.tc.saml._2_0.assertion.AudienceRestrictionType;
import oasis.names.tc.saml._2_0.assertion.AuthnStatementType;
import oasis.names.tc.saml._2_0.assertion.ConditionAbstractType;
import oasis.names.tc.saml._2_0.assertion.ConditionsType;
import oasis.names.tc.saml._2_0.assertion.KeyInfoConfirmationDataType;
import oasis.names.tc.saml._2_0.assertion.NameIDType;
import oasis.names.tc.saml._2_0.assertion.ProxyRestrictionType;
import oasis.names.tc.saml._2_0.assertion.SubjectConfirmationDataType;
import oasis.names.tc.saml._2_0.assertion.SubjectConfirmationType;
import oasis.names.tc.saml._2_0.assertion.SubjectType;
import oasis.names.tc.saml._2_0.conditions.delegation.DelegateType;
import oasis.names.tc.saml._2_0.conditions.delegation.DelegationRestrictionType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3._2000._09.xmldsig_.KeyInfoType;
import org.w3._2000._09.xmldsig_.X509DataType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SamlTokenImpl
implements SamlToken {
    private long _startTime;
    private long _expirationTime;
    private boolean _isRenewable;
    private boolean _isDelegable;
    private ConfirmationType _confirmationType;
    private PrincipalId _subject;
    private final Document _parsedToken;
    private long _issueInstant;
    private String _id;
    private List<SamlToken.TokenDelegate> _delegationChain = Collections.emptyList();
    private Set<String> _audienceRestrictionList = Collections.emptySet();
    private X509Certificate _confirmationCertificate;
    private List<Advice> _advice = Collections.emptyList();
    private List<PrincipalId> _groups = Collections.emptyList();
    private boolean _isSolution;
    private static final Schema SAML_SCHEMA = SamlTokenImpl.loadSamlSchema();
    private static final String ATTRIBUTE_FORMAT_URI = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";
    private static final String SAML_SCHEMA_FILENAME = "profiled-saml-schema-assertion-2.0.xsd";
    private static final String DEFAULT_TIME_ZONE = "GMT";
    private static final String BEARER_CONFIRMATION = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
    private static final String HOLDER_OF_KEY_CONFIRMATION = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
    private static final String XMLNS_NS_URI = "http://www.w3.org/2000/xmlns/";
    private static final String SIGNATURE_ELEMENT_NAME = "Signature";
    private static final String SIGNATURE_VALIDATION_ERROR_MSG = "Signature validation failed";
    private static final String PARSING_TOKEN_ERROR_MSG = "Error parsing SAML token.";
    private static final String PARSE_DELEGATION_ERR_MSG = "Cannot parse delegation restrictions.";
    private static final String X509_CERT_FACTORY_TYPE = "X.509";
    private static final String CERTIFICATE_PARSE_ERR_MSG = "Cannot parse user's confirmation certificate";
    private static final String SUBJ_CONF_DATA_NOT_FOUNT_MSG = "Cannot find subject confirmation data";
    private static final String SUBJ_CONF_DATA_WRONG_TYPE_MSG = "SubjectConfirmationData is not instance of KeyInfoConfirmationData type which is necessary for this kind of tokens (HOK).";
    private static final String ERR_LOADNIG_SAML_SCHEMA = "An error occured while loading SAML schema.";
    private static final String PARSE_GROUPS_ERR_MSG = "Cannot parse group information";
    private static final String PARSE_ISSOLUTION_ERR_MSG = "Value for attribute isSolution is not valid.";
    private static final String UNSPECIFIED_FORMAT_URI = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
    private static final String NAME_QUALIFIER_LOCAL = "local";
    private static final String UPN_FORMAT_URI = "http://schemas.xmlsoap.org/claims/UPN";
    private static final long MILLISECONDS_PER_SECOND = 1000L;
    private static final XmlParserFactory xmlParserFactory = XmlParserFactory.Factory.createSecureXmlParserFactory();
    private final Log _log = LogFactory.getLog(SamlTokenImpl.class);
    private final JAXBContext _jaxbContext;

    private SamlTokenImpl(String sourceType, Document tokenDoc, KeySelector signKeySelector, long clockToleranceSec, JAXBContext jaxbContext) throws InvalidTokenException {
        ValidateUtil.validateNotNull(tokenDoc, "token " + sourceType);
        ValidateUtil.validateNotNull(signKeySelector, "signKeySelector");
        ValidateUtil.validateNotNull(jaxbContext, "JAXBContext");
        this._jaxbContext = jaxbContext;
        this._parsedToken = tokenDoc;
        this.validateAndPopulate(signKeySelector, clockToleranceSec);
        this._log.info((Object)("SAML token for subject " + this.getSubject() + " successfully parsed from " + sourceType));
        this._log.debug((Object)("Token details: " + Util.createRedactedDescription(this)));
    }

    public SamlTokenImpl(String xml, KeySelector signKeySelector, long clockToleranceSec, JAXBContext jaxbContext) throws InvalidTokenException {
        this("XML", SamlTokenImpl.parseTokenXmlToDom(xml), signKeySelector, clockToleranceSec, jaxbContext);
    }

    public SamlTokenImpl(Element tokenRoot, KeySelector signKeySelector, long clockToleranceSec, JAXBContext jaxbContext) throws InvalidTokenException {
        this("Element", SamlTokenImpl.createStandaloneCopy(tokenRoot), signKeySelector, clockToleranceSec, jaxbContext);
    }

    @Override
    public Date getStartTime() {
        return new Date(this._startTime);
    }

    @Override
    public Date getExpirationTime() {
        return new Date(this._expirationTime);
    }

    @Override
    public boolean isRenewable() {
        return this._isRenewable;
    }

    @Override
    public boolean isDelegable() {
        return this._isDelegable;
    }

    @Override
    public ConfirmationType getConfirmationType() {
        return this._confirmationType;
    }

    @Override
    public String toXml() {
        try {
            return Util.serializeToString(this._parsedToken.getDocumentElement());
        }
        catch (ParserException e) {
            throw new IllegalStateException(e);
        }
    }

    public void export(Result destination) {
        Transformer xfrm;
        TransformerFactory xfrmFactory = TransformerFactory.newInstance();
        try {
            xfrm = xfrmFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException("Failed to create XML identity transformer (incompliant Java implementation?)", e);
        }
        try {
            xfrm.transform(new DOMSource(this._parsedToken), destination);
        }
        catch (TransformerException e) {
            throw new IllegalArgumentException("Exporting SAML XML failed with the supplied destination", e);
        }
    }

    @Override
    public PrincipalId getSubject() {
        return this._subject;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public List<SamlToken.TokenDelegate> getDelegationChain() {
        return this._delegationChain;
    }

    @Override
    public Set<String> getAudience() {
        return this._audienceRestrictionList;
    }

    @Override
    public X509Certificate getConfirmationCertificate() {
        return this._confirmationCertificate;
    }

    @Override
    public List<Advice> getAdvice() {
        return this._advice;
    }

    @Override
    public List<PrincipalId> getGroupList() {
        return this._groups;
    }

    private void validateAndPopulate(KeySelector signKeySelector, long clockToleranceSec) throws InvalidTokenException {
        JAXBElement jaxbParserResult = null;
        try {
            Unmarshaller unmarshaller = this._jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(SAML_SCHEMA);
            jaxbParserResult = (JAXBElement)unmarshaller.unmarshal((Node)this._parsedToken);
        }
        catch (JAXBException e) {
            this._log.info((Object)PARSING_TOKEN_ERROR_MSG, (Throwable)e);
            throw new InvalidTokenException(PARSING_TOKEN_ERROR_MSG, e);
        }
        AssertionType assertion = (AssertionType)jaxbParserResult.getValue();
        if (this.validateSignature(signKeySelector)) {
            this.parseAssertionAttributes(assertion);
            this.parseConditions(assertion.getConditions(), clockToleranceSec);
            this.parseSubject(assertion.getSubject());
            this.parseAuthnStatement(assertion.getAuthnStatement());
            if (assertion.getAttributeStatement() != null) {
                this.parseAttributeStatement(assertion.getAttributeStatement());
            }
            if (assertion.getAdvice() != null) {
                this.parseAdvice(assertion.getAdvice());
            }
        } else {
            this._log.info((Object)"SAML token cannot be constructed: Signature validation failed");
            throw new InvalidTokenException(SIGNATURE_VALIDATION_ERROR_MSG);
        }
        this._log.debug((Object)"Token signature is validated and the token fields are successfully populated");
    }

    private void parseAssertionAttributes(AssertionType assertion) throws InvalidTokenException {
        this._issueInstant = assertion.getIssueInstant().toGregorianCalendar(TimeZone.getTimeZone(DEFAULT_TIME_ZONE), null, null).getTimeInMillis();
        this._id = assertion.getID();
        assert (this._id != null) : "assertion ID is required attribute";
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("SAML assertion attributes successfully parsed. Got issueInstant: " + new Date(this._issueInstant)));
        }
    }

    private boolean validateSignature(KeySelector keySelector) throws InvalidTokenException {
        NodeList securityNodeList = this._parsedToken.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_ELEMENT_NAME);
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance();
        DOMValidateContext valContext = new DOMValidateContext(keySelector, securityNodeList.item(0));
        boolean isValid = false;
        try {
            XMLSignature signature = fac.unmarshalXMLSignature(valContext);
            isValid = signature.validate(valContext);
        }
        catch (MarshalException e) {
            this._log.error((Object)SIGNATURE_VALIDATION_ERROR_MSG, (Throwable)e);
            throw new InvalidTokenException(SIGNATURE_VALIDATION_ERROR_MSG, e);
        }
        catch (XMLSignatureException e) {
            this._log.error((Object)SIGNATURE_VALIDATION_ERROR_MSG, (Throwable)e);
            throw new InvalidTokenException(SIGNATURE_VALIDATION_ERROR_MSG, e);
        }
        this._log.debug((Object)("SAML token signature is valid status: " + isValid));
        return isValid;
    }

    private static Document parseTokenXmlToDom(String xmlToken) throws InvalidTokenException {
        Document parsedToken;
        if (xmlToken == null) {
            return null;
        }
        Log log = LogFactory.getLog(SamlTokenImpl.class);
        try {
            DocumentBuilder documentBuilder = xmlParserFactory.newDocumentBuilder();
            parsedToken = documentBuilder.parse(new InputSource(new StringReader(xmlToken)));
        }
        catch (SAXException e) {
            log.info((Object)PARSING_TOKEN_ERROR_MSG, (Throwable)e);
            throw new InvalidTokenException(PARSING_TOKEN_ERROR_MSG, e);
        }
        catch (IOException e) {
            String message = "Error reading from in-memory stream (heap space exhausted?)";
            log.error((Object)message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
        catch (ParserConfigurationException e) {
            String message = "DOM Document builder is not available (incompatible Java implementation?)";
            log.error((Object)message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
        return parsedToken;
    }

    private static Document createStandaloneCopy(Element element) {
        Transformer tx;
        HashMap<String, String> visibleNamespaces = new HashMap<String, String>();
        for (Node walker = element.getParentNode(); walker != null && walker.getNodeType() == 1; walker = walker.getParentNode()) {
            NamedNodeMap attrs = walker.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                if (!XMLNS_NS_URI.equals(attr.getNamespaceURI()) || visibleNamespaces.containsKey(attr.getName())) continue;
                visibleNamespaces.put(attr.getName(), attr.getValue());
            }
        }
        try {
            tx = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerException e) {
            throw new IllegalStateException("Failed to create identity XML transformer. Incompatible Java platform?", e);
        }
        DOMResult result = new DOMResult();
        try {
            tx.transform(new DOMSource(element), result);
        }
        catch (TransformerException e) {
            throw new IllegalStateException("Unexpected failure in Identity DOM-to-DOM transformation", e);
        }
        Document standaloneDoc = (Document)result.getNode();
        Element standaloneToken = standaloneDoc.getDocumentElement();
        for (Map.Entry nsAttr : visibleNamespaces.entrySet()) {
            standaloneToken.setAttributeNS(XMLNS_NS_URI, (String)nsAttr.getKey(), (String)nsAttr.getValue());
        }
        return standaloneDoc;
    }

    private void parseConditions(ConditionsType conditions, long clockToleranceSec) throws InvalidTokenException {
        this._startTime = conditions.getNotBefore().toGregorianCalendar(TimeZone.getTimeZone(DEFAULT_TIME_ZONE), null, null).getTimeInMillis();
        this._expirationTime = conditions.getNotOnOrAfter().toGregorianCalendar(TimeZone.getTimeZone(DEFAULT_TIME_ZONE), null, null).getTimeInMillis();
        if (this._expirationTime < this._startTime) {
            String message = "Start time / Expiration time not valid: StartTime: " + new Date(this._startTime) + " ExpirationTime: " + new Date(this._expirationTime);
            this._log.error((Object)message);
            throw new InvalidTokenException(message);
        }
        long effectiveExpirationTime = this._expirationTime + clockToleranceSec * 1000L;
        long currentTime = Calendar.getInstance(TimeZone.getTimeZone(DEFAULT_TIME_ZONE)).getTimeInMillis();
        if (effectiveExpirationTime < currentTime) {
            String message = "Token expiration date: " + new Date(this._expirationTime) + " is in the past.";
            this._log.info((Object)message);
            throw new InvalidTokenException(message);
        }
        List<ConditionAbstractType> conditionList = conditions.getConditionOrAudienceRestrictionOrProxyRestriction();
        for (ConditionAbstractType condition : conditionList) {
            BigInteger count;
            if (condition instanceof ProxyRestrictionType) {
                count = ((ProxyRestrictionType)condition).getCount();
                this._isDelegable = count != null && count.longValue() > 0L;
                continue;
            }
            if (condition instanceof AudienceRestrictionType) {
                HashSet<String> audienceSet = new HashSet<String>();
                audienceSet.addAll(((AudienceRestrictionType)condition).getAudience());
                this._audienceRestrictionList = Collections.unmodifiableSet(audienceSet);
                continue;
            }
            if (condition instanceof RenewRestrictionType) {
                count = ((RenewRestrictionType)condition).getCount();
                this._isRenewable = count != null && count.longValue() > 0L;
                continue;
            }
            if (!(condition instanceof DelegationRestrictionType)) continue;
            this.parseDelegationChain((DelegationRestrictionType)condition);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Conditions parsed successfully. Got startTime: " + new Date(this._startTime) + " expirationTime: " + new Date(this._expirationTime)));
        }
    }

    private void parseDelegationChain(DelegationRestrictionType delegation) throws InvalidTokenException {
        ArrayList<TokenDelegateImpl> delegationChain = new ArrayList<TokenDelegateImpl>();
        for (DelegateType delegate : delegation.getDelegate()) {
            PrincipalId subject;
            block3: {
                try {
                    subject = SamlTokenImpl.parseSubject(delegate.getNameID());
                }
                catch (ParserException e) {
                    subject = SamlTokenImpl.parseNonUPNSubject(delegate.getNameID());
                    if (subject != null) break block3;
                    this._log.error((Object)PARSE_DELEGATION_ERR_MSG, (Throwable)e);
                    throw new InvalidTokenException(PARSE_DELEGATION_ERR_MSG, e);
                }
            }
            delegationChain.add(new TokenDelegateImpl(subject, delegate.getDelegationInstant().toGregorianCalendar(TimeZone.getTimeZone(DEFAULT_TIME_ZONE), null, null).getTimeInMillis()));
        }
        Collections.sort(delegationChain, new Comparator<SamlToken.TokenDelegate>(){

            @Override
            public int compare(SamlToken.TokenDelegate o1, SamlToken.TokenDelegate o2) {
                long o2Date;
                long o1Date = o1.getDelegationDate().getTime();
                return o1Date < (o2Date = o2.getDelegationDate().getTime()) ? -1 : (o1Date == o2Date ? 0 : 1);
            }
        });
        this._delegationChain = Collections.unmodifiableList(delegationChain);
    }

    private static PrincipalId parseNonUPNSubject(NameIDType subject) {
        PrincipalId subjectId = null;
        if (subject.getFormat().equalsIgnoreCase(UNSPECIFIED_FORMAT_URI) && subject.getNameQualifier().equalsIgnoreCase(NAME_QUALIFIER_LOCAL)) {
            subjectId = new PrincipalId(subject.getValue(), "System-Domain");
        }
        return subjectId;
    }

    private void parseSubject(SubjectType subject) throws InvalidTokenException {
        try {
            this._subject = SamlTokenImpl.parseSubject(subject.getNameID());
        }
        catch (ParserException e) {
            throw new InvalidTokenException("Cannot parse subject", e);
        }
        SubjectConfirmationType subConf = subject.getSubjectConfirmation();
        if (subConf.getMethod().equalsIgnoreCase(BEARER_CONFIRMATION)) {
            SubjectConfirmationDataType subConfData = subConf.getSubjectConfirmationData();
            long subjConfExp = subConfData.getNotOnOrAfter().toGregorianCalendar(TimeZone.getTimeZone(DEFAULT_TIME_ZONE), null, null).getTimeInMillis();
            if (subjConfExp > this._expirationTime) {
                String message = "Subject confirmation expiration time is not valid: Subject time: " + new Date(subjConfExp) + " Token ExpirationTime: " + new Date(this._expirationTime);
                this._log.error((Object)message);
                throw new InvalidTokenException(message);
            }
            this._confirmationType = ConfirmationType.BEARER;
        } else if (subConf.getMethod().equalsIgnoreCase(HOLDER_OF_KEY_CONFIRMATION)) {
            this.parseHolderOfKeyConfirmation(subject);
            this._confirmationType = ConfirmationType.HOLDER_OF_KEY;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Subject " + this._subject + " successfully extracted from the token"));
            this._log.debug((Object)("Got confirmation type: " + (Object)((Object)this._confirmationType)));
        }
    }

    private static PrincipalId parseSubject(NameIDType subject) throws ParserException {
        String subjectFormat = subject.getFormat();
        String nameQualifier = subject.getNameQualifier();
        if (!subjectFormat.equalsIgnoreCase(UPN_FORMAT_URI) || nameQualifier != null) {
            throw new ParserException(String.format("Failed to parse subject: format = '%s', name qualifier = '%s'", subjectFormat, nameQualifier));
        }
        return PrincipalIdParser.parseUpn(subject.getValue());
    }

    private void parseHolderOfKeyConfirmation(SubjectType subject) throws InvalidTokenException {
        byte[] cert;
        SubjectConfirmationDataType subjectConfirmationData = subject.getSubjectConfirmation().getSubjectConfirmationData();
        if (!(subjectConfirmationData instanceof KeyInfoConfirmationDataType)) {
            this._log.error((Object)SUBJ_CONF_DATA_WRONG_TYPE_MSG);
            throw new InvalidTokenException(SUBJ_CONF_DATA_WRONG_TYPE_MSG);
        }
        KeyInfoType keyInfo = SamlTokenImpl.getTheValue(subjectConfirmationData.getContent(), KeyInfoType.class);
        X509DataType x509Data = keyInfo != null ? SamlTokenImpl.getTheValue(keyInfo.getContent(), X509DataType.class) : null;
        byte[] byArray = cert = x509Data != null ? SamlTokenImpl.getTheValue(x509Data.getX509IssuerSerialOrX509SKIOrX509SubjectName(), byte[].class) : null;
        if (cert != null) {
            try {
                CertificateFactory cf = CertificateFactory.getInstance(X509_CERT_FACTORY_TYPE);
                this._confirmationCertificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert));
            }
            catch (CertificateException e) {
                this._log.error((Object)CERTIFICATE_PARSE_ERR_MSG, (Throwable)e);
                throw new InvalidTokenException(CERTIFICATE_PARSE_ERR_MSG, e);
            }
        }
        if (this._confirmationCertificate == null) {
            this._log.error((Object)SUBJ_CONF_DATA_NOT_FOUNT_MSG);
            throw new InvalidTokenException(SUBJ_CONF_DATA_NOT_FOUNT_MSG);
        }
    }

    private static <T> T getTheValue(List<?> list, Class<T> valueType) {
        JAXBElement<?> theOnlyElement = SamlTokenImpl.getSingleJaxbElement(list);
        return (T)(valueType.isInstance(theOnlyElement.getValue()) ? theOnlyElement.getValue() : null);
    }

    private static JAXBElement<?> getSingleJaxbElement(List<?> list) {
        JAXBElement theOnlyElement = null;
        for (Object obj : list) {
            if (!(obj instanceof JAXBElement)) continue;
            if (theOnlyElement != null) {
                return null;
            }
            theOnlyElement = (JAXBElement)obj;
        }
        return theOnlyElement;
    }

    private void parseAuthnStatement(AuthnStatementType authnStatement) {
        authnStatement.getAuthnInstant();
        authnStatement.getAuthnContext().getAuthnContextClassRef();
    }

    private void parseAdvice(AdviceType advice) throws InvalidTokenException {
        ArrayList<Advice> adviceList = new ArrayList<Advice>();
        for (RSAAdviceType rsaAdvice : advice.getRSAAdvice()) {
            String source = rsaAdvice.getAdviceSource();
            ArrayList<Advice.AdviceAttribute> adviceAttributes = new ArrayList<Advice.AdviceAttribute>();
            if (rsaAdvice.getAttribute() != null) {
                for (AttributeType attribute : rsaAdvice.getAttribute()) {
                    List<String> attrValues = attribute.getAttributeValue();
                    String attrName = attribute.getName();
                    adviceAttributes.add(attrValues != null ? new Advice.AdviceAttribute(attrName, attrValues) : new Advice.AdviceAttribute(attrName));
                }
            }
            adviceList.add(new Advice(source, adviceAttributes));
        }
        this._advice = Collections.unmodifiableList(adviceList);
    }

    private void parseAttributeStatement(AttributeStatementType attrStatement) throws InvalidTokenException {
        List<AttributeType> attributeList = attrStatement.getAttribute();
        ArrayList<PrincipalId> groupList = new ArrayList<PrincipalId>();
        for (AttributeType attribute : attributeList) {
            this.verifyElementFormatURI(attribute.getNameFormat(), ATTRIBUTE_FORMAT_URI);
            String attributeName = attribute.getName();
            if (attributeName.equals(AttributeNames.HTTP_RSA_COM_SCHEMAS_ATTR_NAMES_2009_01_GROUP_IDENTITY.value())) {
                try {
                    groupList.addAll(SamlTokenImpl.parseGroup(attribute.getAttributeValue()));
                }
                catch (ParserException e) {
                    this._log.debug((Object)PARSE_GROUPS_ERR_MSG, (Throwable)e);
                    throw new InvalidTokenException(PARSE_GROUPS_ERR_MSG, e);
                }
                this._log.debug((Object)"Groups successfully extracted from token");
                continue;
            }
            if (!attributeName.equals(AttributeNames.HTTP_VMWARE_COM_SCHEMAS_ATTR_NAMES_2011_07_IS_SOLUTION.value())) continue;
            List<String> attributeValue = attribute.getAttributeValue();
            if (null != attributeValue && 1 == attributeValue.size()) {
                this._isSolution = Boolean.parseBoolean(attributeValue.get(0));
                this._log.debug((Object)("isSolution attribute parsed successfully from " + attributeValue + " to: " + this._isSolution));
                continue;
            }
            throw new InvalidTokenException(PARSE_ISSOLUTION_ERR_MSG);
        }
        this._groups = Collections.unmodifiableList(groupList);
        this._log.debug((Object)"Attribute statements successfully parsed");
    }

    private static List<PrincipalId> parseGroup(List<String> groupList) throws ParserException {
        assert (groupList != null);
        ArrayList<PrincipalId> groupResult = new ArrayList<PrincipalId>(groupList.size());
        for (String group : groupList) {
            groupResult.add(PrincipalIdParser.parseGroupId(group));
        }
        return groupResult;
    }

    private void verifyElementFormatURI(String gotFormat, String expectedFormat) throws InvalidTokenException {
        if (!gotFormat.equalsIgnoreCase(expectedFormat)) {
            String message = "Element format does not match the expected URI format. Got: " + gotFormat + " Expected: " + expectedFormat;
            this._log.error((Object)message);
            throw new InvalidTokenException(message);
        }
    }

    private static Schema loadSamlSchema() {
        URL schemaResource = SamlTokenImpl.class.getResource(SAML_SCHEMA_FILENAME);
        if (schemaResource == null) {
            throw new DeploymentError(String.format("Schema resource `%s' is missing.", SAML_SCHEMA_FILENAME));
        }
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema samlSchema = sf.newSchema(schemaResource);
            return samlSchema;
        }
        catch (SAXException e) {
            LogFactory.getLog(SamlTokenImpl.class).error((Object)ERR_LOADNIG_SAML_SCHEMA, (Throwable)e);
            throw new DeploymentError(ERR_LOADNIG_SAML_SCHEMA, e);
        }
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof SamlToken && this.getId().equals(((SamlToken)other).getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public boolean isSolution() {
        return this._isSolution;
    }

    public static class TokenDelegateImpl
    implements SamlToken.TokenDelegate {
        private final PrincipalId _subject;
        private final long _delegationDate;

        public TokenDelegateImpl(PrincipalId subject, long delegationDate) {
            assert (subject != null);
            this._subject = subject;
            this._delegationDate = delegationDate;
        }

        @Override
        public PrincipalId getSubject() {
            return this._subject;
        }

        @Override
        public Date getDelegationDate() {
            return new Date(this._delegationDate);
        }

        public String toString() {
            return "TokenDelegateImpl [subject=" + this._subject + ", delegationDate=" + this._delegationDate + "]";
        }
    }

    static class DeploymentError
    extends Error {
        private static final long serialVersionUID = -6610749680263268064L;

        public DeploymentError(String message, Throwable cause) {
            super(message, cause);
        }

        public DeploymentError(String message) {
            super(message);
        }
    }
}

